/*
 * R : _̍WƂŷ݂̕`ǏWn (zu) \NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclAxis1Placement3D.java,v 1.29 2000/04/26 09:38:41 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : _̍WƂŷ݂̕`ǏWn (zu) \NXB
 * <p>
 * ̃NX́A
 * {@link JgclSurfaceOfRevolution3D ]} ̒SƂȂǂɗp܂B
 * </p>
 * <p>
 * ̃NX̃CX^X́A
 * ǏWň_ƂȂ_ location
 * ƁA
 * ǏWn̂y̕xNg axis
 * ێ܂B
 * ̋ǏWńA(Öق) En̒Wn\܂A
 * gł͂wтx͌̕肵܂B
 * w̕Ƃx̌́̕A̋ǏWn𗘗p鑤ɔC܂B
 * </p>
 * <p>
 * ẙxNǵAɂ̑傫 1 ɒPʉĈ܂B
 * </p>
 * <p>
 * location ɗ^_ɂ͓ɐ͂ȂA
 * {@link JgclPoint3D JgclPoint3D} NX̔Cӂ̓_^邱Ƃł܂A
 * null w肷邱Ƃ͂ł܂B
 * axis ɗ^xNg {@link JgclVector3D JgclVector3D}
 * ͓ɒPʉĂKv͂܂񂪁A
 * [xNg^邱Ƃ͂ł܂B
 * ȂAaxis ɗ^xNg
 * w肵Ȃ (null w肷) Ƃł܂B
 * axis  null ƂƁAy̕ (0, 0, 1) ɓ̂Ɖ߂܂B
 * </p>
 *
 * @version $Revision: 1.29 $, $Date: 2000/04/26 09:38:41 $
 * @author Information-technology Promotion Agency, Japan
 * @see JgclAxis2Placement3D
 */

public class JgclAxis1Placement3D extends JgclPlacement3D {
    /**
     * y̕\xNgB
     * @serial
     */
    private JgclVector3D axis;

    /**
     * y\PʃxNgB
     * <p>
     * KvɉăLbVB
     * </p>
     * @serial
     */
    private JgclVector3D z;

    /**
     * ǏWň_ƂȂ_
     * y̕xNg^āA
     * IuWFNg\zB
     * <p>
     * location  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * axis  null ł\ȂB
     * axis  null ̏ꍇɂ́A
     * y̕ (0, 0, 1) ɓ̂Ɖ߂B
     * </p>
     * <p>
     * axis ̑傫A
     * ݐݒ肳Ă鉉Z̋̋e덷ȉ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param location		ǏWň_
     * @param axis		y̕xNg
     */
    public JgclAxis1Placement3D(JgclPoint3D location, JgclVector3D axis)
    {
	super(location);
	this.axis = axis;
	checkAxis();
    }

    /**
     * y̕xNg̑Ó`FbNB
     * <p>
     * axis  null ł\ȂB
     * axis  null ̏ꍇɂ́A
     * y̕ (0, 0, 1) ɓ̂Ɖ߂B
     * </p>
     * <p>
     * axis ̑傫A
     * ݐݒ肳Ă鉉Z̋̋e덷ȉ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @see	JgclConditionOfOperation
     * @see	JgclInvalidArgumentValue
     */
    private void checkAxis()
    {
	if (axis != null) {
	    JgclConditionOfOperation condition =
		JgclConditionOfOperation.getCondition();
	    double tol_d = condition.getToleranceForDistance();

	    if (axis.norm() <= tol_d * tol_d) {
		throw new JgclInvalidArgumentValue();
	    }
	}
    }

    /**
     * ̋ǏWn̂y̕\xNgԂB
     * <p>
     * IuWFNg̍\zɗ^ꂽ axis ԂB
     * āAnull Ԃ邱Ƃ肤B
     * </p>
     *
     * @return		y̕\xNg
     */
    public JgclVector3D axis() {
	return axis;
    }

    /**
     * ̋ǏWn̂y̕\ (I) xNgԂB
     * <p>
     * axis  null łȂ΁Aaxis ԂB
     * axis  null Ȃ΁A(0, 0, 1) ̃xNgԂB
     * </p>
     *
     * @return	y̕\ (I) xNg
     */
    public JgclVector3D effectiveAxis() {
	return (axis != null)
	    ? axis : JgclGeometrySchemaFunction.defaultAxis3D;
    }

    /**
     * ̋ǏWn̂y\PʃxNgԂB
     *
     * @return	y\PʃxNg
     */
    public JgclVector3D z() {
	if (z == null) {
	    z = (axis != null) ? axis.unitized() : JgclGeometrySchemaFunction.defaultAxis3D;
	}
	return z;
    }

    /**
     * ̋ǏWň_ʂAy̕ɐLт钼ԂB
     *
     * @return	_ʂAy̕ɐLт钼
     */
    public JgclLine3D toLine() {
	return new JgclLine3D(location(), z());
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclAxis1Placement3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint3D tLocation =
	    this.location().transformBy(reverseTransform,
					transformationOperator,
					transformedGeometries);
	JgclVector3D tAxis =
	    this.effectiveAxis().transformBy(reverseTransform,
					     transformationOperator,
					     transformedGeometries);
	return new JgclAxis1Placement3D(tLocation, tAxis);
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    public synchronized JgclAxis1Placement3D
    transformBy(boolean reverseTransform,
		JgclCartesianTransformationOperator3D transformationOperator,
		java.util.Hashtable transformedGeometries)
    {
	if (transformedGeometries == null)
	    return this.doTransformBy(reverseTransform,
				      transformationOperator,
				      transformedGeometries);

	JgclAxis1Placement3D transformed = (JgclAxis1Placement3D)transformedGeometries.get(this);
	if (transformed == null) {
	    transformed = this.doTransformBy(reverseTransform,
					     transformationOperator,
					     transformedGeometries);
	    transformedGeometries.put(this, transformed);
	}
	return transformed;
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    public synchronized JgclAxis1Placement3D
    transformBy(JgclCartesianTransformationOperator3D transformationOperator,
		java.util.Hashtable transformedGeometries)
    {
	return this.transformBy(false,
				transformationOperator,
				transformedGeometries);
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŋtϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŋtϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŋtϊ̂ԂB
     * </p>
     *
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	tϊ̊􉽗vf
     */
    public synchronized JgclAxis1Placement3D
    reverseTransformBy(JgclCartesianTransformationOperator3D transformationOperator,
		       java.util.Hashtable transformedGeometries)
    {
	return this.transformBy(true,
				transformationOperator,
				transformedGeometries);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tlocation");
        location().output(writer, indent + 2);
	if (axis != null) {
	    writer.println(indent_tab + "\taxis");
	    axis.output(writer, indent + 2);
	}
        writer.println(indent_tab + "End");
    }
}

