/*
 * Q : LȋȐ\ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclBoundedCurve2D.java,v 1.24 2000/08/11 06:18:42 shikano Exp $
 */

package jp.go.ipa.jgcl;

/**
 * Q : LȋȐ\ۃNXB
 * <p>
 * ̃NXɂ̓CX^Xׂ͂ȂB
 * </p>
 *
 * @version $Revision: 1.24 $, $Date: 2000/08/11 06:18:42 $
 * @author Information-technology Promotion Agency, Japan
 */

public abstract class JgclBoundedCurve2D extends JgclParametricCurve2D {
    /**
     * ^ɃIuWFNg\zB
     */
    protected JgclBoundedCurve2D() {
	super();
    }

    /**
     * ̗LȐŜ̎ԏł̒ (̂) ԂB
     * <p>
     * []
     * <br>
     * g̃p[^` section ^
     * this.{@link JgclParametricCurve#length(JgclParameterSection)
     * length}(section)
     * ĂяoB
     * </p>
     * 
     * @return	ȐŜ̒
     */
    public double length() {
	try {
	    return length(parameterDomain().section());
	} catch (JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}
    }

    /**
     * ̗LȐŜA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_ JgclPointOnCurve2D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * []
     * <br>
     * g̃p[^` section ^
     * this.{@link JgclParametricCurve2D#toPolyline(JgclParameterSection, JgclToleranceForDistance)
     * toPolyline}(section, tolerance)
     * ĂяoB
     * </p>
     *
     * @param tolerance	̋e덷
     * @return	̋ȐŜ𒼐ߎ|C
     * @see	JgclPointOnCurve2D
     */
    public JgclPolyline2D toPolyline(JgclToleranceForDistance tolerance) {
	try {
	    return toPolyline(parameterDomain().section(), tolerance);
	} catch (JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}
    }

    /**
     * ̗LȐŜɍČL Bspline ȐԂB
     * <p>
     * []
     * <br>
     * g̃p[^` section ^
     * this.{@link JgclParametricCurve2D#toBsplineCurve(JgclParameterSection)
     * toBsplineCurve}(section)
     * ĂяoB
     * </p>
     * 
     * @return	̋ȐŜČL Bspline Ȑ
     */
    public JgclBsplineCurve2D toBsplineCurve() {
	try {
	    return toBsplineCurve(parameterDomain().section());
	} catch (JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}
    }

    /**
     * ̗LȐŜItZbgȐA
     * ^ꂽ덷ŋߎ Bspline Ȑ߂B
     * <p>
     * []
     * <br>
     * g̃p[^` section ^
     * this.{@link JgclParametricCurve2D#offsetByBsplineCurve(JgclParameterSection, double, int, JgclToleranceForDistance)
     * offsetByBsplineCurve}(section, magni, side, tol)
     * ĂяoB
     * </p>
     * 
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋ȐŜ̃ItZbgȐߎ Bspline Ȑ
     * @see	JgclWhichSide
     */
    public JgclBsplineCurve2D
    offsetByBsplineCurve(double magni,
			 int side,
			 JgclToleranceForDistance tol)
    {
	try {
	    return offsetByBsplineCurve(parameterDomain().section(),
					magni, side, tol);
	} catch (JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}
    }

    /**
     * ̗LȐŜItZbgȐA
     * ^ꂽ덷ŋߎLȐ߂B
     * <p>
     * []
     * <br>
     * g̃p[^` section ^
     * this.{@link JgclParametricCurve2D#offsetByBoundedCurve(JgclParameterSection, double, int, JgclToleranceForDistance)
     * offsetByBoundedCurve}(section, magni, side, tol)
     * ĂяoB
     * </p>
     * 
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋ȐŜ̃ItZbgȐߎLȐ
     * @see	JgclWhichSide
     */
    public JgclBoundedCurve2D
    offsetByBoundedCurve(double magni,
			 int side,
			 JgclToleranceForDistance tol)
    {
	try {
	    return offsetByBoundedCurve(parameterDomain().section(),
					magni, side, tol);
	} catch (JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}
    }

    /**
     * ̗LȐŜƑ̗LȐŜɂtBbg߂B
     * <p>
     * tBbg݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * g̃p[^` thisSection
     * 
     * ̗LȐ̃p[^` mateSection
     * ^
     * this.{@link JgclParametricCurve2D#fillet(JgclParameterSection, int, JgclParametricCurve2D, JgclParameterSection, int, double)
     * fillet}(thisSection, side1, mate, mateSection, side2, radius)
     * ĂяoB
     * </p>
     * 
     * @param side1	̋Ȑ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.LEFTȂ΍ARIGHTȂΉEABOTHȂΗ)
     * @param mate	̗LȐ
     * @param side2	̗LȐ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.LEFTȂ΍ARIGHTȂΉEABOTHȂΗ)
     * @param radius	tBbga
     * @return		tBbg̔z
     * @exception JgclIndefiniteSolution	s (ł͔Ȃ)
     * @see	JgclWhichSide
     */
    public JgclFilletObject2D[]
    fillet(int side1, JgclBoundedCurve2D mate, int side2, double radius)
	 throws JgclIndefiniteSolution
    {
	return fillet(parameterDomain().section(), side1, mate, 
		      mate.parameterDomain().section(), side2, radius);
    }

    /**
     * ̗LȐƑ̗LȐ̊߂钊ۃ\bhB
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ
     * @return		Ȑ̊̔z
     */
    abstract public JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate);

    /**
     * ̗LȐƑ̗LȐ () ̊߂钊ۃ\bhB
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ ()
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    abstract JgclCurveCurveInterference2D[] interfere(JgclBoundedLine2D mate,
						      boolean doExchange);

    /**
     * ̗LȐƑ̗LȐ (|C) ̊߂钊ۃ\bhB
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (|C)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    abstract JgclCurveCurveInterference2D[] interfere(JgclPolyline2D mate,
						      boolean doExchange);

    /**
     * ̗LȐƑ̗LȐ (xWGȐ) ̊߂钊ۃ\bhB
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (xWGȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    abstract JgclCurveCurveInterference2D[] interfere(JgclPureBezierCurve2D mate,
						      boolean doExchange);

    /**
     * ̗LȐƑ̗LȐ (aXvCȐ) ̊߂钊ۃ\bhB
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (aXvCȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    abstract JgclCurveCurveInterference2D[] interfere(JgclBsplineCurve2D mate,
						      boolean doExchange);

    /**
     * ̗LȐƑ̗LȐ (gȐ) ̊߂钊ۃ\bhB
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (gȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    abstract JgclCurveCurveInterference2D[] interfere(JgclTrimmedCurve2D mate,
						      boolean doExchange);

    /**
     * ̗LȐƑ̗LȐ (ȐZOg) ̊߂钊ۃ\bhB
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (ȐZOg)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    abstract JgclCurveCurveInterference2D[] interfere(JgclCompositeCurveSegment2D mate,
						      boolean doExchange);

    /**
     * ̗LȐƑ̗LȐ (Ȑ) ̊߂钊ۃ\bhB
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (Ȑ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    abstract JgclCurveCurveInterference2D[] interfere(JgclCompositeCurve2D mate,
						      boolean doExchange);

    /**
     * ̗LȐ̊Jn_ԂB
     * <p>
     * Ȑ`̏ꍇ null ԂB
     * </p>
     *
     * @return	Jn_
     */
    public JgclPoint2D startPoint() {
	if (isPeriodic())
	    return null;

	try {
	    return coordinates(parameterDomain().section().start());
	} catch (JgclParameterOutOfRange e) {
	    throw new JgclFatal();	// should not be occured
	}
    }

    /**
     * ̗LȐ̏I_Ԃ
     * <p>
     * Ȑ`̏ꍇ null ԂB
     * </p>
     *
     * @return	I_
     */
    public JgclPoint2D endPoint() {
	if (isPeriodic())
	    return null;

	try {
	    return coordinates(parameterDomain().section().end());
	} catch (JgclParameterOutOfRange e) {
	    throw new JgclFatal();	// should not be occured
	}
    }

    /**
     * ̗LȐ􉽓IɕĂ邩ۂԂB
     * <p>
     * Ȑ`ł true ԂB
     * </p>
     * <p>
     * ȐJ`ł΁AJn_ƏI_̓ꐫ𒲂ׂB
     * </p>
     *
     * @return	􉽓IɕĂ trueAłȂ false
     * @see	JgclPoint2D#identical(JgclPoint2D)
     */
    boolean getClosedFlag() {
	if (isPeriodic()) {
	    return true;
	} else {
	    return startPoint().identical(endPoint());
	}
    }
}

