/*
 * R : L () aXvCȐїLaXvCȐ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclBsplineCurve3D.java,v 1.104 2000/08/11 06:18:43 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : L () aXvCȐїLaXvCȐ\NXB
 * <p>
 * ̃NX̃CX^X́A
 * aXvC̃mbgɊւ knotData ({@link JgclBsplineKnot JgclBsplineKnot})
 * B
 * _ȂǂێtB[hɂẮA
 * {@link JgclFreeformCurveWithControlPoints3D X[p[NX̉} QƁB
 * </p>
 * <p>
 * aXvCȐ̃p[^`́AΉmbgɂČ܂B
 * </p>
 * <p>
 * t p[^ƂaXvCȐ P(t) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	n = Ȑ̎
 *	m = ZOg̐ (J` : (_̐ - Ȑ̎), ` : _̐)
 *	di = controlPoints[i]
 *	wi = weights[i]
 * </pre>
 * ƂāALaXvCȐ
 * <pre>
 *	P(t) =	(di * Nn,i(t)) ̑a		(i = 0, ..., (m + n - 1))
 * </pre>
 * LaXvCȐ
 * <pre>
 *		(wi * di * Nn,i(t)) ̑a
 *	P(t) =	-------------------------- 	(i = 0, ..., (m + n - 1))
 *		(wi * Nn,i(t)) ̑a
 * </pre>
 *  Nn,i(t) ͂aXvC֐B
 * ȂA`̏ꍇ i &gt; (_̐ - 1) ƂȂ i ɂẮA
 * Ή鐧_Əd݂ꂼ dj, wj (j = i - _̐) ƂȂB
 * </p>
 *
 * @version $Revision: 1.104 $, $Date: 2000/08/11 06:18:43 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclBsplineCurve3D extends JgclFreeformCurveWithControlPoints3D {
    /**
     * mbgB
     * @serial
     */
    private JgclBsplineKnot knotData;

    /**
     * Ȑ̌`tOB
     * <p>
     * ̃tB[h́A܂̂Ƃ늈pĂ炸A
     *  JgclBsplineCurveForm.UNSPECIFIED ɂȂĂB
     * </p>
     * @serial
     * @see JgclBsplineCurveForm
     */
    private int curveForm = JgclBsplineCurveForm.UNSPECIFIED;

    /**
     * mbg𖾎A
     * _^đȐƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints3D#JgclFreeformCurveWithControlPoints3D(JgclPoint3D[])
     * super}(controlPoints)
     * ĂяoĂB
     * </p>
     * <p>
     * knotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(degree, JgclKnotType.UNSPECIFIED, periodic, knotMultiplicities, knots, nControlPoints())
     * ĂяoĂB
     * </p>
     *
     * @param degree	Ȑ̎
     * @param periodic	`ۂ\tO
     * @param knotMultiplicities	mbgdx̔z
     * @param knots	mbgl̔z
     * @param controlPoints	_̔z
     */
    public JgclBsplineCurve3D(int degree, boolean periodic,
			      int[] knotMultiplicities, double[] knots,
			      JgclPoint3D[] controlPoints) {
	super(controlPoints);
	knotData = new JgclBsplineKnot(degree, JgclKnotType.UNSPECIFIED, periodic,
				       knotMultiplicities, knots,
				       nControlPoints());
    }

    /**
     * mbg𖾎A_^ĊJ`̑ȐƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints3D#JgclFreeformCurveWithControlPoints3D(JgclPoint3D[])
     * super}(controlPoints)
     * ĂяoĂB
     * </p>
     * <p>
     * knotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(degree, JgclKnotType.UNSPECIFIED, false, knotMultiplicities, knots, nControlPoints())
     * ĂяoĂB
     * </p>
     *
     * @param degree	Ȑ̎
     * @param knotMultiplicities	mbgdx̔z
     * @param knots	mbgl̔z
     * @param controlPoints	_̔z
     */
    public JgclBsplineCurve3D(int degree,
			      int[] knotMultiplicities, double[] knots,
			      JgclPoint3D[] controlPoints) {
	super(controlPoints);
	knotData = new JgclBsplineKnot(degree, JgclKnotType.UNSPECIFIED, false,
				       knotMultiplicities, knots,
				       nControlPoints());
    }

    /**
     * mbg𖾎A
     * _Ədݗ^ėLȐƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints3D#JgclFreeformCurveWithControlPoints3D(JgclPoint3D[], double[])
     * super}(controlPoints, weights)
     * ĂяoĂB
     * </p>
     * <p>
     * knotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(degree, JgclKnotType.UNSPECIFIED, periodic, knotMultiplicities, knots, nControlPoints())
     * ĂяoĂB
     * </p>
     *
     * @param degree	Ȑ̎
     * @param periodic	`ۂ\tO
     * @param knotMultiplicities	mbgdx̔z
     * @param knots	mbgl̔z
     * @param controlPoints	_̔z
     * @param weights	d݂̔z
     */
    public JgclBsplineCurve3D(int degree, boolean periodic,
			      int[] knotMultiplicities, double[] knots,
			      JgclPoint3D[] controlPoints, double[] weights) {
	super(controlPoints, weights);
	knotData = new JgclBsplineKnot(degree, JgclKnotType.UNSPECIFIED, periodic,
				       knotMultiplicities, knots,
				       nControlPoints());
    }

    /**
     * mbg𖾎A
     * _Ədݗ^ĊJ`̗LȐƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints3D#JgclFreeformCurveWithControlPoints3D(JgclPoint3D[], double[])
     * super}(controlPoints, weights)
     * ĂяoĂB
     * </p>
     * <p>
     * knotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(degree, JgclKnotType.UNSPECIFIED, false, knotMultiplicities, knots, nControlPoints())
     * ĂяoĂB
     * </p>
     *
     * @param degree	Ȑ̎
     * @param knotMultiplicities	mbgdx̔z
     * @param knots	mbgl̔z
     * @param controlPoints	_̔z
     * @param weights	d݂̔z
     */
    public JgclBsplineCurve3D(int degree,
			      int[] knotMultiplicities, double[] knots,
			      JgclPoint3D[] controlPoints, double[] weights) {
	super(controlPoints, weights);
	knotData = new JgclBsplineKnot(degree, JgclKnotType.UNSPECIFIED, false,
				       knotMultiplicities, knots,
				       nControlPoints());
    }

    /**
     * mbg𖾎
     * mbg̎ʂƐ_^đȐƂăIuWFNg\zB
     * <p>
     * ܂̂ƂAknotSpec Ƃ蓾l JgclKnotType.UNIFORM_KNOTS ł
     * (JgclKnotType.{QUASI_UNIFORM_KNOTS, PIECEWISE_BEZIER_KNOTS} ɂ͖Ή) B
     * </p>
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints3D#JgclFreeformCurveWithControlPoints3D(JgclPoint3D[])
     * super}(controlPoints)
     * ĂяoĂB
     * </p>
     * <p>
     * knotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(degree, knotSpec, periodic, null, null, nControlPoints())
     * ĂяoĂB
     * </p>
     *
     * @param degree	Ȑ̎
     * @param periodic	`ۂ\tO
     * @param knotSpec	mbg̎
     * @param controlPoints	_̔z
     */
    public JgclBsplineCurve3D(int degree, boolean periodic,
			      int knotSpec,
			      JgclPoint3D[] controlPoints) {
	super(controlPoints);
	knotData = new JgclBsplineKnot(degree, knotSpec, periodic, null, null,
				       nControlPoints());
    }

    /**
     * mbg𖾎
     * mbg̎ʂƐ_^ĊJȐƂăIuWFNg\zB
     * <p>
     * ܂̂ƂAknotSpec Ƃ蓾l JgclKnotType.UNIFORM_KNOTS ł
     * (JgclKnotType.{QUASI_UNIFORM_KNOTS, PIECEWISE_BEZIER_KNOTS} ɂ͖Ή) B
     * </p>
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints3D#JgclFreeformCurveWithControlPoints3D(JgclPoint3D[])
     * super}(controlPoints)
     * ĂяoĂB
     * </p>
     * <p>
     * knotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(degree, knotSpec, false, null, null, nControlPoints())
     * ĂяoĂB
     * </p>
     *
     * @param degree	Ȑ̎
     * @param knotSpec	mbg̎
     * @param controlPoints	_̔z
     */
    public JgclBsplineCurve3D(int degree,
			      int knotSpec,
			      JgclPoint3D[] controlPoints) {
	super(controlPoints);
	knotData = new JgclBsplineKnot(degree, knotSpec, false, null, null,
				       nControlPoints());
    }

    /**
     * mbg𖾎
     * mbg̎ʂƐ_񂨂яdݗ^ėLȐƂăIuWFNg\zB
     * <p>
     * ܂̂ƂAknotSpec Ƃ蓾l JgclKnotType.UNIFORM_KNOTS ł
     * (JgclKnotType.{QUASI_UNIFORM_KNOTS, PIECEWISE_BEZIER_KNOTS} ɂ͖Ή) B
     * </p>
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints3D#JgclFreeformCurveWithControlPoints3D(JgclPoint3D[], double[])
     * super}(controlPoints, weights)
     * ĂяoĂB
     * </p>
     * <p>
     * knotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(degree, knotSpec, periodic, null, null, nControlPoints())
     * ĂяoĂB
     * </p>
     *
     * @param degree	Ȑ̎
     * @param periodic	`ۂ\tO
     * @param knotSpec	mbg̎
     * @param controlPoints	_̔z
     * @param weights	d݂̔z
     */
    public JgclBsplineCurve3D(int degree, boolean periodic,
			      int knotSpec,
			      JgclPoint3D[] controlPoints, double[] weights) {
	super(controlPoints, weights);
	knotData = new JgclBsplineKnot(degree, knotSpec, periodic, null, null,
				       nControlPoints());
    }

    /**
     * mbg𖾎
     * mbg̎ʂƐ_񂨂яdݗ^ĊJ`̗LȐƂăIuWFNg\zB
     * <p>
     * ܂̂ƂAknotSpec Ƃ蓾l JgclKnotType.UNIFORM_KNOTS ł
     * (JgclKnotType.{QUASI_UNIFORM_KNOTS, PIECEWISE_BEZIER_KNOTS} ɂ͖Ή) B
     * </p>
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints3D#JgclFreeformCurveWithControlPoints3D(JgclPoint3D[], double[])
     * super}(controlPoints, weights)
     * ĂяoĂB
     * </p>
     * <p>
     * knotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(degree, knotSpec, false, null, null, nControlPoints())
     * ĂяoĂB
     * </p>
     *
     * @param degree	Ȑ̎
     * @param knotSpec	mbg̎
     * @param controlPoints	_̔z
     * @param weights	d݂̔z
     */
    public JgclBsplineCurve3D(int degree,
			      int knotSpec,
			      JgclPoint3D[] controlPoints, double[] weights) {
	super(controlPoints, weights);
	knotData = new JgclBsplineKnot(degree, knotSpec, false, null, null,
				       nControlPoints());
    }

    /**
     * mbg JgclBsplineKnot ̃IuWFNgƂēnA
     * _ (Əd) 񎟌zŗ^
     * Ȑ (邢͗LȐ) ƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints3D#JgclFreeformCurveWithControlPoints3D(double[][])
     * super}(cpArray)
     * ĂяoĂB
     * </p>
     * <p>
     * knotData ̎_̐ cpArray ̎_̐vȂꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param knotData	mbg
     * @param cpArray	_ (яd) ̔z
     * @see	JgclInvalidArgumentValue
     */
    JgclBsplineCurve3D(JgclBsplineKnot knotData, double[][] cpArray) {
	super(cpArray);

	if (knotData.nControlPoints() != nControlPoints())
	    throw new JgclInvalidArgumentValue();

	this.knotData = knotData;
    }

    /**
     * mbg JgclBsplineKnot ̃IuWFNgƂēnA
     * _Ədݗ^
     * Ȑ (邢͗LȐ) ƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints3D#JgclFreeformCurveWithControlPoints3D(JgclPoint3D[], double[], boolean)
     * super}(controlPoints, weights, false)
     * ĂяoĂB
     * </p>
     * <p>
     * ̃RXgN^ł͈̃`FbNsȂȂ̂ŁApɂ͒ӂKvłB
     * </p>
     *
     * @param knotData	mbg
     * @param controlPoitns	_̔z
     * @param weights	d݂̔z
     */
    JgclBsplineCurve3D(JgclBsplineKnot knotData,
		       JgclPoint3D[] controlPoints,
		       double[] weights) {
	super(controlPoints, weights, false);
	this.knotData = knotData;
    }

    /**
     * _ƁAɑΉp[^l̗^āA
     * ̓_ԂJ`̑ȐƂăIuWFNg\zB
     *
     * @param points	Ԃ_
     * @param params	_̊e_ɂp[^l̗
     */
    public JgclBsplineCurve3D(JgclPoint3D[] points, double[] params) {
	super();
	JgclInterpolation3D doObj = new JgclInterpolation3D(points, params);
	this.controlPoints = doObj.controlPoints();
	this.knotData = doObj.knotData();
	this.weights = doObj.weights();	// may be null
    }

    /**
     * _ƁAɑΉp[^l̗񂨂ї[_ł̐ڃxNg^āA
     * ̓_ԂJ`̑ȐƂăIuWFNg\zB
     * <p>
     * endvecs[0] Ŏn_ł̐ڃxNgA
     * endvecs[1] ŏI_ł̐ڃxNgB
     * </p>
     *
     * @param points	Ԃ_
     * @param params	_̊e_ɂp[^l̗
     * @param endvecs	[_ł̐ڃxNg
     */
    public JgclBsplineCurve3D(JgclPoint3D[] points, double[] params, JgclVector3D[] endvecs) {
	super();
	JgclInterpolation3D doObj = new JgclInterpolation3D(points, params, endvecs);
	this.controlPoints = doObj.controlPoints();
	this.knotData = doObj.knotData();
	this.weights = doObj.weights();	// may be null
    }

    /**
     * _ƁAɑΉp[^l̗A[_ł̐ڃxNgъJ^āA
     * ̓_Ԃ鑽ȐƂăIuWFNg\zB
     * <p>
     * isClosed  true ̏ꍇA
     * (params ̗vf) = (points ̗vf + 1) ƂȂĂKvB
     * </p>
     * <p>
     * endvecs[0] Ŏn_ł̐ڃxNgA
     * endvecs[1] ŏI_ł̐ڃxNgB
     * ȂAisClosed  true ̏ꍇɂ́A̔z͎QƂȂB
     * </p>
     *
     * @param points	Ԃ_
     * @param params	_̊e_ɂp[^l̗
     * @param endvecs	[_ł̐ڃxNg
     * @param isClosed	`̋Ȑ𐶐邩ۂ̃tO
     */
    public JgclBsplineCurve3D(JgclPoint3D[] points, double[] params, JgclVector3D[] endvecs, boolean isClosed) {
	super();
	JgclInterpolation3D doObj = new JgclInterpolation3D(points, params, endvecs, isClosed);
	this.controlPoints = doObj.controlPoints();
	this.knotData = doObj.knotData();
	this.weights = doObj.weights();	// may be null
    }

    /**
     * _ƁAɑΉp[^l̗A[_ł̐ڐ̕ъJ^āA
     * ̓_ߎ鑽ȐƂăIuWFNg\zB
     * <p>
     * isClosed  true ̏ꍇA
     * (params ̗vf) = (points ̗vf + 1) ƂȂĂKvB
     * </p>
     * <p>
     * endDir[0] Ŏn_ł̐ڐA
     * endDir[1] ŏI_ł̐ڐB
     * ȂAisClosed  true ̏ꍇɂ́A̔z͎QƂȂB
     * </p>
     * <p>
     * w肳ꂽxŋߎłȂꍇɂ́A
     * ^ꂽ_ԂȐ𐶐B
     * </p>
     *
     * @param points	Ԃ_
     * @param params	_̊e_ɂp[^l̗
     * @param endDir	[_ł̐ڐ̕
     * @param isClosed	`̋Ȑ𐶐邩ۂ̃tO
     * @param tol	e_ɂߎ̐x
     * @param midTol	_̒Ԃɂߎ̐x
     */
    public JgclBsplineCurve3D(JgclPoint3D[] points, double[] params, JgclVector3D[] endDir,
			      boolean isClosed, JgclToleranceForDistance tol,
			      JgclToleranceForDistance midTol) {
	super();
	JgclApproximation3D doObj = new JgclApproximation3D(points, params, endDir, isClosed);
	JgclBsplineCurve3D bsc = doObj.getApproximationWithTolerance(tol, midTol);
	this.controlPoints = bsc.controlPoints;
	this.knotData = bsc.knotData;
	this.weights = bsc.weights;	// may be null
    }

    /**
     * ̋Ȑ̎ԂB
     * 
     * @return	
     */
    public int degree() {
	return knotData.degree();
    }

    /**
     * ̋Ȑ̃mbg̎ʂԂB
     * 
     * @return	mbg̎
     * @see	JgclKnotType
     */
    public int knotSpec() {
	return knotData.knotSpec();
    }

    /**
     * ̋Ȑ̃mbg̐ԂB
     * <p>
     * Ōumbg̐vƂ
     * knotData  knots tB[hɐݒ肳ꂽmbgl̔z̒ł͂ȂA
     * aXvC̃mbg{̃mbg̐łB
     * </p>
     *
     * @return	mbg̐
     */
    public int nKnotValues() {
	return knotData.nKnotValues();
    }

    /**
     * ̋Ȑ̃mbg n Ԃ߂̃mbglԂB
     * <p>
     * Ōun ԖځvƂ
     * knotData  knots tB[hɐݒ肳ꂽmbgl̔z̃CfbNXł͂ȂA
     * aXvC̃mbg{̈Ӗł̃CfbNXłB
     * </p>
     *
     * @param n	CfbNX
     * @return	n Ԃ߂̃mbgl
     */
    public double knotValueAt(int n) {
	return knotData.knotValueAt(n);
    }

    /**
     * ̋Ȑ̃ZOg̐ԂB
     *
     * @return	ZOg̐
     */
    int nSegments() {
	return knotData.nSegments();
    }

    /**
     * ̋Ȑ́Ap[^IɏkނĂȂLZOg̏ԂB
     *
     * @return	p[^IɏkނĂȂLZOg̏
     */
    JgclBsplineKnot.ValidSegmentInfo validSegments() {
	return knotData.validSegments();
    }

    /**
     * ̋Ȑ̃mbgԂB
     *
     * @return	mbg
     */
    JgclBsplineKnot knotData() {
	return knotData;
    }

    /**
     * ̋Ȑ̃p[^`悪IۂԂB
     * <p>
     * p[^hC𒲂ׂKvȂ̂ŃI[o[ChB
     * </p>
     * 
     * @return	Ił trueAłȂ false
     */
    public boolean isPeriodic() {
	return knotData.isPeriodic();
    }

    /**
     * ̋Ȑ n Ԗڂ̐_ԂB
     * <p>
     * `̏ꍇ̓CfbNXIɈB
     * </p>
     * 
     * @param n	CfbNX
     * @return	_
     */
    public JgclPoint3D controlPointAt(int n) {
	if (isPeriodic()) {
	    int ncp = nControlPoints();
	    while (n < 0) n += ncp;
	    while (n >= ncp) n -= ncp;
	}
	return controlPoints[n];
    }

    /**
     * ̋Ȑ̎ŵaXvC֐̑\̌W𓾂B
     *
     * @param coef	Zʂł鑽̌Wi[z
     * @param jjj	Z̑ΏۂƂmbg͈̔͂̐擪̃mbg̃CfbNX
     * @param seg	Z̑ΏۂƂZOg̊Jnp[^ƂȂmbg̃CfbNX
     * @param pTol	p[^l̋e덷
     */
    private void make_coef(double[] coef, int jjj, int seg, double pTol) {
	int degree = coef.length - 3;

	if (degree == 0)
	    coef[1] = (jjj == seg) ? 1.0 : 0.0;
	else {
	    double coef_1[] = new double[degree + 2];
	    double aaa;
	    double kj;
	    int ijk;

	    for (ijk = 0; ijk <= degree; ijk++)
		coef[ijk + 1] = 0.0;

	    coef_1[0] = coef_1[degree + 1] = 0.0;

	    if (jjj != (seg - degree)) {
		kj = knotValueAt(jjj);
		aaa = knotValueAt(jjj + degree) - kj;
		if (aaa > pTol) {
		    make_coef(coef_1, jjj, seg, pTol);
		    for (ijk = 0; ijk <= degree; ijk++)
			coef[ijk+1] += (coef_1[ijk+1] - coef_1[ijk]*kj) / aaa;
		}
	    }

	    if (jjj != seg) {
		kj = knotValueAt(jjj + degree + 1);
		aaa = kj - knotValueAt(jjj + 1);
		if (aaa > pTol) {
		    make_coef(coef_1, jjj + 1, seg, pTol);
		    for (ijk = 0; ijk <= degree; ijk++)
			coef[ijk+1] -= (coef_1[ijk+1] - coef_1[ijk]*kj) / aaa;
		}
	    }
	}
    }

    /**
     * ̋Ȑ̎w̃ZOg̑\ԂB
     * <p>
     * ʂƂēz R ̗vf́A
     * ̋ȐLł 3A
     * Lł 4 łB
     * </p>
     * <p>
     * LȐ̏ꍇA
     * R[0]  X A
     * R[1]  Y 
     * R[2]  Z 
     * ̑\\B
     * </p>
     * <p>
     * LȐ̏ꍇA
     * R[0]  WX A
     * R[1]  WY 
     * R[2]  WZ 
     * R[3]  W 
     * ̑\\B
     * </p>
     *
     * @param iSseg	ZOg̔ԍ
     * @param isPoly	Lł邩ǂ
     * @return	̔z
     */
    public JgclRealPolynomial[] polynomial(int iSseg, boolean isPoly) {
	int degree =  degree();
	int isckt = iSseg;
	int ijk, klm, mno, pklm, i;
	double[][] cntlPnts = toDoubleArray(isPoly);
	int uicp = nControlPoints();
	int dim = cntlPnts[0].length;
	double[][] coef = new double[dim][];
	for (i = 0; i < dim; i++)
	    coef[i] = new double[degree + 1];
        double[] eA = new double[degree + 3];
	double pTol = getToleranceForParameter();
	JgclRealPolynomial[] polynomial = new JgclRealPolynomial[dim];

	for (i = 0; i < dim; i++)
	    for (ijk = 0; ijk <= degree; ijk++)
		coef[i][ijk] = 0.0;

	for (ijk = 0, pklm = klm = isckt; ijk <= degree; ijk++, pklm++, klm++){
	    make_coef(eA, klm, (isckt + degree), pTol);

	    if ((isPeriodic()) && (pklm == uicp))
		pklm = 0;
	    for (i = 0; i < dim; i++) {
		for (mno = 0; mno <= degree; mno++)
		    coef[i][degree - mno] += eA[mno+1] * cntlPnts[pklm][i];
	    }
	}

	for (i = 0; i < dim; i++)
	    polynomial[i] = new JgclRealPolynomial(coef[i]);

	return polynomial;
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * <p>
     * pint ̑l͕ł܂ȂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ̋Ȑ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     * @see	JgclParameterOutOfRange
     */
    public double length(JgclParameterSection pint) {
        double length = 0.0;
        JgclRealFunctionWithOneVariable realFunction;
        double dTol = getToleranceForDistance() / 2.0;
	double pTol = getToleranceForParameter();

        if (!isPolynomial() || Math.abs(pint.increase()) <= pTol) {
            realFunction
                = new JgclRealFunctionWithOneVariable() {
                        public double evaluate(double parameter) {
                            return tangentVector(parameter).length();
                        }
                    };
            length = JgclMath.getDefiniteIntegral(realFunction, pint, dTol);
        }
        else {
	    JgclBsplineCurve3D tbsc = truncate(pint);
            JgclBsplineKnot.ValidSegmentInfo vsegInfo
                = tbsc.knotData.validSegments();
            int nvseg = vsegInfo.nSegments();

            for (int ijk = 0; ijk < nvseg; ijk++) {
                JgclRealPolynomial[] poly =
                    tbsc.polynomial(ijk, isPolynomial());
                final JgclRealPolynomial[] deriv =
                    new JgclRealPolynomial[poly.length];

                for (int klm = 0; klm < poly.length; klm++)
                    deriv[klm] = poly[klm].derive();

                realFunction
                    = new JgclRealFunctionWithOneVariable() {
                            public double evaluate(double parameter) {
                                final double[] tang = new double[3];
                                for (int klm = 0; klm < 3; klm++)
                                    tang[klm] = deriv[klm].evaluate(parameter);

                                return Math.sqrt(tang[0] * tang[0] +
                                                 tang[1] * tang[1] +
                                                 tang[2] * tang[2]);
                            }
                        };
                JgclParameterSection psec =
                    new JgclParameterSection(vsegInfo.knotPoint(ijk)[0],
                                             vsegInfo.knotPoint(ijk)[1]);
                length += JgclMath.getDefiniteIntegral(realFunction,
                                                       psec, dTol);
            }
        }
        return length;
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		Wl
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint3D coordinates(double param)
    {
	double[][] cntlPnts;
	double[] d0D;
	boolean isPoly = isPolynomial();

	param = checkParameter(param);
	cntlPnts = toDoubleArray(isPoly);
	d0D = JgclBsplineCurveEvaluation.coordinates(knotData, cntlPnts, param);
	if (!isPoly) {
	    convRational0Deriv(d0D);
	}
	return new JgclCartesianPoint3D(d0D[0], d0D[1], d0D[2]);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ڃxNg
     * @see	JgclParameterOutOfRange
     */
    public JgclVector3D tangentVector(double param)
    {
	double[][] cntlPnts;
	double[] d1D = new double[4];
	boolean isPoly = isPolynomial();

	param = checkParameter(param);
	cntlPnts = toDoubleArray(isPoly);
	if (isPoly) {
	    JgclBsplineCurveEvaluation.evaluation(knotData, cntlPnts, param,
						  null, d1D, null, null);
	} else {
	    double[] d0D = new double[4];

	    JgclBsplineCurveEvaluation.evaluation(knotData, cntlPnts, param,
						  d0D, d1D, null, null);
	    convRational1Deriv(d0D, d1D);
	}
	return new JgclLiteralVector3D(d1D[0], d1D[1], d1D[2]);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ȗ
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveCurvature3D curvature(double param)
    {
	int degree;
	JgclCurveDerivative3D deriv;
	boolean tang0;
	double tang_leng;
	JgclVector3D ewvec;
	double dDcrv;
	JgclVector3D dDnrm;
	JgclCurveCurvature3D crv;
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double tol_d = condition.getToleranceForDistance();

	degree = degree();
	deriv = evaluation(param);

	tang_leng = deriv.d1D().norm();
	if (tang_leng < (tol_d * tol_d)) {
	    tang0 = true;
	} else {
	    tang0 = false;
	}

	if ((degree < 2) || (tang0 == true)) {
	    dDcrv = 0.0;
	    dDnrm = JgclVector3D.zeroVector;
	} else {
	    tang_leng = Math.sqrt(tang_leng);
	    dDcrv = tang_leng * tang_leng * tang_leng;

	    ewvec = deriv.d1D().crossProduct(deriv.d2D());
	    dDcrv = ewvec.magnitude() / dDcrv;
	    dDnrm = ewvec.crossProduct(deriv.d1D()).unitized();
	}

	return new JgclCurveCurvature3D(dDcrv, dDnrm);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̃CԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		C
     * @see	JgclParameterOutOfRange
     */
    public double torsion(double param)
    {
	int degree;
	JgclCurveDerivative3D deriv;
	boolean tang0, curv0;
	double tang_leng;
	JgclVector3D ewvec;
	double ewrk1, ewrk2;
	double dDcrv;
	double dDtsn;
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double tol_d = condition.getToleranceForDistance();

	degree = degree();
	deriv = evaluation(param);

	tang_leng = deriv.d1D().norm();
	if (tang_leng < (tol_d * tol_d)) {
	    tang0 = true;
	} else {
	    tang0 = false;
	}

	if ((degree < 2) || (tang0 == true)) {
	    dDcrv = 0.0;
	    curv0 = true;
	    ewrk2 = 0.0;
	    ewvec = null;
	} else {
	    tang_leng = Math.sqrt(tang_leng);
	    ewrk2 = dDcrv = tang_leng * tang_leng * tang_leng;

	    ewvec = deriv.d1D().crossProduct(deriv.d2D());
	    dDcrv = ewvec.magnitude() / dDcrv;
	    curv0 = false;
	}

	if (degree < 3 || curv0) {
	    dDtsn = 0.0;
	} else {
	    ewrk1 = ewvec.dotProduct(deriv.d3D());
	    ewrk2 = ewrk2 * ewrk2 * dDcrv * dDcrv;
	    dDtsn = ewrk1 / ewrk2;
	}

	return dDtsn;
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		֐
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveDerivative3D evaluation(double param)
    {
	double[][] cntlPnts;
	double[] ld0D = new double[4];
	double[] ld1D = new double[4];
	double[] ld2D = new double[4];
	double[] ld3D = new double[4];
	JgclPoint3D d0D;
	JgclVector3D d1D;
	JgclVector3D d2D;
	JgclVector3D d3D;
	boolean isPoly = isPolynomial();

	param = checkParameter(param);
	cntlPnts = toDoubleArray(isPoly);
	JgclBsplineCurveEvaluation.evaluation(knotData, cntlPnts, param,
					      ld0D, ld1D, ld2D, ld3D);
	if (!isPoly) {
	    convRational3Deriv(ld0D, ld1D, ld2D, ld3D);
	}
	d0D = new JgclCartesianPoint3D(ld0D[0], ld0D[1], ld0D[2]);
	d1D = new JgclLiteralVector3D(ld1D[0], ld1D[1], ld1D[2]);
	d2D = new JgclLiteralVector3D(ld2D[0], ld2D[1], ld2D[2]);
	d3D = new JgclLiteralVector3D(ld3D[0], ld3D[1], ld3D[2]);
	return new JgclCurveDerivative3D(d0D, d1D, d2D, d3D);
    }

    /**
     * ̋Ȑ́A^ꂽp[^ɑ΂ubT~ǑʂԂB
     * <p>
     * parameters ̗vf́A̋Ȑ̎ɈvĂKvB
     * </p>     
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param segNumber	ZΏۂƂȂZOg̔ԍ (擪 0)
     * @param parameters	p[^l̔z
     * @return	ubT~ǑʂłWl
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint3D blossoming(int segNumber,
				  double[] parameters)
    {
	double[] adjustedParameters = new double[this.degree()];
	for (int i = 0; i < this.degree(); i++)
	    adjustedParameters[i] = this.checkParameter(parameters[i]);
	boolean isPoly = this.isPolynomial();

	double[] d0D =
	    JgclBsplineCurveEvaluation.blossoming(knotData,
						  toDoubleArray(isPoly),
						  segNumber,
						  adjustedParameters);

	if (isPoly == true)
	    return new JgclCartesianPoint3D(d0D[0], d0D[1], d0D[2]);
	else
	    return new JgclHomogeneousPoint3D(d0D[0], d0D[1], d0D[2], d0D[3]);
    }

    /**
     * ̋Ȑ̒[_ٓ_Aϋȓ_̉ƂȂ邩ǂ𒲂ׂB
     *
     * @param minParam	ZOg̎n_̃p[^l
     * @param maxParam	ZOg̏I_̃p[^l
     * @param minDegree	
     * @param seg	ZOg̃CfbNX
     * @param nvseg	LȃZOg̐
     * @param paramVec	ێ郊Xg
     */
    private void checkEndPoint(double minParam,
			       double maxParam,
			       int minDegree,
			       int seg,
			       int nvseg,
			       Vector paramVec) {
	int mno;
	if (degree() < minDegree) {
	    if (isClosed() && (paramVec.size() == 0)) {
		paramVec.addElement(new Double(minParam));
	    }
	    if (seg != (nvseg - 1)) {
		for (mno = 0; mno < paramVec.size(); mno++)
		    if (identicalParameter(((Double)paramVec.elementAt(mno)).
					   doubleValue(), maxParam))
			break;
		if (mno == paramVec.size())
		    paramVec.addElement(new Double(maxParam));
	    }
	}
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ٓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return		ٓ_̔z
     */
    public JgclPointOnCurve3D[] singular() {
        JgclBsplineKnot.ValidSegmentInfo vsegInfo = knotData.validSegments();
        int nvseg = vsegInfo.nSegments();
        int numseg = nSegments();
        JgclPureBezierCurve3D[] bzcs = toPureBezierCurveArray();
        int minDegree = 2;
        int ijk, klm, mno;
        Vector snglrParam = new Vector();

        for (ijk = 0; ijk < numseg; ijk++) {
	    double minParam;
	    double maxParam;
            if ((klm = vsegInfo.isValidSegment(ijk)) < 0) {
                // kޏi[BkދԂ̃p[^𓾂B
  		minParam = knotValueAt(degree() + ijk);
  		maxParam = knotValueAt(degree() + ijk + 1);
		checkEndPoint(minParam, maxParam, minDegree, ijk, nvseg, snglrParam);
		continue;
            }

	    // ZOg̗[_ɉ邩ǂ̌
            minParam = vsegInfo.knotPoint(klm)[0];
            maxParam = vsegInfo.knotPoint(klm)[1];
	    checkEndPoint(minParam, maxParam, minDegree, klm, nvseg, snglrParam);

	    // ZOgɉ邩ׂ
            JgclPointOnCurve3D[] singularOnBzc;
            try {
                singularOnBzc = bzcs[klm].singular();
            }
            catch (JgclIndefiniteSolution e) {
		// BezierCurve ŜkނĂꍇB
		// BezierCurve ̗[_̃p[^߉ɉB(łɉɉĂH)
                continue;
            }

	    // ̈Ӑ𒲂ׂB
            for (klm = 0; klm < singularOnBzc.length; klm++) {
                double candidateParam = (maxParam - minParam) *
                    singularOnBzc[klm].parameter() + minParam;
                for (mno = 0; mno < snglrParam.size(); mno++) {
                    if (identicalParameter(((Double)snglrParam.elementAt(mno)).
                                           doubleValue(), candidateParam))
                        break;
                }
                if (mno == snglrParam.size())
                    snglrParam.addElement(new Double(candidateParam));
            }
        }
        
        int numberOfSolution = snglrParam.size();
        JgclPointOnCurve3D[] singular =
            new JgclPointOnCurve3D[numberOfSolution];
        for (ijk = 0; ijk < numberOfSolution; ijk++) {
            singular[ijk] = new JgclPointOnCurve3D
                (this, ((Double)snglrParam.elementAt(ijk)).
                 doubleValue(), false);
        }
        return singular;
    }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * ϋȓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return	ϋȓ_̔z
     */
    public JgclPointOnCurve3D[] inflexion() {
        JgclBsplineKnot.ValidSegmentInfo vsegInfo = knotData.validSegments();
        int nvseg = vsegInfo.nSegments();
        int numseg = nSegments();
        JgclPureBezierCurve3D[] bzcs = toPureBezierCurveArray();
        int minDegree = 3;
        int ijk, klm, mno;
        Vector inflxParam = new Vector();

        for (ijk = 0; ijk < numseg; ijk++) {
	    double minParam;
	    double maxParam;
            if ((klm = vsegInfo.isValidSegment(ijk)) < 0) {
		// k or ȗ 0 Ԃ̃p[^𓾂B
  		minParam = knotValueAt(degree() + ijk);
  		maxParam = knotValueAt(degree() + ijk + 1);
		checkEndPoint(minParam, maxParam, minDegree, ijk, nvseg, inflxParam);
		continue;
            }

	    // ZOg̗[_ɉ邩ǂ̌
            minParam = vsegInfo.knotPoint(klm)[0];
            maxParam = vsegInfo.knotPoint(klm)[1];
	    checkEndPoint(minParam, maxParam, minDegree, klm, nvseg, inflxParam);

	    // ZOgɉ邩ׂ
            JgclPointOnCurve3D[] inflexionOnBzc;
            try {
                inflexionOnBzc = bzcs[klm].inflexion();
            }
            catch (JgclIndefiniteSolution e) {
		// BezierCurve Ŝ ȗ 0 Ԃ̏ꍇ
		// BezierCurve ̗[_̃p[^߉ɉB(łɉĂ?)
		continue;
            }

	    // ̈Ӑ𒲂ׂB
            for (klm = 0; klm < inflexionOnBzc.length; klm++) {
                double candidateParam = (maxParam - minParam) *
                    inflexionOnBzc[klm].parameter() + minParam;
                for (mno = 0; mno < inflxParam.size(); mno++) {
                    if (identicalParameter(((Double)inflxParam.elementAt(mno)).
                                           doubleValue(), candidateParam))
                        break;
                }
                if (mno == inflxParam.size())
                    inflxParam.addElement(new Double(candidateParam));
            }
        }
        
        int numberOfSolution = inflxParam.size();
        JgclPointOnCurve3D[] inflexion =
            new JgclPointOnCurve3D[numberOfSolution];
        for (ijk = 0; ijk < numberOfSolution; ijk++) {
            inflexion[ijk] = new JgclPointOnCurve3D
                (this, ((Double)inflxParam.elementAt(ijk)).
                 doubleValue(), false);
        }
        return inflexion;
    }

    /**
     * ̗LȐŜɍČL Bspline ȐԂB
     * 
     * @return	̋ȐŜČL Bspline Ȑ
     */
    public JgclBsplineCurve3D toBsplineCurve() {
	if (this.isRational() == true)
	    return this;

	return new JgclBsplineCurve3D(this.knotData,
				      this.controlPoints,
				      this.makeUniformWeights());
    }

    /**
     * ̋Ȑ̎w̋ԂɍČL Bspline ȐԂB
     * <p>
     * pint ̒lÂaXvCȐ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param pint	L Bspline ȐōČp[^
     * @return		̋Ȑ̎w̋ԂČL Bspline Ȑ
     * @see	JgclParameterOutOfRange
     */
    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
	JgclBsplineCurve3D target;
	if (this.isPeriodic() == true) {
	    if (pint.absIncrease() >= this.parameterDomain().section().absIncrease()) {
		target = this;
		try {
		    target = target.shiftIfPeriodic(pint.start());
		} catch (JgclOpenCurve e) {
		    ;	// N蓾Ȃ͂
		}
		if (pint.increase() < 0.0)
		    target = target.reverse();
	    } else {
		target = this.truncate(pint);
	    }
	} else {
	    target = this.truncate(pint);
	}
	return target.toBsplineCurve();
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) 
	throws JgclIndefiniteSolution {
	return mate.intersect(this, true);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * aXvCƒ̌_\㐔ɋAĉĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
	JgclBsplineKnot.ValidSegmentInfo vsegInfo = knotData.validSegments();
	JgclAxis2Placement3D placement =
	    new JgclAxis2Placement3D(mate.pnt(), mate.dir().verticalVector(), mate.dir());
	JgclCartesianTransformationOperator3D transform =
	    new JgclCartesianTransformationOperator3D(placement, 1.0);
	int uicp = nControlPoints();
	JgclPoint3D[] newCp = new JgclPoint3D[uicp];

	// Transform Bspline's control points into conic's local coordinates
	for (int i = 0; i < uicp; i++)
	    newCp[i] = transform.toLocal(controlPointAt(i));

	double[] weights = weights();
	if (isRational()) {
	    double max_weight = 0.0;
	    for (int i = 0; i < uicp; i++)
		if (Math.abs(weights[i]) > max_weight)
		    max_weight = weights[i];

	    if (max_weight > 0.0)
		for (int i = 0; i < uicp; i++) {
		    weights[i] /= max_weight;
		}
	}

	// make Bspline curve from new control points
	JgclBsplineCurve3D bsc = new
	    JgclBsplineCurve3D(knotData, newCp, weights);

	// For each segment
	Vector lineParam = new Vector();
	Vector bscParam = new Vector();
	int nSeg = vsegInfo.nSegments();
	int k = 0;
	int degree = bsc.degree();
	JgclPoint3D[] anotherCp = new JgclPoint3D[degree + 3];
	for (int i = 0; i < nSeg; i++) {
	    // If the control points of the segment and the line is coplaner,
	    // solve in 2D space.
	    int l, m;
	    for (l = 0, m = vsegInfo.segmentNumber(i); l <= degree; l++, m++)
		anotherCp[l] = bsc.controlPointAt(m);
	    anotherCp[l++] = JgclPoint3D.origin;
	    anotherCp[l] = new JgclCartesianPoint3D(1.0, 0.0, 0.0);

	    //check coplaner
	    JgclVector3D verticalVector = JgclPlane3D.coplaner(anotherCp);

	    JgclBsplineCurve3D oldBsc = null;
	    if (verticalVector != null) {
		if (verticalVector.norm() < getToleranceForDistance()) continue;	// ??
		JgclVector3D crossVector =
		    verticalVector.crossProduct(JgclVector3D.xUnitVector).unitized();

		JgclCartesianTransformationOperator3D transformToPlane =
		    new JgclCartesianTransformationOperator3D
			(JgclVector3D.xUnitVector, crossVector, verticalVector,
			 JgclPoint3D.origin, 1.0);
		// transform 
		JgclPoint3D[] cpOnPlane = new JgclPoint3D[uicp];
		for (l = 0; l < uicp; l++)
		    cpOnPlane[l] = JgclPoint3D.origin;	// dummy
		for (l = 0, m = vsegInfo.segmentNumber(i); l <= degree; l++, m++) {
		    if (m >= uicp) m = 0;
		    cpOnPlane[m] = transformToPlane.toLocal(anotherCp[l]);
		}

		// reserve old control points in Bsc,
		oldBsc = bsc;

		// and set new control points.
		bsc = new JgclBsplineCurve3D(bsc.knotData(), cpOnPlane, weights);
	    }

	    // make polynomial
	    JgclRealPolynomial[] realPoly =
		bsc.polynomial(vsegInfo.segmentNumber(i), isPolynomial());

	    JgclComplexPolynomial compPoly;
	    if (oldBsc != null) {
		bsc = oldBsc;
		compPoly = realPoly[1].toComplexPolynomial();
	    }
	    else {
		JgclRealPolynomial yPoly = realPoly[1].multiply(realPoly[1]);
		JgclRealPolynomial zPoly = realPoly[2].multiply(realPoly[2]);
		compPoly = yPoly.add(zPoly).toComplexPolynomial();
	    }

	    // solve polynomial
	    JgclComplex[] roots;
	    try {
		roots = compPoly.getRootsByDKA();
	    }
	    catch (JgclComplexPolynomial.DKANotConverge e) {
		roots = e.getValues();
	    }
	    catch (JgclComplexPolynomial.ImpossibleEquation e) {
		throw new JgclFatal();
	    }
	    catch (JgclComplexPolynomial.IndefiniteEquation e) {
		throw new JgclFatal();
	    }

	    // extract root
	    int nRoots = roots.length;
	    for (int j = 0; j < nRoots; j++) {
		double realRoot = roots[j].real();
		if (bsc.parameterValidity(realRoot) == JgclParameterValidity.OUTSIDE)
		    continue;

		double[] knotParams = vsegInfo.knotPoint(i);
		if (realRoot < knotParams[0]) realRoot = knotParams[0];
		if (realRoot > knotParams[1]) realRoot = knotParams[1];

		JgclPoint3D workPoint = bsc.coordinates(realRoot);
		// check solution
		double dTol = bsc.getToleranceForDistance();
		int jj;
		if (workPoint.y() * workPoint.y() + workPoint.z() * workPoint.z()
		    < getToleranceForDistance2()) {
		    for (jj = 0; jj < k; jj++) {
			double paramA = ((Double)lineParam.elementAt(jj)).doubleValue();
			double paramB = ((Double)bscParam.elementAt(jj)).doubleValue();
			if ((Math.abs(paramA - workPoint.x()) < dTol)
			    && (bsc.identicalParameter(paramA, paramB)))
			    break;
		    }
		    if (jj >= k) {
			lineParam.addElement(new Double(workPoint.x()));
			bscParam.addElement(new Double(realRoot));
			k++;
		    }
		}
	    }
	}

	// make intersection point
	int num = bscParam.size();
	JgclIntersectionPoint3D[] intersectPoint = new
	    JgclIntersectionPoint3D[num];
	double mateLength = mate.dir().length();
	for (int i = 0; i < k; i++) {
	    double work = ((Double)lineParam.elementAt(i)).doubleValue() / mateLength;
	    JgclPointOnCurve3D pointOnLine = new
		JgclPointOnCurve3D(mate, work, doCheckDebug);

	    work = ((Double)bscParam.elementAt(i)).doubleValue();
	    JgclPointOnCurve3D pointOnBsc = new
		JgclPointOnCurve3D(this, work, doCheckDebug);

	    JgclPoint3D coordinates = coordinates(work);
	    if (!doExchange)
		intersectPoint[i] = new JgclIntersectionPoint3D
		    (coordinates, pointOnBsc, pointOnLine, doCheckDebug);
	    else
		intersectPoint[i] = new JgclIntersectionPoint3D
		    (coordinates, pointOnLine, pointOnBsc, doCheckDebug);
	}

	return intersectPoint;
    }

    /**
     * ̂aXvCȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ~̃NX́u~ vs. aXvCȐv̌_Z\bh
     * {@link JgclCircle3D#intersect(JgclBsplineCurve3D, boolean)
     * JgclCircle3D.intersect(JgclBsplineCurve3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (~)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȉ~̃NX́uȉ~ vs. aXvCȐv̌_Z\bh
     * {@link JgclEllipse3D#intersect(JgclBsplineCurve3D, boolean)
     * JgclEllipse3D.intersect(JgclBsplineCurve3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ̃NX́u vs. aXvCȐv̌_Z\bh
     * {@link JgclParabola3D#intersect(JgclBsplineCurve3D, boolean)
     * JgclParabola3D.intersect(JgclBsplineCurve3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * oȐ̃NX́uoȐ vs. aXvCȐv̌_Z\bh
     * {@link JgclHyperbola3D#intersect(JgclBsplineCurve3D, boolean)
     * JgclHyperbola3D.intersect(JgclBsplineCurve3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (oȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * |C̃NX́u|C vs. aXvCȐv̌_Z\bh
     * {@link JgclPolyline3D#intersect(JgclBsplineCurve3D, boolean)
     * JgclPolyline3D.intersect(JgclBsplineCurve3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (|C)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsBzcBsc3D#intersection(JgclPureBezierCurve3D, JgclBsplineCurve3D, boolean)
     * JgclIntsBzcBsc3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
	return JgclIntsBzcBsc3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsBscBsc3D#intersection(JgclBsplineCurve3D, JgclBsplineCurve3D, boolean)
     * JgclIntsBscBsc3D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
	return JgclIntsBscBsc3D.intersection(this, mate, doExchange);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. aXvCȐv̌_Z\bh
     * {@link JgclTrimmedCurve3D#intersect(JgclBsplineCurve3D, boolean)
     * JgclTrimmedCurve3D.intersect(JgclBsplineCurve3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (gȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ (ȐZOg) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. aXvCȐv̌_Z\bh
     * {@link JgclCompositeCurveSegment3D#intersect(JgclBsplineCurve3D, boolean)
     * JgclCompositeCurveSegment3D.intersect(JgclBsplineCurve3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ (Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐNX́uȐ vs. aXvCȐv̌_Z\bh
     * {@link JgclCompositeCurve3D#intersect(JgclBsplineCurve3D, boolean)
     * JgclCompositeCurve3D.intersect(JgclBsplineCurve3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗʂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return		_̔z
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate)
	throws JgclIndefiniteSolution {
	return mate.intersect(this, true);
    }

    /**
     * ̋ȐƑ̋Ȗ (͋Ȗ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ (͋Ȗ)
     * @return		_̔z
     */
    public JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate) {
	return mate.intersect(this, true);
    }

    /**
     * ̋ȐƑ̋Ȗ (͋Ȗ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ (͋Ȗ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate,
					boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ (xWGȖ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ (xWGȖ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate,
					boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ (aXvCȖ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ (aXvCȖ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate,
					boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		Ȑ̊̔z
     */
    public JgclCurveCurveInterference3D[] interfere(JgclBoundedCurve3D mate) {
	return mate.interfere(this, true);
    }

    /**
     * ̗LȐƑ̗LȐ () Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̃NX́u vs. aXvCȐv̊Z\bh
     * {@link JgclBoundedLine3D#interfere(JgclBsplineCurve3D, boolean)
     * JgclBoundedLine3D.interfere(JgclBsplineCurve3D, boolean)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclBoundedLine3D mate,
					     boolean doExchange)
    {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (|C) Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * |C̃NX́u|C vs. aXvCȐv̊Z\bh
     * {@link JgclPolyline3D#interfere(JgclBsplineCurve3D, boolean)
     * JgclPolyline3D.interfere(JgclBsplineCurve3D, boolean)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclPolyline3D mate,
					     boolean doExchange)
    {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (xWGȐ) Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsBzcBsc3D#interference(JgclPureBezierCurve3D, JgclBsplineCurve3D, boolean)
     * JgclIntsBzcBsc3D.interference}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclPureBezierCurve3D mate,
					     boolean doExchange)
    {
	return JgclIntsBzcBsc3D.interference(mate, this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (aXvCȐ) Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsBscBsc3D#interference(JgclBsplineCurve3D, JgclBsplineCurve3D, boolean)
     * JgclIntsBscBsc3D.interference}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclBsplineCurve3D mate,
					     boolean doExchange)
    {
	return JgclIntsBscBsc3D.interference(this, mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (gȐ) Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * gȐ̃NX́ugȐ vs. aXvCȐv̊Z\bh
     * {@link JgclTrimmedCurve3D#interfere(JgclBsplineCurve3D, boolean)
     * JgclTrimmedCurve3D.interfere(JgclBsplineCurve3D, boolean)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclTrimmedCurve3D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (ȐZOg) Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ȐZOg̃NX́uȐZOg vs. aXvCȐv̊Z\bh
     * {@link JgclCompositeCurveSegment3D#interfere(JgclBsplineCurve3D, boolean)
     * JgclCompositeCurveSegment3D.interfere(JgclBsplineCurve3D, boolean)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurveSegment3D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (Ȑ) Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * Ȑ̃NX́uȐ vs. aXvCȐv̊Z\bh
     * {@link JgclCompositeCurve3D#interfere(JgclBsplineCurve3D, boolean)
     * JgclCompositeCurve3D.interfere(JgclBsplineCurve3D, boolean)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurve3D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̋Ȑ́Aw̃p[^l̈ʒuɐVȃmbg}ȐԂB
     * <p>
     * `͂̋Ȑ̂܂܂ŁAZOgaXvCȐԂB
     * </p>
     *
     * @param param	mbg}p[^l
     * @return	mbg}̂aXvCȐ
     */
    public JgclBsplineCurve3D insertKnot(double param) {
	double[][] cntlPnts;
	boolean isPoly = isPolynomial();
	Object[] result;
	JgclBsplineKnot newKnotData;
	double[][] newControlPoints;
	JgclBsplineCurve3D bsc;

	param = checkParameter(param);
	cntlPnts = toDoubleArray(isPoly);
	result = JgclBsplineCurveEvaluation.insertKnot(knotData, cntlPnts, param);
	newKnotData = (JgclBsplineKnot)result[0];
	newControlPoints = (double[][])result[1];
	return new JgclBsplineCurve3D(newKnotData, newControlPoints);
    }

    /**
     * ̂aXvCȐA^ꂽp[^lŕB
     * <p>
     * ̋ȐJ`̏ꍇɂ́A
     * param ɑΉ_őO{ɕB
     * ʂƂēz̗vf 2 ŁA
     * ŏ̗vfɁun_番_܂ł\aXvCȐ AvA
     * Ԗڂ̗vfɁu_I_܂ł\aXvCȐ Bv
     * B
     * ̋Ȑ̃p[^` [start, end] ƂƁA
     * A ̃p[^` [start, param]A
     * B ̃p[^` [0, (end - param)] ɂȂB
     * </p>
     * <p>
     * ̋Ȑ`̏ꍇɂ́A
     * param ɑΉ_𗼒[ƂJ`
     * {̂aXvCȐ C ɕϊB
     * ʂƂēz̗vf 1 łB
     * ̋Ȑ̃p[^` [start, end] ƂƁA
     * C ̃p[^` [0, (end - start)] ɂȂB
     * </p>
     * <p>
     * param ̒lÂaXvCȐ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param param	p[^l
     * @return	̂aXvCȐ܂ޔz
     * @see	JgclParameterOutOfRange
     */
    public JgclBsplineCurve3D[] divide(double param)
    {
	double[][] cntlPnts;
	boolean isPoly = isPolynomial();
	JgclBsplineKnot[] newKnotData = new JgclBsplineKnot[2];
	double[][][] newControlPoints = new double[2][][];
	int n_bsc;
	JgclBsplineCurve3D[] bsc;

	param = checkParameter(param);
	cntlPnts = toDoubleArray(isPoly);
	JgclBsplineCurveEvaluation.divide(knotData, cntlPnts, param,
					  newKnotData, newControlPoints);
	if (newKnotData[0] == null)
	    throw new JgclFatal();
	else if (newKnotData[1] == null)
	    n_bsc = 1;
	else
	    n_bsc = 2;

	bsc = new JgclBsplineCurve3D[n_bsc];

	for (int i = 0; i < n_bsc; i++) {
	    try {
		bsc[i] = new JgclBsplineCurve3D(newKnotData[i], newControlPoints[i]);
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}

	return bsc;
    }

    /**
     * ̂aXvCȐA^ꂽp[^ԂŐؒfB
     * <p>
     * section ̑l̏ꍇɂ́Ais]aXvCȐԂB
     * </p>
     * <p>
     * section ̒lÂaXvCȐ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * <p>
     * ؒf̋Ȑ̃p[^` [0, section.absIncrease()] ɂȂB
     * </p>
     *
     * @param section	ؒfĎc\p[^
     * @return	ؒfĎc\aXvCȐ
     * @see	JgclParameterOutOfRange
     */
    public JgclBsplineCurve3D truncate(JgclParameterSection section)
    {
	// sKnot𐶐Ă܂߃G[ƂB
	if (Math.abs(section.increase()) <= getToleranceForParameter())
	    throw new JgclInvalidArgumentValue();

	double start_par, end_par;
	JgclBsplineCurve3D t_bsc;

	if (isNonPeriodic()) {	// open curve
	    start_par = checkParameter(section.lower());
	    end_par = checkParameter(section.upper());

	    t_bsc = divide(start_par)[1];
	    t_bsc = t_bsc.divide(end_par - start_par)[0];
	} else {		// closed curve
	    double crv_intvl = parameterDomain().section().increase();
	    double tol_p = JgclConditionOfOperation.getCondition().getToleranceForParameter();

	    start_par = checkParameter(section.start());
	    t_bsc = divide(start_par)[0];
	    if (Math.abs(section.increase()) < crv_intvl - tol_p) {
		if (section.increase() > 0.0) {
		    end_par = section.increase();
		    t_bsc = t_bsc.divide(end_par)[0];
		} else {
		    end_par = crv_intvl + section.increase();
		    t_bsc = t_bsc.divide(end_par)[1];
		}
	    }
	}

	if (section.increase() < 0.0)
	    t_bsc = t_bsc.reverse();

	return t_bsc;
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * Ȑ̂_ P(t) ^ꂽ_֌xNg
     * P(t) ɂڃxNg P'(t) ̓ς\ D(t) 𐶐A
     * ӂƂ㐔 D(t) = 0 ĂB
     * </p>
     * 
     * @param point	e̓_
     * @return	e_̔z
     */
    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D mate) {
	int dimension = 3;
	int ijk, klm, mno, i;	// loop counter
	int coef_size = isPolynomial() ? dimension : dimension+1;
	JgclRealPolynomial work0, work1, work2, sub;
	double[] work3;
	JgclRealPolynomial[] pointPoly;
	JgclRealPolynomial[] offsPoly = new JgclRealPolynomial[dimension];
	JgclRealPolynomial[] tangPoly = new JgclRealPolynomial[coef_size];
	JgclRealPolynomial[] dotePoly = new JgclRealPolynomial[dimension];
	
        JgclBsplineKnot.ValidSegmentInfo vsegInfo = knotData.validSegments();
	JgclPointOnCurve3D proj;
	JgclPointOnGeometryList projList = new JgclPointOnGeometryList();
	double dTol = getToleranceForDistance();
	JgclComplexPolynomial dtPoly;
	JgclComplex[] root;
	double[] intv;
	JgclParameterDomain domain;
	double par;
	
	for (ijk = 0; ijk < vsegInfo.nSegments(); ijk++) {
	    pointPoly = polynomial(vsegInfo.segmentNumber(ijk), isPolynomial());
	    if (isRational()) {
		offsPoly[0] = pointPoly[dimension].multiply(mate.x());
		offsPoly[1] = pointPoly[dimension].multiply(mate.y());
		offsPoly[2] = pointPoly[dimension].multiply(mate.z());
	    }
	    else {
		double coef[][] = {{ mate.x() }, { mate.y() }, { mate.z() }};
		offsPoly[0] = new JgclRealPolynomial(coef[0]);
		offsPoly[1] = new JgclRealPolynomial(coef[1]);
		offsPoly[2] = new JgclRealPolynomial(coef[2]);
	    }

	    for (i = 0; i < dimension; i++)
		pointPoly[i] = pointPoly[i].subtract(offsPoly[i]);

	    // polynomial of tangent vector
	    for (klm = 0; klm < coef_size; klm++)
		tangPoly[klm] = pointPoly[klm].derive();
	    
	    /*
	     * polynomial for position --> for difference with point A
	     * polynomial for dot product
	     */
	    if (!isRational()) {
		for (klm = 0; klm < dimension; klm++)
		    dotePoly[klm] = pointPoly[klm].multiply(tangPoly[klm]);
	    } else {
		for (klm = 0; klm < 3; klm++) {
		    work0 = pointPoly[3].multiply(tangPoly[klm]);
		    work1 = tangPoly[3].multiply(pointPoly[klm]);
		    // ((a * t^n) * (nb * t^(n-1))) - ((na * t^(n-1)) * (b * t^n)) == 0
		    work2 = work0.subtract(work1);
		    work3 = work2.coefficientsBetween(0, (work2.degree() - 1));
		    sub = new JgclRealPolynomial(work3);
		    dotePoly[klm] = pointPoly[klm].multiply(sub);
		}
	    }

	    try {
		dtPoly = dotePoly[0].add(dotePoly[1]).add(dotePoly[2]).toComplexPolynomial();
	    }
	    catch(JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }

	    try {
		root = dtPoly.getRootsByDKA();
	    }
	    catch (JgclComplexPolynomial.DKANotConverge e) {
		root = e.getValues();
	    }
	    catch (JgclComplexPolynomial.ImpossibleEquation e) {
		throw new JgclFatal();
	    }
	    catch (JgclComplexPolynomial.IndefiniteEquation e) {
		throw new JgclFatal();
	    }
	    
	    // extract proper roots
	    intv = vsegInfo.knotPoint(ijk);
	    domain = new JgclParameterDomain(false, intv[0], intv[1]-intv[0]);

	    for (mno = 0; mno < root.length; mno++) {
		par = root[mno].real();
		if (!domain.isValid(par))
		    continue;
		par = domain.force(par);
		proj = checkProjection(par, mate, dTol*dTol);
		if (proj != null)
		    projList.addPoint(proj);
	    }
	}

	return projList.toJgclPointOnCurve3DArray();
    }

    /**
     * ́u`v̂aXvCȐ̌`ςɁA
     * ^ꂽp[^lɑΉ_Jn_Ƃ悤
     * ϊ̂ԂB
     * <p>
     * ʂƂēaXvCȐ̊Jn_̃p[^l͏ 0 ɂȂB
     * </p>
     *
     * @param	newStartParam	Jn_ƂȂp[^l
     * @return	^ꂽp[^lɑΉ_Jn_ƂaXvCȐ
     * @exception JgclOpenCurve	̋Ȑ͊J`ł
     */
    public JgclBsplineCurve3D shiftIfPeriodic(double newStartParam)
	 throws JgclOpenCurve
    {
	if (this.isPeriodic() != true)
	    throw new JgclOpenCurve();

	newStartParam = this.parameterDomain().wrap(newStartParam);

	// 擪ɂȂZOg̔ԍ𓾂
	int newFirstSegment =
	    this.knotData().getSegmentNumberThatStartIsEqualTo(newStartParam);

	if (newFirstSegment == (- 1))
	    return this.insertKnot(newStartParam).shiftIfPeriodic(newStartParam);

	// mbgf[^̐
	JgclBsplineKnot newKnotData = this.knotData().shift(newFirstSegment);

	// _̐
	int nNewControlPoints = newKnotData.nControlPoints();
	JgclPoint3D[] newControlPoints = new JgclPoint3D[nNewControlPoints];

	for (int i = 0; i < nNewControlPoints; i++)
	    newControlPoints[i] =
		this.controlPointAt((i + newFirstSegment) % nNewControlPoints);

	// dݗ̐
	double[] newWeights = null;
	if (this.isRational() == true) {
	    newWeights = new double[nNewControlPoints];

	    for (int i = 0; i < nNewControlPoints; i++)
		newWeights[i] =
		    this.weightAt((i + newFirstSegment) % nNewControlPoints);
	}

	return new JgclBsplineCurve3D(newKnotData, newControlPoints, newWeights);
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_
     * ̋Ȑx[XȐƂ JgclPointOnCurve3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * section ̒lÃxWGȐ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param section	ߎp[^
     * @param tolerance	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     * @see	JgclParameterOutOfRange
     */
    public JgclPolyline3D toPolyline(JgclParameterSection section,
				     JgclToleranceForDistance tolerance)
    {
	JgclBsplineKnot.ValidSegmentInfo vseg_info;
	int nseg;
	double lower_limit, upper_limit;
	double my_sp, my_ep;
	int my_sseg, my_eseg;
	JgclPureBezierCurve3D[] bzcs;
	int no_total_pnts;
	segmentInfo[] seg_infos;
	double[] kp;
	double bzc_sp, bzc_ep, bzc_ip;
	JgclParameterSection lpint;
	JgclPolyline3D lpol;
	JgclPoint3D[] pnts;
	JgclPointOnCurve3D lpnt;
	JgclPoint3D pnt;
	double param;
	int npnts;
	double tol_p = JgclConditionOfOperation.getCondition().getToleranceForParameter();
	int i, j, m;

	/*
	 * check the parametric consistency
	 */
	vseg_info = knotData.validSegments();
	nseg = vseg_info.nSegments();
	lower_limit = vseg_info.knotPoint(0)[0];
	upper_limit = vseg_info.knotPoint(nseg-1)[1];

	if (isPeriodic()) {
	    /*
	     * closed curve
	     */
	    JgclBsplineCurve3D o_bsc;	/* open curve */
	    double par_intvl = upper_limit - lower_limit; 

	    my_sp = checkParameter(section.start());
	    o_bsc = divide(my_sp)[0];

	    if (section.increase() > 0.0)
		my_sp = lower_limit;
	    else
		my_sp = upper_limit;

	    lpint = new JgclParameterSection(my_sp, section.increase());
	    lpol = o_bsc.toPolyline(lpint, tolerance);

	    pnts = new JgclPoint3D[npnts = lpol.nPoints()];
	    for (i = 0; i < npnts; i++) {
		lpnt = (JgclPointOnCurve3D)lpol.pointAt(i);
		pnt = new JgclCartesianPoint3D(lpnt.x(), lpnt.y(), lpnt.z());
		param = lpnt.parameter() + section.start();
		if (param > upper_limit) param -= upper_limit;
		pnts[i] = new JgclPointOnCurve3D(pnt, this, param, doCheckDebug);
	    }
	    return new JgclPolyline3D(pnts);
	}

	my_sp = checkParameter(section.lower());
	my_ep = checkParameter(section.upper());
  
	my_sseg = vseg_info.segmentIndex(my_sp);
	my_eseg = vseg_info.segmentIndex(my_ep);

	/*
	 * exchange Bspline Curve to Bezier Curves
	 */
	bzcs = toPureBezierCurveArray();

	/*
	 * solution in bezier form
	 */
	no_total_pnts = 0;
	seg_infos = new segmentInfo[nseg];

	for (i = my_sseg; i <= my_eseg; i++) {
	    kp = vseg_info.knotPoint(i);

	    seg_infos[i] = new segmentInfo(kp[0], kp[1]);

	    if (i == my_sseg)
		bzc_sp = (my_sp - seg_infos[i].lp()) / seg_infos[i].dp();
	    else
		bzc_sp = 0.0;

	    if (i == my_eseg)
		bzc_ep = (my_ep - seg_infos[i].lp()) / seg_infos[i].dp();
	    else
		bzc_ep = 1.0;

	    if ((bzc_ip = bzc_ep - bzc_sp) < tol_p) {
		my_eseg = i - 1;
		break;
	    }

	    lpint = new JgclParameterSection(bzc_sp, bzc_ip);
	    try {
		lpol = bzcs[i].toPolyline(lpint, tolerance);
	    } catch (JgclZeroLength e) {
		continue;
	    }
	    seg_infos[i].pnts(lpol.points());

	    no_total_pnts += seg_infos[i].nPnts();
	    if (i > my_sseg)
		no_total_pnts--;
	}

	/*
	 * solution in bspline form
	 */
	if (no_total_pnts < 2)
	    throw new JgclZeroLength();

	pnts = new JgclPoint3D[no_total_pnts];

	boolean first = true;
	for (i = my_sseg, m = 0; i <= my_eseg; i++) {
	    if (first)
		j = 0;
	    else
		j = 1;
	    for (; j < seg_infos[i].nPnts(); j++, m++) {
		lpnt = (JgclPointOnCurve3D)seg_infos[i].pnts(j);
		pnt = new JgclCartesianPoint3D(lpnt.x(), lpnt.y(), lpnt.z());
		param = seg_infos[i].lp() + (seg_infos[i].dp() * lpnt.parameter());
		pnts[m] = new JgclPointOnCurve3D(pnt, this, param, doCheckDebug);
		first = false;
	    }
	}
	if (section.increase() > 0.0) {
	    return new JgclPolyline3D(pnts);
	} else {
	    return new JgclPolyline3D(pnts).reverse();
	}
    }

    /**
     * ZOg𒼐ߎ_̏\NXB
     */
    private class segmentInfo {
	/**
	 * ZOg̊Jnp[^lB
	 */
	private double lp;

	/**
	 * ZOg̏Ip[^lB
	 */
	private double up;

	/**
	 * ZOg̑p[^lB
	 */
	private double dp;

	/**
	 * ZOg𒼐ߎ_B
	 */
	private JgclPoint3D[] pnts;

	/**
	 * Jnp[^lƏIp[^l^ăIuWFNg\zB
	 *
	 * @param lp	Jnp[^l
	 * @param up	Ip[^l
	 */
	private segmentInfo(double lp, double up) {
	    this.lp = lp;
	    this.up = up;
	    this.dp = up - lp;
	}

	/**
	 * ZOg𒼐ߎ_ݒ肷B
	 *
	 * @param pnts	ZOg𒼐ߎ_
	 */
	private void pnts(JgclPoint3D[] pnts) {
	    this.pnts = pnts;
	}

	/**
	 * ZOg̊Jnp[^lԂB
	 *
	 * @return	ZOg̊Jnp[^l
	 */
	private double lp() {
	    return lp;
	}

	/**
	 * ZOg̏Ip[^lԂB
	 *
	 * @return	ZOg̏Ip[^l
	 */
	private double up() {
	    return up;
	}

	/**
	 * ZOg̑p[^lԂB
	 *
	 * @return	ZOg̑p[^l
	 */
	private double dp() {
	    return dp;
	}

	/**
	 * ZOg𒼐ߎ_̓_̐ԂB
	 * <p>
	 * _񂪐ݒ肳ĂȂꍇɂ 0 ԂB
	 * </p>
	 *
	 * @return	ZOg𒼐ߎ_̓_̐
	 */
	private int nPnts() {
	    if (pnts == null)
		return 0;
	    return pnts.length;
	}

	/**
	 * ZOg𒼐ߎ_ n Ԗڂ̓_ԂB
	 *
	 * @return	ZOg𒼐ߎ_ n Ԗڂ̓_
	 */
	private JgclPoint3D pnts(int n) {
	    return pnts[n];
	}
    }

    /**
     * ̂aXvCȐČxWGȐ̗ԂB
     * <p>
     * ̋Ȑ́Ap[^IɏkނĂȂLZOgɑΉxWGȐ̗ԂB
     * </p>
     * 
     * @return	xWGȐ̔z
     */
    public JgclPureBezierCurve3D[] toPureBezierCurveArray() {
	double[][] cntlPnts;
	boolean isPoly = isPolynomial();
	double[][][] bzc_array;
	JgclPureBezierCurve3D[] bzcs;

	cntlPnts = toDoubleArray(isPoly);
	bzc_array = JgclBsplineCurveEvaluation.toBezierCurve(knotData, cntlPnts);
	bzcs = new JgclPureBezierCurve3D[bzc_array.length];
	for (int i = 0; i < bzc_array.length; i++) {
	    try {
		bzcs[i] = new JgclPureBezierCurve3D(bzc_array[i]);
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}

	return bzcs;
    }

    /**
     * ̂aXvCȐis𔽓]aXvCȐԂB
     *
     * @return	]̂aXvCȐ
     */
    JgclBsplineCurve3D reverse() {
	JgclBsplineKnot rKd;
	boolean isRat = isRational();
	int uicp = nControlPoints();
	JgclPoint3D[] rCp = new JgclPoint3D[uicp];
	double[] rWt = null;
	int i, j;

	rKd = knotData.reverse();
	if (isRat)
	    rWt = new double[uicp];
	for (i = 0, j = uicp - 1; i < uicp; i++, j--) {
	    rCp[i] = controlPointAt(j);
	    if (isRat)
		rWt[i] = weightAt(j);
	}
	return new JgclBsplineCurve3D(rKd, rCp, rWt);
    }

    /**
     * ̋ȐA^ꂽxNgɏ]ĕsړȐԂB
     *
     * @param moveVec	sړ̕Ɨʂ\xNg
     * @return		sړ̋Ȑ
     */
    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
	JgclPoint3D[] pnts = new JgclPoint3D[nControlPoints()];
	for (int i = 0; i < nControlPoints(); i++)
	    pnts[i] = controlPointAt(i).add(moveVec);
	return new JgclBsplineCurve3D(knotData, pnts, weights);
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * 
     * @return	p[^`
     * @see	JgclBsplineKnot#getParameterDomain()
     */
    JgclParameterDomain getParameterDomain() {
	return knotData.getParameterDomain();
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve3D#BSPLINE_CURVE_3D JgclParametricCurve3D.BSPLINE_CURVE_3D}
     */
    int type() {
	return BSPLINE_CURVE_3D;
    }

    /*
     * ^ꂽp[^lA̋Ȑ̒`ɑ΂ėLۂ𒲂ׂB
     * <p>
     * ^ꂽp[^l̋Ȑ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @return         KvɉĂ̋Ȑ̒`Ɋۂ߂ꂽp[^l
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterDomain#force(double)
     * @see	JgclParameterDomain#wrap(double)
     * @see	JgclParameterOutOfRange
     */
    private double checkParameter(double param)
    {
	checkValidity(param);
	return parameterDomain().force(parameterDomain().wrap(param));
    }

    /**
     * ̋ȐA`̂܂܂ɂāAグȐԂB
     *
     * @return	`ŁAオȐ
     */
    public JgclBsplineCurve3D elevateOneDegree()
    {
	JgclBsplineKnot oldKnotData = this.knotData();
	double[][] oldControlPoints = this.toDoubleArray(this.isPolynomial());

	JgclBsplineKnot newKnotData = 
	    JgclBsplineCurveEvaluation.
	    getNewKnotDataAtDegreeElevation(oldKnotData);

	double[][] newControlPoints =
	    JgclBsplineCurveEvaluation.
	    getNewControlPointsAtDegreeElevation(oldKnotData,
						 newKnotData,
						 oldControlPoints);

	return new JgclBsplineCurve3D(newKnotData, newControlPoints);
    }

    /**
     * ̋ȐA`̂܂܂ɂāAw̎܂ŎグȐԂB
     *
     * @param max_degree	ԂȐ̎
     * @return	`ŁAw̎܂ŎグȐ
     */
    private JgclBsplineCurve3D elevateDegreeTo(int max_degree) {
	JgclBsplineCurve3D old_bsc, new_bsc;

	if (degree() > max_degree)
	    throw new JgclInvalidArgumentValue();

	old_bsc = this;
	for (int i = degree(); i < max_degree; i++) {
	    new_bsc = old_bsc.elevateOneDegree();
	    old_bsc = new_bsc;
	}

	return old_bsc;
    }

    /**
     * ̂aXvCȐƁA
     * ̂aXvCȐ̏I_Ɋ􉽓IɌqĂaXvCȐ
     * {̂aXvCȐɂB
     *
     * @param mate	̋Ȑ̏I_ɌqȐ
     * @return	this ̏I_ mate ̊Jn_qň{ɂȐ
     * @exception JgclTwoGeomertiesAreNotContinuous
     *			this ̏I_ mate ̊Jn_vȂ
     */
    public JgclBsplineCurve3D mergeIfContinuous(JgclBsplineCurve3D mate)
	 throws JgclTwoGeomertiesAreNotContinuous
    {
	JgclBsplineCurve3D headCurve = this;
	JgclBsplineCurve3D tailCurve = mate;

	JgclParameterSection headSection = headCurve.parameterDomain().section();
	JgclParameterSection tailSection = tailCurve.parameterDomain().section();
	double headEndParameter   = headSection.end();
	double tailStartParameter = tailSection.start();

	// qĂ邩H
	JgclPoint3D headEnd   = headCurve.coordinates(headEndParameter);
	JgclPoint3D tailStart = tailCurve.coordinates(tailStartParameter);
	if (headEnd.identical(tailStart) != true) {
	    // debug
	    // headEnd.output(System.err);
	    // tailStart.output(System.err);
	    throw new JgclTwoGeomertiesAreNotContinuous();
	}

	// Lǂ킹
	boolean headPoly = headCurve.isPolynomial();
	boolean tailPoly = tailCurve.isPolynomial();
	boolean isPoly;

	if ((headPoly == true) && (tailPoly == true)) {
	    isPoly = true;
	} else if (headPoly == true) {
	    isPoly = false;
	    headCurve = headCurve.toBsplineCurve();
	} else if (tailPoly == true) {
	    isPoly = false;
	    tailCurve = tailCurve.toBsplineCurve();
	} else {
	    isPoly = false;
	}

	// 킹
	int headDegree = headCurve.degree();
	int tailDegree = tailCurve.degree();

	while (headDegree < tailDegree) {
	    headCurve = headCurve.elevateOneDegree();
	    headDegree++;
	}

	while (headDegree > tailDegree) {
	    tailCurve = tailCurve.elevateOneDegree();
	    tailDegree++;
	}

	// ꂼڍʒuŕāAmbg̑dxグ
	JgclBsplineCurve3D[] dividedCurves;
	dividedCurves = headCurve.divide(headEndParameter);
	headCurve = dividedCurves[0];
	dividedCurves = tailCurve.divide(tailStartParameter);
	tailCurve = dividedCurves[1];

	// debug
	// headCurve.output(System.err);
	// tailCurve.output(System.err);

	// VȐ̃mbgpӂ
	JgclBsplineKnot headKnotData = headCurve.knotData();
	JgclBsplineKnot tailKnotData = tailCurve.knotData();

	int arrayLength;

	arrayLength = headKnotData.nKnots() + tailKnotData.nKnots() - 1;
	double[] newKnots = new double[arrayLength];
	int[] newKnotMultiplicities = new int[arrayLength];

	int nNewKnots = 0;
	for (int j = 0; j < headKnotData.nKnots(); j++) {
	    newKnots[nNewKnots] = headKnotData.knotAt(j);
	    newKnotMultiplicities[nNewKnots] = headKnotData.knotMultiplicityAt(j);
	    nNewKnots++;
	}
	newKnotMultiplicities[nNewKnots - 1] = headDegree;

	double offset = headEndParameter - tailStartParameter;
	for (int j = 1; j < tailKnotData.nKnots(); j++) {
	    newKnots[nNewKnots] = tailKnotData.knotAt(j) + offset;
	    newKnotMultiplicities[nNewKnots] = tailKnotData.knotMultiplicityAt(j);
	    nNewKnots++;
	}

	// VȐ̐_pӂ
	arrayLength = headKnotData.nControlPoints() + tailKnotData.nControlPoints() - 1;
	JgclPoint3D[] newControlPoints = new JgclPoint3D[arrayLength];
	double[] newWeights = null;
	if (isPoly != true)
	    newWeights = new double[arrayLength];

	int nNewControlPoints = 0;
	for (int j = 0; j < headKnotData.nControlPoints(); j++) {
	    newControlPoints[nNewControlPoints] = headCurve.controlPointAt(j);
	    if (isPoly != true)
		newWeights[nNewControlPoints] = headCurve.weightAt(j);
	    nNewControlPoints++;
	}

	double weightRatio = 0;
	if (isPoly != true)
	    weightRatio = newWeights[nNewControlPoints - 1] / tailCurve.weightAt(0);

	for (int j = 1; j < tailKnotData.nControlPoints(); j++) {
	    newControlPoints[nNewControlPoints] = tailCurve.controlPointAt(j);
	    if (isPoly != true)
		newWeights[nNewControlPoints] = tailCurve.weightAt(j) * weightRatio;
	    nNewControlPoints++;
	}

	// VȐ𐶐
	JgclBsplineCurve3D result;

	if (isPoly == true)
	    result = new JgclBsplineCurve3D(headDegree, false,
					    newKnotMultiplicities, newKnots,
					    newControlPoints);
	else
	    result = new JgclBsplineCurve3D(headDegree, false,
					    newKnotMultiplicities, newKnots,
					    newControlPoints, newWeights);

	return result;
    }

    /**
     * ^ꂽaXvCȐ̗̒̍ō̎ԂB
     * <p>
     * crvs ̒ɊJ`̋Ȑƕ`̋Ȑ݂Ăꍇɂ
     * JgclInvalidArgumentValue ̗OԂB
     * </p>
     *
     * @param crvs	aXvCȐ̔z
     * @return	^ꂽaXvCȐ̗̒̍ō
     * @see	JgclInvalidArgumentValue
     */
    private static int getMaxDegree(JgclBsplineCurve3D[] crvs) {
	boolean isClosed = crvs[0].isPeriodic();
	int maxDegree = crvs[0].degree();

	for (int i = 1; i < crvs.length; i++) {
	    if (isClosed != crvs[i].isPeriodic()) {
		throw new JgclInvalidArgumentValue();
	    }
	    if (maxDegree < crvs[i].degree()) {
		maxDegree = crvs[i].degree();
	    }
	}

	return maxDegree;
    }

    /**
     * ̋Ȑ̃mbg[_ődɂ̂ԂB
     *
     * @return	[_őd̃mbgȐ
     */
    private JgclBsplineCurve3D multipleKnotEndIfOpen() {
	if (isPeriodic())
	    return this;

	return truncate(parameterDomain().section());
    }

    /**
     * ̋Ȑ̃mbg̃mbgdxׂ 1 ɕ̂ԂB
     *
     * @return	mbgdxׂ 1 ̃mbgȐ
     */
    private JgclBsplineCurve3D singleKnot(JgclParameterSection pint) {
	int n_knots = nKnotValues();
	double[] knots = new double[n_knots];
	int[] knotMulti = new int[n_knots];

	double new_lower_limit = pint.start();
	double old_lower_limit = parameterDomain().section().start();
	double increase_ratio  = pint.increase() / parameterDomain().section().increase();

	for (int i = 0; i < n_knots; i++) {
	    knots[i] = new_lower_limit + ((knotValueAt(i) - old_lower_limit) * increase_ratio);
	    knotMulti[i] = 1;
	}
	JgclBsplineKnot newKnot = new JgclBsplineKnot(degree(), knotSpec(), isPeriodic(),
						      knotMulti, knots, nControlPoints(), false);
	return new JgclBsplineCurve3D(newKnot, controlPoints, weights);
    }

    /**
     * ^ꂽaXvCȐ̗̃mbg//_𑵂̐B
     * <p>
     * pint  null ̏ꍇɂ́A[0, 1] ̋Ԃ^ꂽ̂ƂĈB
     * </p>
     *
     * @param crvs	aXvCȐ̔z
     * @param pint	o͂Ȑɗ^p[^`
     * @return	mbg//_̐̑aXvCȐ̔z
     */
    public static JgclBsplineCurve3D[] identicalKnotSequences(JgclBsplineCurve3D[] crvs,
							      JgclParameterSection pint) {
	if (pint == null) {
	    /*
	     * default interval
	     */
	    pint = new JgclParameterSection(0.0, 1.0);
	}
    
	int max_degree = getMaxDegree(crvs);

	/*
	 * make same-format curves
	 */
	int n_crvs = crvs.length;
	JgclBsplineCurve3D[] new_crvs = new JgclBsplineCurve3D[n_crvs];

	for (int i = 0; i < n_crvs; i++) {
	    new_crvs[i] = crvs[i].elevateDegreeTo(max_degree).multipleKnotEndIfOpen().singleKnot(pint);
	}

	/*
	 * unify knots
	 */
	boolean[] s_xst = new boolean[n_crvs];
	double[] k_val = new double[n_crvs];

	int ith_crv;
	int s_idx = 0;
	int k_idx = max_degree;

	boolean segment_exist;
	double minimum_knot = 0.0;	// dummy initialize

	JgclBsplineCurve3D[] new_crvs2;

	double ptol = crvs[0].getToleranceForParameter();

	while (true) {
	    /*
	     * get minimum knot at current index
	     */
	    segment_exist = false;

	    for (ith_crv = 0; ith_crv < n_crvs; ith_crv++) {
		if (s_idx <= new_crvs[ith_crv].nSegments()) {
		    s_xst[ith_crv] = true;
		    k_val[ith_crv] = new_crvs[ith_crv].knotValueAt(k_idx);
		    if (!segment_exist || (k_val[ith_crv] < minimum_knot)) {
			segment_exist = true;
			minimum_knot = k_val[ith_crv];
		    }
		} else {
		    s_xst[ith_crv] = false;
		}
	    }

	    if (!segment_exist)
		break;

	    /*
	     * insert knot at minimum knot
	     */
	    new_crvs2 = new JgclBsplineCurve3D[n_crvs];

	    for (ith_crv = 0; ith_crv < n_crvs; ith_crv++) {
		if (!s_xst[ith_crv] ||
		    ((minimum_knot + ptol) < k_val[ith_crv])) {
		    new_crvs2[ith_crv] = new_crvs[ith_crv].insertKnot(minimum_knot);
		} else {
		    new_crvs2[ith_crv] = new_crvs[ith_crv];
		}
	    }

	    new_crvs = new_crvs2;

	    k_idx++;
	    s_idx++;
	}

	return new_crvs;
    }

    /**
     * ̋ȐA^ꂽǏWn Z ̎ɁA
     * ^ꂽpx]ȐԂB
     *
     * @param trns	ǏWn瓾ꂽWϊZq
     * @param rCos	cos(]px)
     * @param rSin	sin(]px)
     * @return		]̋Ȑ
     */
    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns,
				  double rCos, double rSin) {
	int n_pnts = nControlPoints();
	JgclPoint3D[] pnts = new JgclPoint3D[n_pnts];

	for (int i = 0; i < n_pnts; i++)
	    pnts[i] = controlPointAt(i).rotateZ(trns, rCos, rSin);

	JgclBsplineCurve3D result;
	if (isRational())
	    result = new JgclBsplineCurve3D(knotData, pnts, weights());
	else
	    result = new JgclBsplineCurve3D(knotData, pnts, null);

	return result;
    }

    /**
     * ̋Ȑ̓_ŁA^ꂽɂȂ_ԂB
     *
     * @param line	
     * @return		^ꂽɂȂ_
     */
    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol2 = condition.getToleranceForDistance2();

	int itry = 0, limit = nControlPoints();
	JgclPoint3D point;
	JgclVector3D vector;

	/*
	 * Get a point which is not on the line, then verify that
	 * the distance between a point and the line is greater
	 * than the tolerance.
	 */
	do {
	    if (itry >= limit) {
		throw new JgclFatal();	// should never be occurred
	    }
	    point = controlPointAt(itry);
	    vector = point.subtract(line.project1From(point));
	    itry ++;
	} while(point.isOn(line) || vector.norm() < dTol2);

	return point;
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint3D[] tControlPoints =
	    JgclPoint3D.transform(this.controlPoints,
				  reverseTransform,
				  transformationOperator,
				  transformedGeometries);
	return new JgclBsplineCurve3D(this.knotData, tControlPoints, this.weights);
    }

    /**
     * ^uVʂ̐B
     * <p>
     * this ̃KChȐAmate 𑼕̃KChȐƂ
     * ^uVʂ𐶐B
     * </p>
     *
     * @param mate	̃KChȐ
     * @return		^uVʂ\aXvCȖ
     */
    public JgclBsplineSurface3D tabcylSurface(JgclBsplineCurve3D mate) {
	/*
	 * @see JgclTabcylSurface3D
	 */
	JgclTabcylSurface3D doObj = new JgclTabcylSurface3D(this, mate);
	return doObj.getSurface();
    }

    /**
     * tgʂ̐B
     * <p>
     * this w̕ɑ|ătgʂ𐶐B
     * </p>
     *
     * @param vector	|\xNg
     * @param length	|钷
     * @return		tgʂ\aXvCȖ
     */
    public JgclBsplineSurface3D loftSurface(JgclVector3D vector, double length) {
	/*
	 * @see JgclLoftSurface3D
	 */
	JgclLoftSurface3D doObj = new JgclLoftSurface3D(this, vector, length);
	return doObj.getSurface();
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);
	StringBuffer buf = new StringBuffer();

        writer.println(indent_tab + getClassName());
        // output knotData(JgclBsplineKnot)
        //writer.println(indent_tab + "\tknotData");
        //knotData.output(writer, indent + 2);
        knotData.output(writer, indent, 0);

        // output others
        writer.println(indent_tab + "\tcontrolPoints");
	for (int i = 0; i < nControlPoints(); i++) {
	    controlPointAt(i).output(writer, indent + 2);
        }
	if (weights() != null) {
	    writer.println(indent_tab + "\tweights ");
	    int i = 0;
	    while(true) {
		for (int j =0; j < 10 && i < weights().length; j++, i++){
		    writer.print(" " + weightAt(i));
		}
		writer.println();
		if (i < weights().length) {
		    writer.print(indent_tab + "\t");
		} else {
		    break;
		}
	    }
	}
        writer.println(indent_tab + "\tcurveForm\t"+ JgclBsplineCurveForm.toString(curveForm));
        writer.println(indent_tab + "End");
    }
}
