/*
 * Q : 􉽓IȕϊsȂZq\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclCartesianTransformationOperator2D.java,v 1.21 2000/08/11 06:18:44 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * Q : 􉽓IȕϊsȂZq\NXB
 * <p>
 * 􉽓IȕΐAsړA]ړA~[OAψȃXP[O
 * ō\B
 * ̕ϊł́AϊOƕϊŔCӂ̓_Ԃ͈̋̔łB
 * </p>
 * <p>
 * ܂APʉꂽ̃xNg U1, U2 Ae`钼s T lB
 * U1, U2 ݂͌ɒxNgłB
 * ̒PʃxNǵAxNg axis1, axis2 
 * {@link JgclGeometrySchemaFunction#baseAxis(JgclVector2D, JgclVector2D)
 * JgclGeometrySchemaFunction.baseAxis}(axis1, axis2) ŌvZB
 * T ̍s񎮂 -1 ̏ꍇɂ́AT ̍\vfƂĊ܂ޕϊ̓~[O܂ށB
 * <br>
 * 􉽓IȕΐAT ɉāA
 * sړ̗ʂ߂ǏIȌ_ A (localOrigin)
 *  XP[O̗ʂ߂l S
 * Œ`B
 * </p>
 * <p>
 * ȉ̋LqŁAA.b ͓_ (邢̓xNg) A  b \B
 * </p>
 * <p>
 * _ P ̕ΐAϊ̓_ Q ƂāAȉŒ`B
 * <pre>
 *	Q.x = A.x + S * (P.x * U1.x + P.y * U2.x)
 *	Q.y = A.y + S * (P.x * U1.y + P.y * U2.y)
 * </pre>
 * </p>
 * <p>
 * xNg V ̕ΐAϊ̃xNg W ƂāAȉŒ`B
 * <pre>
 *	W.x = S * (V.x * U1.x + V.y * U2.x)
 *	W.y = S * (V.x * U1.y + V.y * U2.y)
 * </pre>
 * </p>
 * <p>
 *  L ̕ΐAϊ̒ M ƂāAȉŒ`B
 * <pre>
 *	M = S * L
 * </pre>
 * </p>
 *
 * @version $Revision: 1.21 $, $Date: 2000/08/11 06:18:44 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclCartesianTransformationOperator3D
 */

public class JgclCartesianTransformationOperator2D extends JgclCartesianTransformationOperator {
    /**
     * ϊ̑ꎲ U1 K肷xNgB
     * @serial
     * @see JgclGeometrySchemaFunction#baseAxis(JgclVector2D, JgclVector2D)
     */
    private JgclVector2D axis1;

    /**
     * ϊ̑ U2 K肷xNgB
     * @serial
     * @see JgclGeometrySchemaFunction#baseAxis(JgclVector2D, JgclVector2D)
     */
    private JgclVector2D axis2;

    /**
     * sړ̗ʂK肷ǏIȌ_ AB
     * <p>
     * _̕ϊł́AIȌ_ (0, 0) 炱̓_܂ł̕sړ܂ށB
     * </p>
     * @serial
     */
    private JgclPoint2D localOrigin;

    /**
     * ϊ̎ƂȂPʃxNg U1, U2B
     * <p>
     * s T ̊eB
     * </p>
     * <p>
     * KvɉăLbVB
     * </p>
     * @serial
     */
    private JgclVector2D u[];

    /**
     * etB[h̒l𒼐ڎw肵āAIuWFNg\zB
     * <p>
     * axis1  null ł\ȂB
     * </p>
     * <p>
     * axis2  null ł\ȂB
     * </p>
     * <p>
     * localOgirin  null ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * scale ̒l͐łȂ΂ȂȂB
     * scale ̒lAݐݒ肳Ă鉉Z
     * ̋e덷ȉ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param axis1	ϊ̑ꎲ U1 K肷xNg
     * @param axis2	ϊ̑ U2 K肷xNg
     * @param localOrigin	sړ̗ʂ߂ǏIȌ_ A
     * @param scale	XP[Oʂ߂l S
     * @see JgclInvalidArgumentValue
     */
    public JgclCartesianTransformationOperator2D(JgclVector2D axis1,
						 JgclVector2D axis2,
						 JgclPoint2D localOrigin,
						 double scale)
    {
	super(scale);

	if (localOrigin == null)
	    throw new JgclInvalidArgumentValue();

	this.localOrigin = localOrigin;
	this.axis1 = axis1;
	this.axis2 = axis2;
    }

    /**
     * ǏWn (zu) IȍWnւ̕ϊ\IuWFNg\zB
     * <p>
     * position ̌_/X /Yꂼ
     * localOrigin/axis1/axis2 ƂB
     * </p>
     * <p>
     * position  null ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * scale ̒l͐łȂ΂ȂȂB
     * scale ̒lAݐݒ肳Ă鉉Z
     * ̋e덷ȉ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param position	ǏWn (zu)
     * @param scale	XP[Ol
     * @see JgclInvalidArgumentValue
     */
    public JgclCartesianTransformationOperator2D(JgclAxis2Placement2D position,
						 double scale)
    {
	super(scale);

	if (position == null)
	    throw new JgclInvalidArgumentValue();

	this.u = position.axes();
	this.localOrigin = position.location();
	this.axis1 = u1();
	this.axis2 = u2();
    }

    /**
     * ̉Zq̎ԂB
     * <p>
     *  2 ԂB
     * </p>
     * 
     * @return	QȂ̂ŁA 2
     */
    public int dimension() {
	return 2;
    }

    /**
     * ̉Zq̕ϊ̑ꎲ U1 K肷xNgԂB
     *
     * @return	ϊ̑ꎲ U1 K肷xNg
     */
    public JgclVector2D axis1() {
	return axis1;
    }

    /**
     * ̉Zq̕ϊ̑ U2 K肷xNgԂB
     *
     * @return	ϊ̑ U2 K肷xNg
     */
    public JgclVector2D axis2() {
	return axis2;
    }

    /**
     * ̉Zq̕sړ̗ʂK肷ǏIȌ_ԂB
     *
     * @return	sړ̗ʂK肷ǏIȌ_
     */
    public JgclPoint2D localOrigin() {
	return localOrigin;
    }

    /**
     * ̉Zq̕ϊ̑ꎲƂȂPʃxNg U1 ԂB
     *
     * @return	ϊ̑ꎲƂȂPʃxNg U1
     */
    public JgclVector2D u1() {
	if (u == null)
	    u();
	return u[0];
    }

    /**
     * ̉Zq̕ϊ̑񎲂ƂȂPʃxNg U2 ԂB
     *
     * @return	ϊ̑񎲂ƂȂPʃxNg U2
     */
    public JgclVector2D u2() {
	if (u == null)
	    u();
	return u[1];
    }

    /**
     * ̉Zq̕ϊ̎ƂȂPʃxNg U1, U2 ԂB
     * <p>
     * ʂƂĕԂz̗vf 2 ŁA
     * ŏ̗vf U1AԖڂ̗vf U2 ܂ށB
     * </p>
     *
     * @return	ϊ̎ƂȂPʃxNg̔z
     */
    public JgclVector2D[] u() {
	if (u == null) {
	    u = JgclGeometrySchemaFunction.baseAxis(axis1, axis2);
	}
	return (JgclVector2D[])u.clone();
    }

    /**
     * ^ꂽxNg̉ZqŕϊB
     *
     * @param vector	xNg
     * @return	ϊ̃xNg
     */
    public JgclVector2D transform(JgclVector2D vector) {
	double x, y;

	x = scale() * (vector.x() * u1().x() + vector.y() * u2().x());
	y = scale() * (vector.x() * u1().y() + vector.y() * u2().y());
	return new JgclLiteralVector2D(x, y);
    }

    /**
     * ^ꂽ_̉ZqŕϊB
     *
     * @param point	_
     * @return	ϊ̓_
     */
    public JgclPoint2D transform(JgclPoint2D point) {
	double x, y;

	x = localOrigin.x() + scale() * (point.x() * u1().x() + point.y() * u2().x());
	y = localOrigin.y() + scale() * (point.x() * u1().y() + point.y() * u2().y());
	return new JgclCartesianPoint2D(x, y);
    }

    /**
     * ^ꂽxNg̉ZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * vector  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * vector  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł vector L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * vector  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  vector  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param vector	xNg
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̃xNg
     */
    public JgclVector2D transform(JgclVector2D vector,
				  java.util.Hashtable transformedGeometries)
    {
	return vector.transformBy(this, transformedGeometries);
    }

    /**
     * ^ꂽ_̉ZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * point  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * point  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł point L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * point  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  point  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param point	_
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̓_
     */
    public JgclPoint2D transform(JgclPoint2D point,
				 java.util.Hashtable transformedGeometries)
    {
	return point.transformBy(this, transformedGeometries);
    }

    /**
     * ^ꂽȐ̉ZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * curve  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * curve  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł curve L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * curve  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  curve  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param curve	Ȑ
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̋Ȑ
     */
    public JgclParametricCurve2D transform(JgclParametricCurve2D curve,
					   java.util.Hashtable transformedGeometries)
    {
	return curve.transformBy(this, transformedGeometries);
    }

    /**
     * ^ꂽxNg̉ZqŋtϊB
     *
     * @param vector	xNg
     * @return	tϊ̃xNg
     */
    public JgclVector2D reverseTransform(JgclVector2D vector) {
	double x, y;

	x = (vector.x() * u1().x() + vector.y() * u1().y()) / scale();
	y = (vector.x() * u2().x() + vector.y() * u2().y()) / scale();
	return new JgclLiteralVector2D(x, y);
    }

    /**
     * ^ꂽ_̉ZqŋtϊB
     *
     * @param point	_
     * @return	tϊ̓_
     */
    public JgclPoint2D reverseTransform(JgclPoint2D point) {
	JgclVector2D wk;
	double x, y;

	wk = point.subtract(localOrigin);
	x = (wk.x() * u1().x() + wk.y() * u1().y()) / scale();
	y = (wk.x() * u2().x() + wk.y() * u2().y()) / scale();

	return new JgclCartesianPoint2D(x, y);
    }

    /**
     * ^ꂽxNg̉ZqŋtϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * vector  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * vector  transformationOperator ŋtϊ̂ԂB
     * ̍ۂɃ\bhł vector L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * vector  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  vector  transformationOperator ŋtϊ̂ԂB
     * </p>
     *
     * @param vector	xNg
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	tϊ̃xNg
     */
    public JgclVector2D reverseTransform(JgclVector2D vector,
					 java.util.Hashtable transformedGeometries)
    {
	return vector.reverseTransformBy(this, transformedGeometries);
    }

    /**
     * ^ꂽ_̉ZqŋtϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * point  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * point  transformationOperator ŋtϊ̂ԂB
     * ̍ۂɃ\bhł point L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * point  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  point  transformationOperator ŋtϊ̂ԂB
     * </p>
     *
     * @param point	_
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	tϊ̓_
     */
    public JgclPoint2D reverseTransform(JgclPoint2D point,
					java.util.Hashtable transformedGeometries)
    {
	return point.reverseTransformBy(this, transformedGeometries);
    }

    /**
     * ^ꂽȐ̉ZqŋtϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * curve  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * curve  transformationOperator ŋtϊ̂ԂB
     * ̍ۂɃ\bhł curve L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * curve  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  curve  transformationOperator ŋtϊ̂ԂB
     * </p>
     *
     * @param curve	Ȑ
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	tϊ̋Ȑ
     */
    public JgclParametricCurve2D reverseTransform(JgclParametricCurve2D curve,
						  java.util.Hashtable transformedGeometries)
    {
	return curve.reverseTransformBy(this, transformedGeometries);
    }

    /**
     * {@link #transform(JgclVector2D) transform(JgclVector2D)} ̕ʖ\bhB
     * <p>
     * localW -> enclosed (global) W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param vector	xNg
     * @return	ϊ̃xNg
     */
    public JgclVector2D toEnclosed(JgclVector2D vector) {
	return transform(vector);
    }

    /**
     * {@link #transform(JgclPoint2D) transform(JgclPoint2D)} ̕ʖ\bhB
     * <p>
     * localW -> enclosed (global) W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param point	_
     * @return	ϊ̓_
     */
    public JgclPoint2D toEnclosed(JgclPoint2D point) {
	return transform(point);
    }

    /**
     * {@link #transform(JgclVector2D, java.util.Hashtable)
     * transform(JgclVector2D, java.util.Hashtable)} ̕ʖ\bhB
     * <p>
     * localW -> enclosed (global) W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param vector	xNg
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̃xNg
     */
    public JgclVector2D toEnclosed(JgclVector2D vector,
				   java.util.Hashtable transformedGeometries)
    {
	return transform(vector, transformedGeometries);
    }

    /**
     * {@link #transform(JgclPoint2D, java.util.Hashtable)
     * transform(JgclPoint2D, java.util.Hashtable)} ̕ʖ\bhB
     * <p>
     * localW -> enclosed (global) W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param point	_
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̓_
     */
    public JgclPoint2D toEnclosed(JgclPoint2D point,
				  java.util.Hashtable transformedGeometries)
    {
	return transform(point, transformedGeometries);
    }

    /**
     * {@link #transform(JgclParametricCurve2D, java.util.Hashtable)
     * transform(JgclParametricCurve2D, java.util.Hashtable)} ̕ʖ\bhB
     * <p>
     * localW -> enclosed (global) W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param curve	Ȑ
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̋Ȑ
     */
    public JgclParametricCurve2D toEnclosed(JgclParametricCurve2D curve,
					    java.util.Hashtable transformedGeometries)
    {
	return transform(curve, transformedGeometries);
    }

    /**
     * {@link #reverseTransform(JgclVector2D) reverseTransform(JgclVector2D)} ̕ʖ\bhB
     * <p>
     * enclosed (global) W -> localW̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param vector	xNg
     * @return	ϊ̃xNg
     */
    public JgclVector2D toLocal(JgclVector2D vector) {
	return reverseTransform(vector);
    }

    /**
     * {@link #reverseTransform(JgclPoint2D) reverseTransform(JgclPoint2D)} ̕ʖ\bhB
     * <p>
     * enclosed (global) W -> local W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param point	_
     * @return	ϊ̓_
     */
    public JgclPoint2D toLocal(JgclPoint2D point) {
	return reverseTransform(point);
    }

    /**
     * {@link #reverseTransform(JgclVector2D, java.util.Hashtable)
     * reverseTransform(JgclVector2D, java.util.Hashtable)} ̕ʖ\bhB
     * <p>
     * enclosed (global) W -> local W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param vector	xNg
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̃xNg
     */
    public JgclVector2D toLocal(JgclVector2D vector,
				java.util.Hashtable transformedGeometries)
    {
	return reverseTransform(vector, transformedGeometries);
    }

    /**
     * {@link #reverseTransform(JgclPoint2D, java.util.Hashtable)
     * reverseTransform(JgclPoint2D, java.util.Hashtable)} ̕ʖ\bhB
     * <p>
     * enclosed (global) W -> local W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param point	_
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̓_
     */
    public JgclPoint2D toLocal(JgclPoint2D point,
				java.util.Hashtable transformedGeometries)
    {
	return reverseTransform(point, transformedGeometries);
    }

    /**
     * {@link #reverseTransform(JgclParametricCurve2D, java.util.Hashtable)
     * reverseTransform(JgclParametricCurve2D, java.util.Hashtable)} ̕ʖ\bhB
     * <p>
     * enclosed (global) W -> local W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param curve	Ȑ
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̋Ȑ
     */
    public JgclParametricCurve2D toLocal(JgclParametricCurve2D curve,
					 java.util.Hashtable transformedGeometries)
    {
	return reverseTransform(curve, transformedGeometries);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tscale\t" + scale());
	if (axis1 != null) {
	    writer.println(indent_tab + "\taxis1");
	    axis1.output(writer, indent + 2);
	}
	if (axis2 != null) {
	    writer.println(indent_tab + "\taxis2");
	    axis2.output(writer, indent + 2);
	}
        writer.println(indent_tab + "\tlocalOrigin");
        localOrigin.output(writer, indent + 2);
        writer.println("End");
    }
}

