/*
 * Q : ~\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclCircle2D.java,v 1.68 2000/08/11 06:18:44 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

/**
 * Q : ~\NXB
 * <p>
 * ~́A̒S̈ʒuƋǏ X/Y ̕ǏWn
 * (zuA{@link JgclAxis2Placement2D JgclAxis2Placement2D}) position 
 * a radius Œ`B
 * </p>
 * <p>
 * t p[^Ƃ~ P(t) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(t) = position.location() + radius * (cos(t) * position.x() + sin(t) * position.y())
 * </pre>
 * </p>
 *
 * @version $Revision: 1.68 $, $Date: 2000/08/11 06:18:44 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclCircle2D extends JgclConic2D {

    /**
     * aB
     * @serial
     */
    private double radius;


    /**
     * aݒ肷B
     * <p>
     * radius ̒lA
     * ݐݒ肳Ă鉉Z̋̋e덷ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     *
     * @param radius	a
     * @see	JgclInvalidArgumentValue
     */
    private void setRadius(double radius)
    {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol = condition.getToleranceForDistance();

	if (radius < dTol) {
	    throw new JgclInvalidArgumentValue();
	}
	this.radius = radius;
    }

    /**
     * ǏWnƔa^ăIuWFNg\zB
     * <p>
     * position  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * radius ̒lA
     * ݐݒ肳Ă鉉Z̋̋e덷ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * 
     * @param position	SƋǏ X/Y ̕ǏWn
     * @param radius	a
     * @see	JgclInvalidArgumentValue
     */
    public JgclCircle2D(JgclAxis2Placement2D position, double radius)
    {
	super(position);
	setRadius(radius);
    }

    /**
     * SƔa^ăIuWFNg\zB
     * <p>
     * \z~̋Ǐ X/Y ́̕A
     * O[oȍWn X/Y ̕ɈvB
     * </p>
     * <p>
     * center  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * radius ̒lA
     * ݐݒ肳Ă鉉Z̋̋e덷ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * 
     * @param center	S
     * @param radius	a
     * @see	JgclInvalidArgumentValue
     */
    public JgclCircle2D(JgclPoint2D center, double radius)
    {
	super(new JgclAxis2Placement2D(center, JgclVector2D.xUnitVector));
	setRadius(radius);
    }

    /**
     * ʉ߂O_^ăIuWFNg\zB
     * <p>
     * \z~̋Ǐ X/Y ́̕A
     * O[oȍWn X/Y ̕ɈvB
     * </p>
     * <p>
     * pnt1, pnt2, pnt3 ̂ꂩ null ̏ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * <p>
     * ܂Apnt1, pnt2, pnt3 Ԃɂꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * 
     * @param pnt1	~̈_
     * @param pnt2	~̈_
     * @param pnt3	~̈_
     * @see	JgclPoint2D#center(JgclPoint2D, JgclPoint2D)
     * @see	JgclInvalidArgumentValue
     */
    public JgclCircle2D(JgclPoint2D pnt1, JgclPoint2D pnt2, JgclPoint2D pnt3) {
	super(new JgclAxis2Placement2D(JgclPoint2D.center(pnt1, pnt2, pnt3),
				       JgclVector2D.xUnitVector));
	setRadius(position().location().subtract(pnt1).length());
    }

    /**
     * ̉~̔aԂB
     * 
     * @return	a
     */
    public double radius() {
	return this.radius;
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * <p>
     * pint ŗ^Ԃ [0, 2 * PI] Ɏ܂ĂKv͂ȂB
     * ܂Apint ̑l͕ł܂ȂB
     * </p>
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     */
    public double length(JgclParameterSection pint) {
        return radius() * Math.abs(pint.increase());
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * 
     * @param param	p[^l
     * @return		Wl
     */
    public JgclPoint2D coordinates(double param) {
	param = parameterDomain().wrap(param);
	JgclPoint2D center = position().location();
	double ecos = Math.cos(param) * radius;
	double esin = Math.sin(param) * radius;
	JgclVector2D x = position().x().multiply(ecos);
	JgclVector2D y = position().y().multiply(esin);

	return center.add(x.add(y));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * 
     * @param param	p[^l
     * @return		ڃxNg
     */
    public JgclVector2D tangentVector(double param) {
	param = parameterDomain().wrap(param);
	double ecos = Math.cos(param) * radius;
	double esin = Math.sin(param) * radius;
	JgclVector2D x = position().x().multiply(-esin);
	JgclVector2D y = position().y().multiply(ecos);

	return x.add(y);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * 
     * @param param	p[^l
     * @return		ȗ
     */
    public JgclCurveCurvature2D curvature(double param) {
	param = parameterDomain().wrap(param);
	double ucos = Math.cos(param);
	double usin = Math.sin(param);
	JgclVector2D x = position().x().multiply(-ucos);
	JgclVector2D y = position().y().multiply(-usin);

	return new JgclCurveCurvature2D(1.0 / radius, x.add(y));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * 
     * @param param	p[^l
     * @return		֐
     */
    public JgclCurveDerivative2D evaluation(double param) {
	param = parameterDomain().wrap(param);
	double ecos = Math.cos(param) * radius;
	double esin = Math.sin(param) * radius;
	JgclPoint2D center = position().location();
	JgclVector2D xcos = position().x().multiply(ecos);
	JgclVector2D ysin = position().y().multiply(esin);
	JgclVector2D xsin = position().x().multiply(esin);
	JgclVector2D ycos = position().y().multiply(ecos);

	JgclPoint2D d0 = center.add(xcos.add(ysin));
	JgclVector2D d1 = ycos.add(xsin.multiply(-1.0));
	JgclVector2D d2 = xcos.add(ysin).multiply(-1.0);

	return new JgclCurveDerivative2D(d0, d1, d2);
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * ^ꂽ_̉~̒SɈvȂA
     * ɓ̓e_ԂB
     * </p>
     * <p>
     * ^ꂽ_Ƃ̉~̒SƂ̋A
     * ݐݒ肳Ă鉉Z̋̋e덷
     * ꍇɂ́A
     * p[^l 0 ̓_ suitable Ƃ
     * JgclIndefiniteSolution ̗O𓊂B
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     * @exception	JgclIndefiniteSolution	s (e̓_~̒SɈv)
     */
    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point)
	throws JgclIndefiniteSolution
    {
	// unit direction vector from center to point
	JgclVector2D eduvec = point.subtract(position().location());

	// check length & unitize
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol = condition.getToleranceForDistance();

	if (eduvec.length() < dTol) {
	    // any point
	    JgclPointOnCurve2D p;

	    try {
		p = new JgclPointOnCurve2D(this, 0, doCheckDebug);
	    }
	    catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }

 	    throw new JgclIndefiniteSolution(p);
	}

	eduvec = eduvec.unitized();

	JgclVector2D x_axis = position().x();

	// angle between x_axis & eduvec

	// get vector angle, XXX: should be moved to JgclVector2D
	double eangle = Math.acos(x_axis.dotProduct(eduvec));
	if (x_axis.zOfCrossProduct(eduvec) < 0.0)
	    eangle = JgclMath.PI2 - eangle;
	double eangle2 = eangle + Math.PI;
	if (eangle2 >= 2*Math.PI)
	    eangle2 -= 2*Math.PI;

	// get the projected
	try {
	    JgclPointOnCurve2D[] prj = {
		new JgclPointOnCurve2D(this, eangle, doCheckDebug),
                new JgclPointOnCurve2D(this, eangle2, doCheckDebug)
	    };

	    return prj;
	}
	catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}
    }

    /**
     * ^ꂽp[^ԂɂāA
     * Ԃ̗[Ԍłꂽ_̃p[^l߂B
     * <p>
     * ̃\bh
     * {@link JgclConic2D#toPolyline(JgclParameterSection, JgclToleranceForDistance) 
     * JgclConic2D.toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * ̓ŌĂяo邽߂ɗpӂĂB
     * ̃NXł
     * toPolyline(JgclParameterSection, JgclToleranceForDistance)
     * I[o[ChĂ̂ŁA
     * ̃\bh͌Ăяo邱Ƃ͂ȂB
     * </p>
     * <p>
     * ̃\bh͏ JgclFatal ̗O𓊂B
     * </p>
     * 
     * @param left	[ (ԉ) ̃p[^l
     * @param right	E[ (ԏ) ̃p[^l
     * @return		łꂽ_̃p[^l
     */
    double getPeak(double left, double right) {
	// This should never be called because Circle provides
	// its own toPolyline().
	throw new JgclFatal();
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_́A
     * ̋Ȑx[XƂ JgclPointOnCurve2D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * ȂAʂƂē|C_ɏkނ悤ȏꍇɂ
     * JgclZeroLength ̗O𔭐B
     * </p>
     * 
     * @param pint	ߎp[^
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     * @see	JgclPointOnCurve2D
     * @see	JgclZeroLength
     */
    public JgclPolyline2D toPolyline(JgclParameterSection pint,
				     JgclToleranceForDistance tol) {

	double sa = parameterDomain().wrap(pint.start());
	double inc = pint.increase();
	
	int no_intvls = toPolylineNDivision(radius(), inc, tol);
	double atheta = inc / no_intvls;

	JgclPoint2D[] pnts = new JgclPoint2D[no_intvls + 1];

	for (int i = 0; i < no_intvls + 1; i++)
            pnts[i] = new JgclPointOnCurve2D(this, sa + (atheta * i), doCheckDebug);

	if (no_intvls == 1 && pnts[0].identical(pnts[1]))
	    throw new JgclZeroLength();

	return new JgclPolyline2D(pnts);
    }

    /**
     * ^ꂽa~̎w͈̔͂A
     * ^ꂽ덷Œߎ|C𐶐̂
     * K (̎w͈͂) ԂB
     *
     * @param radius	a
     * @param increase	ߎԂ̑l
     * @param tol	̋e덷
     * @return	Ԃ̕
     * @see	#toPolyline(JgclParameterSection, JgclToleranceForDistance)
     */
    static int toPolylineNDivision(double radius,
				   double increase,
				   JgclToleranceForDistance tol) {
	// theta < 2 acos ((R - TOL) / R)
	double etheta = 2.0 * Math.acos((radius - Math.abs(tol.value()))
					/ radius);
	return Math.round((float)Math.floor(Math.abs(increase) / etheta)) + 1;
    }

    /**
     * ̋Ȑ̎w̋ԂČLxWGȐ̗ԂB
     *
     * @param nCurves	̋Ȑ̎w̋ԂČLxWGȐ̐
     * @param increaseP	̗LxWGȐČp[^Ԃ̑傫
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLxWGȐ̔z
     * @see	#toPolyBezierCurves(JgclParameterSection)
     */
    private JgclPureBezierCurve2D[] toPolyBezierCurves(int nCurves,
						       double increaseP,
						       JgclParameterSection pint) {
	double startP;
	int i;

	JgclPureBezierCurve2D[] bzcs = new JgclPureBezierCurve2D[nCurves];

	for (i = 0, startP = pint.start();
	     i < nCurves;
	     i++, startP += increaseP) {

	    JgclParameterSection pintl = new JgclParameterSection(startP, increaseP);
	    JgclPoint2D[] controlPoints = this.getControlPointsOfBezierCurve(pintl);
	    double[] weights = {1.0, 1.0, 1.0};

	    double shoulderParam = (pintl.lower() + pintl.upper()) / 2.0;
	    JgclPoint2D shoulderPoint = this.coordinates(shoulderParam);
	    JgclPoint2D middlePoint = controlPoints[0].midPoint(controlPoints[2]);

	    double vvv = Math.sqrt(shoulderPoint.subtract(middlePoint).norm() /
				   controlPoints[1].subtract(middlePoint).norm());
	    // if (Math.abs(increaseP) > Math.PI) vvv = (- vvv);

	    weights[1] = vvv / (1.0 - vvv);

	    bzcs[i] = new JgclPureBezierCurve2D(controlPoints, weights);
	}

	return bzcs;
    }

    /**
     * ̋Ȑ̎w̋ԂČLxWGȐ̗ԂB
     * <p>
     * pint ̑l̐Βl (2 * ) ȏ̏ꍇɂ́A
     *  (2 * ) ƌȂďB
     * </p>
     *
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLxWGȐ̔z
     */
    public JgclPureBezierCurve2D[] toPolyBezierCurves(JgclParameterSection pint) {
	double increase = pint.increase();
	int nCurves;
	double increaseP;

	if (Math.abs(increase) > JgclMath.PI2) {
	    nCurves = 3;
	    increaseP = (increase > 0.0) ? (JgclMath.PI2 / 3) : (- JgclMath.PI2 / 3);
	} else if (Math.abs(increase) > (4 * JgclMath.PI2 / 5)) {
	    nCurves = 3;
	    increaseP = (increase) / 3;
	} else if (Math.abs(increase) > (4 * Math.PI / 5)) {
	    nCurves = 2;
	    increaseP = (increase) / 2;
	} else {
	    nCurves = 1;
	    increaseP = (increase);
	}

	return toPolyBezierCurves(nCurves, increaseP, pint);
    }

    /**
     * ̋Ȑ̎w̋ԂČLxWGȐ̗ԂB
     * <p>
     * nCurves ̒l 0 ȉ邢 4 ȏ̏ꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * <p>
     * ܂Apint ̑lɑ΂ nCurves ̒lꍇɂ
     * JgclFatal ̗O𔭐B
     * </p>
     *
     * @param nCurves	̋Ȑ̎w̋ԂČLxWGȐ̐ (1 Ȃ 3)
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLxWGȐ̔z
     * @see	#toPolyBezierCurves(JgclParameterSection)
     */
    JgclPureBezierCurve2D[] toPolyBezierCurvesOfN(int nCurves,
						  JgclParameterSection pint) {
	double increase = pint.increase();
	double increaseP;

	increaseP = (increase) / nCurves;

	switch (nCurves) {
	case 3:
	    if (Math.abs(increase) > JgclMath.PI2)
		increaseP = (increase > 0.0) ? (JgclMath.PI2 / 3) : (- JgclMath.PI2 / 3);
	    break;

	case 2:
	    if (Math.abs(increase) > (4 * JgclMath.PI2 / 5))
		throw new JgclFatal("Can not convert with given parameters");
	    break;

	case 1:
	    if (Math.abs(increase) > (4 * Math.PI / 5))
		throw new JgclFatal("Can not convert with given parameters");
	    increaseP = (increase);
	    break;

	default:
	    throw new JgclParameterOutOfRange("value of nCurves is out of range");
	}

	return toPolyBezierCurves(nCurves, increaseP, pint);
    }

    /**
     * ̋Ȑ̎w̋ԂČLaXvCȐԂB
     * <p>
     * pint ̑l̐Βl (2 * ) ȏ̏ꍇɂ́A
     *  (2 * ) ƌȂďA
     * `̋ȐԂB
     * </p>
     * 
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLaXvCȐ
     * @see	#toPolyBezierCurves(JgclParameterSection)
     */
    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
	JgclPureBezierCurve2D[] bzcs = this.toPolyBezierCurves(pint);
	boolean closed =
	    (Math.abs(pint.increase()) >= JgclMath.PI2) ? true : false;

	return JgclConic2D.convertPolyBezierCurvesToOneBsplineCurve(bzcs, closed);
    }

    /**
     * ̋Ȑ̎w̋ԂČLaXvCȐԂB
     * <p>
     * nSegments ̒l 0 ȉ邢 4 ȏ̏ꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * <p>
     * ܂Apint ̑lɑ΂ nSegments ̒lꍇɂ
     * JgclFatal ̗O𔭐B
     * </p>
     * <p>
     * pint ̑l̐Βl (2 * ) ȏ̏ꍇɂ́A
     * `̋ȐԂB
     * </p>
     * 
     * @param nSegments	̋Ȑ̎w̋ԂČLaXvCȐ̃ZOg (1 Ȃ 3)
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLaXvCȐ
     * @see	#toPolyBezierCurvesOfN(int, JgclParameterSection)
     * @see	JgclConic2D#convertPolyBezierCurvesToOneBsplineCurve(JgclPureBezierCurve2D[], boolean)
     */
    JgclBsplineCurve2D toBsplineCurveOfNSegments(int nSegments,
						 JgclParameterSection pint) {
	JgclPureBezierCurve2D[] bzcs = this.toPolyBezierCurvesOfN(nSegments, pint);
	boolean closed =
	    (Math.abs(pint.increase()) >= JgclMath.PI2) ? true : false;

	return JgclConic2D.convertPolyBezierCurvesToOneBsplineCurve(bzcs, closed);
    }

    /**
     * ̋ȐƑ̋ȐƂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ~̂ƂɁA
     * ~̒SԂ̋Ɠ~̔a̍A
     * ƂɌݐݒ肳Ă鉉Z̋̋e덷菬ꍇɂ́A
     * ~̓I[o[bvĂ̂ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution mate ~ŁA~̓I[o[bvĂAsł
     */
    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate)
	 throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̉~ (\ꂽ) RȐ̌_\㐔𐶐B
     * 
     * @param poly	xWGȐ邢͂aXvCȐ̂ZOg̑\̔z
     * @return		̉~ poly ̌_\㐔̍
     */
    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly){
	JgclRealPolynomial xPoly = poly[0].multiply(poly[0]);
	JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
	double rad2 = radius() * radius();
	boolean isPoly = poly.length < 3;
	int degree = xPoly.degree();
	double[] coef = new double[degree + 1];

	if (isPoly) {
	    for (int j = 0; j <= degree; j++)
		coef[j] = xPoly.coefficientAt(j) + yPoly.coefficientAt(j);
	    coef[0] -= rad2;
	}
	else {
	    JgclRealPolynomial wPoly = poly[2].multiply(poly[2]);
	    for (int j = 0; j <= degree; j++)
		coef[j] = xPoly.coefficientAt(j) + yPoly.coefficientAt(j) -
		    (rad2 * wPoly.coefficientAt(j));
	}
	return new JgclRealPolynomial(coef);
    }

    /**
     * ^ꂽ_̋Ȑɂ邩ۂ`FbNB
     * 
     * @param point	ΏۂƂȂ_
     * @return		^ꂽ_̋Ȑɂ trueAłȂ false
     */
    boolean checkSolution(JgclPoint2D point) {
	double dTol = getToleranceForDistance();
	return Math.abs(point.toVector2D().length() - radius()) < dTol;
    }

    /**
     * ^ꂽ_̋Ȑɂ̂ƂāA
     * ̓_̋Ȑł̃p[^l߂B
     * 
     * @param point	ΏۂƂȂ_
     * @return		p[^l
     */
    double getParameter(JgclPoint2D point) {
	double cos = point.x() / radius();
	if (cos > 1.0) cos = 1.0;
	if (cos < -1.0) cos = -1.0;
	double acos = Math.acos(cos);
	if (point.y() < 0.0) acos = Math.PI * 2 - acos;

	return acos;
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsLinCnc2D#intersection(JgclLine2D, JgclCircle2D, boolean)
     * JgclIntsLinCnc2D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclIntsLinCnc2D
     */
    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
	JgclIntsLinCnc2D doObj = new JgclIntsLinCnc2D(mate, this);
	return doObj.intersection(mate, this, !doExchange);
     }

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ~̒SԂ̋Ɠ~̔a̍A
     * ƂɌݐݒ肳Ă鉉Z̋̋e덷菬ꍇɂ́A
     * ~̓I[o[bvĂ̂ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     * <p>
     * []
     * <br>
     * ~̒SԂ̋Ɠ~̔a̘a邢͍ɂāA
     * _̐ŏꍇŁA
     * 􉽓IɉĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	~̓I[o[bvĂAsł
     */
    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) 
	throws JgclIndefiniteSolution
    {
	 JgclPoint2D center1 = position().location();
	 JgclPoint2D center2 = mate.position().location();
	 JgclVector2D evec = center2.subtract(center1);	// this -> mate
	 double edist = evec.length();
	 double egap1 = edist - (radius() + mate.radius());
	 double egap2 = Math.abs(radius() - mate.radius()) - edist;
	 double dTol = getToleranceForDistance();
	 JgclPoint2D pnt1;
	 JgclPoint2D pnt2;

	 if (egap1 > dTol || egap2 > dTol) {
	     return new JgclIntersectionPoint2D[0];
	 }
	 evec = evec.unitized();

	 if (egap1 > -dTol) {
	     // 1 intersection (external contact)
	     pnt1 = center1.add(evec.multiply(this.radius()));
	     pnt2 = center2.add(evec.multiply(-mate.radius()));
	     pnt1 = pnt1.linearInterpolate(pnt2, 0.5);
	     JgclIntersectionPoint2D pnts[] = {
		 new JgclIntersectionPoint2D(this, this.pointToParameter(pnt1),
					     mate, mate.pointToParameter(pnt1), doCheckDebug)
	     };
	     if (doExchange)
		 pnts[0] = pnts[0].exchange();

	     return pnts;
	 }
	 else if (egap2 > -dTol) {
	     // 1 intersection (internal contact)
	     egap2 = radius() - mate.radius();
	     if (Math.abs(egap2) < dTol) {
		 // 2 circles are same
		JgclIntersectionPoint2D ip = 
		    new JgclIntersectionPoint2D(this, 0.0, mate, 0.0, doCheckDebug);
		if (doExchange)
		    ip = ip.exchange();
		 throw new JgclIndefiniteSolution(ip);
	     }
	     if (egap2 < 0.0)

		 evec = evec.multiply(-1);
	     pnt1 = center1.add(evec.multiply(this.radius()));
	     pnt2 = center2.add(evec.multiply(mate.radius()));
	     pnt1 = pnt1.linearInterpolate(pnt2, 0.5);
	     JgclIntersectionPoint2D pnts[] = {
		 new JgclIntersectionPoint2D(this, this.pointToParameter(pnt1),
					     mate, mate.pointToParameter(pnt1), doCheckDebug)
	     };
	     if (doExchange)
		 pnts[0] = pnts[0].exchange();

	     return pnts;

	 }
	 else {
	     // 2 intersections
	     double edfatl = (radius() * radius() -
			      mate.radius() * mate.radius() +
			      edist * edist) / (2 * edist);
	     double e2dfatl = Math.sqrt(radius() * radius() - edfatl * edfatl);
	     JgclPoint2D eill = center1.add(evec.multiply(edfatl));
	     JgclVector2D elvec = evec.verticalVector();

	     pnt1 = eill.add(elvec.multiply(e2dfatl));
	     pnt2 = eill.add(elvec.multiply(-e2dfatl));

	     JgclIntersectionPoint2D pnts[] = {
		 new JgclIntersectionPoint2D(this, this.pointToParameter(pnt1),
					     mate, mate.pointToParameter(pnt1), doCheckDebug),
		 new JgclIntersectionPoint2D(this, this.pointToParameter(pnt2),
					     mate, mate.pointToParameter(pnt2), doCheckDebug)
	     };
	     if (doExchange)
		 for (int i = 0; i < 2; i++)
		     pnts[i] = pnts[i].exchange();

	     return pnts;
	 }
     }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsCirCnc2D#intersection(JgclCircle2D, JgclEllipse2D, boolean)
     * JgclIntsCirCnc2D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȉ~)
     * @param doExchange _ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclIntsCirCnc2D
     */
    JgclIntersectionPoint2D[] intersect(JgclEllipse2D  mate, boolean doExchange) {
	JgclIntsCirCnc2D doObj = new JgclIntsCirCnc2D();
	return doObj.intersection(this, mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ () Ƃ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsCirCnc2D#intersection(JgclCircle2D, JgclParabola2D, boolean)
     * JgclIntsCirCnc2D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclIntsCirCnc2D
     */
    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
	JgclIntsCirCnc2D doObj = new JgclIntsCirCnc2D();
	return doObj.intersection(this, mate, doExchange);
     }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) Ƃ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsCirCnc2D#intersection(JgclCircle2D, JgclHyperbola2D, boolean)
     * JgclIntsCirCnc2D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclIntsCirCnc2D
     */
    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
	JgclIntsCirCnc2D doObj = new JgclIntsCirCnc2D();
	return doObj.intersection(this, mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) Ƃ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * |C̃NX́u|C vs. ~v̌_Z\bh
     * {@link JgclPolyline2D#intersect(JgclCircle2D, boolean)
     * JgclPolyline2D.intersect(JgclCircle2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) Ƃ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. ~v̌_Z\bh
     * {@link JgclTrimmedCurve2D#intersect(JgclCircle2D, boolean)
     * JgclTrimmedCurve2D.intersect(JgclCircle2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐZOg) Ƃ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. ~v̌_Z\bh
     * {@link JgclCompositeCurveSegment2D#intersect(JgclCircle2D, boolean)
     * JgclCompositeCurveSegment2D.intersect(JgclCircle2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (Ȑ) Ƃ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * Ȑ̃NX́uȐ vs. ~v̌_Z\bh
     * {@link JgclCompositeCurve2D#intersect(JgclCircle2D, boolean)
     * JgclCompositeCurve2D.intersect(JgclCircle2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎ Bspline Ȑ߂B
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎ Bspline Ȑ
     * @see	JgclWhichSide
     */
    public JgclBsplineCurve2D
	offsetByBsplineCurve(JgclParameterSection pint,
			     double magni,
                             int side,
                             JgclToleranceForDistance tol) {
	JgclOfst2D doObj = new JgclOfst2D(this,pint,magni,side,tol);
	return doObj.offset();
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎLȐ߂B
     * <p>
     * ʂƂĕԂLȐ́A
     * JgclCircle2D ̃CX^XȐƂ
     * {@link JgclTrimmedCurve2D JgclTrimmedCurve2D}
     * ̃CX^XłB
     * </p>
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎLȐ
     * @see	JgclWhichSide
     */
    public JgclBoundedCurve2D
        offsetByBoundedCurve(JgclParameterSection pint,
			     double magni,
                             int side,
                             JgclToleranceForDistance tol)
    {
	JgclCircle2D basisCircle;

	if (side == JgclWhichSide.RIGHT) {
	    basisCircle = new JgclCircle2D(this.position(), (this.radius() + magni));
	    pint = pint;
	} else {
	    if (!(magni > radius)) {
		basisCircle = new JgclCircle2D(this.position(), (this.radius() - magni));
		pint = pint;
	    } else {
		basisCircle = new JgclCircle2D(this.position(), (magni - this.radius()));
		pint = new JgclParameterSection
		    (this.parameterDomain().wrap(pint.start() + Math.PI),
		     pint.increase());
	    }
	}

	return new JgclTrimmedCurve2D(basisCircle, pint);
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʐڐ߂B
     * <p>
     * ʐڐ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     *
     * @param mate	̋Ȑ
     * @return		ʐڐ̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʖ@߂B
     * <p>
     * ʖ@݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		ʖ@̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonNormal2D[]	commonNormal(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * <p>
     * LŎIȃp[^`ԂB
     * ȂAvC}ȗLԂ [0, (2 * )] łB
     * </p>
     * 
     * @return	LŎIȃp[^`
     */
    JgclParameterDomain getParameterDomain() {
	try {
	    return new JgclParameterDomain(true, 0, 2*Math.PI);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * ̋Ȑ􉽓IɕĂ邩ۂԂB
     * <p>
     * ~Ȃ̂ŁA true ԂB
     * </p>
     *
     * @return	~Ȃ̂ŁA <code>false</code>
     */
    boolean getClosedFlag() {
	return true;
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve2D#CIRCLE_2D JgclParametricCurve2D.CIRCLE_2D}
     */
    int type() {
	return CIRCLE_2D;
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclAxis2Placement2D tPosition =
	    this.position().transformBy(reverseTransform,
					transformationOperator,
					transformedGeometries);
	double tRadius;
	if (reverseTransform != true)
	    tRadius = transformationOperator.transform(this.radius());
	else
	    tRadius = transformationOperator.reverseTransform(this.radius());
	return new JgclCircle2D(tPosition, tRadius);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tposition");
        position().output(writer, indent + 2);
        writer.println(indent_tab + "\tradius " + radius);
        writer.println(indent_tab + "End");
    }

    /**
     * SƎn_AI_~ʂ𐶐B
     * <p>
     * ~ʂ̓gȐŕ\B
     * </p>
     * <p>
     * gȐ̕ȐƂȂ~̋Ǐ X ́̕A
     * Sn_֌ƂȂB
     * ܂A~̔áAuS|n_Ԃ̋vƁuS|I_Ԃ̋v̕ϒlƂȂB
     * uS|n_Ԃ̋vƁuS|I_Ԃ̋v̍ɂĂ͓ɈӎĂȂB
     * </p>
     * <p>
     * ȂA~ʂ́An_I_Ɍp[^l̐Βl
     * ΂zȂ悤ɐB
     * āA~ʂ\gȐ̃p[^l͕ɂȂ邱Ƃ蓾B
     * </p>
     *
     * @param center	S
     * @param startPoint	n_
     * @param endPoint	I_
     * @return	~ʂ\gȐ
     */
    public static JgclTrimmedCurve2D makeTrimmedCurve(JgclPoint2D center,
						      JgclPoint2D startPoint,
						      JgclPoint2D endPoint) {
	JgclVector2D sVec = startPoint.subtract(center);
	JgclVector2D eVec = endPoint.subtract(center);
	double radius = (sVec.length() + eVec.length()) / 2.0;

	sVec = sVec.unitized();
	eVec = eVec.unitized();

	double iParam = sVec.angleWith(eVec);
	if (Math.abs(iParam) > Math.PI)
	    iParam -= JgclMath.PI2;

	return new JgclTrimmedCurve2D
	    (new JgclCircle2D(new JgclAxis2Placement2D(center, sVec), radius),
	     new JgclParameterSection(0.0, iParam));
    }
}
