/*
 * R : Ȑ\ZOg\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclCompositeCurveSegment3D.java,v 1.61 2000/08/11 06:18:46 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : Ȑ\ZOg\NXB
 * <p>
 * ȐƂ́A ([_ŘA) ̗LȐ܂Ƃ߂
 * {̋ȐɌĂ̂łB
 * ̃NX́A
 * ̕Ȑ\X̗LȐ (𕡍Ȑ̃ZOgƂ)
 * \B
 * </p>
 * <p>
 * ̃NX̃CX^X́A
 * <ul>
 * <li> ZOg̎ۂ̋OՂ\LȐ parentCurve (ȐƂ)
 * <li>	ZOgȐƓۂtO sameSense
 * <li> ̃ZOgƂ̘A transition
 * </ul>
 * ێB
 * </p>
 * <p>
 * ȐZOg̒`́AȐ̒`ɈvB
 * </p>
 * <p>
 * <a name="CONSTRAINTS">[Ԃ̍S]</a>
 * </p>
 * <p>
 * parentCurve ͊J`łȂ΂ȂȂB
 * </p>
 *
 * @version $Revision: 1.61 $, $Date: 2000/08/11 06:18:46 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclCompositeCurveSegment3D extends JgclBoundedCurve3D {

    /**
     * ̃ZOgƂ̘AB
     * @serial
     * @see JgclTransitionCode
     */
    private int transition;

    /**
     * ZOgȐƓۂtOB
     * @serial
     */
    private boolean sameSense;

    /**
     * ZOg̎ۂ̋OՂ\ȐB
     * @serial
     */
    private JgclBoundedCurve3D parentCurve;

    /**
     * etB[hɐݒ肷l^ăIuWFNg\zB
     * <p>
     * ̒l <a href="#CONSTRAINTS">[Ԃ̍S]</a> 𖞂Ȃꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param transition	̃ZOgƂ̘A
     * @param sameSense		ȐƓۂtO
     * @param parentCurve	Ȑ
     * @see	JgclTransitionCode
     * @see	JgclInvalidArgumentValue
     */
    public JgclCompositeCurveSegment3D(int transition, boolean sameSense,
				       JgclBoundedCurve3D parentCurve)
    {
	super();

	if (parentCurve.isPeriodic() || parentCurve.isInfinite())
	    throw new JgclInvalidArgumentValue();

	this.transition = transition;
	this.sameSense = sameSense;
	this.parentCurve = parentCurve;
    }

    /**
     * ̃ZOg̎̃ZOgƂ̘AԂB
     * 
     * @return	̃ZOgƂ̘A
     * @see	JgclTransitionCode
     */
    public int transition() {
	return this.transition;
    }

    /**
     * ̃ZOgȐƓۂtOԂB
     * 
     * @return	ȐƓۂtO
     */
    public boolean sameSense() {
	return this.sameSense;
    }

    /**
     * ̃ZOg̕ȐԂB
     * 
     * @return	Ȑ
     */
    public JgclBoundedCurve3D parentCurve() {
	return this.parentCurve;
    }

    /**
     * ̗LȐ̊Jn_ԂB
     *
     * @return	Jn_
     */
    public JgclPoint3D startPoint() {
	if (sameSense)
	    return parentCurve.startPoint();
	else
	    return parentCurve.endPoint();
    }

    /**
     * ̗LȐ̏I_ԂB
     *
     * @return	I_
     */
    public JgclPoint3D endPoint() {
	if (sameSense)
	    return parentCurve.endPoint();
	else
	    return parentCurve.startPoint();
    }

    /**
     * ̗LȐ̊Jn_̃p[^lԂB
     *
     * @return	Jn_̃p[^l
     */
    double sParameter() {
	return parameterDomain().section().start();
    }

    /**
     * ̗LȐ̏I_̃p[^lԂB
     *
     * @return	I_̃p[^l
     */
    double eParameter() {
	return parameterDomain().section().end();
    }

    /**
     * ̃ZOgɑ΂ė^ꂽp[^lA
     * Ȑɑ΂p[^lɕϊB
     * <p>
     * ̃ZOg̒`͕Ȑ̒`ƈv邪A
     * sameSense  false ̏ꍇɂ́Ap[^l̕ϊKvɂȂB
     * </p>
     * <p>
     * ^ꂽp[^l̋Ȑ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param param	ZOgɑ΂p[^l
     * @return	Ȑɑ΂p[^l
     */
    private double toBasisParameter(double param) {
	checkValidity(param);

	if (sameSense)
	    return param;
	else {
	    JgclParameterSection sec = parameterDomain().section();
	    return sec.end() - (param - sec.start());
	}
    }

    /**
     * ̃ZOgɑ΂ė^ꂽp[^ԂA
     * Ȑɑ΂p[^ԂɕϊB
     * <p>
     * ̃ZOg̒`͕Ȑ̒`ƈv邪A
     * sameSense  false ̏ꍇɂ́Ap[^l̕ϊKvɂȂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ̋Ȑ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param pint	ZOgɑ΂p[^
     * @return	Ȑɑ΂p[^
     */
    public JgclParameterSection toBasisParameter(JgclParameterSection pint) {
	double start = toBasisParameter(pint.start());
	double end = toBasisParameter(pint.end());

	return new JgclParameterSection(start, end - start);
    }

    /**
     * ̃ZOg̕Ȑɑ΂ė^ꂽp[^lA
     * ̃ZOgɑ΂p[^lɕϊB
     * <p>
     * ̃ZOg̒`͕Ȑ̒`ƈv邪A
     * sameSense  false ̏ꍇɂ́Ap[^l̕ϊKvɂȂB
     * </p>
     *
     * @param param	Ȑɑ΂p[^l
     * @return	ZOgɑ΂p[^l
     */
    private double toOwnParameter(double param) {
	double result;

	if (sameSense)
	    result = param;
	else {
	    JgclParameterSection sec = parameterDomain().section();
	    result = sec.start() - (param - sec.end());
	}

	return result;
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * <p>
     * pint ̑l͕ł܂ȂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ̋Ȑ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     * @see	JgclParameterOutOfRange
     */
    public double length(JgclParameterSection pint) {
	return parentCurve.length(toBasisParameter(pint));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		Wl
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint3D coordinates(double param) {
	return parentCurve.coordinates(toBasisParameter(param));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ڃxNg
     * @see	JgclParameterOutOfRange
     */
    public JgclVector3D tangentVector(double param) {
	JgclVector3D tang = parentCurve.tangentVector(toBasisParameter(param));

	if (sameSense)
	    return tang;
	else
	    return tang.multiply(-1);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ȗ
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveCurvature3D curvature(double param) {
	return parentCurve.curvature(toBasisParameter(param));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̃CԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		C
     * @see	JgclParameterOutOfRange
     */
    public double torsion(double param) {
	return parentCurve.torsion(toBasisParameter(param));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		֐
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveDerivative3D evaluation(double param) {
	JgclCurveDerivative3D curv =
	    parentCurve.evaluation(toBasisParameter(param));
	if (sameSense)
	    return curv;
	else {
	    JgclCurveDerivative3D rcurv =
		new JgclCurveDerivative3D(curv.d0D(), curv.d1D().multiply(-1), 
					  curv.d2D(), curv.d3D().multiply(-1));
	    return rcurv;
	}
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ٓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return	ٓ_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    public JgclPointOnCurve3D[] singular() throws JgclIndefiniteSolution {
	JgclPointOnCurve3D[] singular = parentCurve.singular();
	JgclPointOnCurve3D[] thisSingular =
	  new JgclPointOnCurve3D[singular.length];

	for (int i = 0; i < singular.length; i++) {

	    try {
		thisSingular[i] = new JgclPointOnCurve3D
		    (this, toOwnParameter(singular[i].parameter()));
	    }
	    catch(JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }

	}
	return thisSingular;
    }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * ϋȓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return	ϋȓ_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    public JgclPointOnCurve3D[] inflexion() throws JgclIndefiniteSolution {
	JgclPointOnCurve3D[] inflexion = parentCurve.inflexion();
	JgclPointOnCurve3D[] thisInflexion =
	    new JgclPointOnCurve3D[inflexion.length];

	for (int i = 0; i < inflexion.length; i++) {

	    try {
		thisInflexion[i] = new JgclPointOnCurve3D
		    (this, toOwnParameter(inflexion[i].parameter()));
	    }
	    catch(JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }

	}
	return thisInflexion;
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param point	e̓_
     * @return	e_
     * @exception JgclIndefiniteSolution	sł
     */
    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D point)
	throws JgclIndefiniteSolution
    {
 	JgclPointOnCurve3D[] proj = parentCurve.projectFrom(point);
 	JgclPointOnCurve3D[] proj2 = new JgclPointOnCurve3D[proj.length];

	for (int i = 0; i < proj.length; i++) {
	    try {
 		proj2[i] = new JgclPointOnCurve3D
		    (this, toOwnParameter(proj[i].parameter()));
	    }
	    catch(JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}
	return proj2;
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_
     * ̋Ȑx[XȐƂ JgclPointOnCurve3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * section ̒lÃxWGȐ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param section	ߎp[^
     * @param tolerance	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     * @see	JgclParameterOutOfRange
     */
    public JgclPolyline3D toPolyline(JgclParameterSection pint,
				     JgclToleranceForDistance tol)
    {
	JgclPolyline3D pl = parentCurve.toPolyline(toBasisParameter(pint), tol);
	JgclPoint3D[] pnts = new JgclPoint3D[pl.nPoints()];

	for (int i = 0; i < pnts.length; i++) {
	    JgclPointOnCurve3D p = (JgclPointOnCurve3D)pl.pointAt(i);
	    pnts[i] = new JgclPointOnCurve3D(this, toOwnParameter(p.parameter()), doCheckDebug);
	}
	return new JgclPolyline3D(pnts);
    }

    /**
     * ̋Ȑ̎w̋ԂɍČL Bspline ȐԂB
     * <p>
     * pint ̒lÂaXvCȐ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param pint	L Bspline ȐōČp[^
     * @return		̋Ȑ̎w̋ԂČL Bspline Ȑ
     * @see	JgclParameterOutOfRange
     */
    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
	return parentCurve.toBsplineCurve(toBasisParameter(pint));
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * ̋Ȑ̕ȐƑ̋Ȑ̌_߂ɁA
     * ̕Ȑɑ΂p[^l
     * ̃ZOgɑ΂p[^lɕϊ
     * u_vƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    private JgclIntersectionPoint3D[] doIntersect(JgclParametricCurve3D mate,
						  boolean doExchange) {
	JgclIntersectionPoint3D[] ints;
	try {
	    ints = parentCurve.intersect(mate);
	} catch (JgclIndefiniteSolution e) {
	    return new JgclIntersectionPoint3D[0];	// ??
	}
	JgclIntersectionPoint3D[] thisInts =
	    new JgclIntersectionPoint3D[ints.length];

	for (int i = 0; i < ints.length; i++) {
	    double param = toOwnParameter(ints[i].pointOnCurve1().parameter());
	    JgclPointOnCurve3D thisPnts = new JgclPointOnCurve3D(this, param, doCheckDebug);

	    if (!doExchange)
		thisInts[i] =
		    new JgclIntersectionPoint3D(thisPnts, ints[i].pointOnGeometry2(), doCheckDebug);
	    else
		thisInts[i] =
		    new JgclIntersectionPoint3D(ints[i].pointOnGeometry2(), thisPnts, doCheckDebug);
	}
	return thisInts;
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return	_̔z
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) {
	return doIntersect(mate, false);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (~)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐZOg) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗʂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     *
     * @param mate	̋Ȗ
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] doIntersect(JgclParametricSurface3D mate,
					  boolean doExchange) {
	JgclIntersectionPoint3D[] intp;
	try {
	    intp = parentCurve.intersect(mate);
	} catch (JgclIndefiniteSolution e) {
	    return new JgclIntersectionPoint3D[0];	// ??
	}

	JgclCurveSurfaceInterferenceList intfList =
	    new JgclCurveSurfaceInterferenceList(this, mate);

	for (int i = 0; i < intp.length; i++) {
	    JgclPointOnCurve3D crvPnt =
		(JgclPointOnCurve3D)intp[i].pointOnGeometry1();
	    double crvParam = toOwnParameter(crvPnt.parameter());
	    JgclPointOnSurface3D srfPnt =
		(JgclPointOnSurface3D)intp[i].pointOnGeometry2();
	    intfList.addAsIntersection(intp[i].coordinates(), crvParam,
					    srfPnt.uParameter(), srfPnt.vParameter());
	}
  	return intfList.toJgclIntersectionPoint3DArray(doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗʂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return		_̔z
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate) {
	return doIntersect(mate, false);
    }

    /**
     * ̋ȐƑ̋Ȗʂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate,
					boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ (͋Ȗ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ (͋Ȗ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate,
					boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ (xWGȖ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ (xWGȖ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate,
					boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ (aXvCȖ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ (aXvCȖ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate,
					       boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		Ȑ̊̔z
     */
    public JgclCurveCurveInterference3D[] interfere(JgclBoundedCurve3D mate) {
	return this.interfere(mate, false);
    }

    /**
     * Ȑɑ΂p[^l
     * ZOgɑ΂p[^lւ̕ϊ\NXB
     * @see	#interfere(JgclBoundedCurve3D, boolean)
     */
    class ToSegmentConversion extends JgclParameterConversion3D {
	/**
	 * ^ɃIuWFNg\zB
	 */
	ToSegmentConversion() {
	}

	/**
	 * Ȑɑ΂p[^lZOgɑ΂p[^l֕ϊB
	 * 
	 * @param param	Ȑɑ΂p[^l
	 * @return	ZOgɑ΂p[^l
	 */
	double convParameter(double param) {
	    return JgclCompositeCurveSegment3D.this.toOwnParameter(param);
	}

	/**
	 * Ȑɑ΂p[^lϊΏۂłZOgԂB
	 * 
	 * @param param Ȑɑ΂p[^l
	 * @return	ZOg
	 */
	JgclParametricCurve3D convCurve(double param) {
	    return JgclCompositeCurveSegment3D.this;
	}
    }

    /**
     * ̗LȐƑ̗LȐ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȑ̕ȐƑ̗LȐ̊߂ɁA
     * ̕Ȑɑ΂p[^l
     * ̃ZOgɑ΂p[^lɕϊ
     * uvƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     * @see	JgclCompositeCurveSegment3D.ToSegmentConversion
     */
    JgclCurveCurveInterference3D[] interfere(JgclBoundedCurve3D mate,
					     boolean doExchange) {
	ToSegmentConversion conv = new ToSegmentConversion();
	JgclParameterSection sec = this.parameterDomain().section();

	JgclCurveCurveInterference3D[] intf;
	if (!doExchange) {
	    intf = this.parentCurve.interfere(mate);
	} else {
	    intf = mate.interfere(this.parentCurve);
	}

	Vector vec = new Vector();

	for (int i = 0; i < intf.length; i++) {
	    JgclCurveCurveInterference3D trimintf;
	    if (!doExchange) {
		trimintf = intf[i].trim1(sec, conv);
	    } else {
		trimintf = intf[i].trim2(sec, conv);
	    }
	    if (trimintf != null)
		vec.addElement(trimintf);
	}
	JgclCurveCurveInterference3D[] interf =
	    new JgclCurveCurveInterference3D[vec.size()];
	vec.copyInto(interf);
	return interf;
    }

    /**
     * ̗LȐƑ̗LȐ () ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ ()
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve3D, boolean)
     */
    JgclCurveCurveInterference3D[] interfere(JgclBoundedLine3D mate,
					     boolean doExchange)
    {
	return this.interfere((JgclBoundedCurve3D)mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (|C) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (|C)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve3D, boolean)
     */
    JgclCurveCurveInterference3D[] interfere(JgclPolyline3D mate,
					     boolean doExchange)
    {
	return this.interfere((JgclBoundedCurve3D)mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (xWGȐ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (xWGȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve3D, boolean)
     */
    JgclCurveCurveInterference3D[] interfere(JgclPureBezierCurve3D mate,
					     boolean doExchange)
    {
	return this.interfere((JgclBoundedCurve3D)mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (aXvCȐ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (aXvCȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve3D, boolean)
     */
    JgclCurveCurveInterference3D[] interfere(JgclBsplineCurve3D mate,
					     boolean doExchange)
    {
	return this.interfere((JgclBoundedCurve3D)mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (gȐ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (gȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve3D, boolean)
     */
    JgclCurveCurveInterference3D[] interfere(JgclTrimmedCurve3D mate,
					     boolean doExchange) {
	return this.interfere((JgclBoundedCurve3D)mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (ȐZOg) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (ȐZOg)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve3D, boolean)
     */
    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurveSegment3D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (Ȑ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (Ȑ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve3D, boolean)
     */
    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurve3D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̋ȐA^ꂽxNgɏ]ĕsړȐԂB
     *
     * @param moveVec	sړ̕Ɨʂ\xNg
     * @return		sړ̋Ȑ
     */
    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
	JgclBoundedCurve3D newParent = (JgclBoundedCurve3D)parentCurve.parallelTranslate(moveVec);
	return new JgclCompositeCurveSegment3D(transition, sameSense, newParent);
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * <p>
     * Ȑ̒`ԂB
     * </p>
     *
     * @return	LŔIȃp[^`
     */
    JgclParameterDomain getParameterDomain() {
	return parentCurve.parameterDomain();
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve3D#COMPOSITE_CURVE_SEGMENT_3D JgclParametricCurve3D.COMPOSITE_CURVE_SEGMENT_3D}
     */
    int type() {
	return COMPOSITE_CURVE_SEGMENT_3D;
    }

    /**
a     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	ȐR`ł trueAłȂ false
     */
    public boolean isFreeform() {
	return this.parentCurve.isFreeform();
    }

    /**
     * ̋ȐA^ꂽǏWn Z ̎ɁA
     * ^ꂽpx]ȐԂB
     *
     * @param trns	ǏWn瓾ꂽWϊZq
     * @param rCos	cos(]px)
     * @param rSin	sin(]px)
     * @return		]̋Ȑ
     */
    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns,
				  double rCos, double rSin) {
	JgclBoundedCurve3D r_bnd = (JgclBoundedCurve3D)parentCurve().rotateZ(trns, rCos, rSin);
	return new JgclCompositeCurveSegment3D(transition(), sameSense(), r_bnd);
    }

    /**
     * ̋Ȑ̓_ŁA^ꂽɂȂ_ԂB
     *
     * @param line	
     * @return		^ꂽɂȂ_
     */
    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
	JgclParameterSection pint = parameterDomain().section();
	JgclBsplineCurve3D b_spline = toBsplineCurve(pint);
	return b_spline.getPointNotOnLine(line);
    }

    /**
     * ̃ZOǵũZOgƂ̘Av
     * w̒lɕύXIuWFNgԂB
     *
     * @param transition	̃ZOgƂ̘A
     * @return	w̕ύXč쐬ZOg
     */
    JgclCompositeCurveSegment3D makeCopyWithTransition(int transition) {
	return new JgclCompositeCurveSegment3D(transition,
					       this.sameSense,
					       this.parentCurve);
    }

    /**
     * ̃ZOǵũZOgƂ̘Av
     * w̒lɕύXAZOg̕𔽓]IuWFNgԂB
     *
     * @param transition	̃ZOgƂ̘A
     * @return	w̕ύXč쐬ZOg
     */
    JgclCompositeCurveSegment3D makeReverseWithTransition(int transition) {
	return new JgclCompositeCurveSegment3D(transition,
					       !this.sameSense,
					       this.parentCurve);
    }

    /**
     * ̃ZOgA^ꂽp[^ԂŐؒfIuWFNgԂB
     *
     * @param section	ؒfĎc\p[^
     * @return	ؒfĎc\ZOg
     */
    JgclCompositeCurveSegment3D truncate(JgclParameterSection section,
					 int transition) {
	JgclParameterSection parentSection = this.toBasisParameter(section);
	JgclTrimmedCurve3D newParent;

	if (this.parentCurve.type() == TRIMMED_CURVE_3D) {
	    JgclTrimmedCurve3D trc = (JgclTrimmedCurve3D)this.parentCurve;
	    newParent = new JgclTrimmedCurve3D(trc.basisCurve(), parentSection);
	} else {
	    newParent = new JgclTrimmedCurve3D(this.parentCurve, parentSection);
	}

	return new JgclCompositeCurveSegment3D(transition, true, newParent);
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclBoundedCurve3D tParentCurve =
	    (JgclBoundedCurve3D)this.parentCurve().transformBy(reverseTransform,
							       transformationOperator,
							       transformedGeometries);
	return new JgclCompositeCurveSegment3D(this.transition(),
					       this.sameSense(),
					       tParentCurve);
    }

    /**
     * ̋Ȑ|C̕܂ނۂԂB
     *
     * @return	̋Ȑ|Cł邩A
     *		܂͎g\镔iƂă|C܂ނȂ trueA
     *		łȂ false
     */
    protected boolean hasPolyline() {
	return parentCurve.hasPolyline();
    }

    /**
     * ̋Ȑ|C̕łłĂ邩ۂԂB
     *
     * @return	̋Ȑ|Cł邩A
     *		܂͎g\镔iƂă|C܂ނȂ trueA
     *		łȂ false
     */
    protected boolean isComposedOfOnlyPolylines() {
	return parentCurve.isComposedOfOnlyPolylines();
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\ttransition\t"
		       + JgclTransitionCode.toString(transition));
        writer.println(indent_tab + "\tsameSense\t" + sameSense);
        writer.println(indent_tab + "\tparentCurve");
        parentCurve.output(writer, indent + 2);
        writer.println(indent_tab + "End");
    }

}
