/*
 * R : ~Ȑ̃NXKw̃[gƂȂ钊ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclConic3D.java,v 1.59 2000/08/11 06:18:46 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;

/**
 * R : ~Ȑ̃NXKw̃[gƂȂ钊ۃNXB
 * <p>
 * ̃NX̃CX^X́A
 * ~Ȑ̈ʒuƌX肷ǏWn
 * (zuA{@link JgclAxis2Placement3D JgclAxis2Placement3D})
 * position ێB
 * </p>
 * <p>
 * position  null łĂ͂ȂȂB
 * </p>
 *
 * @version $Revision: 1.59 $, $Date: 2000/08/11 06:18:46 $
 * @author Information-technology Promotion Agency, Japan
 */

public abstract class JgclConic3D extends JgclParametricCurve3D {
    /**
     * ~Ȑ́uSvƋǏ̕肷ǏWnB
     * @serial
     */
    private JgclAxis2Placement3D position;

    /**
     * ǏWnw肵ȂIuWFNg͍ȂB
     */
    private JgclConic3D() {
	super();
	this.position = null;
    }

    /**
     * ǏWnw肵ăIuWFNg\zB
     * <p>
     * position  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param position	SƎ
     * @see	JgclInvalidArgumentValue
     */
    protected JgclConic3D(JgclAxis2Placement3D position) {
	super();
	if (position == null)
	    throw new JgclInvalidArgumentValue("position is null.");
	this.position = position;
    }

    /**
     * XP[Ol 1 ƂāA
     * ̉~Ȑ̋ǏWnIȍWnւ̕ϊsȂZqԂB
     * 
     * @return	ǏWnIȍWnւ̕ϊsȂZq
     */
    protected JgclCartesianTransformationOperator3D toGlobal() {
	return new JgclCartesianTransformationOperator3D(position(), 1.0);
    }

    /**
     * ̉~ȐA
     * ^ꂽQ̋ǏWn (zu) Q`ɕϊ̂ԂB
     *
     * @param position	Q̋ǏWn (zu)
     * @return	Q`
     */
    abstract JgclConic2D toLocal2D(JgclAxis2Placement2D position);

    /**
     * ̉~ȐA
     * Q̑IȍWnzuƂQ`ɕϊ̂ԂB
     * 
     * @return	Q`
     * @see	#toLocal2D(JgclAxis2Placement2D)
     */
    JgclConic2D toLocal2D() {
	return toLocal2D(JgclAxis2Placement2D.origin);
    }

    /**
     * ̉~ȐA
     * ^ꂽǏWnɋtϊɁA
     * ̋ǏWn X/Y ʏ̂Q`ɕϊ̂ԂB
     * <p>
     * transform ́A
     * ̉~Ȑ镽ʂ̖@Ǐ Z Ƃ
     * ǏWn\̂łȂ΂ȂȂB
     * </p>
     * 
     * @param transform	ǏWn\􉽓IϊZq
     * @return	Q`
     * @see	#toLocal2D(JgclAxis2Placement2D)
     */
    JgclConic2D toLocal2D(JgclCartesianTransformationOperator3D transform) {
	JgclPoint2D location = transform.toLocal(position().location()).to2D();
	JgclVector2D x_axis = transform.toLocal(position().x()).to2D();
	JgclAxis2Placement2D position =
	    new JgclAxis2Placement2D(location, x_axis);
	return toLocal2D(position);
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     */
    public double length(JgclParameterSection pint) {
	JgclConic2D conic2D = toLocal2D();
	return conic2D.length(pint);
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_ JgclPointOnCurve3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * ȂAʂƂē|C_ɏkނ悤ȏꍇɂ
     * JgclZeroLength ̗O𔭐B
     * </p>
     * 
     * @param pint	ߎp[^
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     * @see	JgclPointOnCurve3D
     * @see	JgclZeroLength
     */
    public JgclPolyline3D toPolyline(JgclParameterSection pint,
				     JgclToleranceForDistance tol) 
    {
	if (pint.increase() < 0.0) {
	    return toPolyline(pint.reverse(), tol).reverse();
	}

	double sp;
	double ep;
	JgclParameterDomain domain = parameterDomain();

	if (domain.isPeriodic()) {
	    // Ellipse
	    sp = domain.wrap(pint.start());
	    ep = domain.wrap(pint.end());

	    if (sp > ep)
		ep += domain.section().increase();
	}
	else {
	    sp = pint.lower();
	    checkValidity(sp);

	    ep = pint.upper();
	    checkValidity(ep);
	}

	double tolerance = Math.abs(tol.value());

	IntervalInfo root_info = new IntervalInfo();
	try {
	    root_info.left = new JgclPointOnCurve3D(this, sp, doCheckDebug);
	    root_info.right = new JgclPointOnCurve3D(this, ep, doCheckDebug);
	}
	catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}

	JgclBinaryTree pnt_tree = new JgclBinaryTree(root_info);

	int no_pnts = 2;	// left & right
	no_pnts += divideInterval(pnt_tree.rootNode(), tolerance*tolerance);

	JgclPoint3D[] pnts = new JgclPoint3D[no_pnts];
	FillInfo fill_info = new FillInfo(pnts, 0);

	pnt_tree.rootNode().preOrderTraverse(new FillArray(), fill_info);

	if (no_pnts == 2 && pnts[0].identical(pnts[1]))
	    throw new JgclZeroLength();

	return new JgclPolyline3D(pnts);
    }

    /**
     * ~Ȑ̂ԂNXB
     * <p>
     * ̓NX
     * {@link #toPolyline(JgclParameterSection, JgclToleranceForDistance)
     * toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * ̓ł̂ݗpB
     * </p>
     */
    private class IntervalInfo {
	/**
	 * Ԃ̍[ ()B
	 */
	JgclPointOnCurve3D left;

	/**
	 * Ԃ̉E[ ()B
	 */
	JgclPointOnCurve3D right;
    }

    /**
     * ̉~Ȑ́A^ꂽԂ𒼐ߎ_𔭐B
     * <p>
     * _̏ crnt_node ȉ̓񕪖ؓɎ߂B
     * </p>
     * <p>
     * ̃\bh
     * {@link #toPolyline(JgclParameterSection, JgclToleranceForDistance)
     * toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * ̓ł̂ݗpB
     * </p>
     *
     * @param crnt_node	Ԃێ񕪖؂̃m[h
     * @param tol	ߎ̐xƂė^ꂽűe덷v
     * @return	Ȑ𒼐ߎ_̓_̐
     * @see IntervalInfo
     * @see #checkInterval(JgclConic3D.IntervalInfo, double)
     */
    private int divideInterval(JgclBinaryTree.Node crnt_node,
			       double tol_2) {
	int no_pnts = 1;	// mid

	IntervalInfo crnt_info = (IntervalInfo)crnt_node.data();
	double mid_param = (crnt_info.left.parameter() +
			    crnt_info.right.parameter()) / 2.0;

	// divide current interval into two

	IntervalInfo left_info = new IntervalInfo();
	left_info.left = crnt_info.left;
	try {
	    left_info.right = new JgclPointOnCurve3D(this, mid_param, doCheckDebug);
	}
	catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}

	JgclBinaryTree.Node left_node = crnt_node.makeLeft(left_info);

	IntervalInfo right_info = new IntervalInfo();
	right_info.left = left_info.right;
	right_info.right = crnt_info.right;

	JgclBinaryTree.Node right_node = crnt_node.makeRight(right_info);

	// check

	if (!checkInterval(left_info, tol_2))
	    no_pnts += divideInterval(left_node, tol_2);

	if (!checkInterval(right_info, tol_2))
	    no_pnts += divideInterval(right_node, tol_2);

	return no_pnts;
    }

    /**
     * ^ꂽp[^ԂɂāA
     * Ԃ̗[Ԍłꂽ_̃p[^l߂钊ۃ\bhB
     * <p>
     * ̃\bh
     * {@link #checkInterval(JgclConic3D.IntervalInfo, double)
     * checkInterval(JgclConic3D.IntervalInfo, double)}
     * ŌĂяoB
     * </p>
     * 
     * @param left	[ (ԉ) ̃p[^l
     * @param right	E[ (ԏ) ̃p[^l
     * @return		łꂽ_̃p[^l
     * @see	#checkInterval(JgclConic3D.IntervalInfo, double)
     */
    abstract double getPeak(double left, double right);

    /**
     * ̋Ȑ́A^ꂽԂ́uvw̐x菬ۂԂB
     * <p>
     * Ԃ́uv
     * {@link #getPeak(double, double) getPeak(double, double)}
     * œB
     * </p>
     * <p>
     * ̃\bh
     * {@link #toPolyline(JgclParameterSection, JgclToleranceForDistance)
     * toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * ̓ł̂ݗpB
     * mɂ́A
     * toPolyline(JgclParameterSection, JgclToleranceForDistance) 
     * ŌĂяo
     * {@link #divideInterval(JgclBinaryTree.Node, double)
     * divideInterval(JgclBinaryTree.Node, double)}
     * ̒ł̂݌ĂяoB
     * </p>
     *
     * @param info	Ȑ̋
     * @param tol	ߎ̐xƂė^ꂽűe덷v
     * @return	Ԃ́uvw̐x菬 trueAłȂ false
     * @see	#getPeak(double, double)
     */
    private boolean checkInterval(IntervalInfo info, double tol_2) {
	double peak_param = getPeak(info.left.parameter(),
				    info.right.parameter());

	// ̃R[hŒuč : hideit 2000/03/17
	/***
	JgclPointOnCurve3D peak = null;
	try {
	    peak = new JgclPointOnCurve3D(this, peak_param, doCheckDebug);
	}
	catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}

	JgclLine3D line = new JgclLine3D(info.left, info.right);
	JgclPoint3D proj;
	try {
	    proj = line.project1From(peak);
	}
	catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}

	return (peak.subtract(proj).norm() < tol_2);
	***/

	// ̃R[h
	JgclPoint3D peak = this.coordinates(peak_param);
	JgclVector3D unitChord = info.right.subtract(info.left).unitized();
	JgclVector3D left2peak = peak.subtract(info.left);
	double norm = left2peak.crossProduct(unitChord).norm();

	return (norm < tol_2);
    }

    /**
     * qm[hȂm[h́uf[^v
     * ^ꂽzɑ JgclBinaryTree.TraverseProcB
     */
    private class FillArray implements JgclBinaryTree.TraverseProc {
	/**
	 * qm[hȂm[h́uf[^v^ꂽzɑB
	 * <p>
	 * pdata  {@link JgclConic3D.FillInfo JgclConic3D.FillInfo} NX
	 * CX^XłȂ΂ȂȂB
	 * </p>
	 * <p>
	 * ̓NX
	 * {@link #toPolyline(JgclParameterSection, JgclToleranceForDistance)
	 * toPolyline(JgclParameterSection, JgclToleranceForDistance)}
	 * ̓ł̂ݗpB
	 * </p>
	 *
	 * @param node	ΏۂƂȂm[h
	 * @param ctl	Jnm[h node ܂ł̐[ (QƂȂ)
	 * @param pdata	m[h́uf[^vz
	 * @see #toPolyline(JgclParameterSection, JgclToleranceForDistance)
	 */
	public boolean doit(JgclBinaryTree.Node node, int ctl, Object pdata) {
	    if ((node.left() == null) && (node.right() == null)) {

		FillInfo fill_info = (FillInfo)pdata;
		int idx = fill_info.index;
		IntervalInfo info = (IntervalInfo)node.data();

		if (idx == 0)
		    fill_info.pnts[idx++] = info.left;

		fill_info.pnts[idx++] = info.right;
		fill_info.index = idx;
	    }
	    return false;
	}
    }

    /**
     * ̋Ȑ̂Ԃ𒼐ߎ_߂邽߂̔zNXB
     * <p>
     * ̓NX
     * {@link #toPolyline(JgclParameterSection, JgclToleranceForDistance)
     * toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * ̓ł̂ݗpB
     * </p>
     */
    private class FillInfo {
	/**
	 * ̋Ȑ̂Ԃ𒼐ߎ_B
	 */
	private JgclPoint3D[] pnts;

	/**
	 * ̑ pnts[index] ɑ΂čsȂׂł邱ƂlB
	 */
	private int index;

	/**
	 * _ێׂzƁA̗vf̐擪ԍ^
	 * IuWFNg\zB
	 */
	private FillInfo(JgclPoint3D[] pnts, int index) {
	    super();
	    this.pnts = pnts;
	    this.index = index;
	}
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ̋Ȑ~łƂA
     * ^ꂽ_Ƃ̉~̒SƂ̋A
     * ݐݒ肳Ă鉉Z̋̋e덷
     * ꍇɂ́A
     * p[^l 0 ̓_ suitable Ƃ
     * JgclIndefiniteSolution ̗O𓊂B
     * </p>
     * <p>
     * []
     * <br>
     * <ul>
     * <li>	^ꂽ_Ȑ̏Ă镽ʂɓe_ Q ߂
     * <li>	Q Ȑւ̓e_ R Qʏŋ߂
     * <li>	e_ R ̃p[^lp JgclPointOnCurve3D 𐶐
     * </ul>
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     * @exception	JgclIndefiniteSolution	s (Ȑ~łAe̓_~̒SɈv)
     */
    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D point) 
	throws JgclIndefiniteSolution
    {
	JgclCartesianTransformationOperator3D trans = toGlobal();

	JgclPoint3D localp = trans.reverseTransform(point);
	JgclPoint2D p2 = localp.to2D();
	JgclConic2D conic2d = toLocal2D();

	JgclPointOnCurve2D[] proj2 = conic2d.projectFrom(p2);
	JgclPointOnCurve3D[] proj3 = new JgclPointOnCurve3D[proj2.length];
	for (int i = 0; i < proj2.length; i++)
	    proj3[i] = new JgclPointOnCurve3D(this, proj2[i].parameter(), doCheckDebug);
	return proj3;
    }

    /**
     * ̉~Ȑ́uSvƋǏ̕肵ĂǏWnԂB
     * 
     * @return	SƋǏ̕ǏWn
     */
    public JgclAxis2Placement3D position() {
	return position;
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̃CԂB
     * <p>
     * ~Ȑ͝ĂȂ̂ŁA 0 ԂB
     * </p>
     * 
     * @param param	p[^l
     * @return		C
     */
    public double torsion(double param) {
	// SĂ conic ͝ĂȂB
	return 0.0;
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ~Ȑɂ͓ٓ_݂͑Ȃ̂ŁAɒ 0 ̔zԂB
     * </p>
     * 
     * @return		ٓ_̔z
     */
    public JgclPointOnCurve3D[] singular() {
        return new JgclPointOnCurve3D[0];
    }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * ~Ȑɂ͕ϋȓ_݂͑Ȃ̂ŁAɒ 0 ̔zԂB
     * </p>
     * 
     * @return		ϋȓ_̔z
     */
    public JgclPointOnCurve3D[] inflexion() {
        return new JgclPointOnCurve3D[0];
    }

    /**
     * ̉~Ȑ (\ꂽ) RȐ̌_\㐔𐶐钊ۃ\bhB
     * 
     * @param poly	xWGȐ邢͂aXvCȐ̂ZOg̑\̔z
     * @return		̉~Ȑ poly ̌_\㐔̍
     * @see	#intersect(JgclPureBezierCurve3D, boolean)
     * @see	#intersect(JgclBsplineCurve3D, boolean)
     */
    abstract JgclRealPolynomial makePoly(JgclRealPolynomial[] poly);

    /**
     * ^ꂽ_̋Ȑɂ邩ۂ`FbN钊ۃ\bhB
     * 
     * @param point	ΏۂƂȂ_
     * @return		^ꂽ_̋Ȑɂ trueAłȂ false
     * @see	#intersect(JgclPureBezierCurve3D, boolean)
     * @see	#intersect(JgclBsplineCurve3D, boolean)
     */
    abstract boolean checkSolution(JgclPoint3D point);

    /**
     * ^ꂽ_̋Ȑɂ̂ƂāA
     * ̓_̋Ȑł̃p[^l߂钊ۃ\bhB
     * 
     * @param point	ΏۂƂȂ_
     * @return		p[^l
     * @see	#intersect(JgclPureBezierCurve3D, boolean)
     * @see	#intersect(JgclBsplineCurve3D, boolean)
     */
    abstract double getParameter(JgclPoint3D point);

    /**
     * 񎟌̌_ {@link JgclIntersectionPoint2D JgclIntersectionPoint2D} 
     * Ǒ_֕ϊB
     * <p>
     * i Ԗڂ̌_ ints2[i] ɂāA
     * {@link JgclIntersectionPoint2D#pointOnCurve1() pointOnCurve1()}.parameter(),
     * {@link JgclIntersectionPoint2D#pointOnCurve2() pointOnCurve2()}.parameter()
     * ̂܂܎gāA
     * ŐȐ curve1, curve2 ̌_쐬B
     * </p>
     * 
     * @param ints2	񎟌̌_̔z
     * @param curve1	pointOnCurve1 ɑΉOȐ
     * @param curve2	pointOnCurve2 ɑΉOȐ
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		Ǒ_̔z
     */
    private JgclIntersectionPoint3D[]
	toIntersectionPoint3D(JgclIntersectionPoint2D[] ints2,
			      JgclParametricCurve3D curve1,
			      JgclParametricCurve3D curve2,
			      boolean doExchange) {

	JgclIntersectionPoint3D[] ints3 =
	    new JgclIntersectionPoint3D[ints2.length];

	for (int i = 0; i < ints2.length; i++) {
	    if (!doExchange)
		ints3[i] = new JgclIntersectionPoint3D
		    (curve1, ints2[i].pointOnCurve1().parameter(),
		     curve2, ints2[i].pointOnCurve2().parameter(), false);
	    else
		ints3[i] = new JgclIntersectionPoint3D
		    (curve2, ints2[i].pointOnCurve2().parameter(),
		     curve1, ints2[i].pointOnCurve1().parameter(), false);
	}
	return ints3;
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * <ul>
     * <li>	̉~Ȑ C ̏Ă镽 P Ɨ^ꂽ L Ƃ̌_ A ߂B
     * <li>	L  P ̏ɏĂ A łȂꍇɂ
     *		P ̓񎟌Ԃ C  L Ƃ̌_߂B
     * <li>	A ܂ꍇA
     *		A  C ̏̏Ă A _ƂB
     * </ul>
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange _ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
	JgclIntersectionPoint3D ints;
	JgclPlane3D plane = new JgclPlane3D(position());

	try {
	    ints = plane.intersect1(mate);
	}
	catch(JgclIndefiniteSolution e) {
	    // lines on the plane
	    JgclCartesianTransformationOperator3D trans = 
		new JgclCartesianTransformationOperator3D(position(), 1.0);

	    JgclLine2D lline = mate.toLocal2D(trans);
	    JgclIntersectionPoint2D[] ints2d;
	    try {
		ints2d = toLocal2D().intersect(lline);
	    } catch (JgclIndefiniteSolution e2) {
		throw new JgclFatal();	// Never be occured??
	    }
	    return toIntersectionPoint3D(ints2d, this, mate, doExchange);
	}

	if (ints != null) {
	    double cparam;
	    try {
		cparam = pointToParameter(ints);
	    }
	    catch (JgclInvalidArgumentValue e) {
		// XXX: assume "point not on the curve"
		return new JgclIntersectionPoint3D[0];
	    }

	    // just 1 intersection
	    JgclPointOnCurve3D pnt2 =
		(JgclPointOnCurve3D)ints.pointOnGeometry2();

	    JgclIntersectionPoint3D[] intvec = {
		new JgclIntersectionPoint3D(this, cparam,
					    mate, pnt2.parameter(), doCheckDebug)
	    };
	    if (!doExchange)
		intvec[0] = intvec[0].exchange();

	    return intvec;
	}
	return new JgclIntersectionPoint3D[0];
    }

    /**
     * ̋ȐƑ̋Ȑ (~Ȑ) Ƃ̌_𓾂 (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * <ul>
     * <li>	̉~Ȑ C ̏Ă镽 P 
     *		^ꂽ~Ȑ D ̏Ă镽 Q Ƃ̌ A ߂B
     * <li>	P  Q I[o[bvĂ A łȂꍇɂ
     *		̋ʂ̕ʏ̓񎟌Ԃ C  D Ƃ̌_߂B
     * <li>	A ܂ꍇA
     *		C  A ̌_߁A̓ D ̏ɏĂ̂_ƂB
     * </ul>
     * </p>
     * 
     * @param mate	̋Ȑ(~Ȑ)
     * @param doExchange _ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersectCnc(JgclConic3D mate, boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	JgclPlane3D plane1 = new JgclPlane3D(position());
	JgclPlane3D plane2 = new JgclPlane3D(mate.position());
	JgclLine3D line;
	JgclIntersectionPoint2D[] lpnts;
	JgclCartesianTransformationOperator3D trans1 =
	    new JgclCartesianTransformationOperator3D(position(), 1.0);
	JgclConic2D con1 = toLocal2D();
	JgclConic2D con2 = mate.toLocal2D(trans1);

	try {
	    line = plane1.intersect1Plane(plane2);
	}
	catch (JgclIndefiniteSolution e) {
	    // overlap
	    lpnts = con1.intersect(con2);
	    return toIntersectionPoint3D(lpnts, this, mate, doExchange);
	}
	if (line == null)
	    return new JgclIntersectionPoint3D[0];

	JgclLine2D lline = line.toLocal2D(trans1);
	lpnts = con1.intersect(lline);
	Vector intsvec = new Vector();

	for (int i = 0; i < lpnts.length; i++) {
	    JgclIntersectionPoint2D int2d = lpnts[i];
	    double c2param;

	    try {
		c2param = con2.pointToParameter(int2d);
	    }
	    catch (JgclInvalidArgumentValue e) {
		// XXX: assume "point not on the curve"
		continue;
	    }
	    double c1param = int2d.pointOnCurve1().parameter();
	    JgclIntersectionPoint3D int3d =
		new JgclIntersectionPoint3D(this, c1param,
					    mate, c2param, doCheckDebug);
	    intsvec.addElement(int3d);
	}

	JgclIntersectionPoint3D[] ints =
	    new JgclIntersectionPoint3D[intsvec.size()];
	intsvec.copyInto(ints);
	return ints;
    }

    /**
     * ̋ȐƑ̋Ȑ (xWGȐ) ̌_߂ (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * <ul>
     * <li>	xWGȐẢ~Ȑ̋ǏWnł̕\ɕϊB
     * <li>	̋ȐƕϊxWGȐ̌_\㐔𐶐B
     * <li>	㐔̍߂B
     * <li>	̊eXɂāAԂł̉ƂđÓł邩ۂ؂B
     * <li>	Ԃł̉ƂđÓȍu_v𐶐B
     * </ul>
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange _ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
	JgclAxis2Placement3D placement = position();
	JgclCartesianTransformationOperator3D transform =
	new JgclCartesianTransformationOperator3D(placement, 1.0);
	int uicp = mate.nControlPoints();
	JgclPoint3D[] newCp = new JgclPoint3D[uicp];

	// Transform Bezier's control points into conic's local coordinates
	for (int i = 0; i < uicp; i++)
	    newCp[i] = transform.toLocal(mate.controlPointAt(i));

	// make Bezier curve from new control points
	JgclPureBezierCurve3D bzc = new
	    JgclPureBezierCurve3D(newCp, mate.weights(), false);

	// For each segment
	Vector pointVec = new Vector();
	Vector paramVec = new Vector();
	boolean isPoly = bzc.isPolynomial();
	// make polynomial
	JgclRealPolynomial[] poly = bzc.polynomial(isPoly);
	JgclRealPolynomial realPoly = makePoly(poly);
	JgclComplexPolynomial compPoly = realPoly.toComplexPolynomial();

	// solve polynomial
	JgclComplex[] roots;
	try {
	    roots = compPoly.getRootsByDKA();
	}
	catch (JgclComplexPolynomial.DKANotConverge e) {
	    roots = e.getValues();
	}
	catch (JgclComplexPolynomial.ImpossibleEquation e) {
	    throw new JgclFatal();
	}
	catch (JgclComplexPolynomial.IndefiniteEquation e) {
	    throw new JgclFatal();
	}

	int nRoots = roots.length;
	for (int j = 0; j < nRoots; j++) {
	    double realRoot = roots[j].real();
	    if (bzc.parameterValidity(realRoot) == JgclParameterValidity.OUTSIDE)
		continue;

	    if (realRoot < 0.0) realRoot = 0.0;
	    if (realRoot > 1.0) realRoot = 1.0;

	    JgclPoint3D workPoint = bzc.coordinates(realRoot);
	    // check solution
	    if (!checkSolution(workPoint))
		continue;
	    for (int jj = 0; jj < pointVec.size(); jj++) {
		JgclPoint3D pt = (JgclPoint3D)pointVec.elementAt(jj);
		double param = ((Double)paramVec.elementAt(jj)).doubleValue();
		if (pt.identical(workPoint)
		    && bzc.identicalParameter(param, realRoot))
		    break;
	    }
	    // add solution
	    pointVec.addElement(workPoint);
	    paramVec.addElement(new Double(realRoot));
	}

	// make intersection point
	int num = paramVec.size();
	JgclIntersectionPoint3D[] intersectPoint = new JgclIntersectionPoint3D[num];
	for (int i = 0; i < num; i++) {
	    // get Parameter from solution point
	    JgclPoint3D point = (JgclPoint3D)pointVec.elementAt(i);
	    double param = getParameter(point);

	    // make intersection point on Conic
	    JgclPointOnCurve3D pointOnConic = new
		JgclPointOnCurve3D(this, param, doCheckDebug);

	    // make intersection point on Bzc
	    double work = ((Double)paramVec.elementAt(i)).doubleValue();
	    JgclPointOnCurve3D pointOnBzc = new
		JgclPointOnCurve3D(mate, work, doCheckDebug);

	    if (!doExchange)
		intersectPoint[i] = new
		    JgclIntersectionPoint3D(pointOnConic, pointOnBzc, doCheckDebug);
	    else
		intersectPoint[i] = new
		    JgclIntersectionPoint3D(pointOnBzc, pointOnConic, doCheckDebug);
	}

	return intersectPoint;
    }

    /**
     * ̋ȐƑ̋Ȑ (aXvCȐ) ̌_߂ (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * <ul>
     * <li>	aXvCȐẢ~Ȑ̋ǏWnł̕\ɕϊB
     * <li>	ϊaXvCȐ̊eZOgɂ
     * <ul>
     * <li>	̋ȐƕϊaXvCȐ̃ZOǧ_\㐔𐶐B
     * <li>	㐔̍߂B
     * <li>	̊eXɂāAԂł̉ƂđÓł邩ۂ؂B
     * </ul>
     * <li>	Ԃł̉ƂđÓȍu_v𐶐B
     * </ul>
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
	JgclAxis2Placement3D placement = position();
	JgclCartesianTransformationOperator3D transform =
	new JgclCartesianTransformationOperator3D(placement, 1.0);
	JgclBsplineKnot.ValidSegmentInfo vsegInfo = mate.validSegments();
	JgclPoint3D[] cp = mate.controlPoints();
	int uicp = mate.nControlPoints();
	JgclPoint3D[] newCp = new JgclPoint3D[uicp];

	// Transform Bspline's control points into conic's local coordinates
	for (int i = 0; i < uicp; i++)
	    newCp[i] = transform.toLocal(cp[i]);

	// make Bspline curve from new control points
	JgclBsplineCurve3D bsc = new
	    JgclBsplineCurve3D(mate.knotData(), newCp, mate.weights());

	// For each segment
	Vector pointVec = new Vector();
	Vector paramVec = new Vector();
	int nSeg = vsegInfo.nSegments();
	int k = 0;
	for (int i = 0; i < nSeg; i++) {
	    // make polynomial
	    JgclRealPolynomial[] poly =
		bsc.polynomial(vsegInfo.segmentNumber(i), bsc.isPolynomial());
	    JgclRealPolynomial realPoly = makePoly(poly);
	    JgclComplexPolynomial compPoly = realPoly.toComplexPolynomial();

	    // solve polynomial
	    JgclComplex[] roots;
	    try {
		roots = compPoly.getRootsByDKA();
	    }
	    catch (JgclComplexPolynomial.DKANotConverge e) {
		roots = e.getValues();
	    }
	    catch (JgclComplexPolynomial.ImpossibleEquation e) {
		throw new JgclFatal();
	    }
	    catch (JgclComplexPolynomial.IndefiniteEquation e) {
		throw new JgclFatal();
	    }

	    int nRoots = roots.length;
	    for (int j = 0; j < nRoots; j++) {
		double realRoot = roots[j].real();
		if (bsc.parameterValidity(realRoot) == JgclParameterValidity.OUTSIDE)
		    continue;

		double[] knotParams = vsegInfo.knotPoint(i);
		if (realRoot < knotParams[0]) realRoot = knotParams[0];
		if (realRoot > knotParams[1]) realRoot = knotParams[1];

		JgclPoint3D workPoint = bsc.coordinates(realRoot);
		// check solution
		if (!checkSolution(workPoint))
		    continue;
		int jj;
  		for (jj = 0; jj < k; jj++) {
  		    double dTol = bsc.getToleranceForDistance();
  		    JgclPoint3D pt = (JgclPoint3D)pointVec.elementAt(jj);
  		    double param = ((Double)paramVec.elementAt(jj)).doubleValue();
  		    if (pt.identical(workPoint)
			&& bsc.identicalParameter(param, realRoot))
  			break;
  		}
		if (jj >= k) {
		    pointVec.addElement(workPoint);
		    paramVec.addElement(new Double(realRoot));
		    k++;
		}
	    }
	}

	// make intersection point
	int num = paramVec.size();
	JgclIntersectionPoint3D[] intersectPoint = new JgclIntersectionPoint3D[num];
	for (int i = 0; i < k; i++) {
	    // get Parameter from solution point
	    JgclPoint3D point = (JgclPoint3D)pointVec.elementAt(i);
	    double param = getParameter(point);

	    // make intersection point on Conic
	    JgclPointOnCurve3D pointOnConic = new
		JgclPointOnCurve3D(this, param, doCheckDebug);

	    // make intersection point on Bsc
	    double work = ((Double)paramVec.elementAt(i)).doubleValue();
	    JgclPointOnCurve3D pointOnBsc = new
		JgclPointOnCurve3D(mate, work, doCheckDebug);

	    if (!doExchange)
		intersectPoint[i] = new JgclIntersectionPoint3D
		    (pointOnConic, pointOnBsc, doCheckDebug);
	    else
		intersectPoint[i] = new JgclIntersectionPoint3D
		    (pointOnBsc, pointOnConic, doCheckDebug);
	}

	return intersectPoint;
    }

    /**
     * ̋ȐƑ̋Ȗʂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return	_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate)
	 throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̋ȐƑ̋Ȗ () ƌ_߂ (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * return mate.intersect(this, !doExchange)
     * </p>
     *
     * @param mate    ̋Ȗ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclPlane3D mate, boolean doExchange)
        throws JgclIndefiniteSolution
    {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ (񎟋Ȗ) ƌ_߂ (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * <ul>
     * <li>	̉~Ȑ̏Ă镽ʂƗ^ꂽ񎟋ȖʂƂ̌ A ߂B
     * <li>	A Ƃ̉~Ȑ̌__ƂB
     * </ul>
     * </p>
     *
     * @param mate    ̋Ȗ (񎟋Ȗ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersectQrd(JgclElementarySurface3D mate, boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	JgclIntersectionPoint3D[] ints;
	JgclSurfaceSurfaceInterference3D[] dCint;
	JgclIntersectionPoint3D[] dEpnt;
	JgclIntersectionPoint3D one_int;
	double[] params;
	double param;
	int i, j;

	/*
	 * intersection between Conic's osculating plane & mate => dCint
	 */
	JgclPlane3D pln = new JgclPlane3D(this.position());
	dCint = pln.intersect(mate);
	if (dCint.length < 1) {
	    return new JgclIntersectionPoint3D[0];
	}

	/*
	 * intersection between Conic & dCint
	 */
	Vector ints_list = new Vector();
	boolean indefinite = false;
	for (i = 0; i < dCint.length; i++) {
	    if (dCint[i].isIntersectionCurve()) {	// 
		JgclIntersectionCurve3D dCintCurve = dCint[i].toIntersectionCurve();
		try {
		    dEpnt = this.intersect(dCintCurve.curve3d());
		} catch (JgclIndefiniteSolution e) {		// ~Ȑ
		    dEpnt = new JgclIntersectionPoint3D[1];
		    dEpnt[0] = (JgclIntersectionPoint3D)e.suitable();
		    indefinite = true;
		}
		for (j = 0; j < dEpnt.length; j++) {
		    params = mate.pointToParameter(dEpnt[j]);
		    if (!doExchange)
			one_int = new JgclIntersectionPoint3D(dEpnt[j].coordinates(),
							      this,
							      dEpnt[j].pointOnCurve1().parameter(),
							      mate, params[0], params[1],
							      doCheckDebug);
		    else
			one_int = new JgclIntersectionPoint3D(dEpnt[j].coordinates(),
							      mate, params[0], params[1],
							      this,
							      dEpnt[j].pointOnCurve1().parameter(),
							      doCheckDebug);
		    ints_list.addElement(one_int);
		}
	    } else {					// _
		JgclIntersectionPoint3D dCintPnt = dCint[i].toIntersectionPoint();
		try {
		    param = this.pointToParameter(dCintPnt);
		} catch (JgclInvalidArgumentValue e) {	// ĂȂ
		    continue;
		}
		if (!doExchange)
		    one_int = new JgclIntersectionPoint3D(this, param,
							  mate,
							  dCintPnt.pointOnSurface2().uParameter(),
							  dCintPnt.pointOnSurface2().vParameter(),
							  doCheckDebug);
		else
		    one_int = new JgclIntersectionPoint3D(mate,
							  dCintPnt.pointOnSurface2().uParameter(),
							  dCintPnt.pointOnSurface2().vParameter(),
							  this, param,
							  doCheckDebug);
		ints_list.addElement(one_int);
	    }
	}

	if (indefinite && ints_list.size() == 1) {
	    throw new JgclIndefiniteSolution((JgclIntersectionPoint3D)ints_list.elementAt(0));
	}
	ints = new JgclIntersectionPoint3D[ints_list.size()];
	ints_list.copyInto(ints);
	return ints;
    }

    /**
     * ̋ȐƑ̋Ȗ (͋Ȗ) ƌ_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * {@link #intersectQrd(JgclElementarySurface3D, boolean)
     * intersectQrd(JgclElementarySurface3D, boolean)} ĂяoB
     * </p>
     * 
     * @param mate	̋Ȗ (͋Ȗ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate, boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	return intersectQrd(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ (xWGȖ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * return mate.intersect(this, !doExchange)
     * </p>
     *
     * @param mate      ̋Ȗ (xWGȖ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange)
        throws JgclIndefiniteSolution
    {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ (aXvCȖ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * return mate.intersect(this, !doExchange)
     * </p>
     *
     * @param mate      ̋Ȗ (aXvCȖ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange)
        throws JgclIndefiniteSolution
    {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̉~Ȑ
     * ǏWnłQŕ\ꂽ (̉~Ȑ̈ꕔČ) LxWGȐ
     * ȒWnł̕\ɕϊB
     * <p>
     * ^LxWGȐ́A
     * (̉~Ȑ̈ꕔČ̂) evfׂ͂ĂQȐł̂Ƒz肵ĂB
     * </p>
     * <p>
     * ̐̂߁Ã\bh́A
     * xWGȐ邢͂aXvCȐ̃NXɒuׂł͂ȂƍlB
     * </p>
     *
     * @param bezierCurves2D	ǏWnłQŕ\ꂽLxWGȐ̔z
     * @return	ȒWnŕ\ꂽLxWGȐ̔z
     */
    JgclPureBezierCurve3D[]
    transformPolyBezierCurvesInLocal2DToGrobal3D(JgclPureBezierCurve2D[] bezierCurves2D) {
	int nCurves = bezierCurves2D.length;

	JgclCartesianTransformationOperator3D localTransformationOperator =
	    this.position().toCartesianTransformationOperator(1.0);

	JgclPureBezierCurve3D[] bzcs = new JgclPureBezierCurve3D[nCurves];

	for (int i = 0; i < nCurves; i++) {
	    JgclPoint3D[] controlPoints = new JgclPoint3D[3];
	    double[] weights = new double[3];

	    for (int j = 0; j < 3; j++) {
		JgclPoint3D pnt = bezierCurves2D[i].controlPointAt(j).to3D();
		controlPoints[j] = localTransformationOperator.toEnclosed(pnt);
		weights[j] = bezierCurves2D[i].weightAt(j);
	    }

	    bzcs[i] = new JgclPureBezierCurve3D(controlPoints, weights);
	}

	return bzcs;
    }

    /**
     * ~Ȑ̈ꕔČLxWGȐ{̗LaXvCȐɕϊB
     * <p>
     * ^LxWGȐ́A~Ȑ̈ꕔČ̂ŁA
     * Ȑ̗vf 1 Ȃ 3 łA
     * evfׂ͂ĂQȐł̂Ƒz肵ĂB
     * </p>
     * <p>
     * ̐̂߁Ã\bh́A
     * xWGȐ邢͂aXvCȐ̃NXɒuׂł͂ȂƍlB
     * </p>
     *
     * @param bezierCurves	(~Ȑ̈ꕔČ) LxWGȐ
     * @param closed	LxWGȐ񂪕Ă trueAłȂ false
     * @return	LaXvCȐ
     */
    protected static JgclBsplineCurve3D
    convertPolyBezierCurvesToOneBsplineCurve(JgclPureBezierCurve3D[] bezierCurves,
					     boolean closed) {
	int nBeziers = bezierCurves.length;
	int uicp;
	int uik;

	if (closed != true) {
	    // open
	    uicp = (nBeziers != 3) ? (nBeziers + 2) : (nBeziers + 3);
	    uik  = nBeziers + 1;
	} else {
	    // closed : nBeziers should be always 3
	    uicp = 5;   // nBeziers + 2
	    uik  = 6;	// nBeziers + 3
	}

	int degree = 2;
	boolean periodic = closed;
	int[] knotMultiplicities = new int[uik];
	double[] knots = new double[uik];
	JgclPoint3D[] controlPoints = new JgclPoint3D[uicp];
	double[] weights = new double[uicp];

	switch (nBeziers) {
	case 1:
	    for (int i = 0; i < 3; i++) {
		controlPoints[i] = bezierCurves[0].controlPointAt(i);
		weights[i] = bezierCurves[0].weightAt(i);
	    }
	    knots[0] = 0.0; knotMultiplicities[0] = 3;
	    knots[1] = 1.0; knotMultiplicities[1] = 3;
	    break;

	case 2:
	    /*
	     * weights:
	     *              inverse of standard form              bspline
	     *	1 a 1 1 a 1 ========================> 1 b b b b 1 =======> 1 b b 1
	     *
	     *	b = a * a
	     */
	    controlPoints[0] = bezierCurves[0].controlPointAt(0);
	    controlPoints[1] = bezierCurves[0].controlPointAt(1);
	    controlPoints[2] = bezierCurves[1].controlPointAt(1);
	    controlPoints[3] = bezierCurves[1].controlPointAt(2);
	    weights[0] = 1.0;
	    weights[1] = weights[2] =
		bezierCurves[0].weightAt(1) * bezierCurves[0].weightAt(1);
	    weights[3] = 1.0;

	    knots[0] = 0.0; knotMultiplicities[0] = 3;
	    knots[1] = 1.0; knotMultiplicities[1] = 1;
	    knots[2] = 2.0; knotMultiplicities[2] = 3;
	    break;

	case 3:
	    if (closed != true) {
		// open
		controlPoints[0] = bezierCurves[0].controlPointAt(0);
		controlPoints[1] = bezierCurves[0].controlPointAt(1);
		controlPoints[2] = bezierCurves[1].controlPointAt(1);
		controlPoints[3] = bezierCurves[1].controlPointAt(2);
		controlPoints[4] = bezierCurves[2].controlPointAt(1);
		controlPoints[5] = bezierCurves[2].controlPointAt(2);
		weights[0] = 1.0;
		weights[1] = weights[2] =
		    bezierCurves[0].weightAt(1) * bezierCurves[0].weightAt(1);
		weights[3] = 1.0;
		weights[4] = bezierCurves[2].weightAt(1);
		weights[5] = 1.0;

		knots[0] = 0.0; knotMultiplicities[0] = 3;
		knots[1] = 1.0; knotMultiplicities[1] = 1;
		knots[2] = 2.0; knotMultiplicities[2] = 2;
		knots[3] = 4.0; knotMultiplicities[3] = 3; // knots[3] != 3.0
	    } else {
		// closed
		controlPoints[0] = bezierCurves[2].controlPointAt(1);
		controlPoints[1] = bezierCurves[0].controlPointAt(0);
		controlPoints[2] = bezierCurves[0].controlPointAt(1);
		controlPoints[3] = bezierCurves[1].controlPointAt(1);
		controlPoints[4] = bezierCurves[1].controlPointAt(2);
		weights[0] = bezierCurves[2].weightAt(1);
		weights[1] = 1.0;
		weights[2] = weights[3] =
		    bezierCurves[0].weightAt(1) * bezierCurves[0].weightAt(1);
		weights[4] = 1.0;

		knots[0] = (-2.0); knotMultiplicities[0] = 2;
		knots[1] = 0.0;    knotMultiplicities[1] = 2;
		knots[2] = 1.0;    knotMultiplicities[2] = 1;
		knots[3] = 2.0;    knotMultiplicities[3] = 2;
		knots[4] = 4.0;    knotMultiplicities[4] = 2; // knots[4] != 3.0
		knots[5] = 5.0;    knotMultiplicities[5] = 1;
	    }
	    break;
	}

	return new JgclBsplineCurve3D(degree, periodic,
				      knotMultiplicities, knots,
				      controlPoints, weights);
    }

    /**
     * ̋ȐƁAꂽxWGȖʂƂ̊𒲂ׂ钊ۃ\bhB
     * <p>
     * ̃\bh {@link JgclIntsCncBzs3D JgclIntsCncBzs3D} ̓ŎgB
     * </p>
     *
     * @param bi	ꂽxWGȖʂ̏
     * @return	Ă trueAłȂ false
     */
    abstract boolean checkInterfere(JgclIntsCncBzs3D.BezierSurfaceInfo bi);

    /**
     * ̉~ȐƗ^ꂽʂ̌_߂钊ۃ\bhB
     * <p>
     * ̃\bh {@link JgclIntsCncBzs3D JgclIntsCncBzs3D} ̓ŎgB
     * </p>
     *
     * @param plane  
     * @return       _̔z
     */
    abstract JgclIntersectionPoint3D[] intersectConicPlane(JgclPlane3D plane);

    /**
     * ̋Ȑ́A^ꂽp[^lł (̉~Ȑ̋ǏWnł) Wl
     * Ԃۃ\bhB
     * 
     * @param parameter	p[^l
     * @return	̉~Ȑ̋ǏWnł̍Wl
     */
    abstract JgclPoint3D nlFunc(double parameter);

    /**
     * ̋Ȑ́A^ꂽp[^lł (̉~Ȑ̋ǏWnł) ڃxNg
     * Ԃۃ\bhB
     * 
     * @param parameter	p[^l
     * @return	̉~Ȑ̋ǏWnł̐ڃxNg
     */
    abstract JgclVector3D dnlFunc(double parameter);
}
