/*
 * Q : ȉ~\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclEllipse2D.java,v 1.68 2000/08/11 06:18:48 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

/**
 * Q : ȉ~\NXB
 * <p>
 * ȉ~́A̒S̈ʒuƋǏ X/Y ̕ǏWn
 * (zuA{@link JgclAxis2Placement2D JgclAxis2Placement2D}) position 
 * Ǐ X ̔a semiAxis1A
 * Ǐ Y ̔a semiAxis2
 * Œ`B
 * </p>
 * <p>
 * t p[^Ƃȉ~ P(t) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(t) = position.location()
 *	     + semiAxis1 * cos(t) * position.x()
 *	     + semiAxis2 * sin(t) * position.y()
 * </pre>
 * </p>
 *
 * @version $Revision: 1.68 $, $Date: 2000/08/11 06:18:48 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclEllipse2D extends JgclConic2D {

    /**
     * a1 (ǏWnX̔a) B
     * @serial
     */
    private double semiAxis1;

    /**
     * a2 (ǏWnY̔a) B
     * @serial
     */
    private double semiAxis2;

    /**
     * ̔a̒lAێtB[hɐݒ肷B
     * <p>
     * semiAxis1, semiAxis2 ̒l͐łȂ΂ȂȂB
     * </p>
     * <p>
     * semiAxis1, semiAxis2 ̂ꂩ̒l
     * ݐݒ肳Ă鉉Z̋̋e덷菬ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     *
     * @param semiAxis1	a1
     * @param semiAxis2	a2
     * @see	JgclInvalidArgumentValue
     */
    private void setSemiAxis(double semiAxis1, double semiAxis2)
    {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol = condition.getToleranceForDistance();

	if (semiAxis1 < dTol) {
	    throw new JgclInvalidArgumentValue();
	}
	this.semiAxis1 = semiAxis1;

	if (semiAxis2 < dTol) {
	    throw new JgclInvalidArgumentValue();
	}
	this.semiAxis2 = semiAxis2;
    }

    /**
     * ǏWnƊeɑ΂锼a^ăIuWFNg\zB
     * <p>
     * position  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * semiAxis1, semiAxis2 ̂ꂩ̒l
     * ݐݒ肳Ă鉉Z̋̋e덷菬ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * 
     * @param position	SƋǏ X/Y ̕ǏWn
     * @param semiAxis1	a1 (Ǐ X ɑ΂锼a)
     * @param semiAxis2	a2 (Ǐ Y ɑ΂锼a)
     * @see	JgclInvalidArgumentValue
     */
    public JgclEllipse2D(JgclAxis2Placement2D position,
			 double semiAxis1, double semiAxis2)
    {
	super(position);
	setSemiAxis(semiAxis1, semiAxis2);
    }

    /**
     * ̑ȉ~̔a1 (ǏWn X ̔a) ԂB
     * 
     * @return	a1
     */
    public double semiAxis1() {
	return this.semiAxis1;
    }

    /**
     * {@link #semiAxis1() semiAxis1()} ̕ʖ\bhB
     * 
     * @return	a1
     */
    public double xRadius() {
	return this.semiAxis1;
    }

    /**
     * ̑ȉ~̔a2 (ǏWn Y ̔a) ԂB
     * 
     * @return	a2
     */
    public double semiAxis2() {
	return this.semiAxis2;
    }

    /**
     * {@link #semiAxis2() semiAxis2()} ̕ʖ\bhB
     * 
     * @return	a2
     */
    public double yRadius() {
	return this.semiAxis2;
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * <p>
     * pint ŗ^Ԃ [0, 2 * PI] Ɏ܂ĂKv͂ȂB
     * ܂Apint ̑l͕ł܂ȂB
     * </p>
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     */
    public double length(JgclParameterSection pint) {
        final double m2eal_majrd2 = semiAxis1() * semiAxis1();
        final double m2eal_minrd2 = semiAxis2() * semiAxis2();
        double dTol = getToleranceForDistance() / 2.0;

        return JgclMath.getDefiniteIntegral
            (new JgclRealFunctionWithOneVariable(){
                    public double evaluate(double parameter){
                        double ecos = Math.cos(parameter);
                        double esin = Math.sin(parameter);

                        return Math.sqrt(m2eal_majrd2 * esin * esin +
                                         m2eal_minrd2 * ecos * ecos);
                    }
                },
             pint, dTol);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * 
     * @param param	p[^l
     * @return		Wl
     */
    public JgclPoint2D coordinates(double param) {
	param = parameterDomain().wrap(param);
	JgclAxis2Placement2D ax = position();
	JgclVector2D ex = ax.x().multiply(Math.cos(param) * semiAxis1);
	JgclVector2D ey = ax.y().multiply(Math.sin(param) * semiAxis2);

	return ax.location().add(ex.add(ey));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * 
     * @param param	p[^l
     * @return		ڃxNg
     */
    public JgclVector2D tangentVector(double param) {
	param = parameterDomain().wrap(param);
	JgclAxis2Placement2D ax = position();
	JgclVector2D ex1 = ax.x().multiply(-Math.sin(param)* semiAxis1);
	JgclVector2D ey1 = ax.y().multiply(Math.cos(param) * semiAxis2);

	return ex1.add(ey1);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * 
     * @param param	p[^l
     * @return		ȗ
     */
    public JgclCurveCurvature2D curvature(double param) {
	param = parameterDomain().wrap(param);
	JgclAxis2Placement2D ax = position();
	double xlen = Math.cos(param) * semiAxis1;
	double ylen = Math.sin(param) * semiAxis2;
	double x1len = -Math.sin(param) * semiAxis1;
	double y1len = Math.cos(param) * semiAxis2;
	double plen = Math.sqrt(x1len * x1len + y1len * y1len);
	double crv = Math.abs(x1len * ylen - y1len * xlen)
	    / (plen * plen * plen);
	JgclVector2D ex1 = ax.x().multiply(x1len);
	JgclVector2D ey1 = ax.y().multiply(y1len);

	JgclVector2D tangent = ex1.add(ey1);
	// rotate tangent PI/2
	JgclVector2D nrmDir =
	    new JgclLiteralVector2D(-tangent.y(), tangent.x());
	return new JgclCurveCurvature2D(crv, nrmDir.unitized());
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * 
     * @param param	p[^l
     * @return		֐
     */
    public JgclCurveDerivative2D evaluation(double param) {
	param = parameterDomain().wrap(param);
	JgclAxis2Placement2D ax = position();
	JgclVector2D ex = ax.x().multiply(Math.cos(param) * semiAxis1);
	JgclVector2D ey = ax.y().multiply(Math.sin(param) * semiAxis2);
	JgclVector2D ex1 = ax.x().multiply(-Math.sin(param)* semiAxis1);
	JgclVector2D ey1 = ax.y().multiply(Math.cos(param) * semiAxis2);

	JgclPoint2D d0 = ax.location().add(ex.add(ey));
	JgclVector2D d1 = ex1.add(ey1);
	JgclVector2D d2 = ex.add(ey).multiply(-1.0);

	return new JgclCurveDerivative2D(d0, d1, d2);
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * ̑ȉ~~` (eɑ΂锼a) ŁA
     * ^ꂽ_Ƃ̑ȉ~̒SƂ̋A
     * ݐݒ肳Ă鉉Z̋̋e덷
     * ꍇɂ́A
     * p[^l 0 ̓_ suitable Ƃ
     * JgclIndefiniteSolution ̗O𓊂B
     * </p>
     * <p>
     * []
     * <br>
     * l̑㐔̍߂邱ƂɋAāA㐔IɉĂB
     * </p>
     * 
     * @param point	e̓_
     * @return		e_
     * @exception	JgclIndefiniteSolution	s (e̓_~̑ȉ~̒SɈv)
     */
    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point) 
	throws JgclIndefiniteSolution
    {
	double dTol2 = getToleranceForDistance2();

	/*
	 * NOTE:
	 *
	 * equation of normal line is
	 *
	 *	A*Px/cosT - B*Py/sinT = A**2 - B**2    ( A=dBlrd, B=dBsrd ),
	 *
	 * so a polynomial of cosT is
	 *
	 *   -F**2 * z4 + 2DF * z3 + (F**2-D**2-E**2) * z2 - 2DF * z1 + D**2
	 *        ( z = cosT, D = A*Px, E = B*Py, F = A**2-B**2 ).
	 */

	double dBlrd, dBsrd;	/* longer / shorter radius of B */
	JgclCartesianTransformationOperator2D trans;

	if (semiAxis1 < semiAxis2) {
	    dBlrd = semiAxis2;
	    dBsrd = semiAxis1;
	    try {
		JgclAxis2Placement2D ax =
		    new JgclAxis2Placement2D(position().location(), position().y());
		trans = new JgclCartesianTransformationOperator2D(ax, 1.0);
	    }
	    catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}
	else {
	    dBlrd = semiAxis1;
	    dBsrd = semiAxis2;
	    try {
		trans = new JgclCartesianTransformationOperator2D(position(), 1.0);
	    }
	    catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}

	// vector from B's center to A
	JgclVector2D Bc2A = point.subtract(position().location());

	if ((semiAxis1 - semiAxis2)*(semiAxis1 - semiAxis2) < dTol2 && 
	    Bc2A.norm() < dTol2) {
	    /*
	     * (the ellipse is circle) &
	     * (the given point is the center of the circle)
	     */

	    JgclPointOnCurve2D p;
	    try {
		p = new JgclPointOnCurve2D(this, 0, doCheckDebug);
	    }
	    catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }

 	    throw new JgclIndefiniteSolution(p);
	}

	// inverse rotated point
	JgclVector2D eAir = trans.reverseTransform(Bc2A);


	// make polynomial
	double eDDD = dBlrd * eAir.x();
	double eEEE = dBsrd * eAir.y();
	double eFFF = dBlrd * dBlrd - dBsrd * dBsrd;

	// coefficients of polynomial (real)
	double[] ercoef = new double[5];

	ercoef[4] = (- eFFF * eFFF);
	ercoef[0] = eDDD * eDDD;
	ercoef[3] = 2.0 * eDDD * eFFF;
	ercoef[1] = (- ercoef[3]);
	ercoef[2] = ercoef[4] + ercoef[0] + eEEE * eEEE;
	ercoef[2] = (- ercoef[2]);

	JgclComplexPolynomial pol;
	try {
	    pol = new JgclComplexPolynomial(ercoef);
	}
	catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}

	JgclComplex[] root;

	try {
	    root = pol.getRootsByDKA();
	}
	catch (JgclComplexPolynomial.DKANotConverge e) {
	    root = e.getValues();
	}
	catch (JgclComplexPolynomial.ImpossibleEquation e) {
	    throw new JgclFatal();
	}
	catch (JgclComplexPolynomial.IndefiniteEquation e) {
	    throw new JgclFatal();
	}

	JgclPointOnGeometryList projList = new JgclPointOnGeometryList();

	for (int i = 0; i < root.length; i++) {
	    JgclPointOnCurve2D proj;

	    double eCOS = root[i].real();

	    if (eCOS > 1.0)
		eCOS = 1.0;
	    if (eCOS < -1.0)
		eCOS = -1.0;

	    double Bparam1 = Math.acos(eCOS);
	    double Bparam2 = (JgclMath.PI2 - Bparam1);
	    if (semiAxis1 < semiAxis2) {
		Bparam1 += Math.PI / 2.0;
		Bparam2 += Math.PI / 2.0;
	    }

	    proj = checkProjection(parameterDomain().wrap(Bparam1),
				   point, dTol2);
	    if (proj != null)
		projList.addPoint(proj);

	    proj = checkProjection(parameterDomain().wrap(Bparam2),
				   point, dTol2);
	    if (proj != null)
		projList.addPoint(proj);
	}
	return projList.toJgclPointOnCurve2DArray();
    }

    /**
     * ^ꂽp[^ԂɂāA
     * Ԃ̗[Ԍłꂽ_̃p[^l߂B
     * <p>
     * ̃\bh
     * {@link JgclConic2D#toPolyline(JgclParameterSection, JgclToleranceForDistance) 
     * JgclConic2D.toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * ̓ŌĂяoB
     * </p>
     * 
     * @param left	[ (ԉ) ̃p[^l
     * @param right	E[ (ԏ) ̃p[^l
     * @return		łꂽ_̃p[^l
     */
    double getPeak(double left, double right) {
	double peak;

	peak = Math.atan2(Math.cos(left) - Math.cos(right),
			  Math.sin(right) - Math.sin(left));

	while (peak < left)
	    peak += Math.PI;
	while (peak > right)
	    peak -= Math.PI;

	return peak;
    }

    /**
     * ̋Ȑ̎w̋ԂČLxWGȐ̗ԂB
     * <p>
     * pint ̑l̐Βl (2 * ) ȏ̏ꍇɂ́A
     *  (2 * ) ƌȂďB
     * </p>
     *
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLxWGȐ̔z
     */
    public JgclPureBezierCurve2D[] toPolyBezierCurves(JgclParameterSection pint) {
	double increase = pint.increase();
	int nCurves;
	double startP;
	double increaseP;
	int i;

	if (Math.abs(increase) > JgclMath.PI2) {
	    nCurves = 3;
	    increaseP = (increase > 0.0) ? (JgclMath.PI2 / 3) : (- JgclMath.PI2 / 3);
	} else if (Math.abs(increase) > (4 * JgclMath.PI2 / 5)) {
	    nCurves = 3;
	    increaseP = increase / 3;
	} else if (Math.abs(increase) > (4 * Math.PI / 5)) {
	    nCurves = 2;
	    increaseP = increase / 2;
	} else {
	    nCurves = 1;
	    increaseP = increase;
	}

	JgclCartesianTransformationOperator2D localTransformationOperator =
	    this.position().toCartesianTransformationOperator(1.0);

	JgclPureBezierCurve2D[] bzcs = new JgclPureBezierCurve2D[nCurves];

	for (i = 0, startP = pint.start();
	     i < nCurves;
	     i++, startP += increaseP) {

	    JgclParameterSection pintl = new JgclParameterSection(startP, increaseP);
	    JgclPoint2D[] controlPoints = this.getControlPointsOfBezierCurve(pintl);
	    double[] weights = {1.0, 1.0, 1.0};

	    /*
	     * the middle weight will be greater than 0.0 & less than 1.0
	     */

	    /*
	     * Given:
	     *	Rx, Ry	: ellipse's {x, y}_radius
	     *	Tx, Ty	: unit vector of shoulder point
	     *		  (rotated into ellipse's local coordinates system)
	     *
	     * Find:
	     *	theta	: the parameter of shoulder point
	     *
	     *	tan(theta) = - (Ry * Tx) / (Rx * Ty)
	     */
	    JgclVector2D mvec = controlPoints[2].subtract(controlPoints[0]);
	    JgclVector2D tmvec = localTransformationOperator.toLocal(mvec).unitized();

	    double shoulderParam;
	    double tmpBuf;
	    if (Math.abs(tmpBuf = (this.xRadius() * tmvec.y())) > JgclMachineEpsilon.DOUBLE) {
		shoulderParam = Math.atan(- (this.yRadius() * tmvec.x()) / tmpBuf);
	    } else {
		shoulderParam = Math.PI / 2.0;
	    }

	    while (shoulderParam < pintl.lower())
		shoulderParam += Math.PI;
	    while (shoulderParam > pintl.upper())
		shoulderParam -= Math.PI;

	    /*
	     *	v = (sp - m) / (cp1 - m)
	     *	w1 = v / (1 - v)
	     *
	     * where
	     *	sp	: shoulder point
	     *	cp1	: middle control point
	     *	m	: middle point between end points
	     *
	     *	w1	: middle weight
	     */
	    JgclPoint2D shoulderPoint = this.coordinates(shoulderParam);
	    JgclPoint2D middlePoint = controlPoints[0].midPoint(controlPoints[2]);
	    double vvv = Math.sqrt(shoulderPoint.subtract(middlePoint).norm() /
				   controlPoints[1].subtract(middlePoint).norm());
	    // if (Math.abs(increaseP) > Math.PI) vvv = (- vvv);

	    weights[1] = vvv / (1.0 - vvv);

	    bzcs[i] = new JgclPureBezierCurve2D(controlPoints, weights);
	}

	return bzcs;
    }

    /**
     * ̋Ȑ̎w̋ԂČLaXvCȐԂB
     * <p>
     * pint ̑l̐Βl (2 * ) ȏ̏ꍇɂ́A
     *  (2 * ) ƌȂďA
     * `̋ȐԂB
     * </p>
     * 
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLaXvCȐ
     */
    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
	JgclPureBezierCurve2D[] bzcs = this.toPolyBezierCurves(pint);
	boolean closed =
	    (Math.abs(pint.increase()) >= JgclMath.PI2) ? true : false;

	return JgclConic2D.convertPolyBezierCurvesToOneBsplineCurve(bzcs, closed);
    }

    /**
     * ̋ȐƑ̋ȐƂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȉ~̂ƂɁA
     * ݐݒ肳Ă鉉Z̉ŁA
     * ȉ~̒SԂ̋̋e덷菬A
     * ȉ~̋Ǐ X ̂Ȃpxpx̋e덷菬A
     * ȉ~̋Ǐ X/Y ꂼɂĂ̔a̍̋e덷ȓłꍇɂ́A
     * ȉ~̓I[o[bvĂ̂ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return	_̔z
     * @exception	JgclIndefiniteSolution mate ȉ~ŁAȉ~̓I[o[bvĂAsł
     */
    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate)
	 throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̑ȉ~ (\ꂽ) RȐ̌_\㐔𐶐B
     * 
     * @param poly	xWGȐ邢͂aXvCȐ̂ZOg̑\̔z
     * @return		̑ȉ~ poly ̌_\㐔̍
     */
    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
	JgclRealPolynomial xPoly = poly[0].multiply(poly[0]);
	JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
	double dAlrd2 = xRadius() * xRadius();
	double dAsrd2 = yRadius() * yRadius();
	boolean isPoly = poly.length < 3;
	int degree = xPoly.degree();
	double[] coef = new double[degree + 1];

	if (isPoly) {
	    for (int j = 0; j <= degree; j++)
		coef[j] = (xPoly.coefficientAt(j) / dAlrd2) +
		    (yPoly.coefficientAt(j) / dAsrd2);
	    coef[0] -= 1.0;
	}
	else {
	    JgclRealPolynomial wPoly = poly[2].multiply(poly[2]);
	    for (int j = 0; j <= degree; j++)
		coef[j] = (dAsrd2 * xPoly.coefficientAt(j)) + (dAlrd2 * yPoly.coefficientAt(j))
		    - (dAlrd2 * dAsrd2 * wPoly.coefficientAt(j));
	}
	return new JgclRealPolynomial(coef);
    }

    /**
     * ^ꂽ_̋Ȑɂ邩ۂ`FbNB
     * 
     * @param point	ΏۂƂȂ_
     * @return		^ꂽ_̋Ȑɂ trueAłȂ false
     */
    boolean checkSolution(JgclPoint2D point) {
	double param = getParameter(point);
	double px = xRadius() * Math.cos(param);
	double py = yRadius() * Math.sin(param);

	return point.identical(new JgclCartesianPoint2D(px, py));
    }

    /**
     * ^ꂽ_̋Ȑɂ̂ƂāA
     * ̓_̋Ȑł̃p[^l߂B
     * 
     * @param point	ΏۂƂȂ_
     * @return		p[^l
     */
    double getParameter(JgclPoint2D point) {
	double cos = point.x() / xRadius();
	if (cos > 1.0) cos = 1.0;
	if (cos < -1.0) cos = -1.0;
	double acos = Math.acos(cos);
	if (point.y() < 0.0) acos = 2 * Math.PI - acos;

	return acos;
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsLinCnc2D#intersection(JgclLine2D, JgclEllipse2D, boolean)
     * JgclIntsLinCnc2D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
	JgclIntsLinCnc2D doObj = new JgclIntsLinCnc2D(mate, this);
	return doObj.intersection(mate, this, !doExchange);
     }

    /**
     * ̋ȐƑ̋Ȑ (~) Ƃ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ~̃NX́u~ vs. ȉ~v̌_Z\bh
     * {@link JgclCircle2D#intersect(JgclEllipse2D, boolean)
     * JgclCircle2D.intersect(JgclEllipse2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCircle2D  mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ݐݒ肳Ă鉉Z̉ŁA
     * ȉ~̒SԂ̋̋e덷菬A
     * ȉ~̋Ǐ X ̂Ȃpxpx̋e덷菬A
     * ȉ~̋Ǐ X/Y ꂼɂĂ̔a̍̋e덷ȓłꍇɂ́A
     * ȉ~̓I[o[bvĂ̂ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsEllCnc2D#intersection(JgclEllipse2D, JgclEllipse2D, boolean)
     * JgclIntsEllCnc2D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution ȉ~̓I[o[bvĂAsł
     */
    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	double d_tol = getToleranceForDistance();
	JgclIntersectionPoint2D one_sol;
	double mateParam;
        if (this.position().location().identical(mate.position().location())) {
            if (this.position().x().parallelDirection(mate.position().x())) {
                if (Math.abs(this.xRadius() - mate.xRadius()) <= d_tol &&
                    Math.abs(this.yRadius() - mate.yRadius()) <= d_tol) {
                    if (this.position().x().dotProduct(mate.position().x()) > 0.0) {
                        mateParam = 0.0;
                    } else {
                        mateParam = Math.PI;
                    }
                    if (!doExchange)
                        one_sol = new JgclIntersectionPoint2D(this, 0.0, mate, mateParam, doCheckDebug);
                    else
                        one_sol = new JgclIntersectionPoint2D(mate, mateParam, this, 0.0, doCheckDebug);
                    throw new JgclIndefiniteSolution(one_sol);
                }
            }
            if (this.position().x().parallelDirection(mate.position().y())) {
                if (Math.abs(this.xRadius() - mate.yRadius()) <= d_tol &&
                    Math.abs(this.yRadius() - mate.xRadius()) <= d_tol) {
                    if (this.position().x().dotProduct(mate.position().y()) > 0.0) {
                        mateParam = Math.PI * 0.5;
                    } else {
                        mateParam = Math.PI * 1.5;
                    }
                    if (!doExchange)
                        one_sol = new JgclIntersectionPoint2D(this, 0.0, mate, mateParam, doCheckDebug);
                    else
                        one_sol = new JgclIntersectionPoint2D(mate, mateParam, this, 0.0, doCheckDebug);
                    throw new JgclIndefiniteSolution(one_sol);
                }
            }
        }

        JgclIntsEllCnc2D doObj = new JgclIntsEllCnc2D();
        return doObj.intersection(this, mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsEllCnc2D#intersection(JgclEllipse2D, JgclParabola2D, boolean)
     * JgclIntsEllCnc2D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclParabola2D  mate, boolean doExchange) {
	JgclIntsEllCnc2D doObj = new JgclIntsEllCnc2D();
	return doObj.intersection(this, mate, doExchange);
     }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsEllCnc2D#intersection(JgclEllipse2D, JgclHyperbola2D, boolean)
     * JgclIntsEllCnc2D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D  mate, boolean doExchange) {
	JgclIntsEllCnc2D doObj = new JgclIntsEllCnc2D();
	return doObj.intersection(this, mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * |C̃NX́u|C vs. ȉ~v̌_Z\bh
     * {@link JgclPolyline2D#intersect(JgclEllipse2D, boolean)
     * JgclPolyline2D.intersect(JgclEllipse2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) Ƃ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. ȉ~v̌_Z\bh
     * {@link JgclTrimmedCurve2D#intersect(JgclEllipse2D, boolean)
     * JgclTrimmedCurve2D.intersect(JgclEllipse2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐZOg) Ƃ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. ȉ~v̌_Z\bh
     * {@link JgclCompositeCurveSegment2D#intersect(JgclEllipse2D, boolean)
     * JgclCompositeCurveSegment2D.intersect(JgclEllipse2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (Ȑ) Ƃ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * Ȑ̃NX́uȐ vs. ȉ~v̌_Z\bh
     * {@link JgclCompositeCurve2D#intersect(JgclEllipse2D, boolean)
     * JgclCompositeCurve2D.intersect(JgclEllipse2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎ Bspline Ȑ߂B
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎ Bspline Ȑ
     * @see	JgclWhichSide
     */
    public JgclBsplineCurve2D
	offsetByBsplineCurve(JgclParameterSection pint,
			     double magni,
                             int side,
			     JgclToleranceForDistance tol) {
	JgclOfst2D doObj = new JgclOfst2D(this,pint,magni,side,tol);
	return doObj.offset();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʐڐ߂B
     * <p>
     * ʐڐ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		ʐڐ̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʖ@߂B
     * <p>
     * ʖ@݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		ʖ@̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonNormal2D[]	commonNormal(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * <p>
     * LŎIȃp[^`ԂB
     * ȂAvC}ȗLԂ [0, (2 * )] łB
     * </p>
     * 
     * @return	LŎIȃp[^`
     */
    JgclParameterDomain getParameterDomain() {
	try {
	    return new JgclParameterDomain(true, 0, 2*Math.PI);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * ̋Ȑ􉽓IɕĂ邩ۂԂB
     * <p>
     * ȉ~Ȃ̂ŁA true ԂB
     * </p>
     *
     * @return	ȉ~Ȃ̂ŁA <code>false</code>
     */
    boolean getClosedFlag() {
	return true;
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve2D#ELLIPSE_2D JgclParametricCurve2D.ELLIPSE_2D}
     */
    int type() {
	return ELLIPSE_2D;
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclAxis2Placement2D tPosition =
	    this.position().transformBy(reverseTransform,
					transformationOperator,
					transformedGeometries);
	double tSemiAxis1;
	double tSemiAxis2;
	if (reverseTransform != true) {
	    tSemiAxis1 = transformationOperator.transform(this.semiAxis1());
	    tSemiAxis2 = transformationOperator.transform(this.semiAxis2());
	} else {
	    tSemiAxis1 = transformationOperator.reverseTransform(this.semiAxis1());
	    tSemiAxis2 = transformationOperator.reverseTransform(this.semiAxis2());
	}
	return new JgclEllipse2D(tPosition, tSemiAxis1, tSemiAxis2);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tposition");
        position().output(writer, indent + 2);
        writer.println(indent_tab + "\tsemiAxis1 " + semiAxis1);
        writer.println(indent_tab + "\tsemiAxis2 " + semiAxis2);
        writer.println(indent_tab + "End");
    }
}
