/*

 * (Q) ߍ݃Ot\NX

 *

 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *

 * $Id: JgclEmbeddedGraph.java,v 1.21 2000/12/24 18:07:08 hideit Exp $

 */



package jp.go.ipa.jgcl;



import java.util.*;



/**

 * (Q) ߍ݃Ot\NXB

 * <p>

 * ̃NX́AOtɊւ Euler ̌ (|V| - |E| + |F| = 2) 

 * Ot\B

 * ŁAV ͒_AE ͕ӁAF ͖ʂӖA|X|  X ̌ӖB

 * </p>

 * <p>

 * ̃NX̃CX^X Euler ̌ۑȂ

 * Ot𑀍삷 Euler Operator B

 * </p>

 * <p>

 * OtɊ܂܂钸_^Ӂ^ʂ́ÃNX̓NXƂĕ\ĂB

 * </p>

 * <p>

 * 璸_^Ӂ^ʂ\NX́A

 * ݂̐ڑ֌Wێ݂̂łA

 * _̍Wl̊􉽏͒ڂɂ͕ێȂB

 * A

 * e_^Ӂ^ʂɂ́A

 * Cӂ̃IuWFNg (java.lang.Object) ֘At邱ƂłB

 * </p>

 * <p>

 * ȂA

 * ̃NX̃CX^X́A

 * Otł̐VȒ_^Ӂ^ʂ̐SIuWFNg

 * graphItemMaker ({@link JgclEmbeddedGraph.GraphItemMaker JgclEmbeddedGraph.GraphItemMaker})

 * ێB

 * Ot𑀍삷 Euler Operation ̍ۂɂ́A

 * p҂ΏۂƂȂ钸_^Ӂ^ʂ𒼐ڐ̂ł͂ȂA

 * ꂼ Euler Operator g̓

 *  graphItemMaker ̓Y@\Ăяo

 * _^Ӂ^ʂ𐶐B

 * </p>

 *

 * @version $Revision: 1.21 $, $Date: 2000/12/24 18:07:08 $

 * @author $JGCL_Author$

 */

public class JgclEmbeddedGraph extends java.lang.Object implements Cloneable {

    /**

     * Ot̍\\NXB

     * <p>

     * ̃NX́AOt̒_^Ӂ^ʂ\NX̃X[p[NXłB

     * </p>

     * <p>

     * ̃NX̃CX^X́A

     * p҂̃IuWFNgɊ֘AtCӂ̃f[^ userData (java.lang.Object)

     * ێB

     * </p>

     */

    protected abstract class GraphItem extends java.lang.Object {

	/**

	 * p҂֘AtCӂ̃f[^B

	 */

	private java.lang.Object userData = null;



	/**

	 * g̕B

	 * <p>

	 * ̃tB[h́AOt̕ۂɗpB

	 * </p>

	 *

	 * @see	#copy()

	 * @see	#copy(JgclEmbeddedGraph)

	 * @see	#dualCopy()

	 * @see	#dualCopy(JgclEmbeddedGraph)

	 */

	private GraphItem replica = null;



	/**

	 * ^ɃIuWFNg\zB

	 * <p>

	 * userData  null ɐݒ肳B

	 * </p>

	 */

	GraphItem() {

	    super();

	}



	/**

	 * p҂́uOt̍\vɊ֘AtCӂ̃f[^ userData ɐݒ肷B

	 * <p>

	 * ̌ĂяoȑO userData ɐݒ肳Ăf[^͖YꋎB

	 * </p>

	 * <p>

	 * object  null ł\ȂB

	 * ̏ꍇAuserData ɂ null ݒ肳B

	 * </p>

	 *

	 * @param object	Cӂ̃f[^ (Cӂ̃IuWFNg)

	 * @see	#getUserData()

	 */

	public synchronized void setUserData(java.lang.Object object) {

	    this.userData = object;

	}



	/**

	 * ́uOt̍\v userData ԂB

	 *

	 * @return	́uOt̍\vɊ֘AtĂCӂ̃IuWFNg

	 * @see	#setUserData(java.lang.Object)

	 */

	public synchronized java.lang.Object getUserData() {

	    return this.userData;

	}



	/**

	 * ^ꂽuOt̍\vg̕ƂĐݒ肷B

	 * <p>

	 * ̌ĂяoȑOɐݒ肳Ă͖YꋎB

	 * </p>

	 * <p>

	 * itemAsReplica  null ł\ȂB

	 * ̏ꍇA݂͑Ȃ̂ƂȂB

	 * </p>

	 * <p>

	 * itemAsReplica  null łȂꍇA

	 * g userData  itemAsReplica  userData ɐݒ肷B

	 * </p>

	 * <p>

	 * ȂAʏ̕ł͂ȂoΕ쐬Ȃ΁A

	 * _̕ƂĖʁAʂ̕ƂĒ_^邱ƂɂȂB

	 * </p>

	 *

	 * @param itemAsReplica	ƂĐݒ肷uOt̍\v

	 * @see	#copy()

	 * @see	#copy(JgclEmbeddedGraph)

	 * @see	#dualCopy()

	 * @see	#dualCopy(JgclEmbeddedGraph)

	 */

	protected synchronized void setReplica(GraphItem itemAsReplica) {

	    if ((this.replica = itemAsReplica) != null) {

		this.replica.userData = this.userData;

	    }

	}



	/**

	 * g̕ƂĐݒ肳ĂuOt̍\vԂB

	 * <p>

	 * ȂAʏ̕ł͂ȂoΕ쐬ĂȂ΁A

	 * _̕ƂĖʁAʂ̕ƂĒ_Ԃ邱ƂɂȂB

	 * </p>

	 *

	 * @return	ƂĐݒ肳ĂuOt̍\v

	 * @see	#copy()

	 * @see	#copy(JgclEmbeddedGraph)

	 * @see	#dualCopy()

	 * @see	#dualCopy(JgclEmbeddedGraph)

	 */

	protected synchronized GraphItem getReplica() {

	    return this.replica;

	}

    }



    /**

     * Ot̒_\NXB

     * <p>

     * ̃NX̃CX^X́A

     * ̒_芪ӂ̃Xg (ACCW) ̍ŏ̕ firstEdge

     * ێB

     * </p>

     * <p>

     * ȂAӂӃTCŃuŏ̕Ӂvɐݒ肳ĂƂāA

     * ͂̕ӂƒ_Ƃ̊֌Wɂēʂ̈Ӗ킯ł͂ȂA

     * ܂܍ŏ̂̂ƂċLĂ邾łB

     * </p>

     * <p>

     * ̕ӂ̍ (CCW) ̃XgA_́uӃTCN (edge cycle)vƂB

     * ܂A_芪ʂ̍ (CCW) ̃XguʃTCN (face cycle)vƂB

     * </p>

     */

    public class Vertex extends GraphItem {

	/**

	 * ̒_̕ӃTCN̍ŏ̕ӁB

	 */

	private Edge firstEdge = null;



	/**

	 * ^ɃIuWFNg\zB

	 * <p>

	 * \z̒_͑̒_^Ӂ^ʂƂ̊֌WȂB

	 * </p>

	 * <p>

	 * ̃RXgN^́AOt̗p҂ɂĒڌĂяoׂł͂ȂB

	 * Ot̗p҂́A܂ł Euler Operator () 𗘗pāA

	 * Ot𑀍삷̂ƂĂB

	 * </p>

	 */

	protected Vertex() {

	    JgclEmbeddedGraph.this.super();

	}



	/**

	 * ̒_OtԂB

	 * 

	 * @return	̒_Ot

	 */

	public JgclEmbeddedGraph getGraph() {

	    return JgclEmbeddedGraph.this;

	}



	/**

	 * ^ꂽӂA̒_ firstEdge ɐݒ肷B

	 *

	 * @param edge	firstEdge ɐݒ肷

	 */

	private void setFirstEdge(Edge edge) {

	    firstEdge = edge;

	}



	/**

	 * ̒_ firstEdge ɐݒ肳ĂӂԂB

	 *

	 * @return	firstEdge ɐݒ肳Ă

	 */

	private Edge getFirstEdge() {

	    Edge edge = firstEdge;

	    if ((edge != null) && (edge.getVertex() != this))

		edge = edge.getMate();

	    return edge;

	}



	/**

	 * ^ꂽӂ̒_芪ӂ̓̈łƂāA

	 * ̒_̕ӃTCNɂāÄO̕ӂԂB

	 *

	 * @param edge	

	 * @return	ӃTCNŁAO̕

	 */

	private Edge getPrevEdgeInCCW(Edge edge) {

	    edge = edge.getMate().getNextEdge();

	    if (this.isIdentWith(edge.getVertex()) != true)

		edge = edge.getMate();

	    return edge;

	}



	/**

	 * ^ꂽӂ̒_芪ӂ̓̈łƂāA

	 * ̒_̕ӃTCNɂāÄ̕ӂԂB

	 *

	 * @param edge	

	 * @return	ӃTCNŁA̕

	 */

	private Edge getNextEdgeInCCW(Edge edge) {

	    edge = edge.getPrevEdge();

	    if (this.isIdentWith(edge.getVertex()) != true)

		edge = edge.getMate();

	    return edge;

	}



	/**

	 * ^ꂽ_̒_Ɠł邩ۂԂB

	 *

	 * @param	vrtx	_

	 * @return	̒_Ȃ trueAłȂ false

	 */

	public boolean isIdentWith(Vertex vrtx) {

	    return (this == vrtx);

	}



	/**

	 * ̒_̕ӃTCN\XgԂB

	 * <p>

	 * ʂƂē Vector ̊evf́A

	 * {@link JgclEmbeddedGraph.Edge JgclEmbeddedGraph.Edge}

	 * ̃CX^XłB

	 * </p>

	 *

	 * @return	̒_̕ӃTCN\Xg

	 */

	public synchronized Vector getEdgeCycleInCCW() {

	    Vector result = new Vector();

	    Edge firstE = getFirstEdge();

	    Edge edge = firstE;



	    if (edge == null)

		return result;



	    do {

		result.addElement(edge);

		edge = getNextEdgeInCCW(edge);

	    } while (edge.isIdentWith(firstE) != true);



	    return result;

	}



	/**

	 * ̒_̖ʃTCN\XgԂB

	 * <p>

	 * ʂƂē Vector ̊evf́A

	 * {@link JgclEmbeddedGraph.Face JgclEmbeddedGraph.Face}

	 * ̃CX^XłB

	 * </p>

	 *

	 * @return	̒_̖ʃTCN\Xg

	 */

	public synchronized Vector getFaceCycleInCCW() {

	    Vector result = new Vector();

	    Edge firstE = getFirstEdge();

	    Edge edge = firstE;



	    if (edge == null) {

		result.addElement(JgclEmbeddedGraph.this.faceList.elementAt(0));

		return result;

	    }



	    do {

		if (result.contains(edge.getFace()) != true)

		    result.addElement(edge.getFace());

		edge = getNextEdgeInCCW(edge);

	    } while (edge.isIdentWith(firstE) != true);



	    return result;

	}



	/**

	 * ̒_̕ƂĐݒ肳Ă钸_̃tB[hɐlB

	 * <p>

	 * ̒_ firstEdge ̕

	 * ̒_̕ firstEdge ƂB

	 * ̒_ firstEdge  null ̏ꍇɂ͉ȂB

	 * </p>

	 * <p>

	 * JgclEmbeddedGraph.Vertex ̃TuNX́A

	 * KvɉẴ\bhI[o[ChׂłB

	 * ȂÃI[o[Ch\bh̓ł́A

	 * super.fillFieldsOfReplica() ƂāÃ\bhĂяoȂ΂ȂȂB

	 * </p>

	 * @see	JgclEmbeddedGraph.GraphItem#setReplica(JgclEmbeddedGraph.GraphItem)

	 * @see	JgclEmbeddedGraph.Edge

	 */

	protected void fillFieldsOfReplica() {

	    if (this.firstEdge != null) {

		Vertex replica = (Vertex)this.getReplica();

		replica.firstEdge = this.firstEdge.getReplica();

	    }

	}



	/**

	 * ̒_̑oΕƂĐݒ肳Ăʂ̃tB[hɐlB

	 * <p>

	 * ̒_ firstEdge ̑̕

	 * ̒_̑oΕ firstEdge ƂB

	 * ̒_ firstEdge  null ̏ꍇɂ͉ȂB

	 * </p>

	 * <p>

	 * JgclEmbeddedGraph.Vertex ̃TuNX́A

	 * KvɉẴ\bhI[o[ChׂłB

	 * ȂÃI[o[Ch\bh̓ł́A

	 * super.fillFieldsOfDualReplica() ƂāÃ\bhĂяoȂ΂ȂȂB

	 * </p>

	 * @see	JgclEmbeddedGraph.GraphItem#setReplica(JgclEmbeddedGraph.GraphItem)

	 * @see	JgclEmbeddedGraph.Face

	 * @see	JgclEmbeddedGraph.Edge

	 */

	protected void fillFieldsOfDualReplica() {

	    if (this.firstEdge != null) {

		Face replica = (Face)this.getReplica();

		replica.firstEdge = this.firstEdge.getReplica().getMate();

	    }

	}

    }



    /**

     * Ot̖ʂ\NXB

     * <p>

     * ̃NX̃CX^X́A

     * ̖ʂ芪ӂ̃Xg (ACCW) ̍ŏ̕ firstEdge

     * ێB

     * </p>

     * <p>

     * ȂAӂ́uŏ̕Ӂvɐݒ肳ĂƂāA

     * ͂̕ӂƂ̖ʂƂ̊֌Wɂēʂ̈Ӗ킯ł͂ȂA

     * ܂܍ŏ̂̂ƂċLĂ邾łB

     * </p>

     * <p>

     * ̕ӂ̍ (CCW) ̃XgAʂ́uӃTCN (edge cycle)vƂB

     * ܂Aʂ芪_̍ (CCW) ̃Xgu_TCN (vertex cycle)vƂB

     * </p>

     */

    public class Face extends GraphItem {

	/**

	 * ̖ʂ̕ӃTCNŏ̕ӁB

	 */

	private Edge firstEdge = null;



	/**

	 * ^ɃIuWFNg\zB

	 * <p>

	 * \z̖ʂ͑̒_^Ӂ^ʂƂ̊֌WȂB

	 * </p>

	 * <p>

	 * ̃RXgN^́AOt̗p҂ɂĒڌĂяoׂł͂ȂB

	 * Ot̗p҂́A܂ł Euler Operator () 𗘗pāA

	 * Ot𑀍삷̂ƂĂB

	 * </p>

	 */

	protected Face() {

	    JgclEmbeddedGraph.this.super();

	}



	/**

	 * ̖ʂOtԂB

	 * 

	 * @return	̖ʂOt

	 */

	public JgclEmbeddedGraph getGraph() {

	    return JgclEmbeddedGraph.this;

	}



	/**

	 * ^ꂽӂA̖ʂ firstEdge ɐݒ肷B

	 *

	 * @param edge	firstEdge ɐݒ肷

	 */

	private void setFirstEdge(Edge edge) {

	    firstEdge = edge;

	}



	/**

	 * ̖ʂ firstEdge ɐݒ肳ĂӂԂB

	 *

	 * @return	firstEdge ɐݒ肳Ă

	 */

	private Edge getFirstEdge() {

	    Edge edge = firstEdge;

	    if ((edge != null) && (edge.getFace() != this))

		edge = edge.getMate();

	    return edge;

	}



	/**

	 * ^ꂽʂ̖ʂƓł邩ۂԂB

	 *

	 * @param	face	

	 * @return	̖ʂȂ trueAłȂ false

	 */

	public boolean isIdentWith(Face face) {

	    return (this == face);

	}



	/**

	 * ̖ʂ̕ӃTCN\XgԂB

	 * <p>

	 * ʂƂē Vector ̊evf́A

	 * {@link JgclEmbeddedGraph.Edge JgclEmbeddedGraph.Edge}

	 * ̃CX^XłB

	 * </p>

	 *

	 * @return	̖ʂ̕ӃTCN\Xg

	 */

	public synchronized Vector getEdgeCycleInCCW() {

	    Vector result = new Vector();

	    Edge firstE = getFirstEdge();

	    Edge edge = firstE;



	    if (edge == null)

		return result;



	    do {

		result.addElement(edge);

		edge = edge.getNextEdge();

	    } while (edge != firstE);	// do not use isIdentWith()



	    return result;

	}



	/**

	 * ̖ʂ̒_TCN\XgԂB

	 * <p>

	 * ʂƂē Vector ̊evf́A

	 * {@link JgclEmbeddedGraph.Vertex JgclEmbeddedGraph.Vertex}

	 * ̃CX^XłB

	 * </p>

	 *

	 * @return	̖ʂ̒_TCN\Xg

	 */

	public synchronized Vector getVertexCycleInCCW() {

	    Vector result = new Vector();

	    Edge firstE = getFirstEdge();

	    Edge edge = firstE;



	    if (edge == null) {

		result.addElement(JgclEmbeddedGraph.this.vrtxList.elementAt(0));

		return result;

	    }



	    do {

		result.addElement(edge.getVertex());

		edge = edge.getNextEdge();

	    } while (edge != firstE);	// do not use isIdentWith()



	    return result;

	}



	/**

	 * ̖ʂ̕ƂĐݒ肳Ăʂ̃tB[hɐlB

	 * <p>

	 * ̖ʂ firstEdge ̕

	 * ̖ʂ̕ firstEdge ƂB

	 * ̖ʂ firstEdge  null ̏ꍇɂ͉ȂB

	 * </p>

	 * <p>

	 * JgclEmbeddedGraph.Face ̃TuNX́A

	 * KvɉẴ\bhI[o[ChׂłB

	 * ȂÃI[o[Ch\bh̓ł́A

	 * super.fillFieldsOfReplica() ƂāÃ\bhĂяoȂ΂ȂȂB

	 * </p>

	 * @see	JgclEmbeddedGraph.GraphItem#setReplica(JgclEmbeddedGraph.GraphItem)

	 * @see	JgclEmbeddedGraph.Edge

	 */

	protected void fillFieldsOfReplica() {

	    if (this.firstEdge != null) {

		Face replica = (Face)this.getReplica();

		replica.firstEdge = this.firstEdge.getReplica();

	    }

	}



	/**

	 * ̖ʂ̑oΕƂĐݒ肳Ă钸_̃tB[hɐlB

	 * <p>

	 * ̖ʂ firstEdge ̕

	 * ̖ʂ̑oΕ firstEdge ƂB

	 * ̖ʂ firstEdge  null ̏ꍇɂ͉ȂB

	 * </p>

	 * <p>

	 * JgclEmbeddedGraph.Face ̃TuNX́A

	 * KvɉẴ\bhI[o[ChׂłB

	 * ȂÃI[o[Ch\bh̓ł́A

	 * super.fillFieldsOfDualReplica() ƂāÃ\bhĂяoȂ΂ȂȂB

	 * </p>

	 * @see	JgclEmbeddedGraph.GraphItem#setReplica(JgclEmbeddedGraph.GraphItem)

	 * @see	JgclEmbeddedGraph.Vertex

	 * @see	JgclEmbeddedGraph.Edge

	 */

	protected void fillFieldsOfDualReplica() {

	    if (this.firstEdge != null) {

		Vertex replica = (Vertex)this.getReplica();

		replica.firstEdge = this.firstEdge.getReplica();

	    }

	}

    }



    /**

     * Ot̔ (ӂ̕Њ) \NXB

     * <p>

     * ̕ӂ́Aw킹ɂȂg̔ (half edge) ɂč\̂ƍlB

     * ̃NX͂̔ӂ\B

     * ʏ͂̔ӂPɁuӁvƌĂԁB

     * Ot̗p҂́Aӂ𑀍삷ꍇɂ́A̔ӂ𑀍삷邱ƂɂȂB

     * </p>

     * <p>

     * ̃NX̃CX^X́A

     * <ul>

     * <li>	ӂ̎n_ƂȂ钸_ vertex

     * <li>	ӂ̍ɐڂ face

     * <li>	face ɂO̔ prevEdge

     * <li>	face ɂ̔ nextEdge

     * <li>	ӂƋtŔw킹ɂȂĂ锼 () mate

     * </ul>

     * ێB

     * </p>

     * <p>

     * Ot̒_^ʂ\NX

     * {@link JgclEmbeddedGraph.Vertex Vertex}/{@link JgclEmbeddedGraph.Face Face}

     * 

     * {@link JgclEmbeddedGraph.GraphItem GraphItem}

     * ̒ڂ̃TuNXɂȂĂ邪A

     * () ӂ\̃NXɂẮA

     * w킹̓̔ӂ܂ JgclEmbeddedGraph.EdgeContainer ƂNX

     * {@link JgclEmbeddedGraph.GraphItem GraphItem}

     * ̃TuNXɂȂĂB

     * ȂAJgclEmbeddedGraph.EdgeContainer 

     * JgclEmbeddedGraph  private ȓNXłB

     * </p>

     */

    public class Edge extends java.lang.Object {

	/*

	 * Half Edge Structure

	 *

	 *       \

	 *        \ nextEdge

	 *         \

	 *          -

	 *        ^ |

	 *  face  | |

	 *        | |

	 *          + vertex

	 *         /

	 *        / prevEdge

	 *       /

	 *

	 */



	/**

	 * ӂ̎n_ƂȂ钸_B

	 */

	private Vertex vertex;



	/**

	 * ӂ̍ɐڂʁB

	 */

	private Face face;



	/**

	 * face ɂO̕ӁB

	 */

	private Edge prevEdge;



	/**

	 * face ɂ̕ӁB

	 */

	private Edge nextEdge;



	/**

	 * ӂƋtŔw킹ɂȂĂ锼 : B

	 */

	private Edge mate;



	/**

	 * ӂ̃ReiB

	 */

	private EdgeContainer container;



	/**

	 * ^ɃIuWFNg\zB

	 * <p>

	 * \z̕ӂ͑̒_^Ӂ^ʂƂ̊֌WȂB

	 * </p>

	 * <p>

	 * ̃RXgN^́AOt̗p҂ɂĒڌĂяoׂł͂ȂB

	 * Ot̗p҂́A܂ł Euler Operator () 𗘗pāA

	 * Ot𑀍삷̂ƂĂB

	 * </p>

	 */

	protected Edge() {

	    super();

	}



	/**

	 * ̕ӂOtԂB

	 *

	 * @return	̕ӂOt

	 */

	public JgclEmbeddedGraph getGraph() {

	    return JgclEmbeddedGraph.this;

	}



	/**

	 * ^ꂽ_A̕ӂ̎n_ɐݒ肷B

	 *

	 * @param vertex	n_ɐݒ肷钸_

	 */

	private void setVertex(Vertex vertex) {

	    this.vertex = vertex;

	}



	/**

	 * ̕ӂ̎n_ɐݒ肳Ă钸_ԂB

	 *

	 * @return	n_ɐݒ肳Ă钸_

	 */

	private Vertex getVertex() {

	    return this.vertex;

	}



	/**

	 * ^ꂽʂA̕ӂ̍ʂɐݒ肷B

	 *

	 * @param face	ʂɐݒ肷

	 */

	private void setFace(Face face) {

	    this.face = face;

	}



	/**

	 * ̕ӂ̍ʂɐݒ肳ĂʂԂB

	 *

	 * @return	ʂɐݒ肳Ă

	 */

	private Face getFace() {

	    return this.face;

	}



	/**

	 * ^ꂽӂA̕ӂ̈O̕ӂɐݒ肷B

	 *

	 * @param edge	O̕ӂɐݒ肷

	 */

	private void setPrevEdge(Edge edge) {

	    this.prevEdge = edge;

	}



	/**

	 * ̕ӂ̈O̕ӂɐݒ肳ĂӂԂB

	 *

	 * @return	O̕ӂɐݒ肳Ă

	 */

	private Edge getPrevEdge() {

	    Edge prev = this.prevEdge;

	    if (prev.vertex == this.vertex)

		prev = prev.mate;

	    return prev;

	}



	/**

	 * ^ꂽӂA̕ӂ̈̕ӂɐݒ肷B

	 *

	 * @param edge	̕ӂɐݒ肷

	 */

	private void setNextEdge(Edge edge) {

	    this.nextEdge = edge;

	}



	/**

	 * ̕ӂ̈̕ӂɐݒ肳ĂӂԂB

	 *

	 * @return	̕ӂɐݒ肳Ă

	 */

	private Edge getNextEdge() {

	    Edge next = this.nextEdge;

	    if (next.vertex != mate.vertex)

		next = next.mate;

	    return next;

	}



	/**

	 * ^ꂽӂA̕ӂ̑ɐݒ肷B

	 *

	 * @param edge	ƂĐݒ肷

	 */

	private void setMate(Edge edge) {

	    this.mate = edge;

	}



	/**

	 * ̕ӂ̑ɐݒ肳ĂӂԂB

	 *

	 * @return	ƂĐݒ肳Ă

	 */

	public Edge getMate() {

	    return this.mate;

	}



	/**

	 * ^ꂽuӂ̃ReivA̕ӂ̃Reiɐݒ肷B

	 *

	 * @param container	ӂ̃Rei

	 */

	private void setContainer(EdgeContainer container) {

	    this.container = container;

	}



	/**

	 * ̕ӂ̃ReiԂB

	 *

	 * @return	ӂ̃Rei

	 */

	private EdgeContainer getContainer() {

	    return this.container;

	}



	/**

	 * ^ꂽӂA̕ӂƓ̕ӂۂԂB

	 * <p>

	 * edge  this  this ̑ł true ԂB

	 * </p>

	 *

	 * @param	edge	

	 * @return	̕ӂȂ trueAłȂ false

	 */

	public boolean isIdentWith(Edge edge) {

	    return (this.container == edge.container);

	}



	/**

	 * ̕ӂ̎n_^I_ԂB

	 * <p>

	 * ʂƂēz̗vf 2 ŁA

	 * ŏ̗vfɂ͎n_A

	 * Ԗڂ̗vfɂ͏I_

	 * B

	 * </p>

	 * <p>

	 * I_Ƃ́A̎n_łB

	 * </p>

	 *

	 * @return n_^I_܂ޔz

	 */

	public synchronized Vertex[] getVertices() {

	    Vertex[] result = new Vertex[2];

	    result[0] = getVertex();

	    result[1] = getMate().getVertex();

	    return result;

	}



	/**

	 * ̕ӂ̎n_ԂB

	 *

	 * @return n_

	 */

	public synchronized Vertex getStartingVertex() {

	    return getVertex();

	}



	/**

	 * ̕ӂ̏I_ԂB

	 * <p>

	 * I_Ƃ́A̎n_łB

	 * </p>

	 *

	 * @return I_

	 */

	public synchronized Vertex getTerminalVertex() {

	    return getMate().getVertex();

	}



	/**

	 * ̕ӂ̍ʁ^EʂԂB

	 * <p>

	 * ʂƂēz̗vf 2 ŁA

	 * ŏ̗vfɂ͍ʁA

	 * Ԗڂ̗vfɂ͉E

	 * B

	 * </p>

	 * <p>

	 * EʂƂ́A̍ʂłB

	 * </p>

	 *

	 * @return ʁ^Eʂ܂ޔz

	 */

	public synchronized Face[] getFaces() {

	    Face[] result = new Face[2];

	    result[0] = getFace();

	    result[1] = getMate().getFace();

	    return result;

	}



	/**

	 * ̕ӂ̍ʂԂB

	 *

	 * @return	

	 */

	public synchronized Face getLeftFace() {

	    return getFace();

	}



	/**

	 * ̕ӂ̉EʂԂB

	 * <p>

	 * EʂƂ́A̍ʂłB

	 * </p>

	 *

	 * @return	E

	 */

	public synchronized Face getRightFace() {

	    return getMate().getFace();

	}



	/**

	 * p҂̕ӂɊ֘AtCӂ̃f[^ userData ɐݒ肷B

	 * <p>

	 * ̌ĂяoȑO userData ɐݒ肳Ăf[^͖YꋎB

	 * ȂA̕ӂƂ̕ӂ͓̑ userData LB

	 * </p>

	 * <p>

	 * object  null ł\ȂB

	 * ̏ꍇAuserData ɂ null ݒ肳B

	 * </p>

	 *

	 * @param object	Cӂ̃f[^ (Cӂ̃IuWFNg)

	 * @see	#getUserData()

	 * @see	JgclEmbeddedGraph.GraphItem

	 */

	public synchronized void setUserData(java.lang.Object object) {

	    container.setUserData(object);

	}



	/**

	 * ̕ӂ userData ԂB

	 *

	 * @return	̕ӂɊ֘AtĂCӂ̃IuWFNg

	 * @see	#setUserData(java.lang.Object)

	 * @see	JgclEmbeddedGraph.GraphItem

	 */

	public synchronized java.lang.Object getUserData() {

	    return container.getUserData();

	}



	/*

	 * ̕ӂAg܂ރRei̔ A ł邩ۂԂB

	 *

	 * @return Rei̔ A ł true,  Z ł false

	 * @see	JgclEmbeddedGraph.EdgeContainer

	 */

	private boolean isHalfA() {

	    return (this == container.getHalfA());

	}



	/**

	 *  () ӂ̕ƂĐݒ肳Ă锼ӂԂB

	 *

	 * @return	ƂĐݒ肳Ă锼

	 * @see	#copy()

	 * @see	#copy(JgclEmbeddedGraph)

	 * @see	#dualCopy()

	 * @see	#dualCopy(JgclEmbeddedGraph)

	 */

	protected Edge getReplica() {

	    EdgeContainer replica = (EdgeContainer)container.getReplica();

	    if (replica == null)

		return null;



	    return (this.isHalfA()) ? replica.getHalfA() : replica.getHalfZ();

	}



	/**

	 *  () ӂ̕ƂĐݒ肳Ă锼ӂ̃tB[hɐlB

	 * <p>

	 * JgclEmbeddedGraph.Edge ̃TuNX́A

	 * KvɉẴ\bhI[o[ChׂłB

	 * ȂÃI[o[Ch\bh̓ł́A

	 * super.fillFieldsOfReplica() ƂāÃ\bhĂяoȂ΂ȂȂB

	 * </p>

	 * @see	JgclEmbeddedGraph.GraphItem#setReplica(JgclEmbeddedGraph.GraphItem)

	 */

	protected void fillFieldsOfReplica() {

	    Edge replica = this.getReplica();



	    replica.vertex   = (Vertex)this.vertex.getReplica();

	    replica.face     = (Face)this.face.getReplica();

	    replica.prevEdge = this.prevEdge.getReplica();

	    replica.nextEdge = this.nextEdge.getReplica();

	}



	/**

	 *  () ӂ̑oΕƂĐݒ肳Ă锼ӂ̃tB[hɐlB

	 * <p>

	 * JgclEmbeddedGraph.Edge ̃TuNX́A

	 * KvɉẴ\bhI[o[ChׂłB

	 * ȂÃI[o[Ch\bh̓ł́A

	 * super.fillFieldsOfDualReplica() ƂāÃ\bhĂяoȂ΂ȂȂB

	 * </p>

	 * @see	JgclEmbeddedGraph.GraphItem#setReplica(JgclEmbeddedGraph.GraphItem)

	 */

	protected void fillFieldsOfDualReplica() {

	    Edge replica = this.getReplica();



	    replica.vertex   = (Vertex)this.face.getReplica();

	    replica.face     = (Face)this.mate.vertex.getReplica();

	}

    }



    /**

     * w킹̓̔ӂ̃Rei\NXB

     * <p>

     * ̃NX͊Oɂ͌ȂB

     * </p>

     * <p>

     * ̃NX̃CX^X́A

     * <ul>

     * <li>	ӂ̈̕Њłu Av halfA

     * <li>	ӂ̑̕Њłu Zv halfZ

     * </ul>

     * ێB

     * </p>

     */

    private class EdgeContainer extends GraphItem {

	/**

	 * ӂ̈̕Њł锼 A B

	 */

	private Edge halfA;



	/**

	 * ӂ̑̕Њł锼 Z B

	 */

	private Edge halfZ;



	/**

	 * ^ɃIuWFNg\zB

	 * <p>

	 * ̃RXgN^̓ł́A

	 * Otɐݒ肳Ă graphItemMaker  newEdge() gāA

	 * ̔ӂ𐶐B

	 * </p>

	 * @see	JgclEmbeddedGraph#graphItemMaker

	 * @see	JgclEmbeddedGraph.GraphItemMaker#newEdge()

	 */

	private EdgeContainer() {

	    JgclEmbeddedGraph.this.super();



	    halfA = graphItemMaker.newEdge();

	    halfZ = graphItemMaker.newEdge();



	    halfA.setMate(halfZ);

	    halfA.setContainer(this);



	    halfZ.setMate(halfA);

	    halfZ.setContainer(this);

	}



	/**

	 * ̃Rei halfA ԂB

	 *

	 * @return  A

	 */

	private Edge getHalfA() {

	    return halfA;

	}



	/**

	 * ̃Rei halfZ ԂB

	 *

	 * @return  Z

	 */

	private Edge getHalfZ() {

	    return halfZ;

	}



	/**

	 * ̃Rei܂ޔӂ̕ƂĐݒ肳Ă锼ӂ̃tB[hɐlB

	 *

	 * @see	JgclEmbeddedGraph.Edge#fillFieldsOfReplica()

	 */

	private void fillFieldsOfReplica() {

	    halfA.fillFieldsOfReplica();

	    halfZ.fillFieldsOfReplica();

	}



	/**

	 * ̃Rei܂ޔӂ̑oΕƂĐݒ肳Ă锼ӂ̃tB[hɐlB

	 *

	 * @see	JgclEmbeddedGraph.Edge#fillFieldsOfDualReplica()

	 */

	private void fillFieldsOfDualReplica() {

	    halfA.fillFieldsOfDualReplica();

	    halfZ.fillFieldsOfDualReplica();

	}

    }



    /**

     * Otł̐VȒ_^Ӂ^ʂ̐SIuWFNgׂC^[tFCXB

     */

    public interface GraphItemMaker {

	/**

	 * VȒ_𐶐B

	 * <p>

	 * JgclEmbeddedGraph.Vertex

	 * 邢͂̃TuNX̃RXgN^ō\z_Ԃ\bhB

	 * </p>

	 *

	 * @return	Vɐ_

	 */

	public abstract Vertex newVertex();



	/**

	 * VȖʂ𐶐B

	 * <p>

	 * JgclEmbeddedGraph.Face

	 * 邢͂̃TuNX̃RXgN^ō\zʂԂ\bhB

	 * </p>

	 *

	 * @return	Vɐ

	 */

	public abstract Face   newFace();



	/**

	 * Vȕӂ𐶐B

	 * <p>

	 * JgclEmbeddedGraph.Edge

	 * 邢͂̃TuNX̃RXgN^ō\zӂԂ\bhB

	 * </p>

	 *

	 * @return	Vɐ

	 */

	public abstract Edge   newEdge();

    }



    /**

     * VȒ_^Ӂ^ʂ̐SIuWFNgB

     */

    private GraphItemMaker graphItemMaker;



    /**

     * _̃XgB

     */

    private Vector vrtxList;



    /**

     *  (̃Rei) ̃XgB

     */

    private Vector edgeList;



    /**

     * ʂ̃XgB

     */

    private Vector faceList;



    /**

     * ^ꂽIuWFNgA

     * ̃Ot̐VȒ_^Ӂ^ʂ̐SIuWFNgƂ

     * ݒ肷B

     *

     * @param	VȒ_^Ӂ^ʂ̐SIuWFNg

     */

    protected void setGraphItemMaker(GraphItemMaker maker) {

	graphItemMaker = maker;

    }



    /**

     * ̃Ot܂ޒ_̐ԂB

     *

     * @return	_̐

     */

    public synchronized int getNumberOfVertices() {

	return vrtxList.size();

    }



    /**

     * ̃Ot܂ޕӂ̐ԂB

     *

     * @return	ӂ̐

     */

    public synchronized int getNumberOfEdges() {

	return edgeList.size();

    }



    /**

     * ̃Ot܂ޖʂ̐ԂB

     *

     * @return	ʂ̐

     */

    public synchronized int getNumberOfFaces() {

	return faceList.size();

    }



    /**

     * ̃Ot܂ޒ_ Enumeration ԂB

     *

     * @return  _ Enumeration

     */

    public synchronized Enumeration vertexElements() {

	return vrtxList.elements();

    }



    /**

     * ̃Ot܂ޕӂ Enumeration ԂB

     *

     * @return  ӂ Enumeration

     */

    public synchronized Enumeration edgeElements() {

	return new Enumeration() {

	    Enumeration e = edgeList.elements();



	    public boolean hasMoreElements() {

		return e.hasMoreElements();

	    }



	    public java.lang.Object nextElement() {

		EdgeContainer edgeContainer = (EdgeContainer)e.nextElement();

		return edgeContainer.getHalfA();

	    }

	};

    }



    /**

     * ̃Ot܂ޖʂ Enumeration ԂB

     *

     * @return  ʂ Enumeration

     */

    public synchronized Enumeration faceElements() {

	return faceList.elements();

    }



    /**

     * ̃OtɐVȒ_쐬B

     * <p>

     * ̃\bhɂĐ̒_͑̒_^Ӂ^ʂƂ̊֌WȂB

     * </p>

     *

     * @return	Vɐꂽ_

     * @see	JgclEmbeddedGraph.GraphItemMaker#newVertex()

     */

    private Vertex addVertex() {

	Vertex vrtx = graphItemMaker.newVertex();

	vrtxList.addElement(vrtx);

	return vrtx;

    }



    /**

     * ̃OtɐVȖʂ쐬B

     * <p>

     * ̃\bhɂĐ̖ʂ͑̒_^Ӂ^ʂƂ̊֌WȂB

     * </p>

     *

     * @return	Vɐꂽ

     * @see	JgclEmbeddedGraph.GraphItemMaker#newFace()

     */

    private Face addFace() {

	Face face = graphItemMaker.newFace();

	faceList.addElement(face);

	return face;

    }



    /**

     * ̃OtɐVȕӂ쐬B

     * <p>

     * ̃\bhɂĐ̕ӂ͑̒_^Ӂ^ʂƂ̊֌WȂB

     * </p>

     *

     * @return	Vɐꂽ

     * @see	JgclEmbeddedGraph.EdgeContainer#JgclEmbeddedGraph.EdgeContainer(JgclEmbeddedGraph)

     * @see	JgclEmbeddedGraph.EdgeContainer#getHalfA()

     */

    private Edge addEdge() {

	EdgeContainer edgeContainer = this.new EdgeContainer();

	edgeList.addElement(edgeContainer);



	return edgeContainer.getHalfA();

    }



    /**

     * ^ꂽ_ÃOt폜B

     *

     * @param vrtx	폜钸_

     */

    private void removeVertex(Vertex vrtx) {

	vrtxList.removeElement(vrtx);

    }



    /**

     * ^ꂽʂÃOt폜B

     *

     * @param	face	폜

     */

    private void removeFace(Face face) {

	faceList.removeElement(face);

    }



    /**

     * ^ꂽӂ܂ރReiÃOt폜B

     *

     * @param	edge	폜

     */

    private void removeEdge(Edge edge) {

	edgeList.removeElement(edge.getContainer());

    }



    /**

     * ̃OtA^ꂽ_܂ނۂԂB

     *

     * @param	vrtx	钸_

     * @param	vrtx OtɊ܂܂Ă trueAłȂ false

     */

    public boolean contains(Vertex vrtx) {

	if (((vrtx != null) && (vrtx.getGraph() == this)) != true) {

	    return false;

	}



	return vrtxList.contains(vrtx);

    }



    /**

     * ̃OtA^ꂽʂ܂ނۂԂB

     *

     * @param	face	

     * @param	face OtɊ܂܂Ă trueAłȂ false

     */

    public boolean contains(Face face) {

	if (((face != null) && (face.getGraph() == this)) != true) {

	    return false;

	}



	return faceList.contains(face);

    }



    /**

     * ̃OtA^ꂽӂ܂ނۂԂB

     *

     * @param	edge	

     * @param	edge OtɊ܂܂Ă trueAłȂ false

     */

    public boolean contains(Edge edge) {

	if (((edge != null) && (edge.getGraph() == this)) != true) {

	    return false;

	}



	return edgeList.contains(edge.getContainer());

    }



    /**

     * ^ɁA̖ߍ݃OtƂăIuWFNg\zB

     * <p>

     * ̃RXgN^ł́A

     * \zCX^X graphItemMaker ƂāAP

     * {@link JgclEmbeddedGraph.Vertex JgclEmbeddedGraph.Vertex}

     * /

     * {@link JgclEmbeddedGraph.Face JgclEmbeddedGraph.Face}

     * /

     * {@link JgclEmbeddedGraph.Edge JgclEmbeddedGraph.Edge}

     * ̃CX^X𐶐IuWFNgݒ肷B

     * </p>

     */

    public JgclEmbeddedGraph() {

	graphItemMaker = new GraphItemMaker() {

	    public Vertex newVertex() { return JgclEmbeddedGraph.this.new Vertex(); }

	    public Face   newFace()   { return JgclEmbeddedGraph.this.new Face(); }

	    public Edge   newEdge()   { return JgclEmbeddedGraph.this.new Edge(); }

	};

	vrtxList = new Vector();

	edgeList = new Vector();

	faceList = new Vector();

    }



    /**

     * graphItemMaker ^āA̖ߍ݃OtƂăIuWFNg\zB

     *

     * @param	maker	VȒ_^Ӂ^ʂ̐SIuWFNg

     */

    public JgclEmbeddedGraph(GraphItemMaker maker) {

	graphItemMaker = maker;

	vrtxList = new Vector();

	edgeList = new Vector();

	faceList = new Vector();

    }



    /**

     * JgclEmbeddedGraph  Euler Operator ̊e make \bhɂ

     * Vɐꂽ_^Ӂ^ʂNXB

     */

    public class Result extends java.lang.Object {

	/**

	 * Vɐꂽ_B

	 * <p>

	 * _Ȃ\bh̏ꍇɂ null B

	 * </p>

	 */

	public Vertex vrtx;



	/**

	 * VɐꂽӁB

	 * <p>

	 * ӂȂ\bh̏ꍇɂ null B

	 * </p>

	 */

	public Edge edge;



	/**

	 * VɐꂽʁB

	 * <p>

	 * ʂȂ\bh̏ꍇɂ null B

	 * </p>

	 */

	public Face face;



	/**

	 * etB[hɐݒ肷l^āAIuWFNg\zB

	 * <p>

	 * vrtx, edge, face ̂ꂼ null ł\ȂB

	 * </p>

	 *

	 * @param vrtx	Vɐꂽ_

	 * @param edge	Vɐꂽ

	 * @param face	Vɐꂽ

	 */

	private Result(Vertex vrtx, Edge edge, Face face) {

	    super();

	    this.vrtx = vrtx;

	    this.edge = edge;

	    this.face = face;

	}

    }



    /**

     *  () Otɒ_Ɩʂ𐶐B

     * <p>

     * ̃OtłȂꍇɂ́A

     * JgclFatal ̗O𔭐B

     * </p>

     *

     * @return	Vɐꂽ_Ɩ

     * @see	JgclFatal

     * @see	#killVertexFace()

     */

    public synchronized Result makeVertexFace() {

	if ((vrtxList.size() != 0) ||

	    (edgeList.size() != 0) ||

	    (faceList.size() != 0)) {

	    // Illegal State

	    throw new JgclFatal("The graph is not empty.");

	}



	Vertex newV = addVertex();

	Face   newF = addFace();



	newV.setFirstEdge(null);

	newF.setFirstEdge(null);



	return this.new Result(newV, null, newF);

    }



    /**

     *  (_Ɩʂ) OtA̒_Ɩʂ폜B

     * <p>

     * ̃Ot_Ɩʂ̂łȂꍇɂ́A

     * JgclFatal ̗O𔭐B

     * </p>

     *

     * @see	JgclFatal

     * @see	#makeVertexFace()

     */

    public synchronized void killVertexFace()

    {

	if ((vrtxList.size() != 1) ||

	    (edgeList.size() != 0) ||

	    (faceList.size() != 1)) {

	    // Illegal State

	    throw new JgclFatal("The graph does not have only 1 vertex & 1 face.");

	}



	removeVertex((Vertex)(vrtxList.elementAt(0)));

	removeFace((Face)(faceList.elementAt(0)));

    }



    /**

     * ̃Otɕӂƒ_𐶐B

     * <p>

     * _VȕӂL΂B

     * </p>

     * <p>

     * face 邢 vrtx ÃOtɊ܂܂ĂȂꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * </p>

     * <p>

     * vrtx  face ̒_TCNɊ܂܂ĂȂꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * </p>

     *

     * @param	face	̓ɐVȕӂL΂

     * @param	vrtx	Vȕӂ̎n_ƂȂ钸_

     * @return	Vɐꂽӂƒ_

     * @see	JgclInvalidArgumentValue

     * @see	#killEdgeVertex(JgclEmbeddedGraph.Edge)

     */

    public synchronized Result makeEdgeVertex(Face face,

					      Vertex vrtx)

    {

	if (contains(face) != true) {

	    throw new JgclInvalidArgumentValue("Given face is not in the graph.");

	}

	if (contains(vrtx) != true) {

	    throw new JgclInvalidArgumentValue("Given vertex is not in the graph.");

	}



	/*

	 * determine the location of 'vrtx' in 'face's edge cycle

	 */

	Edge firstE = face.getFirstEdge();	// first edge of 'face'

	Edge nextE = firstE;		// an edge that vertex is 'vrtx'

	Edge prevE = null;			// prev. of 'nextE'



	if (nextE != null) {

	    while (nextE.getVertex() != vrtx) {

		nextE = nextE.getNextEdge();

		if (nextE == firstE)

		    throw new JgclInvalidArgumentValue("Given vertex is not in given face.");

	    }

	    prevE = nextE.getPrevEdge();

	}



	/*

	 * make new edge and vertex

	 *

	 *			   newV +

	 *			       ^ |

	 *			  newE | | newM

	 *			       | V

	 *    vrtx +	  ====>	   vrtx +

	 *        ^ \		       ^ \

	 * prevE /   \ nextE	prevE /   \ nextE

	 *      /     V		     /     V

	 */

	Vertex newV = addVertex();

	Edge   newE = addEdge();

	Edge   newM = newE.getMate();



	newV.setFirstEdge(newM);



	newE.setVertex(vrtx);

	newE.setFace(face);

	newE.setPrevEdge((prevE != null) ? prevE : newM);

	newE.setNextEdge(newM);



	newM.setVertex(newV);

	newM.setFace(face);

	newM.setPrevEdge(newE);

	newM.setNextEdge((nextE != null) ? nextE : newE);



	if (nextE != null) {

	    prevE.setNextEdge(newE);

	    nextE.setPrevEdge(newM);

	} else {

	    face.setFirstEdge(newE);

	    vrtx.setFirstEdge(newE);

	}



	return this.new Result(newV, newE, null);

    }



    /**

     * ̃Otӂƒ_폜B

     * <p>

     * Ԃ牺ӂ폜B

     * </p>

     * <p>

     * edge ÃOtɊ܂܂ĂȂꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * </p>

     * <p>

     * edge Ԃ牺ӂłȂꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * ȂA̕ӂqĂԂ牺Ă悤ȏ󋵂ɂẮA

     * ̍Ő[ȊO̕ӂ́uԂ牺ĂvƂ݂͂ȂȂB

     * </p>

     *

     * @param	edge	폜

     * @see	JgclInvalidArgumentValue

     * @see	#makeEdgeVertex(JgclEmbeddedGraph.Face, JgclEmbeddedGraph.Vertex)

     */

    public synchronized void killEdgeVertex(Edge edge)

    {

	if (contains(edge) != true) {

	    throw new JgclInvalidArgumentValue("Given edge is not in the graph.");

	}



	Edge mate = edge.getMate();	// mate



	if (edge.getFace() != mate.getFace()) {

	    throw new JgclInvalidArgumentValue("Given edge is not dangling.");

	}



	/*  */ if ((edge.getNextEdge() == mate) && (mate.getPrevEdge() == edge)) {

	    ;	// nop

	} else if ((edge.getPrevEdge() == mate) && (mate.getNextEdge() == edge)) {

	    edge = mate;

	    mate = edge.getMate();

	} else {

	    throw new JgclInvalidArgumentValue("Given edge is not dangling.");

	}



	Face relatedF = edge.getFace();

	Vertex remainedV = edge.getVertex();

	Vertex removedV  = mate.getVertex();



	Edge prevE = edge.getPrevEdge();

	Edge nextE = mate.getNextEdge();



	prevE.setNextEdge(nextE);

	nextE.setPrevEdge(prevE);



	if (edge.isIdentWith(nextE) != true) {

	    if (edge.isIdentWith(remainedV.getFirstEdge()) == true)

		remainedV.setFirstEdge(nextE);

	    if (edge.isIdentWith(relatedF.getFirstEdge()) == true)

		relatedF.setFirstEdge(nextE);

	} else {

	    remainedV.setFirstEdge(null);

	    relatedF.setFirstEdge(null);

	}



	removeVertex(removedV);

	removeEdge(edge);

    }



    /**

     * ̃Otɒ_ƕӂ𐶐B

     * <p>

     * ӂɕB

     * </p>

     * <p>

     * edge ÃOtɊ܂܂ĂȂꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * </p>

     *

     * @param	edge	

     * @return	Vɐꂽ_ƕ

     * @see	JgclInvalidArgumentValue

     * @see	#killVertexEdge(JgclEmbeddedGraph.Vertex, JgclEmbeddedGraph.Edge)

     */

    public synchronized Result makeVertexEdge(Edge edge)

    {

	if (contains(edge) != true) {

	    throw new JgclInvalidArgumentValue("Given edge is not in the graph.");

	}



	Vertex newV = addVertex();

	Edge   newE = addEdge();



	Edge   newM = newE.getMate();

	Edge   mate = edge.getMate();

	Edge   nextE = edge.getNextEdge();

	Edge   prevE = mate.getPrevEdge();



	/*

	 *      ^      /	      ^      /

	 * nextE \    / prevE	 nextE \    / prevE

	 *        \  V		        \  V

	 *          +		          +

	 *         ^ |		         ^ |

	 *         | |   	    newE | | newM

	 *         | |	  ====>	         | V

	 *         | |		     newV +

	 *         | |		         ^ |

	 *    edge | | mate	    edge | | mate

	 *         | V		         | V

	 *          +		          +

	 */



	newE.setVertex(newV);

	newE.setFace(edge.getFace());

	newE.setPrevEdge(edge);

	newE.setNextEdge(nextE);



	newM.setVertex(mate.getVertex());

	newM.setFace(mate.getFace());

	newM.setPrevEdge(prevE);

	newM.setNextEdge(mate);



	edge.setNextEdge(newE);

	mate.setVertex(newV);

	mate.setPrevEdge(newM);



	nextE.setPrevEdge(newE);

	prevE.setNextEdge(newM);



	newV.setFirstEdge(newE);

	newM.getVertex().setFirstEdge(newM);



	return this.new Result(newV, newE, null);

    }



    /**

     * ̃Ot璸_ƕӂ폜B

     * <p>

     * ̕ӂԒ_폜B

     * </p>

     * <p>

     * vrtx 邢 edge ÃOtɊ܂܂ĂȂꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * </p>

     * <p>

     * edge  vrtx ɌqĂȂꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * </p>

     * <p>

     * vrtx ɌqĂӂ̐ 2 ȊȌꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * </p>

     *

     * @param	vrtx	폜钸_

     * @param	edge	폜

     * @see	JgclInvalidArgumentValue

     * @see	#makeVertexEdge(JgclEmbeddedGraph.Edge)

     */

    public synchronized void killVertexEdge(Vertex vrtx,

					    Edge edge)

    {

	if (contains(vrtx) != true) {

	    throw new JgclInvalidArgumentValue("Given vertex is not in the graph.");

	}



	if (contains(edge) != true) {

	    throw new JgclInvalidArgumentValue("Given edge is not in the graph.");

	}



	/*

	 * target vertex should have 2 edges

	 */

	Edge firstE = vrtx.getFirstEdge();

	if (firstE == null) {

	    throw new JgclInvalidArgumentValue("No edge is attached to given vertex.");

	}



	Edge secondE = vrtx.getNextEdgeInCCW(firstE);

	if (secondE == null) {

	    throw new JgclInvalidArgumentValue("Only 1 edge is attached to given vertex.");

	}



	Edge thirdE = vrtx.getNextEdgeInCCW(secondE);

	if (thirdE.isIdentWith(firstE) != true) {

	    throw new JgclInvalidArgumentValue("3 or more edges are attached to given vertex.");

	}



	/*

	 * determine the relations between edges

	 */

	Edge edge1;

	Edge mate1;

	Edge edge2;

	Edge mate2;



	if (edge.isIdentWith(firstE) == true) {

	    edge1 = firstE;

	    mate2 = secondE;

	} else if (edge.isIdentWith(secondE) == true) {

	    edge1 = secondE;

	    mate2 = firstE;

	} else {

	    throw new JgclInvalidArgumentValue("Given edge is not attached to given vertex.");

	}



	mate1 = edge1.getMate();

	edge2 = mate2.getMate();



	Edge nextE = edge1.getNextEdge();

	Edge prevE = mate1.getPrevEdge();



	Vertex vrtx1 = vrtx;

	Vertex vrtx2 = mate1.getVertex();



	/*

	 *     ^      /	          ^      /

	 *   ne \    / pm	ne \    / pm

	 *       \  V		    \  V

	 *  vrtx2  +		vrtx2 +

	 *        ^ |		     ^ |

	 *  edge1 | | mate1	     | |

	 *        | V	  ====>	     | |

	 *  vrtx1  +		     | |

	 *        ^ |		     | |

	 *  edge2 | | mate2    edge2 | | mate2

	 *        | V		     | V

	 *         +		      +

	 */

	if (nextE != mate1) {

	    edge2.setNextEdge(nextE);

	    nextE.setPrevEdge(edge2);

	} else {

	    edge2.setNextEdge(mate2);

	}



	if (prevE != edge1) {

	    mate2.setPrevEdge(prevE);

	    prevE.setNextEdge(mate2);

	} else {

	    mate2.setPrevEdge(edge2);

	}



	mate2.setVertex(vrtx2);



	if (edge1.isIdentWith(vrtx2.getFirstEdge()) == true)

	    vrtx2.setFirstEdge(mate2);



	removeVertex(vrtx1);

	removeEdge(edge1);

    }



    /**

     * ̃OtɕӂƖʂ𐶐B

     * <p>

     * ʂɕB

     * </p>

     * <p>

     * w肵 face ͏ɐVɐӂ̍ʂƂĎcB

     * </p>

     * <p>

     * ̃\bh́A^ꂽ_^Ӂ^ʂ̊Ԃ̐`FbNȂB

     * </p>

     *

     * @param	face	

     * @param	headVrtx	Vɐӂ̎n_ƂȂ钸_

     * @param	nextHead	Vɐӂ̉Eʂ̎ɂȂ

     * @param	prevHead	Vɐӂ̍ʂ̑OɂȂ

     * @param	tailVrtx	Vɐӂ̏I_ƂȂ钸_

     * @param	nextTail	Vɐӂ̍ʂ̎ɂȂ

     * @param	prevTail	Vɐӂ̉Eʂ̑OɂȂ

     * @return	VɐꂽӂƖ

     * @see	#makeEdgeFace(JgclEmbeddedGraph.Face, JgclEmbeddedGraph.Vertex, JgclEmbeddedGraph.Vertex)

     * @see	#makeEdgeFace(JgclEmbeddedGraph.Face, JgclEmbeddedGraph.Vertex, JgclEmbeddedGraph.Vertex, JgclEmbeddedGraph.Edge, JgclEmbeddedGraph.Edge)

     */

    private Result makeEdgeFace(Face face,

				Vertex headVrtx,

				Edge nextHead,

				Edge prevHead,

				Vertex tailVrtx,

				Edge nextTail,

				Edge prevTail) {

	Face newF = addFace();

	Edge newE = addEdge();

	Edge newM = newE.getMate();



	/*

	 *          tailV                         tailV

	 *     nextT    prevT		     nextT    prevT

	 *    <----- + <-----		    <----- + <-----

	 * 					  ^ |  newF

	 *    			   ====>      newE| |newM

	 *    face			    face  | V

	 *    -----> + ----->		    -----> + ----->

	 *    prevH    nextH		    prevH    nextH

	 *         headV                         headV

	 */



	face.setFirstEdge(newE);

	newF.setFirstEdge(newM);



	newE.setVertex(headVrtx);

	newE.setFace(face);

	newE.setPrevEdge(prevHead);

	newE.setNextEdge(nextTail);



	newM.setVertex(tailVrtx);

	newM.setFace(newF);

	newM.setPrevEdge(prevTail);

	newM.setNextEdge(nextHead);



	prevHead.setNextEdge(newE);

	prevTail.setNextEdge(newM);



	nextHead.setPrevEdge(newM);

	nextTail.setPrevEdge(newE);



	Edge edge = nextHead;

	while (edge != newM) {

	    edge.setFace(newF);

	    edge = edge.getNextEdge();

	}



	return this.new Result(null, newE, newF);

    }



    /**

     * ̃OtɕӂƖʂ𐶐B

     * <p>

     * ʂɕB

     * </p>

     * <p>

     * w肵 face ͏ɐVɐӂ̍ʂƂĎcB

     * </p>

     * <p>

     * ̃\bh́A̓ɂԂ牺ӂȂʂ𕪊ꍇz肵ĂB

     * Ԃ牺ӂȂʂÂԂ牺ӂ̍{̒_ŕꍇɂ́A

     * {@link #makeEdgeFace(JgclEmbeddedGraph.Face, JgclEmbeddedGraph.Vertex, JgclEmbeddedGraph.Vertex, JgclEmbeddedGraph.Edge, JgclEmbeddedGraph.Edge)

     * makeEdgeFace(Face, Vertex, Vertex, Edge, Edge)}

     * 𗘗pȂ΂ȂȂB

     * </p>

     * <p>

     * face 邢 headVrtx, tailVrtx ÃOtɊ܂܂ĂȂꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * </p>

     * <p>

     * headVrtx, tailVrtx  face ̒_TCNɊ܂܂ĂȂꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * </p>

     * <p>

     * headVrtx  tailVrtx ̒_łꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * </p>

     *

     * @param	face	

     * @param	headVrtx	Vɐӂ̎n_ƂȂ钸_

     * @param	tailVrtx	Vɐӂ̏I_ƂȂ钸_

     * @return	VɐꂽӂƖ

     * @see	JgclInvalidArgumentValue

     * @see	#killEdgeFace(JgclEmbeddedGraph.Edge, JgclEmbeddedGraph.Face)

     */

    public synchronized Result makeEdgeFace(Face face,

					    Vertex headVrtx,

					    Vertex tailVrtx)

    {

	if (contains(face) != true) {

	    throw new JgclInvalidArgumentValue("Given face is not in the graph.");

	}



	if ((contains(headVrtx) != true) || (contains(tailVrtx) != true)) {

	    throw new JgclInvalidArgumentValue("Given vertex is not in the graph.");

	}



	if (headVrtx.isIdentWith(tailVrtx) == true) {

	    throw new JgclInvalidArgumentValue("Given vertices are ideitical.");

	}



	Edge firstE = face.getFirstEdge();

	Edge edge = firstE;



	if (firstE == null) {

	    throw new JgclInvalidArgumentValue("Given face can not be divided.");

	}



	Edge nextHead = null;

	Edge nextTail = null;

	Edge prevHead = null;

	Edge prevTail = null;



	while (true) {

	    if ((headVrtx.isIdentWith(edge.getVertex()) == true) && (nextHead == null)) {

		nextHead = edge;

		prevHead = nextHead.getPrevEdge();

	    }



	    if ((tailVrtx.isIdentWith(edge.getVertex()) == true) && (nextTail == null)) {

		nextTail = edge;

		prevTail = nextTail.getPrevEdge();

	    }

	

	    if ((nextHead != null) && (nextTail != null))

		break;



	    if ((edge = edge.getNextEdge()) == firstE) {

		throw new JgclInvalidArgumentValue("Given vertices are not in given face.");

	    }

	}



	return makeEdgeFace(face, headVrtx, nextHead, prevHead, tailVrtx, nextTail, prevTail);

    }



    /**

     * ̃OtɕӂƖʂ𐶐B

     * <p>

     * ʂɕB

     * </p>

     * <p>

     * w肵 face ͏ɐVɐӂ̍ʂƂĎcB

     * </p>

     * <p>

     * ̃\bh́A̓ɂԂ牺ӂ悤Ȗʂ

     * ̂Ԃ牺ӂ̍{̒_ŕ悤ȏꍇz肵ĂB

     * Ԃ牺ӂȂʂ𕪊ꍇɂ́A

     * 킴킴ӂw肷Kv̖\bh

     * {@link #makeEdgeFace(JgclEmbeddedGraph.Face, JgclEmbeddedGraph.Vertex, JgclEmbeddedGraph.Vertex)

     * makeEdgeFace(Face, Vertex, Vertex)}

     * 𗘗pȒPłB

     * </p>

     * <p>

     * ^ꂽʁ^_^ӂ̂ꂩÃOtɊ܂܂ĂȂꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * </p>

     * <p>

     * headVrtx, tailVrtx  face ̒_TCNɊ܂܂ĂȂꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * </p>

     * <p>

     * headVrtx  tailVrtx ̒_łꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * </p>

     * <p>

     * headVrtx  headEdge ̒[_łȂꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * </p>

     * <p>

     * tailVrtx  tailEdge ̒[_łȂꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * </p>

     *

     * @param	face	

     * @param	headVrtx	Vɐӂ̎n_ƂȂ钸_

     * @param	tailVrtx	Vɐӂ̏I_ƂȂ钸_

     * @param	headEdge	Vɐӂ̉Eʂ̎ɂȂ

     * @param	tailEdge	Vɐӂ̍ʂ̎ɂȂ

     * @return	VɐꂽӂƖ

     * @see	JgclInvalidArgumentValue

     * @see	#killEdgeFace(JgclEmbeddedGraph.Edge, JgclEmbeddedGraph.Face)

     */

    public synchronized Result makeEdgeFace(Face face,

					    Vertex headVrtx,

					    Vertex tailVrtx,

					    Edge headEdge,

					    Edge tailEdge)

    {

	if (contains(face) != true) {

	    throw new JgclInvalidArgumentValue("Given face is not in the graph.");

	}



	if ((contains(headVrtx) != true) || (contains(tailVrtx) != true)) {

	    throw new JgclInvalidArgumentValue("Given vertex is not in the graph.");

	}



	if ((contains(headEdge) != true) || (contains(tailEdge) != true)) {

	    throw new JgclInvalidArgumentValue("Given edge is not in the graph.");

	}



	if (headVrtx.isIdentWith(tailVrtx) == true) {

	    throw new JgclInvalidArgumentValue("Given vertices are ideitical.");

	}



	Edge nextHead = null;

	Edge prevHead = null;



	if (headVrtx.isIdentWith(headEdge.getVertex()) == true) {

	    nextHead = headEdge;

	} else if (headVrtx.isIdentWith(headEdge.getMate().getVertex()) == true) {

	    nextHead = headEdge.getMate();

	} else {

	    throw new JgclInvalidArgumentValue("Given edge is not attached to given vertex.");

	}



	prevHead = nextHead.getPrevEdge();



	if ((face.isIdentWith(nextHead.getFace()) != true) ||

	    (face.isIdentWith(prevHead.getFace()) != true)) {

	    throw new JgclInvalidArgumentValue("Given edge is not attached to given face.");

	}



	Edge nextTail = null;

	Edge prevTail = null;



	if (tailVrtx.isIdentWith(tailEdge.getVertex()) == true) {

	    nextTail = tailEdge;

	} else if (tailVrtx.isIdentWith(tailEdge.getMate().getVertex()) == true) {

	    nextTail = tailEdge.getMate();

	} else {

	    throw new JgclInvalidArgumentValue("Given edge is not attached to given vertex.");

	}



	prevTail = nextTail.getPrevEdge();



	if ((face.isIdentWith(nextTail.getFace()) != true) ||

	    (face.isIdentWith(prevTail.getFace()) != true)) {

	    throw new JgclInvalidArgumentValue("Given edge is not attached to given face.");

	}



	return makeEdgeFace(face, headVrtx, nextHead, prevHead, tailVrtx, nextTail, prevTail);

    }



    /**

     * ̃OtӂƖʂ폜B

     * <p>

     * ̖ʂ𕪂Ăӂ폜B

     * </p>

     * <p>

     * edge 邢 face ÃOtɊ܂܂ĂȂꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * </p>

     * <p>

     * edge  face ̕ӃTCNɊ܂܂ĂȂꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * </p>

     * <p>

     * edge Ԃ牺ӂłꍇɂ

     * JgclInvalidArgumentValue ̗O𔭐B

     * ȂA̕ӂqĂԂ牺Ă悤ȏ󋵂ɂẮA

     * ׂ̂Ă̕ӂuԂ牺ĂvƂ݂ȂB

     * </p>

     *

     * @param	edge	폜

     * @param	face	폜

     * @see	JgclInvalidArgumentValue

     * @see	#makeEdgeFace(JgclEmbeddedGraph.Face, JgclEmbeddedGraph.Vertex, JgclEmbeddedGraph.Vertex)

     * @see	#makeEdgeFace(JgclEmbeddedGraph.Face, JgclEmbeddedGraph.Vertex, JgclEmbeddedGraph.Vertex, JgclEmbeddedGraph.Edge, JgclEmbeddedGraph.Edge)

     */

    public synchronized void killEdgeFace(Edge edge, Face face)

    {

	if (contains(edge) != true) {

	    throw new JgclInvalidArgumentValue("Given edge is not in the graph.");

	}



	if (contains(face) != true) {

	    throw new JgclInvalidArgumentValue("Given face is not in the graph.");

	}



	Edge mate = edge.getMate();



	if (edge.getFace().isIdentWith(mate.getFace()) == true) {

	    throw new JgclInvalidArgumentValue("Given edge is dangling.");

	}



	/*  */ if (face.isIdentWith(edge.getFace()) == true) {

	    edge = mate;

	    mate = edge.getMate();

	} else if (face.isIdentWith(mate.getFace()) == true) {

	    ; // nop

	} else {

	    throw new JgclInvalidArgumentValue("Given edge is not in given face.");

	}



	Face remainedF = edge.getFace();

	if (edge.isIdentWith(remainedF.getFirstEdge()) == true) {

	    remainedF.setFirstEdge(edge.getPrevEdge());

	}



	/*

	 *    <----- + <-----		    <----- + <-----

	 * 	    ^ |  face

	 *     edge | | mate	   ====>

	 *  remainF | V			  remainF

	 *    -----> + ----->		    -----> + ----->

	 *    prevE    nextE		    prevE    nextE

	 */



	for (int i = 0; i < 2; i++) {

	    Edge prevE = edge.getPrevEdge();

	    Edge nextE = mate.getNextEdge();



	    prevE.setNextEdge(nextE);

	    nextE.setPrevEdge(prevE);



	    if (edge.isIdentWith(edge.getVertex().getFirstEdge()) == true) {

		edge.getVertex().setFirstEdge(nextE);

	    }



	    edge = mate;

	    mate = edge.getMate();

	}



	removeFace(face);

	removeEdge(edge);



	Edge firstE = remainedF.getFirstEdge();

	edge = firstE;

	do {

	    edge.setFace(remainedF);

	    edge = edge.getNextEdge();

	} while (edge != firstE);

    }



    /**

     * ̃Ot̕ԂB

     *

     * @return	ꂽOt

     * @see	#copy()

     * @see	#copy(JgclEmbeddedGraph)

     */

    protected java.lang.Object clone() {

	return this.copy();

    }



    /**

     * ̃Ot̕ԂB

     * <p>

     * ̃\bh͈̏ȉ̒ʂB

     * <pre>

     *		return copy(new JgclEmbeddedGraph());

     * </pre>

     * </p>

     *

     * @return	ꂽOt

     * @see	#clone()

     * @see	#copy(JgclEmbeddedGraph)

     * @see	#JgclEmbeddedGraph()

     */

    public synchronized JgclEmbeddedGraph copy() {

	return copy(new JgclEmbeddedGraph());

    }



    /**

     * ̃Ot̕ԂB

     * <p>

     * seed ɂ́A\z΂̋̃Ot^B

     * </p>

     *

     * @param seed	ꂽʑێ邽߂̃Ot

     * @return	ꂽOt

     * @see	#clone()

     * @see	#copy()

     */

    public synchronized JgclEmbeddedGraph copy(JgclEmbeddedGraph seed) {

	JgclEmbeddedGraph replica = seed;

	Enumeration e;



	/*

	 * make new items

	 */

	for (e = this.vrtxList.elements(); e.hasMoreElements();) {

	    Vertex src = (Vertex)e.nextElement();

	    Vertex dst = replica.addVertex();

	    src.setReplica(dst);

	}



	for (e = this.faceList.elements(); e.hasMoreElements();) {

	    Face src = (Face)e.nextElement();

	    Face dst = replica.addFace();

	    src.setReplica(dst);

	}



	for (e = this.edgeList.elements(); e.hasMoreElements();) {

	    EdgeContainer src = (EdgeContainer)e.nextElement();

	    EdgeContainer dst = replica.addEdge().getContainer();

	    src.setReplica(dst);

	}



	/*

	 * fill new items

	 */

	for (e = this.vrtxList.elements(); e.hasMoreElements();) {

	    Vertex src = (Vertex)e.nextElement();

	    src.fillFieldsOfReplica();

	}



	for (e = this.faceList.elements(); e.hasMoreElements();) {

	    Face src = (Face)e.nextElement();

	    src.fillFieldsOfReplica();

	}



	for (e = this.edgeList.elements(); e.hasMoreElements();) {

	    EdgeContainer src = (EdgeContainer)e.nextElement();

	    src.fillFieldsOfReplica();

	}



	/*

	 * clear replica field

	 */

	for (e = this.vrtxList.elements(); e.hasMoreElements();) {

	    Vertex src = (Vertex)e.nextElement();

	    src.setReplica(null);

	}



	for (e = this.faceList.elements(); e.hasMoreElements();) {

	    Face src = (Face)e.nextElement();

	    src.setReplica(null);

	}



	for (e = this.edgeList.elements(); e.hasMoreElements();) {

	    EdgeContainer src = (EdgeContainer)e.nextElement();

	    src.setReplica(null);

	}



	return replica;

    }



    /**

     * ̃Ot̑oΕԂB

     * <p>

     * ̃\bh͈̏ȉ̒ʂB

     * <pre>

     *		return dualCopy(new JgclEmbeddedGraph());

     * </pre>

     * </p>

     *

     * @return oΕꂽOt

     * @see	#dualCopy(JgclEmbeddedGraph)

     * @see	#JgclEmbeddedGraph()

     */

    public synchronized JgclEmbeddedGraph dualCopy() {

	return dualCopy(new JgclEmbeddedGraph());

    }



    /**

     * ̃Ot̑oΕԂB

     * <p>

     * seed ɂ́A\z΂̋̃Ot^B

     * </p>

     *

     * @param seed	oΕꂽʑێ邽߂̃Ot

     * @return oΕꂽOt

     * @see	#dualCopy()

     */

    public synchronized JgclEmbeddedGraph dualCopy(JgclEmbeddedGraph seed) {

	JgclEmbeddedGraph replica = seed;

	Enumeration e;



	/*

	 * make new items

	 */

	for (e = this.vrtxList.elements(); e.hasMoreElements();) {

	    Vertex src = (Vertex)e.nextElement();

	    Face   dst = replica.addFace();

	    src.setReplica(dst);

	}



	for (e = this.faceList.elements(); e.hasMoreElements();) {

	    Face   src = (Face)e.nextElement();

	    Vertex dst = replica.addVertex();

	    src.setReplica(dst);

	}



	for (e = this.edgeList.elements(); e.hasMoreElements();) {

	    EdgeContainer src = (EdgeContainer)e.nextElement();

	    EdgeContainer dst = replica.addEdge().getContainer();

	    src.setReplica(dst);

	}



	/*

	 * fill new items

	 */

	for (e = this.vrtxList.elements(); e.hasMoreElements();) {

	    Vertex src = (Vertex)e.nextElement();

	    src.fillFieldsOfDualReplica();

	}



	for (e = this.faceList.elements(); e.hasMoreElements();) {

	    Face src = (Face)e.nextElement();

	    src.fillFieldsOfDualReplica();

	}



	for (e = this.edgeList.elements(); e.hasMoreElements();) {

	    EdgeContainer src = (EdgeContainer)e.nextElement();

	    src.fillFieldsOfDualReplica();

	}



	/*

	 * fille edge's previous and next edge fields

	 */

	for (e = this.vrtxList.elements(); e.hasMoreElements();) {

	    Vertex vrtx = (Vertex)e.nextElement();

	    Edge firstE = vrtx.getFirstEdge();

	    Edge edge = firstE;



	    if (firstE == null)

		continue;



	    Edge firstReplicaEdge = edge.getMate().getReplica();

	    Edge prevReplicaEdge = firstReplicaEdge;

	    Edge crntReplicaEdge = null;



	    edge = vrtx.getNextEdgeInCCW(edge);

	    while (edge.isIdentWith(firstE) != true) {

		crntReplicaEdge = edge.getMate().getReplica();

		prevReplicaEdge.setNextEdge(crntReplicaEdge);

		crntReplicaEdge.setPrevEdge(prevReplicaEdge);

		prevReplicaEdge = crntReplicaEdge;

		edge = vrtx.getNextEdgeInCCW(edge);

	    }



	    crntReplicaEdge = firstReplicaEdge;

	    prevReplicaEdge.setNextEdge(crntReplicaEdge);

	    crntReplicaEdge.setPrevEdge(prevReplicaEdge);

	}



	/*

	 * clear replica field

	 */

	for (e = this.vrtxList.elements(); e.hasMoreElements();) {

	    Vertex src = (Vertex)e.nextElement();

	    src.setReplica(null);

	}



	for (e = this.faceList.elements(); e.hasMoreElements();) {

	    Face src = (Face)e.nextElement();

	    src.setReplica(null);

	}



	for (e = this.edgeList.elements(); e.hasMoreElements();) {

	    EdgeContainer src = (EdgeContainer)e.nextElement();

	    src.setReplica(null);

	}



	return replica;

    }

}



// end of file

