/*
 * Q : (`vf̑ݔ͈͂) ӂɕsȋ`\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclEnclosingBox2D.java,v 1.5 2000/04/26 09:38:54 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * Q : (`vf̑ݔ͈͂) ӂɕsȋ`\NXB
 * <p>
 * ̃NX̃CX^X́A
 * `
 * ̓_ (ŏl) \_ min
 * 
 * E̓_ (ől) \_ max
 * ێB
 * </p>
 *
 * @version $Revision: 1.5 $, $Date: 2000/04/26 09:38:54 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclEnclosingBox2D {
    /**
     * ̓_ (ŏl) \_
     */
    private final JgclPoint2D min;

    /**
     * E̓_ (ől) \_ max
     */
    private final JgclPoint2D max;

    /**
     * `̍ŏ/ől\_^ăIuWFNg\zB
     * <p>
     * min ̂鐬 max ̑Ή鐬傫ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param min	`̍ŏl\_
     * @param max	`̍ől\_
     * @see	JgclInvalidArgumentValue
     */
    public JgclEnclosingBox2D(JgclPoint2D min, JgclPoint2D max) {
	super();
	if (min.x() > max.x() || min.y() > max.y())
	    throw new JgclInvalidArgumentValue();
	this.min = min;
	this.max = max;
    }

    /**
     * `̍ŏ/ől\_̍Wl^ăIuWFNg\zB
     * <p>
     * minX  maxX 傫ꍇ
     * 邢
     * minY  maxY 傫ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param minX	`̍ŏl\_ X Wl
     * @param minY	`̍ŏl\_ Y Wl
     * @param maxX	`̍ől\_ X Wl
     * @param maxY	`̍ől\_ Y Wl
     * @see	JgclInvalidArgumentValue
     */
    public JgclEnclosingBox2D(double minX, double minY, double maxX, double maxY) {
	super();
	if (minX > maxX || minY > maxY)
	    throw new JgclInvalidArgumentValue();
	this.min = new JgclCartesianPoint2D(minX, minY);
	this.max = new JgclCartesianPoint2D(maxX, maxY);
    }

    /**
     * ^ꂽ_Q߂ŏ̋`\IuWFNg\zB
     * <p>
     * `́A^ꂽ_Qɑ΂ă}[W܂܂ȂB
     * </p>
     *
     * @param points	`Ɏ܂ׂ_Q
     */
    public JgclEnclosingBox2D(JgclPoint2D[] points) {
	super();

	double max_x;
	double max_y;
	double min_x;
	double min_y;

	min_x = max_x = points[0].x();
	min_y = max_y = points[0].y();

	for (int i = 1; i < points.length; i++) {
	    if (max_x < points[i].x()) max_x = points[i].x();
	    if (max_y < points[i].y()) max_y = points[i].y();
	    if (min_x > points[i].x()) min_x = points[i].x();
	    if (min_y > points[i].y()) min_y = points[i].y();
	}

	this.min = new JgclCartesianPoint2D(min_x, min_y);
	this.max = new JgclCartesianPoint2D(max_x, max_y);
    }

    /**
     * ̋`̍̓_ (ŏl) \_ԂB
     *
     * @return	ŏl\_
     */
    public JgclPoint2D min() {
	return this.min;
    }

    /**
     * ̋`̉E̓_ (ől) \_ԂB
     *
     * @return	ől\_
     */
    public JgclPoint2D max() {
	return this.max;
    }

    /**
     * ̋`̍ŏl/őlӂޔzԂB
     * <p>
     * ʂƂēz̗vf 2 ŁA
     * ŏ̗vfɍŏlAԖڂ̗vfɍől܂ށB
     * </p>
     *
     * @return	ŏl/őlӂޔz
     */
    public JgclPoint2D[] toArray() {
	JgclPoint2D[] array = new JgclPoint2D[2];
	array[0] = this.min;
	array[1] = this.max;
	return array;
    }

    /**
     * ̋`^ꂽ̋`ƌ邩ۂԂB
     * <p>
     * ܂ޏꍇuvƂ݂ȂB
     * </p>
     * <p>
     * 邩ۂ̔fɂ́Aݐݒ肳Ă鉉Z̋̋e덷lB
     * </p>
     *
     * @param mate	̋`
     * @return	Ȃ trueAłȂ false
     * @see	JgclConditionOfOperation
     */
    public boolean hasIntersection(JgclEnclosingBox2D mate) {
	double d_tol = JgclConditionOfOperation.getCondition().getToleranceForDistance();

	if ((min().x() > mate.max().x() + d_tol) ||
	    (min().y() > mate.max().y() + d_tol) ||
	    (mate.min().x() > max().x() + d_tol) ||
	    (mate.min().y() > max().y() + d_tol))
	    return false;
	return true;
    }
}


