/*
 * R : (`vf̑ݔ͈͂) ӂɕsȒ̂\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclEnclosingBox3D.java,v 1.5 2000/04/26 09:38:54 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * R : (`vf̑ݔ͈͂) ӂɕsȒ̂\NXB
 * <p>
 * ̃NX̃CX^X́A
 * ̂
 * XYZ ꂼ̒lŏł_ (ŏl) min
 * 
 * XYZ ꂼ̒lőł_ (ől) max
 * ێB
 * </p>
 *
 * @version $Revision: 1.5 $, $Date: 2000/04/26 09:38:54 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclEnclosingBox3D {
    /**
     * XYZ ꂼ̒lŏł_ (ŏl)
     */
    private final JgclPoint3D min;

    /**
     * XYZ ꂼ̒lőł_ (ől)
     */
    private final JgclPoint3D max;

    /**
     * ̂̍ŏ/ől\_^ăIuWFNg\zB
     * <p>
     * min ̂鐬 max ̑Ή鐬傫ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param min	̂̍ŏl\_
     * @param max	̂̍ől\_
     * @see	JgclInvalidArgumentValue
     */
    public JgclEnclosingBox3D(JgclPoint3D min, JgclPoint3D max) {
	super();
	if (min.x() > max.x() || min.y() > max.y() || min.z() > max.z())
	    throw new JgclInvalidArgumentValue();
	this.min = min;
	this.max = max;
    }

    /**
     * ̂̍ŏ/ől\_̍Wl^ăIuWFNg\zB
     * <p>
     * minX  maxX 傫ꍇA
     * minY  maxY 傫ꍇ
     * 邢
     * minZ  maxZ 傫ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param minX	̂̍ŏl\_ X Wl
     * @param minY	̂̍ŏl\_ Y Wl
     * @param minZ	̂̍ŏl\_ Z Wl
     * @param maxX	̂̍ől\_ X Wl
     * @param maxY	̂̍ől\_ Y Wl
     * @param maxZ	̂̍ől\_ Z Wl
     * @see	JgclInvalidArgumentValue
     */
    public JgclEnclosingBox3D(double minX, double minY, double minZ,
			      double maxX, double maxY, double maxZ) {
	super();
	if (minX > maxX || minY > maxY || minZ > maxZ)
	    throw new JgclInvalidArgumentValue();
	this.min = new JgclCartesianPoint3D(minX, minY, minZ);
	this.max = new JgclCartesianPoint3D(maxX, maxY, maxZ);
    }

    /**
     * ^ꂽ_Q߂ŏ̒̂\IuWFNg\zB
     * <p>
     * 钼̂́A^ꂽ_Qɑ΂ă}[W܂܂ȂB
     * </p>
     *
     * @param points	̂Ɏ܂ׂ_Q
     */
    public JgclEnclosingBox3D(JgclPoint3D[] points) {
	super();

	double max_x;
	double max_y;
	double max_z;
	double min_x;
	double min_y;
	double min_z;

	min_x = max_x = points[0].x();
	min_y = max_y = points[0].y();
	min_z = max_z = points[0].z();

	for (int i = 1; i < points.length; i++) {
	    if (max_x < points[i].x()) max_x = points[i].x();
	    if (max_y < points[i].y()) max_y = points[i].y();
	    if (max_z < points[i].z()) max_z = points[i].z();
	    if (min_x > points[i].x()) min_x = points[i].x();
	    if (min_y > points[i].y()) min_y = points[i].y();
	    if (min_z > points[i].z()) min_z = points[i].z();
	}

	this.min = new JgclCartesianPoint3D(min_x, min_y, min_z);
	this.max = new JgclCartesianPoint3D(max_x, max_y, max_z);
    }

    /**
     * ̒̂̍ŏl\_ԂB
     *
     * @return	ŏl\_
     */
    public JgclPoint3D min() {
	return this.min;
    }

    /**
     * ̒̂̍ől\_ԂB
     *
     * @return	ől\_
     */
    public JgclPoint3D max() {
	return this.max;
    }

    /**
     * ̋`̍ŏl/őlӂޔzԂB
     * <p>
     * ʂƂēz̗vf 2 ŁA
     * ŏ̗vfɍŏlAԖڂ̗vfɍől܂ށB
     * </p>
     *
     * @return	ŏl/őlӂޔz
     */
    public JgclPoint3D[] toArray() {
	JgclPoint3D[] array = new JgclPoint3D[2];
	array[0] = this.min;
	array[1] = this.max;
	return array;
    }

    /**
     * ̋`^ꂽ̋`ƌ邩ۂԂB
     * <p>
     * ܂ޏꍇuvƂ݂ȂB
     * </p>
     * <p>
     * 邩ۂ̔fɂ́Aݐݒ肳Ă鉉Z̋̋e덷lB
     * </p>
     *
     * @param mate	̋`
     * @return	Ȃ trueAłȂ false
     * @see	JgclConditionOfOperation
     */
    public boolean hasIntersection(JgclEnclosingBox3D mate) {
	double d_tol = JgclConditionOfOperation.getCondition().getToleranceForDistance();

	if ((min().x() > mate.max().x() + d_tol) ||
	    (min().y() > mate.max().y() + d_tol) ||
	    (min().z() > mate.max().z() + d_tol) ||
	    (mate.min().x() > max().x() + d_tol) ||
	    (mate.min().y() > max().y() + d_tol) ||
	    (mate.min().z() > max().z() + d_tol))
	    return false;
	return true;
    }
}


