/*
 * R : tBbg̒fʂ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclFilletSection3D.java,v 1.11 2000/04/26 09:38:55 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : tBbg̒fʂ\NXB
 * <p>
 * ̃NX́A􉽗vfɐڂ~ʂ̋O (tBbgƂ) 
 * fʂ\B
 * </p>
 * <p>
 * ̃NX̃CX^X
 * <ul>
 * <li> tBbgfʂ̔a radius
 * <li> tBbgfʂ̒S center
 * <li> tBbgfʂ̊􉽗vf (􉽗vf 1) Ɛڂ_ pointOnGeometry1
 * <li> tBbgfʂ̊􉽗vf (􉽗vf 2) Ɛڂ_ pointOnGeometry2
 * </ul>
 * ێB
 * </p>
 *
 * @version $Revision: 1.11 $, $Date: 2000/04/26 09:38:55 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclFilletObject3D
 */

public class JgclFilletSection3D extends JgclNonParametricCurve3D {

    /**
     * tBbgfʂ̔aB
     * @serial
     */
    private double radius;

    /**
     * tBbgfʂ̒SB
     * @serial
     */
    private JgclPoint3D center;

    /**
     * 􉽗vf 1 ̓_B
     * @serial
     */
    private JgclPointOnGeometry3D pointOnGeometry1;

    /**
     * 􉽗vf 2 ̓_B
     * @serial
     */
    private JgclPointOnGeometry3D pointOnGeometry2;

    /**
     * etB[hɐݒ肷l^ăIuWFNg\zB
     * <p>
     * ܂̂ƂApubic ȃRXgN^ł͂Ȃ߁Ã`FbNsĂȂB
     * publicɂKvoꍇ́AdoCheck ̂KvB
     * </p>
     * 
     * @param radius	tBbgfʂ̔a
     * @param center	tBbgfʂ̒S
     * @param pointOnGeometry1	􉽗vf 1 ̓_
     * @param pointOnGeometry2	􉽗vf 2 ̓_
     */
    JgclFilletSection3D(double radius, JgclPoint3D center,
			JgclPointOnGeometry3D pointOnGeometry1,
			JgclPointOnGeometry3D pointOnGeometry2) {
	super();
	this.radius = radius;
	this.center = center;
	this.pointOnGeometry1 = pointOnGeometry1;
	this.pointOnGeometry2 = pointOnGeometry2;
    }
	
    /**
     * ̃tBbgfʂ̔aԂB
     * 
     * @return	tBbg̔a
     */
    public double radius() {
	return this.radius;
    }

    /**
     * ̃tBbgfʂ̒SԂB
     * 
     * @return	tBbg̒S
     */
    public JgclPoint3D center() {
	return this.center;
    }

    /**
     * ̃tBbgfʂ̊􉽗vf 1 ̓_ԂB
     * 
     * @return	􉽗vf 1 ̓_
     */
    public JgclPointOnGeometry3D pointOnGeometry1() {
	return this.pointOnGeometry1;
    }

    /**
     * ̃tBbgfʂ̊􉽗vf 2 ̓_ԂB
     * 
     * @return	􉽗vf 2 ̓_
     */
    public JgclPointOnGeometry3D pointOnGeometry2() {
	return this.pointOnGeometry2;
    }

    /**
     * ̃tBbgfʂ̊􉽗vf 1 ȖʂƂāA̋Ȗʏ̓_ԂB
     * 
     * @return Ȗʂł􉽗vf 1 ̓_
     */
    public JgclPointOnSurface3D pointOnSurface1() {
	if (!pointOnGeometry1().geometry().isSurface())
	    return null;
        return (JgclPointOnSurface3D)pointOnGeometry1();
    }

    /**
     * ̃tBbgfʂ̊􉽗vf 2 ȖʂƂāA̋Ȗʏ̓_ԂB
     * 
     * @return Ȗʂł􉽗vf 2 ̓_
     */
    public JgclPointOnSurface3D pointOnSurface2() {
	if (!pointOnGeometry2().geometry().isSurface())
	    return null;
        return (JgclPointOnSurface3D)pointOnGeometry2();
    }

    /**
     * ̃tBbgfʂȐ (~) ɕϊB
     * <p>
     * smallFan  true ̏ꍇ́ASp΂菬Ȃ̉~ʂԂB
     * smallFan  false ̏ꍇ́ASp΂傫Ȃ̉~ʂԂB
     * ȂA~ʂ̐is͕K pointOnGeometry1  pointOnGeometry2 ֌B
     * </p>
     *
     * @param smallFan	~ʂ̒Sp΂菬Ȃ悤ɂ邩ǂB
     * @return	tBbgfʂ\~
     */
    public JgclTrimmedCurve3D toCurve(boolean smallFan) {
	JgclVector3D vecS = pointOnSurface1().subtract(center()).unitized();
	JgclVector3D vecE = pointOnSurface2().subtract(center()).unitized();
	if (vecS.parallelDirection(vecE))
	    throw new JgclInvalidArgumentValue();

	JgclVector3D nrm = vecS.crossProduct(vecE);
	double angle = vecS.angleWith(vecE, nrm);

	if ((angle < Math.PI && !smallFan) ||
	    (angle > Math.PI && smallFan))
	    angle -= JgclMath.PI2;
	    
	JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(center(), nrm, vecS);
	JgclCircle3D cir = new JgclCircle3D(a2p, radius);
	JgclParameterSection section = new JgclParameterSection(0.0, angle);
	return new JgclTrimmedCurve3D(cir, section);
    }

    /**
     * ̃tBbgfʂ pointOnGeometry1  pointOnGeometry2 ̂ԂB
     *
     * @return	pointOnGeometry1  pointOnGeometry2 tBbgf
     */
    JgclFilletSection3D exchange() {
	return new JgclFilletSection3D(radius(), center(), pointOnGeometry2(), pointOnGeometry1());
    }

    /**
     * ̃tBbgfʂƁA^ꂽtBbgfʂ̃tBbgfʂ\ۂ𒲂ׂB
     * <p>
     * ł̓p[^l͎QƂAPɊ􉽓Iȓꐫ݂̂𒲂ׂĂB
     * </p>
     *
     * @return	̃tBbgfʂ\Ȃ trueAłȂ false
     */
    boolean parametricallyIdentical(JgclFilletSection3D mate) {
	if (!center.identical(mate.center()))
	    return false;

	if (!pointOnGeometry1.identical(mate.pointOnGeometry1()))
	    return false;

	if (!pointOnGeometry2.identical(mate.pointOnGeometry2()))
	    return false;

	return true;
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tradius " + radius);
        writer.println(indent_tab + "\tcenter");
        center().output(writer, indent + 2);
        writer.println(indent_tab + "\tpointOnGeometry1");
        pointOnGeometry1().output(writer, indent + 2);
        writer.println(indent_tab + "\tpointOnGeometry2");
        pointOnGeometry2().output(writer, indent + 2);
        writer.println(indent_tab + "End");
    }
}
