/*
 * 2D 2ȐԂ̃tBbg߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclFiltCrvCrv2D.java,v 1.16 2000/08/11 06:18:49 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 2D 2ȐԂ̃tBbg߂NX
 *
 * @version $Revision: 1.16 $, $Date: 2000/08/11 06:18:49 $
 * @author Information-technology Promotion Agency, Japan
 */
final class JgclFiltCrvCrv2D
{
    static boolean debug = false;

    /**
     * ߂ꂽtBbg̃Xg
     * @see	JgclFilletObjectList
     */
    private JgclFilletObjectList fillets;

    /**
     * zItZbgȐ A ̏
     * <p>
     * sideAJgclWhichSide.BOTHł΍Eꂼ̕2A
     * ȊȌꍇ͎w肳ꂽ1B
     * </p>
     * @see	CurveInfo
     * @see	JgclWhichSide
     */
    private CurveInfo[] infoA;

    /**
     * zItZbgȐ B ̏
     * <p>
     * sideAJgclWhichSide.BOTHł΍Eꂼ̕2A
     * ȊȌꍇ͎w肳ꂽ1B
     * </p>
     * @see	CurveInfo
     * @see	JgclWhichSide
     */
    private CurveInfo[] infoB;

    /**
     * tBbga
     */
    private double radius;

    /**
     * IuWFNg\z
     * @param	curveA	Ȑ A
     * @param	sectA	Ȑ A ̑ΏۂƂȂp[^
     * @param	sideA	Ȑ A ̂ǂ瑤ɃtBbg𐶐邩
     * @param	curveB	Ȑ B
     * @param	sectB	Ȑ B ̑ΏۂƂȂp[^
     * @param	sideB	Ȑ B ̂ǂ瑤ɃtBbg𐶐邩
     * @param	raidus	tBbg̔a
     * @see	JgclParametricCurve2D
     * @see	JgclParameterSection
     * @see	JgclWhichSide
     */
    private JgclFiltCrvCrv2D(JgclParametricCurve2D curveA,
			     JgclParameterSection sectA,
			     int sideA,
			     JgclParametricCurve2D curveB,
			     JgclParameterSection sectB,
			     int sideB,
			     double radius) {
	super();

	curveA.checkValidity(sectA);
	curveB.checkValidity(sectB);

	double tol = curveA.getToleranceForDistance();
	if (radius < tol)
	    throw new JgclInvalidArgumentValue();

	fillets = new JgclFilletObjectList();
	this.radius = radius;
	infoA = getInfo(curveA, sectA, sideA);
	infoB = getInfo(curveB, sectB, sideB);
    }

    /**
     * ItZbgȐ(ߎ)߂
     * ({JgclParametricCurve2Dׂ)
     * @param curve	ItZbgȐ
     * @param section	ItZbg
     * @param side	ItZbg
     * @param radius	ItZbg鋗
     */
    private JgclParametricCurve2D offsetCurve(JgclParametricCurve2D curve,
					      JgclParameterSection section,
					      int side,
					      double radius) {
	switch (curve.type()) {
	case JgclParametricCurve2D.LINE_2D:
	    /*
	     * ̏ꍇ͕sړ(g~O)ƂȂ
	     */
	    JgclLine2D lin = (JgclLine2D)curve;
	    JgclVector2D enrm;
	    if (side == JgclWhichSide.RIGHT)
		enrm = new JgclLiteralVector2D(lin.dir().y(), -lin.dir().x());
	    else
		enrm = new JgclLiteralVector2D(-lin.dir().y(), lin.dir().x());
	    enrm = enrm.unitized();
	    JgclPoint2D pnt = lin.pnt().add(enrm.multiply(radius));
	    lin = new JgclLine2D(pnt, lin.dir());

	    return new JgclTrimmedCurve2D(lin, section);
	case JgclParametricCurve2D.CIRCLE_2D:
	    /*
	     * ~̏ꍇ͔atBbgaύX(g~O)ƂȂ
	     */
	    JgclCircle2D cir = (JgclCircle2D)curve;
	    double cRadius;
	    boolean rev = false;
	    if (side == JgclWhichSide.RIGHT)
		cRadius = cir.radius() + radius;
	    else {
		cRadius = cir.radius() - radius;
		if (cRadius < 0.0) {
		    cRadius = -cRadius;
		    rev = true;
		}
	    }
	    if (cRadius < curve.getToleranceForDistance())	// reduced into a point
		break;		// ???
	    cir = new JgclCircle2D(cir.position(), cRadius);
	    if (rev) {
		double newStart = section.start() + Math.PI;
		if (newStart > JgclMath.PI2)
		    newStart -= JgclMath.PI2;
		section = new JgclParameterSection(newStart, section.increase());
	    }

	    return new JgclTrimmedCurve2D(cir, section);
	}
	/*
	 * ȊŐȐBsplineȐŋߎ
	 */
	JgclToleranceForDistance ofst_tol = new JgclToleranceForDistance(radius / 100.0);
	return curve.offsetByBsplineCurve(section, radius, side, ofst_tol);
    }

    /**
     * zItZbgȐ킷NX
     */
    private class CurveInfo {
	/**
	 * ƂȂȐ
	 * @see	JgclParametricCurve2D
	 */
	JgclParametricCurve2D curve;

	/**
	 * ƂȂȐ̃p[^
	 * @see	JgclParameterSection
	 */
	JgclParameterSection section;

	/**
	 * ƂȂȐ̂ǂ瑤ɃItZbg邩
	 * @see	JgclWhichSide
	 */
	int side;
	
	/**
	 * ۂɃItZbgꂽȐ(ߎ)
	 * @see	JgclBsplineCurve2D
	 */
	JgclParametricCurve2D ofstCrv;

	/**
	 * IuWFNg\z
	 * @param	curve	Ȑ
	 * @param	section	Ȑ̑ΏۂƂȂp[^
	 * @param	side	Ȑ̂ǂ瑤ɃtBbg𐶐邩
	 * @param	raidus	tBbg̔a
	 * @see	JgclParametricCurve2D
	 * @see	JgclParameterSection
	 * @see	JgclWhichSide
	 */
	private CurveInfo(JgclParametricCurve2D curve,
			  JgclParameterSection section,
			  int side,
			  double radius) {
	    super();

	    this.curve = curve;
	    this.section = section;
	    this.side = side;
	    ofstCrv = offsetCurve(curve, section, side, radius);
	    if (debug) {
		ofstCrv.output(System.out);
	    }
	}

	/**
	 * zItZbgȐ̗^ꂽp[^ł̍Wl߂
	 * @param	parameter	p[^
	 * @return			Wl
	 * @see	JgclPoint2D
	 */
	private JgclPoint2D evaluate(double parameter) {
	    JgclCurveDerivative2D deriv;
	    JgclVector2D enrm;
	    deriv = curve.evaluation(curve.parameterDomain().force(parameter));
	    if (side == JgclWhichSide.RIGHT)
		enrm = new JgclLiteralVector2D(deriv.d1D().y(), -deriv.d1D().x());
	    else
		enrm = new JgclLiteralVector2D(-deriv.d1D().y(), deriv.d1D().x());
	    enrm = enrm.unitized();

	    return deriv.d0D().add(enrm.multiply(radius));
	}
    }

    /**
     * zItZbgȐ̏߂
     * @param curve	ƂȂȐ
     * @param section	ƂȂȐ̃p[^
     * @param side	ƂȂȐ̂ǂ瑤ɃItZbg邩
     * @see	CurveInfo
     * @see	JgclParametricCurve2D
     * @see	JgclParameterSection
     * @see	JgclWhichSide
     */
    private CurveInfo[] getInfo(JgclParametricCurve2D curve,
				JgclParameterSection section,
				int side) {
	CurveInfo[] infoArray;
	int nInfo;
	int[] sides;

	switch (side) {
	case JgclWhichSide.BOTH:
	    /*
	     * ɋ߂ꍇ͍Eꂼ̉̕zItZbgȐ̏߂
	     */
	    nInfo = 2;
	    sides = new int[2];
	    sides[0] = JgclWhichSide.LEFT;
	    sides[1] = JgclWhichSide.RIGHT;
	    break;
	case JgclWhichSide.RIGHT:
	case JgclWhichSide.LEFT:
	    /*
	     * ^ꂽ̉zItZbgȐ̏߂
	     */
	    nInfo = 1;
	    sides = new int[1];
	    sides[0] = side;
	    break;
	default:
	    throw new JgclInvalidArgumentValue();
	}

	infoArray = new CurveInfo[nInfo];
	for (int i = 0; i < nInfo; i++) {
	    infoArray[i] = new CurveInfo(curve, section, sides[i], radius);
	}
	return infoArray;
    }

    /**
     * tBbg̏\NX
     */
    private class FilletInfo {
	/**
	 * zItZbgȐ A ̏
	 */
	CurveInfo cInfoA;

	/**
	 * zItZbgȐ B ̏
	 */
	CurveInfo cInfoB;

	/*
	 * ȉ͎ZɂĈꎞgp
	 */
	private nlFunc nl_func;
	private JgclRealFunction[] dnl_func;
	private cnvFunc cnv_func;

	private JgclPoint2D sPntA;
	private JgclPoint2D sPntB;
	private JgclVector2D sTngA;
	private JgclVector2D sTngB;
	private JgclVector2D sNrmA;
	private JgclVector2D sNrmB;

	/**
	 * IuWFNg\z
	 * @param	cInfoA	zItZbgȐ A ̏
	 * @param	cInfoB	zItZbgȐ B ̏
	 */
	private FilletInfo(CurveInfo cInfoA, CurveInfo cInfoB) {
	    super();

	    this.cInfoA = cInfoA;
	    this.cInfoB = cInfoB;

	    nl_func = new nlFunc();
	    dnl_func = new JgclRealFunction[2];
	    dnl_func[0] = new dnlFunc(0);
	    dnl_func[1] = new dnlFunc(1);
	    cnv_func = new cnvFunc();
	}

	/**
	 * tBbgrefinement
	 * <p>
	 * Åe̒l߂
	 * </p>
	 * @see	JgclMath#solveSimultaneousEquations(JgclRealFunction, JgclRealFunction[],
	 *					    JgclBooleanFunctionWithRealVariables, double[])
	 */
	private class nlFunc implements JgclRealFunction {
	    private nlFunc() {
		super();
	    }

	    public double[] evaluate(double[] parameter) {
		double[] vctr = new double[2];
		JgclVector2D evec;

		/*
		 * sPntA & sPntB are already computed by previous cnvFunc.evaluate()
		 */
		evec = sPntA.subtract(sPntB);

		vctr[0] = evec.x();
		vctr[1] = evec.y();

		return vctr;
	    }
	}

	/**
	 * tBbgrefinement
	 * <p>
	 * Åe̕Δ̒l߂
	 * </p>
	 * @see	JgclMath#solveSimultaneousEquations(JgclRealFunction, JgclRealFunction[],
	 *					    JgclBooleanFunctionWithRealVariables, double[])
	 */
	private class dnlFunc implements JgclRealFunction {
	    int idx;
	    private dnlFunc(int idx) {
		super();
		this.idx = idx;
	    }

	    public double[] evaluate(double[] parameter) {
		double[] mtrx = new double[2];
		if (idx == 0) {	/* this must be called first */
		    JgclCurveDerivative2D deriv;
		    JgclVector2D enrm;

		    deriv = cInfoA.curve.evaluation(cInfoA.curve.parameterDomain().force(parameter[0]));
		    sTngA = deriv.d1D();
		    if (cInfoA.side == JgclWhichSide.RIGHT)
			enrm = new JgclLiteralVector2D(sTngA.y(), -sTngA.x());
		    else
			enrm = new JgclLiteralVector2D(-sTngA.y(), sTngA.x());
		    enrm = enrm.unitized();

		    /*
		     * solve the following simultaneous equations for N' (enrm: N)
		     *
		     *	(N, N') = 0		->	Nx * N'x + Ny * N'y = 0
		     *
		     *	(P'', N) + (P', N') = 0	->	P''x * Nx + P''y * Ny + P'x * N'x + P'y * N'y = 0
		     */
		    double nrmX, nrmY;
		    if (Math.abs(enrm.x()) > Math.abs(enrm.y())) {
			nrmY = (- (deriv.d2D().x() * enrm.x() + deriv.d2D().y() * enrm.y()))
			    / (sTngA.y() - ((sTngA.x() * enrm.y()) / enrm.x()));
			nrmX = (- (enrm.y() * nrmY)) / enrm.x();
		    } else {
			nrmX = (- (deriv.d2D().x() * enrm.x() + deriv.d2D().y() * enrm.y()))
			    / (sTngA.x() - ((sTngA.y() * enrm.x()) / enrm.y()));
			nrmY = (- (enrm.x() * nrmX)) / enrm.y();
		    }
		    sNrmA = new JgclLiteralVector2D(nrmX, nrmY);

		    deriv = cInfoB.curve.evaluation(cInfoB.curve.parameterDomain().force(parameter[1]));
		    sTngB = deriv.d1D();
		    if (cInfoB.side == JgclWhichSide.RIGHT)
			enrm = new JgclLiteralVector2D(sTngB.y(), -sTngB.x());
		    else
			enrm = new JgclLiteralVector2D(-sTngB.y(), sTngB.x());

		    /*
		     * solve the following simultaneous equations for M' (enrm: M)
		     *
		     *	(M, M') = 0		->	Mx * M'x + My * M'y = 0
		     *
		     *	(Q'', M) + (Q', M') = 0	->	Q''x * Mx + Q''y * My + Q'x * M'x + Q'y * M'y = 0
		     */
		    nrmY = (- (deriv.d2D().x() * enrm.x() + deriv.d2D().y() * enrm.y()))
			/ (sTngB.y() - ((sTngB.x() * enrm.y()) / enrm.x()));
		    nrmX = (- (enrm.y() * nrmY)) / enrm.x();
		    sNrmB = new JgclLiteralVector2D(nrmX, nrmY);

		    mtrx[0] = sTngA.x() + radius * sNrmA.x();
		    mtrx[1] = - sTngB.x() - radius * sNrmB.x();
		} else {
		    mtrx[0] = sTngA.y() + radius * sNrmA.y();
		    mtrx[1] = - sTngB.y() - radius * sNrmB.y();
		}
		return mtrx;
	    }
	}

	/**
	 * tBbgrefinement
	 * <p>
	 * Ảǂ𔻒肷
	 * </p>
	 * @see	JgclMath#solveSimultaneousEquations(JgclRealFunction, JgclRealFunction[],
	 *					    JgclBooleanFunctionWithRealVariables, double[])
	 */
	private class cnvFunc implements JgclBooleanFunctionWithRealVariables {
	    private cnvFunc() {
		super();
	    }

	    public boolean evaluate(double[] parameter) {
		sPntA = cInfoA.evaluate(parameter[0]);
		sPntB = cInfoB.evaluate(parameter[1]);

		return sPntA.identical(sPntB);
	    }
	}

	/**
	 * tBbgrefinementsB
	 * <p>
	 * zItZbgȐm̌_tBbg̒S̏lƂāA
	 * tBbg̐SʒuZŋ߂
	 * </p>
	 * @param	intp	zItZbgȐm̌_(tBbg̒S̏l)
	 * @param	pocA	Ȑ A ̃tBbg̐ړ_̏l
	 * @param	pocB	Ȑ B ̃tBbg̐ړ_̏l
	 * @return		tBbg
	 * @see	JgclMath#solveSimultaneousEquations(JgclRealFunction, JgclRealFunction[],
	 *					    JgclBooleanFunctionWithRealVariables, double[])
	 */
	private JgclFilletObject2D refineFillet(JgclIntersectionPoint2D intp,
						JgclPointOnCurve2D pocA,
						JgclPointOnCurve2D pocB) {
	    double[] param = new double[2];

	    param[0] = pocA.parameter();
	    param[1] = pocB.parameter();

	    double[] refined = JgclMath.solveSimultaneousEquations(nl_func, dnl_func, cnv_func, param);
	    if (refined == null)
		return null;

	    JgclPoint2D cntr = sPntA.midPoint(sPntB);
	    pocA = new JgclPointOnCurve2D(cInfoA.curve, refined[0], JgclGeometry.doCheckDebug);
	    pocB = new JgclPointOnCurve2D(cInfoB.curve, refined[1], JgclGeometry.doCheckDebug);
	    return new JgclFilletObject2D(radius, cntr, pocA, pocB);
	}

	/**
	 * zItZbgȐm̌_tBbg߂B
	 * @param	intp	zItZbgȐm̌_
	 * @return		tBbg
	 */
	private JgclFilletObject2D toFillet(JgclIntersectionPoint2D intp) {
	    JgclPointOnCurve2D pocA = cInfoA.curve.nearestProjectWithDistanceFrom(intp, radius);
	    JgclPointOnCurve2D pocB = cInfoB.curve.nearestProjectWithDistanceFrom(intp, radius);
	    return refineFillet(intp, pocA, pocB);
	}

	/**
	 * ۂɃtBbg߂鏈
	 */
	private void getFillets() {
	    /*
	     * ܂߂ɎۂɃItZbgȐ(ߎ)m̌_𓾂B
	     * ꂽ_tBbg̒S(̏l)ƂȂB
	     */
	    JgclIntersectionPoint2D[] ints;
	    try {
		ints = cInfoA.ofstCrv.intersect(cInfoB.ofstCrv);
	    } catch (JgclIndefiniteSolution e) {
		/*
		 * JgclIndefiniteSolution𔭐ׂǂYނƂł͂B
		 * ɂ̂݃tBbg𔭐ȂǂȂA
		 * ɔ邱Ƃ邽߁B
		 */
		JgclIntersectionPoint2D intp = (JgclIntersectionPoint2D)e.suitable();
		ints = new JgclIntersectionPoint2D[1];
		ints[0] = intp;
	    }
	    /*
	     * ꂽ_ƂɃtBbg̏֕ϊB
	     */
	    JgclFilletObject2D oneSol;
	    for (int i = 0; i < ints.length; i++)
		if ((oneSol = toFillet(ints[i])) != null)
		    fillets.addFillet(oneSol);
	}
    }

    /**
     * 2ȐԂ̃tBbg𓾂
     *
     * @return		2 Ȑ̃tBbg̔z
     */
    private JgclFilletObject2D[] getFillets() {
	/*
	 * ꂼ̋Ȑ̉zItZbgȐ̏ƂɃtBbg𓾂
	 */
	FilletInfo doObj;
	for (int i = 0; i < infoA.length; i++)
	    for (int j = 0; j < infoB.length; j++) {
		doObj = new FilletInfo(infoA[i], infoB[j]);
		doObj.getFillets();
	    }
	return fillets.toJgclFilletObject2DArray(false);
    }

    /**
     * 2ȐԂ̃tBbg𓾂
     *
     * @param	curveA	Ȑ A
     * @param	sectA	Ȑ A ̑ΏۂƂȂp[^
     * @param	sideA	Ȑ A ̂ǂ瑤ɃtBbg𐶐邩
     * @param	curveB	Ȑ B
     * @param	sectB	Ȑ B ̑ΏۂƂȂp[^
     * @param	sideB	Ȑ B ̂ǂ瑤ɃtBbg𐶐邩
     * @param	raidus	tBbg̔a
     * @return		2 Ȑ̃tBbg̔z
     * @see		JgclParametricCurve2D
     * @see		JgclParameterSection
     * @see		JgclWhichSide
     * @see		JgclFilletObject2D
     */
    static JgclFilletObject2D[] fillet(JgclParametricCurve2D curveA,
				       JgclParameterSection sectA,
				       int sideA,
				       JgclParametricCurve2D curveB,
				       JgclParameterSection sectB,
				       int sideB,
				       double radius)
	throws JgclIndefiniteSolution
    {
	/*
	 * ł̓|C/gȐ/Ȑ/ȐZOgȊŐȐB
	 * LȐɂẮAꂼ̃tBbgɔCB
	 */
	int typeA = curveA.type();
	int typeB = curveB.type();

	switch (typeA) {
	case JgclParametricCurve2D.LINE_2D:
	case JgclParametricCurve2D.CIRCLE_2D:
	case JgclParametricCurve2D.ELLIPSE_2D:
	case JgclParametricCurve2D.PARABOLA_2D:
	case JgclParametricCurve2D.HYPERBOLA_2D:
	case JgclParametricCurve2D.PURE_BEZIER_CURVE_2D:
	case JgclParametricCurve2D.BSPLINE_CURVE_2D:
	    switch (typeB) {
	    case JgclParametricCurve2D.LINE_2D:
	    case JgclParametricCurve2D.CIRCLE_2D:
	    case JgclParametricCurve2D.ELLIPSE_2D:
	    case JgclParametricCurve2D.PARABOLA_2D:
	    case JgclParametricCurve2D.HYPERBOLA_2D:
	    case JgclParametricCurve2D.PURE_BEZIER_CURVE_2D:
	    case JgclParametricCurve2D.BSPLINE_CURVE_2D:
		/*
		 * {NXtBbg
		 */
		JgclFiltCrvCrv2D doObj = new JgclFiltCrvCrv2D(curveA, sectA, sideA,
							      curveB, sectB, sideB,
							      radius);	// 
		return doObj.getFillets();				// tBbg߂
	    case JgclParametricCurve2D.TRIMMED_CURVE_2D:
		return ((JgclTrimmedCurve2D)curveB).doFillet(sectB, sideB, curveA, sectA, sideA,
							     radius, true);
	    case JgclParametricCurve2D.COMPOSITE_CURVE_2D:
		return ((JgclCompositeCurve2D)curveB).doFillet(sectB, sideB, curveA, sectA, sideA,
							       radius, true);
	    case JgclParametricCurve2D.COMPOSITE_CURVE_SEGMENT_2D:
		return ((JgclCompositeCurveSegment2D)curveB).doFillet(sectB, sideB, curveA, sectA, sideA,
								      radius, true);
	    case JgclParametricCurve2D.POLYLINE_2D:
		return ((JgclPolyline2D)curveB).doFillet(sectB, sideB, curveA, sectA, sideA,
							 radius, true);
	    case JgclParametricCurve2D.BOUNDED_LINE_2D:
		return ((JgclBoundedLine2D)curveB).doFillet(sectB, sideB, curveA, sectA, sideA,
							    radius, true);
	    }
	    throw new JgclNotSupported();
	case JgclParametricCurve2D.TRIMMED_CURVE_2D:
	    return ((JgclTrimmedCurve2D)curveA).doFillet(sectA, sideA, curveB, sectB, sideB, radius, false);
	case JgclParametricCurve2D.COMPOSITE_CURVE_2D:
	    return ((JgclCompositeCurve2D)curveA).doFillet(sectA, sideA, curveB, sectB, sideB, radius, false);
	case JgclParametricCurve2D.COMPOSITE_CURVE_SEGMENT_2D:
	    return ((JgclCompositeCurveSegment2D)curveA).doFillet(sectA, sideA, curveB, sectB, sideB,
								  radius, false);
	case JgclParametricCurve2D.POLYLINE_2D:
	    return ((JgclPolyline2D)curveA).doFillet(sectA, sideA, curveB, sectB, sideB, radius, false);
	case JgclParametricCurve2D.BOUNDED_LINE_2D:
	    return ((JgclBoundedLine2D)curveA).doFillet(sectA, sideA, curveB, sectB, sideB, radius, false);
	}
	throw new JgclNotSupported();
    }
}

// end of file
