/*
 * 3D 2ȖʊԂ̃tBbg߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclFiltSrfSrf3D.java,v 1.19 2000/08/11 06:18:49 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 3D 2ȖʊԂ̃tBbg߂NX
 *
 * @version $Revision: 1.19 $, $Date: 2000/08/11 06:18:49 $
 * @author Information-technology Promotion Agency, Japan
 */
final class JgclFiltSrfSrf3D
{
    static boolean debug = false;

    /**
     * ߂ꂽtBbg̃Xg
     * @see	JgclFilletObjectList
     */
    private JgclFilletObjectList fillets;

    /**
     * zItZbgȖ A ̏
     * <p>
     * sideAJgclWhichSide.BOTHłΕ\ꂼ̕2A
     * ȊȌꍇ͎w肳ꂽ1B
     * </p>
     * @see	SurfaceInfo
     * @see	JgclWhichSide
     */
    private SurfaceInfo[] infoA;

    /**
     * zItZbgȖ B ̏
     * <p>
     * sideAJgclWhichSide.BOTHłΕ\ꂼ̕2A
     * ȊȌꍇ͎w肳ꂽ1B
     * </p>
     * @see	SurfaceInfo
     * @see	JgclWhichSide
     */
    private SurfaceInfo[] infoB;

    /**
     * tBbga
     */
    private double radius;

    static final int A_U_FIX = 0;
    static final int A_V_FIX = 1;
    static final int B_U_FIX = 2;
    static final int B_V_FIX = 3;

    /**
     * IuWFNg\z
     * @param	surfaceA	Ȗ A
     * @param	uSectA		Ȗ A ̑ΏۂƂȂŨp[^
     * @param	vSectA		Ȗ A ̑ΏۂƂȂṼp[^
     * @param	sideA		Ȗ A ̂ǂ瑤ɃtBbg𐶐邩
     * @param	surfaceB	Ȗ B
     * @param	uSectB		Ȗ B ̑ΏۂƂȂŨp[^
     * @param	vSectB		Ȗ B ̑ΏۂƂȂṼp[^
     * @param	sideB		Ȗ B ̂ǂ瑤ɃtBbg𐶐邩
     * @param	raidus		tBbg̔a
     * @see	JgclParametricSurface3D
     * @see	JgclParameterSection
     * @see	JgclWhichSide
     */
    private JgclFiltSrfSrf3D(JgclParametricSurface3D surfaceA,
			     JgclParameterSection uSectA,
			     JgclParameterSection vSectA,
			     int sideA,
			     JgclParametricSurface3D surfaceB,
			     JgclParameterSection uSectB,
			     JgclParameterSection vSectB,
			     int sideB,
			     double radius) {
	super();

	surfaceA.checkUValidity(uSectA);
	surfaceA.checkVValidity(vSectA);
	surfaceB.checkUValidity(uSectB);
	surfaceB.checkVValidity(vSectB);

	double tol = surfaceA.getToleranceForDistance();
	if (radius < tol)
	    throw new JgclInvalidArgumentValue();

	fillets = new JgclFilletObjectList();
	this.radius = radius;
	infoA = getInfo(surfaceA, uSectA, vSectA, sideA);
	infoB = getInfo(surfaceB, uSectB, vSectB, sideB);
    }

    /**
     * ItZbgȖ(ߎ)߂
     * ({JgclParametricSurface3Dׂ)
     * @param surface	ItZbgȖ
     * @param uSection	ItZbgŰ
     * @param vSection	ItZbgV̋
     * @param side	ItZbg
     * @param radius	ItZbg鋗
     */
    private JgclParametricSurface3D offsetSurface(JgclParametricSurface3D surface,
						  JgclParameterSection uSection,
						  JgclParameterSection vSection,
						  int side,
						  double radius) {
	JgclAxis2Placement3D a2p;
	switch (surface.type()) {
	case JgclParametricSurface3D.PLANE_3D:
	    /*
	     * ʂ̏ꍇ͕sړ(g~O)ƂȂ
	     */
	    {
		JgclPlane3D pln = (JgclPlane3D)surface;
		JgclVector3D enrm = pln.normalVector(0.0, 0.0);
		if (side == JgclWhichSide.BACK)
		    enrm = enrm.reverse();
		JgclPoint3D pnt = pln.position().location().add(enrm.multiply(radius));
		a2p = new JgclAxis2Placement3D(pnt, pln.position().z(), pln.position().x());
		pln = new JgclPlane3D(a2p);

		return new JgclRectangularTrimmedSurface3D(pln, uSection, vSection);
	    }
	case JgclParametricSurface3D.SPHERICAL_SURFACE_3D:
	    /*
	     * ̏ꍇ͔atBbgaύX(g~O)ƂȂ
	     */
	    {
		JgclSphericalSurface3D sph = (JgclSphericalSurface3D)surface;
		double sRadius;
		if (side == JgclWhichSide.FRONT)
		    sRadius = sph.radius() + radius;
		else {
		    sRadius = sph.radius() - radius;
		    if (sRadius < 0.0) {
			break;		// do as Bspline
		    }
		}
		if (sRadius < surface.getToleranceForDistance())	// reduced into a point
		    break;		// ???
		a2p = new JgclAxis2Placement3D(sph.position().location(),
					       sph.position().z(), sph.position().x());
		sph = new JgclSphericalSurface3D(a2p, sRadius);

		return new JgclRectangularTrimmedSurface3D(sph, uSection, vSection);
	    }
	case JgclParametricSurface3D.CYLINDRICAL_SURFACE_3D:
	    /*
	     * ~̏ꍇ͔atBbgaύX(g~O)ƂȂ
	     */
	    {
		JgclCylindricalSurface3D cyl = (JgclCylindricalSurface3D)surface;
		JgclVector3D x = cyl.position().x();
		double sRadius;
		if (side == JgclWhichSide.FRONT)
		    sRadius = cyl.radius() + radius;
		else {
		    sRadius = cyl.radius() - radius;
		    if (sRadius < 0.0) {
			x = x.reverse();
			sRadius = - sRadius;
		    }
		}
		if (sRadius < surface.getToleranceForDistance())	// reduced into a line
		    break;		// ???
		a2p = new JgclAxis2Placement3D(cyl.position().location(), cyl.position().z(), x);
		cyl = new JgclCylindricalSurface3D(a2p, sRadius);

		return new JgclRectangularTrimmedSurface3D(cyl, uSection, vSection);
	    }
	case JgclParametricSurface3D.CONICAL_SURFACE_3D:
	    /*
	     * ~̏ꍇ͎Ɉړ~(g~O)ƂȂ
	     */
	    {
		JgclConicalSurface3D con = (JgclConicalSurface3D)surface;
		double sinCon = Math.sin(con.semiAngle());
		double cosCon = Math.cos(con.semiAngle());
		double moveZ = radius * sinCon;
		if (side == JgclWhichSide.FRONT)
		    moveZ = - moveZ;
		JgclPoint3D loc = con.position().location().add(con.position().z().multiply(moveZ));
		a2p = new JgclAxis2Placement3D(loc, con.position().z(), con.position().x());
		double oftRadius = con.radius() + radius * cosCon;
		con = new JgclConicalSurface3D(a2p, oftRadius, con.semiAngle());

		return new JgclRectangularTrimmedSurface3D(con, uSection, vSection);
	    }
	case JgclParametricSurface3D.RECTANGULAR_TRIMMED_SURFACE_3D:
	    /*
	     * `LȖʂ̏ꍇ̓x[XȖʂItZbg(g~O)ƂȂ
	     */
	    {
		JgclRectangularTrimmedSurface3D rts = (JgclRectangularTrimmedSurface3D)surface;
		uSection = rts.toBasisUParameter(uSection);
		vSection = rts.toBasisVParameter(vSection);
		if (rts.uSense() != rts.vSense())
		    side = JgclWhichSide.reverse(side);

		return offsetSurface(rts.basisSurface(), uSection, vSection, side, radius);
	    }
	}
	/*
	 * ȊŐȖʂBsplineȖʂŋߎ
	 */
	JgclToleranceForDistance ofst_tol = new JgclToleranceForDistance(radius / 100.0);
	return surface.offsetByBsplineSurface(uSection, vSection, radius, side, ofst_tol);
    }

    /**
     * tBbg𐶐͈͂\E֓_𓊉eB
     * ^ꂽItZbgaɈԋ߂̓e_߂B
     * @param surface	Ȗ
     * @param uPInfo	tBbg𐶐U͈̔
     * @param vPInfo	tBbg𐶐V͈̔
     * @param point	e_
     * @param radius	ItZbga
     * @return		^ꂽItZbgaɈԋ߂̓e_
     */
    private JgclPointOnSurface3D nearestPointOnBoundaryWithDistance(JgclParametricSurface3D surface,
								    JgclParameterDomain uPInfo,
								    JgclParameterDomain vPInfo,
								    JgclPoint3D point,
								    double radius) {
	JgclPoint3D prj = null;
	double uParam = 0.0;
	double vParam = 0.0;
	double minDist = -1.0;
	double dist;
	JgclTrimmedCurve3D trc;
	JgclPoint3D prj0;
	JgclPointOnCurve3D poc;
	double uParam0, vParam0;
	for (int i = 0; i < 8; i++) {
	    switch (i) {
	    /*
	     * project on 4 boundaries
	     * 4{̉zEȐł铙p[^Ȑ߁A
	     * ꂼ֓eB
	     */
	    case 0:
	    case 1:
		if (uPInfo.isPeriodic())
		    continue;
		if (i == 0)
		    uParam0 = uPInfo.section().start();
		else
		    uParam0 = uPInfo.section().end();
		try {
		    if (surface.type() == JgclParametricSurface3D.SPHERICAL_SURFACE_3D) {
			/*
			 * V̓p[^Ȑ͉~ʂł邪A
			 * gȐŕ\邽߁AṼp[^`ƈقȂ
			 * [0,]̒`B̂vPInfoƂ܂Ȃ̂ŁA
			 * Ux[XȐł~oAgȐ`ĂB
			 */
			trc = (JgclTrimmedCurve3D)surface.uIsoParametricCurve(uParam0);
			trc = new JgclTrimmedCurve3D((JgclCircle3D)trc.basisCurve(),
						     vPInfo.section());
		    } else {
			trc = new JgclTrimmedCurve3D(surface.uIsoParametricCurve(uParam0),
						     vPInfo.section());
		    }
		    poc = trc.nearestProjectWithDistanceFrom(point, radius);
		    if (poc == null) continue;
		    vParam0 = trc.toBasisParameter(poc.parameter());
		    if (surface.type() == JgclParametricSurface3D.SPHERICAL_SURFACE_3D) {
			/*
			 * V͗LȋԂł邪Ap[^Ȑ͉~ł邽߁A
			 * IȒlƂȂĂ\B
			 * V̒`[-/2,/2]([-,])֕ϊB
			 */
			JgclParameterDomain dmn = new JgclParameterDomain(true, -Math.PI,
									  JgclMath.PI2);
			vParam0 = dmn.wrap(vParam0);
		    }
		    prj0 = poc;
		} catch (JgclReducedToPoint e) {
		    vParam0 = (vPInfo.section().start() + vPInfo.section().end()) / 2.0;
		    prj0 = (JgclPoint3D)e.point();
		}
		break;
	    case 2:
	    case 3:
		if (vPInfo.isPeriodic())
		    continue;
		if (i == 2)
		    vParam0 = vPInfo.section().start();
		else
		    vParam0 = vPInfo.section().end();
		try {
		    trc = new JgclTrimmedCurve3D(surface.vIsoParametricCurve(vParam0), uPInfo.section());
		    poc = trc.nearestProjectWithDistanceFrom(point, radius);
		    if (poc == null) continue;
		    uParam0 = trc.toBasisParameter(poc.parameter());
		    prj0 = poc;
		} catch (JgclReducedToPoint e) {
		    uParam0 = (uPInfo.section().start() + uPInfo.section().end()) / 2.0;
		    prj0 = (JgclPoint3D)e.point();
		}
		break;
	    /*
	     * project on 4 corner points
	     * E4̓_e_ƂĈ
	     */
	    case 4:
		if (uPInfo.isPeriodic() || vPInfo.isPeriodic()) continue;
		uParam0 = uPInfo.section().start();
		vParam0 = vPInfo.section().start();
		prj0 = surface.coordinates(uParam0, vParam0);
		break;
	    case 5:
		if (uPInfo.isPeriodic() || vPInfo.isPeriodic()) continue;
		uParam0 = uPInfo.section().end();
		vParam0 = vPInfo.section().start();
		prj0 = surface.coordinates(uParam0, vParam0);
		break;
	    case 6:
		if (uPInfo.isPeriodic() || vPInfo.isPeriodic()) continue;
		uParam0 = uPInfo.section().start();
		vParam0 = vPInfo.section().end();
		prj0 = surface.coordinates(uParam0, vParam0);
		break;
	    default:	// case 7
		if (uPInfo.isPeriodic() || vPInfo.isPeriodic()) continue;
		uParam0 = uPInfo.section().end();
		vParam0 = vPInfo.section().end();
		prj0 = surface.coordinates(uParam0, vParam0);
		break;
	    }
	    /*
	     * ƂtBbgaɋ߂̓e_I
	     */
	    dist = Math.abs(radius - point.distance(prj0));
	    if (prj == null || dist < minDist) {
		prj = prj0;
		minDist = dist;
		uParam = uParam0;
		vParam = vParam0;
	    }
	}
	if (prj == null)
	    return null;

	return new JgclPointOnSurface3D(prj, surface, uParam, vParam, JgclGeometry.doCheckDebug);
    }

    /**
     * _ȖʂɓeB
     * ^ꂽItZbgaɈԋ߂̓e_߂B
     * @param surface	Ȗ
     * @param uPInfo	eU͈̔
     * @param vPInfo	eV͈̔
     * @param point	e_
     * @param radius	ItZbga
     */
    private JgclPointOnSurface3D project(JgclParametricSurface3D surface,
					 JgclParameterDomain uPInfo,
					 JgclParameterDomain vPInfo,
					 JgclPoint3D point,
					 double radius) {
	JgclRectangularTrimmedSurface3D rts
	    = new JgclRectangularTrimmedSurface3D(surface, uPInfo.section(), vPInfo.section());
	JgclPointOnSurface3D pos = rts.nearestProjectWithDistanceFrom(point, radius);
	JgclPointOnSurface3D pos2 = nearestPointOnBoundaryWithDistance(surface, uPInfo, vPInfo,
								       point, radius);
	if (pos == null) {
	    if (pos2 != null)
		pos = pos2;
	} else {
	    pos = new JgclPointOnSurface3D(pos, surface,
					   rts.toBasisUParameter(pos.uParameter()),
					   rts.toBasisVParameter(pos.vParameter()),
					   JgclGeometry.doCheckDebug);
	    if (pos2 != null &&
		Math.abs(radius - point.distance(pos2)) < Math.abs(radius - point.distance(pos)))
		pos = pos2;
	}
	if (debug) {
	    System.out.println("// project defference = " +
			       Math.abs(radius - point.distance(pos)));
	}
	return pos;
    }

    /**
     * zItZbgȖʂ̕]l킷NX
     */
    private class SurfaceDeriv {
	/**
	 * Wl
	 * @see	JgclPoint3D
	 */
	JgclPoint3D pnt;

	/**
	 * ̋Ȗʂ̕]l
	 * @see	JgclSurfaceDerivative3D
	 */
	JgclSurfaceDerivative3D deriv;

	/**
	 * @xNg
	 * @see	JgclVector3D
	 */
	JgclVector3D nrm;

	/**
	 * IuWFNg\z
	 * @param	pnt	Wl
	 * @param	deriv	̋Ȗʂ̕]l
	 * @param	nrm	@xNg
	 * @see	JgclPoint3D
	 * @see	JgclSurfaceDerivative3D
	 * @see	JgclVector3D
	 */
	private SurfaceDeriv(JgclPoint3D pnt, JgclSurfaceDerivative3D deriv, JgclVector3D nrm) {
	    this.pnt = pnt;
	    this.deriv = deriv;
	    this.nrm = nrm;
	}
    }

    /**
     * zItZbgȖʂ킷NX
     */
    private class SurfaceInfo {
	/*
	 * ƂȂȖ
	 * @see	JgclParametricSurface3D
	 */
	JgclParametricSurface3D surface;

	/*
	 * ŨtBbgΏۋԂ̎
	 * @see	JgclParameterDomain
	 */
	JgclParameterDomain uPInfo;

	/*
	 * ṼtBbgΏۋԂ̎
	 * @see	JgclParameterDomain
	 */
	JgclParameterDomain vPInfo;

	/**
	 * ItZbg(܂)
	 * @see	JgclWhichSide
	 */
	double magni;
	
	/**
	 * ۂɃItZbgꂽȖ(ߎ)
	 * @see	JgclParametricSurface3D
	 */
	JgclParametricSurface3D ofstSrf;

	/**
	 * tBbgΏۋԂ̎𓾂
	 * @param section	tBbgΏۋ
	 * @param domain	Ȗʂ̃p[^`̏
	 * @param ptol		p[^̋e덷
	 * @return		tBbgΏۋԂ̎
	 */
	private JgclParameterDomain cyclicPInfo(JgclParameterSection section,
						JgclParameterDomain domain,
						double ptol) {
	    double start = section.start();
	    double increase = section.increase();
	    boolean periodic = false;
	    if (domain.isPeriodic()) {	// closed
		double dInc = domain.section().increase();
		if (Math.abs(increase) > dInc - ptol) {
		    /*
		     * the range of the target section is greater than the base section
		     */
		    periodic = true;
		    increase = (increase > 0.0) ? dInc : - dInc;
		}
	    }
	    return new JgclParameterDomain(periodic, start, increase);
	}

	/**
	 * IuWFNg\z
	 * @param	surface		Ȗ
	 * @param	uSection	Ȗʂ̑ΏۂƂȂŨp[^
	 * @param	vSection	Ȗʂ̑ΏۂƂȂṼp[^
	 * @param	side		Ȗʂ̂ǂ瑤ɃtBbg𐶐邩
	 * @see	JgclParametricSurface3D
	 * @see	JgclParameterSection
	 * @see	JgclWhichSide
	 */
	private SurfaceInfo(JgclParametricSurface3D surface,
			    JgclParameterSection uSection,
			    JgclParameterSection vSection,
			    int side) {
	    super();

	    this.surface = surface;
	    double ptol = surface.getToleranceForParameter();
	    this.uPInfo = cyclicPInfo(uSection, surface.uParameterDomain(), ptol);
	    this.vPInfo = cyclicPInfo(vSection, surface.vParameterDomain(), ptol);
	    if (side == JgclWhichSide.FRONT)
		this.magni = radius;
	    else
		this.magni = - radius;
	    ofstSrf = offsetSurface(surface, uPInfo.section(), vPInfo.section(), side, radius);
	}

	/**
	 * zItZbgȖʂ̗^ꂽp[^ł̕]l߂
	 * @param	parameter	p[^
	 * @return			]l
	 */
	private SurfaceDeriv evaluate(double[] parameter) {
	    JgclSurfaceDerivative3D deriv = surface.evaluation(parameter[0], parameter[1]);
	    JgclVector3D nrm = deriv.du().crossProduct(deriv.dv()).unitized();
	    JgclPoint3D pnt = deriv.d0().add(nrm.multiply(magni));
	    return new SurfaceDeriv(pnt, deriv, nrm);
	}
    }

    /**
     * zItZbgȖʂ̏߂
     * @param surface	ƂȂȖ
     * @param uSection	ƂȂȖʂŨp[^
     * @param vSection	ƂȂȖʂṼp[^
     * @param side	ƂȂȖʂ̂ǂ瑤ɃItZbg邩
     * @see	SurfaceInfo
     * @see	JgclParametricSurface3D
     * @see	JgclParameterSection
     * @see	JgclWhichSide
     */
    private SurfaceInfo[] getInfo(JgclParametricSurface3D surface,
				  JgclParameterSection uSection,
				  JgclParameterSection vSection,
				  int side) {
	SurfaceInfo[] infoArray;
	int nInfo;
	int[] sides;

	switch (side) {
	case JgclWhichSide.BOTH:
	    /*
	     * ɋ߂ꍇ͕\ꂼ̉̕zItZbgȖʂ̏߂
	     */
	    nInfo = 2;
	    sides = new int[2];
	    sides[0] = JgclWhichSide.FRONT;
	    sides[1] = JgclWhichSide.BACK;
	    break;
	case JgclWhichSide.FRONT:
	case JgclWhichSide.BACK:
	    /*
	     * ^ꂽ̉zItZbgȖʂ̏߂
	     */
	    nInfo = 1;
	    sides = new int[1];
	    sides[0] = side;
	    break;
	default:
	    throw new JgclInvalidArgumentValue();
	}

	infoArray = new SurfaceInfo[nInfo];
	for (int i = 0; i < nInfo; i++) {
	    infoArray[i] = new SurfaceInfo(surface, uSection, vSection, sides[i]);
	}
	return infoArray;
    }

    /**
     * tBbg̏\NX
     */
    private class FilletInfo {
	/**
	 * zItZbgȖ A ̏
	 */
	SurfaceInfo sInfoA;

	/**
	 * zItZbgȖ B ̏
	 */
	SurfaceInfo sInfoB;

	/*
	 * ȉ͎ZɂĈꎞgp
	 */
	private nlFunc nl_func;
	private JgclRealFunction[] dnl_func;
	private cnvFunc cnv_func;
	private dltFunc dlt_func;

	private SurfaceDeriv derivA;
	private SurfaceDeriv derivB;

	private int fixedParamType;
	private double fxParam;

	private double[][] sMatrix = new double[3][3];

	/**
	 * IuWFNg\z
	 * @param	cInfoA	zItZbgȖ A ̏
	 * @param	cInfoB	zItZbgȖ B ̏
	 */
	private FilletInfo(SurfaceInfo sInfoA, SurfaceInfo sInfoB) {
	    super();

	    this.sInfoA = sInfoA;
	    this.sInfoB = sInfoB;

	    nl_func = new nlFunc();
	    dnl_func = new JgclRealFunction[3];
	    for (int i = 0; i < 3; i++)
		dnl_func[i] = new dnlFunc(i);
	    cnv_func = new cnvFunc();
	    dlt_func = new dltFunc();
	}

	/**
	 * p[^̒l␳
	 * @param domain	Ȗʂ̃p[^`̏
	 * @param pinfo		tBbgΏۋԂ̎
	 * @param param		p[^
	 * @return		␳ꂽp[^
	 */
	private double refineParam(JgclParameterDomain domain, JgclParameterDomain pInfo, double param) {
	    if (domain.isNonPeriodic())
		return param;

	    /*
	     * make sure that param is inside of pInfo
	     */
	    double lo = pInfo.section().lower();
	    double up = pInfo.section().upper();
	    double il = domain.section().increase();
	    if (pInfo.section().increase() > 0.0) {
		while (param < lo) param += il;
		while (param > up) param -= il;
	    } else {
		while (param > lo) param -= il;
		while (param < up) param += il;
	    }
	    return param;
	}

	private double[] setupParams(int i,
				     double uParamA,
				     double vParamA,
				     double uParamB,
				     double vParamB) {
	    double[] param = new double[3];

	    switch (i) {
	    case 0:
		fixedParamType = A_U_FIX;
		break;
	    case 1:
		fixedParamType = A_V_FIX;
		break;
	    case 2:
		fixedParamType = B_U_FIX;
		break;
	    case 3:
		fixedParamType = B_V_FIX;
		break;
	    }

	    /*
	     * set up parameters
	     */
	    switch (fixedParamType) {
	    case A_U_FIX:
		fxParam = uParamA; param[0] = vParamA; param[1] = uParamB; param[2] = vParamB;
		break;
	    case A_V_FIX:
		param[0] = uParamA; fxParam = vParamA; param[1] = uParamB; param[2] = vParamB;
		break;
	    case B_U_FIX:
		param[0] = uParamA; param[1] = vParamA; fxParam = uParamB; param[2] = vParamB;
		break;
	    case B_V_FIX:
		param[0] = uParamA; param[1] = vParamA; param[2] = uParamB; fxParam = vParamB;
		break;
	    }

	    return param;
	}

	private void reformParam(double[][] paramS) {
	    JgclParameterDomain[] domainA = {sInfoA.surface.uParameterDomain(),
					     sInfoA.surface.vParameterDomain()};
	    JgclParameterDomain[] domainB = {sInfoB.surface.uParameterDomain(),
					     sInfoB.surface.vParameterDomain()};
	    JgclParameterDomain[] pInfoA = {sInfoA.uPInfo, sInfoA.vPInfo};
	    JgclParameterDomain[] pInfoB = {sInfoB.uPInfo, sInfoB.vPInfo};
	    JgclParameterDomain[] pInfo = pInfoA;
	    JgclParameterDomain[] domain = domainA;

	    double param_lo_p = 0.0;
	    double param_up_s = 0.0;
	    boolean s_exist;
	    
	    for (int i = 0; i < 2; i++) {
		for (int j = 0; j < 2; j++) {
		    double pup = pInfo[j].section().upper();
		    double plo = pInfo[j].section().lower();
		    s_exist = false;

		    if (domain[j].isPeriodic()) {	/* base surface is closed */
			double lo = domain[j].section().lower();
			double up = domain[j].section().upper();
			double il = domain[j].section().increase();

			while (paramS[i][j] < lo) paramS[i][j] += il;
			while (paramS[i][j] > up) paramS[i][j] -= il;

			if (pup > up) {
			    param_lo_p = plo;
			    param_up_s = lo + (pup - up);
			    s_exist = true;

			} else if (plo < lo) {
			    param_lo_p = up - (plo - lo);
			    param_up_s = pup;
			    s_exist = true;
			}
		    }

		    if (pInfo[j].isNonPeriodic()) {	/* target section is open */
			if (!s_exist) {
			    if (paramS[i][j] < plo) paramS[i][j] = plo;
			    if (paramS[i][j] > pup) paramS[i][j] = pup;
			} else {
			    if ((param_up_s < paramS[i][j]) && (paramS[i][j] < param_lo_p)) {
				if ((paramS[i][j] - param_up_s) < (param_lo_p - paramS[i][j]))
				    paramS[i][j] = param_up_s;
				else
				    paramS[i][j] = param_lo_p;
			    }
			}
		    }
		}

		domain = domainB;
		pInfo = pInfoB;
	    }
	}

	private double[][] fillParam(double[] param) {
	    double[][] paramS = new double[2][2];

	    switch (fixedParamType) {
	    case A_U_FIX:
		paramS[0][0] = fxParam;
		paramS[0][1] = param[0];
		paramS[1][0] = param[1];
		paramS[1][1] = param[2];
		break;
	    case A_V_FIX:
		paramS[0][0] = param[0];
		paramS[0][1] = fxParam;
		paramS[1][0] = param[1];
		paramS[1][1] = param[2];
		break;
	    case B_U_FIX:
		paramS[0][0] = param[0];
		paramS[0][1] = param[1];
		paramS[1][0] = fxParam;
		paramS[1][1] = param[2];
		break;
	    case B_V_FIX:
		paramS[0][0] = param[0];
		paramS[0][1] = param[1];
		paramS[1][0] = param[2];
		paramS[1][1] = fxParam;
		break;
	    }

	    reformParam(paramS);

	    return paramS;
	}

	/**
	 * tBbgfʂrefinement
	 * <p>
	 * Åe̒l߂
	 * F of F(x) = 0
	 * </p>
	 * @see	JgclMath#solveSimultaneousEquationsWithCorrection(JgclRealFunction, JgclRealFunction[],
	 *							  JgclBooleanFunctionWithRealVariables,
	 *							  JgclRealFunction, double[])
	 */
	private class nlFunc implements JgclRealFunction {
	    private nlFunc() {
		super();
	    }

	    public double[] evaluate(double[] parameter) {
		/*
		 * derivA & derivB are already computed by previous cnvFunc.evaluate()
		 */
		JgclVector3D evec = derivA.pnt.subtract(derivB.pnt);

		return evec.toDoubleArray();
	    }
	}

	/**
	 * tBbgfʂrefinement
	 * <p>
	 * Åe̕Δ̒l߂
	 * partial derivatives of F
	 * </p>
	 * @see	JgclMath#solveSimultaneousEquationsWithCorrection(JgclRealFunction, JgclRealFunction[],
	 *							  JgclBooleanFunctionWithRealVariables,
	 *							  JgclRealFunction, double[])
	 */
	private class dnlFunc implements JgclRealFunction {
	    int idx;
	    private dnlFunc(int idx) {
		super();
		this.idx = idx;
	    }

	    private void fillMatrix(int m_idx, JgclVector3D vec, double magni, double[] dX,
				    boolean reverse) {
		sMatrix[0][m_idx] = vec.x() + magni * dX[0];
		sMatrix[1][m_idx] = vec.y() + magni * dX[1];
		sMatrix[2][m_idx] = vec.z() + magni * dX[2];
		if (reverse)
		    for (int i = 0; i < 3; i++)
			sMatrix[i][m_idx] *= -1.0;
	    }

	    public double[] evaluate(double[] parameter) {
		if (idx == 0) {		// this must be called first
		    /*
		     * computation of derivatives is already done by previous cnvFunc.evaluate()
		     */
		    JgclMatrix dDm = new JgclMatrix(3, 3);
		    double[] dB = new double[3];
		    double[] dX;

		    int m_idx = 0;

		    if (fixedParamType != A_U_FIX) {
			dDm.setElementsAt(0, derivA.deriv.du().toDoubleArray());
			dDm.setElementsAt(1, derivA.deriv.dv().toDoubleArray());
			dDm.setElementsAt(2, derivA.nrm.toDoubleArray());
			dB[0] = - derivA.deriv.duu().dotProduct(derivA.nrm);
			dB[1] = - derivA.deriv.duv().dotProduct(derivA.nrm);
			dB[2] = 0.0;
			if ((dX = dDm.solveSimultaneousLinearEquations(dB)) == null)
			    return null;
			fillMatrix(m_idx, derivA.deriv.du(), sInfoA.magni, dX, false);
			m_idx++;
		    }

		    if (fixedParamType != A_V_FIX) {
			dDm.setElementsAt(0, derivA.deriv.dv().toDoubleArray());
			dDm.setElementsAt(1, derivA.deriv.du().toDoubleArray());
			dDm.setElementsAt(2, derivA.nrm.toDoubleArray());
			dB[0] = - derivA.deriv.dvv().dotProduct(derivA.nrm);
			dB[1] = - derivA.deriv.duv().dotProduct(derivA.nrm);
			dB[2] = 0.0;
			if ((dX = dDm.solveSimultaneousLinearEquations(dB)) == null)
			    return null;
			fillMatrix(m_idx, derivA.deriv.dv(), sInfoA.magni, dX, false);
			m_idx++;
		    }

		    if (fixedParamType != B_U_FIX) {
			dDm.setElementsAt(0, derivB.deriv.du().toDoubleArray());
			dDm.setElementsAt(1, derivB.deriv.dv().toDoubleArray());
			dDm.setElementsAt(2, derivB.nrm.toDoubleArray());
			dB[0] = - derivB.deriv.duu().dotProduct(derivB.nrm);
			dB[1] = - derivB.deriv.duv().dotProduct(derivB.nrm);
			dB[2] = 0.0;
			if ((dX = dDm.solveSimultaneousLinearEquations(dB)) == null)
			    return null;
			fillMatrix(m_idx, derivB.deriv.du(), sInfoB.magni, dX, true);
			m_idx++;
		    }

		    if (fixedParamType != B_V_FIX) {
			dDm.setElementsAt(0, derivB.deriv.dv().toDoubleArray());
			dDm.setElementsAt(1, derivB.deriv.du().toDoubleArray());
			dDm.setElementsAt(2, derivB.nrm.toDoubleArray());
			dB[0] = - derivB.deriv.dvv().dotProduct(derivB.nrm);
			dB[1] = - derivB.deriv.duv().dotProduct(derivB.nrm);
			dB[2] = 0.0;
			if ((dX = dDm.solveSimultaneousLinearEquations(dB)) == null)
			    return null;
			fillMatrix(m_idx, derivB.deriv.dv(), sInfoB.magni, dX, true);
			m_idx++;
		    }

		    /*
		     * check whether the matrix is regular or not
		     */
		    int i, j;
		    double tol = sInfoA.surface.getToleranceForDistance();
		    for (i = 0; i < 3; i++) {
			for (j = 0; j < 3; j++) {
			    if (Math.abs(sMatrix[i][j]) > tol)
				break;
			}
			if (j == 3)
			    return null;
		    }
		}
		return sMatrix[idx];
	    }
	}

	/**
	 * tBbgfʂrefinement
	 * <p>
	 * Ảǂ𔻒肷
	 * convergence test
	 * </p>
	 * @see	JgclMath#solveSimultaneousEquationsWithCorrection(JgclRealFunction, JgclRealFunction[],
	 *							  JgclBooleanFunctionWithRealVariables,
	 *							  JgclRealFunction, double[])
	 */
	private class cnvFunc implements JgclBooleanFunctionWithRealVariables {
	    private cnvFunc() {
		super();
	    }

	    public boolean evaluate(double[] parameter) {
		double[][] paramS = fillParam(parameter);

		derivA = sInfoA.evaluate(paramS[0]);
		derivB = sInfoB.evaluate(paramS[1]);

		if (debug) {
		    System.out.println("// refine dist = " +
				       derivA.pnt.distance(derivB.pnt));
		}

		return derivA.pnt.identical(derivB.pnt);
	    }
	}

	/**
	 * tBbgfʂrefinement
	 * <p>
	 * Zrł̃p[^̕␳s
	 * </p>
	 * @see	JgclMath#solveSimultaneousEquationsWithCorrection(JgclRealFunction, JgclRealFunction[],
	 *							  JgclBooleanFunctionWithRealVariables,
	 *							  JgclRealFunction, double[])
	 */
	private class dltFunc implements JgclRealFunction {
	    private dltFunc() {
		super();
	    }

	    public double[] evaluate(double[] parameter) {
		double[][] paramS = fillParam(parameter);

		switch (fixedParamType) {
		case A_U_FIX:
		    parameter[0] = paramS[0][1];
		    parameter[1] = paramS[1][0];
		    parameter[2] = paramS[1][1];
		    break;
		case A_V_FIX:
		    parameter[0] = paramS[0][0];
		    parameter[1] = paramS[1][0];
		    parameter[2] = paramS[1][1];
		    break;
		case B_U_FIX:
		    parameter[0] = paramS[0][0];
		    parameter[1] = paramS[0][1];
		    parameter[2] = paramS[1][1];
		    break;
		case B_V_FIX:
		    parameter[0] = paramS[0][0];
		    parameter[1] = paramS[0][1];
		    parameter[2] = paramS[1][0];
		    break;
		}
		return parameter;
	    }
	}

	private JgclFilletSection3D setbackParams(double[] parameter) {
	    double[][] paramS = fillParam(parameter);

	    /*
	     * take the middle position of A and B
	     */
	    JgclPoint3D cntr = derivA.pnt.midPoint(derivB.pnt);
	    JgclPointOnSurface3D posA
		= new JgclPointOnSurface3D(sInfoA.surface, paramS[0][0], paramS[0][1],
					   JgclGeometry.doCheckDebug);
	    JgclPointOnSurface3D posB
		= new JgclPointOnSurface3D(sInfoB.surface, paramS[1][0], paramS[1][1],
					   JgclGeometry.doCheckDebug);
	    return new JgclFilletSection3D(radius, cntr, posA, posB);
	}

	/**
	 * tBbgfʂrefinementsB
	 * <p>
	 * zItZbgȖʓm̌_(1_)tBbgfʂ̒S̏lƂāA
	 * tBbgfʂ̐SʒuZŋ߂
	 * </p>
	 * @param	intp	zItZbgȖʓm̌_(tBbgfʂ̒S̏l)
	 * @param	pocA	Ȗ A ̃tBbgfʂ̐ړ_̏l
	 * @param	pocB	Ȗ B ̃tBbgfʂ̐ړ_̏l
	 * @return		tBbgf
	 * @see	JgclMath#solveSimultaneousEquationsWithCorrection(JgclRealFunction, JgclRealFunction[],
	 *							  JgclBooleanFunctionWithRealVariables,
	 *							  JgclRealFunction, double[])
	 */
	private JgclFilletSection3D refineFillet(JgclPoint3D intp,
						 double uParamA, double vParamA,
						 double uParamB, double vParamB,
						 boolean doProjection) {
	    /*
	     * resolve (F = 0)
	     *
	     *	F = P + a * N - (Q + b * M)
	     *
	     * where
	     *	P : point on A
	     *	a : magnitude of offset of A (negative if offset_side is specified as BACK)
	     *	N : unit normal at P
	     *	Q : point on B
	     *	b : magnitude of offset of B (negative if offset_side is specified as BACK)
	     *	M : unit normal at Q
	     */
	    JgclFilletSection3D sec = null;
	    JgclFilletSection3D secI;
	    double diff = -1.0;
	    double diffI;
	    uParamA = refineParam(sInfoA.surface.uParameterDomain(), sInfoA.uPInfo, uParamA);
	    vParamA = refineParam(sInfoA.surface.vParameterDomain(), sInfoA.vPInfo, vParamA);
	    uParamB = refineParam(sInfoB.surface.uParameterDomain(), sInfoB.uPInfo, uParamB);
	    vParamB = refineParam(sInfoB.surface.vParameterDomain(), sInfoB.vPInfo, vParamB);
	    for (int i = 0; i < 4; i++) {
		double[] param = setupParams(i, uParamA, vParamA, uParamB, vParamB);
		double[] refined
		    = JgclMath.solveSimultaneousEquationsWithCorrection(nl_func, dnl_func, cnv_func,
									dlt_func, param);
		if (refined == null)
		    continue;
		secI = setbackParams(refined);
		diffI = secI.center().distance(intp);
		if (sec == null || diffI < diff) {
		    sec = secI;
		    diff = diffI;
		}
	    }
	    return sec;
	}

	/**
	 * zItZbgȖʓm̌tBbg߂B
	 * @param	intp	zItZbgȖʓm̌
	 * @return		tBbg
	 */
	private JgclFilletObject3D toFillet(JgclSurfaceSurfaceInterference3D intf) {
	    JgclIntersectionCurve3D ints;
	    if ((ints = intf.toIntersectionCurve()) == null)	// not a curve
		return null;

	    JgclParametricCurve3D curve3d = ints.curve3d();
	    JgclPolyline3D pol;
	    if (curve3d.type() == JgclParametricCurve3D.POLYLINE_3D)
		pol = (JgclPolyline3D)curve3d;
	    else
		pol = curve3d.toPolyline(curve3d.parameterDomain().section(),	// must be bounded curve
					 curve3d.getToleranceForDistanceAsObject());

	    int nPoints = pol.nPoints();
	    JgclFilletObjectList secList = new JgclFilletObjectList();
	    JgclFilletSection3D oneSec;
	    JgclPointOnSurface3D posA;
	    JgclPointOnSurface3D posB;
	    double uParamA, vParamA, uParamB, vParamB;
	    for (int i = 0; i < nPoints; i++) {
		/*
		 * ݖʏ̓e悤ɂȂĂ邪A
		 * {͗[Õp[^lƂesׂB
		if (i == 0 || i == nPoints - 1) {
		*/
		    posA = project(sInfoA.surface, sInfoA.uPInfo, sInfoA.vPInfo, pol.pointAt(i), radius);
		    posB = project(sInfoB.surface, sInfoB.uPInfo, sInfoB.vPInfo, pol.pointAt(i), radius);
		    uParamA = posA.uParameter();
		    vParamA = posA.vParameter();
		    uParamB = posB.uParameter();
		    vParamB = posB.vParameter();
		    if ((oneSec = refineFillet(pol.pointAt(i), uParamA, vParamA, uParamB, vParamB,
					       false)) != null)
			secList.addSection(oneSec);
		    /*
		} else {
		    if ((sec[i] = refineFillet(pol.pointAt(i), uParamA, vParamA, uParamB, vParamB, true)) == null) {
			posA = project(sInfoA.surface, sInfoA.uPInfo,
				       sInfoA.vPInfo, pol.pointAt(i), radius);
			posB = project(sInfoB.surface, sInfoB.uPInfo,
				       sInfoB.vPInfo, pol.pointAt(i), radius);
			uParamA = posA.uParameter();
			vParamA = posA.vParameter();
			uParamB = posB.uParameter();
			vParamB = posB.vParameter();
			if ((oneSec = refineFillet(pol.pointAt(i), uParamA, vParamA, uParamB, vParamB,
						   false)) != null)
			    secList.addSection(oneSec);
		    }
		}
		    */
	    }
	    return secList.toJgclFilletObject3D(false);
	}

	/**
	 * ۂɃtBbg߂鏈
	 */
	private void getFillets() {
	    /*
	     * ܂߂ɎۂɃItZbgȖ(ߎ)m̌𓾂B
	     * ꂽtBbg̒SO(̏l)ƂȂB
	     */
	    JgclSurfaceSurfaceInterference3D[] ints;
	    try {
		if (debug) {
		    System.out.println("intersection start");
		    sInfoA.ofstSrf.output(System.out);
		    sInfoB.ofstSrf.output(System.out);
		}
		ints = sInfoA.ofstSrf.intersect(sInfoB.ofstSrf);
		if (debug) {
		    System.out.println("intersection OK");
		    if (ints.length < 1)
			System.out.println("no intersection");
		}
	    } catch (JgclIndefiniteSolution e) {
		/*
		 * JgclIndefiniteSolution𔭐ׂǂYނƂł͂B
		 * ɂ̂݃tBbg𔭐ȂǂȂA
		 * ɔ邱Ƃ邽߁B
		 */
		JgclSurfaceSurfaceInterference3D intf = (JgclSurfaceSurfaceInterference3D)e.suitable();
		ints = new JgclSurfaceSurfaceInterference3D[1];
		ints[0] = intf;
	    }
	    /*
	     * ꂽƂɃtBbg̏֕ϊB
	     */
	    JgclFilletObject3D oneSol;
	    for (int i = 0; i < ints.length; i++)
		if ((oneSol = toFillet(ints[i])) != null)
		    fillets.addFillet(oneSol);
	}
    }

    /**
     * 2ȖʊԂ̃tBbg𓾂
     *
     * @return		2 Ȗʂ̃tBbg̔z
     */
    private JgclFilletObject3D[] getFillets() {
	/*
	 * ꂼ̋Ȗʂ̉zItZbgȖʂ̏ƂɃtBbg𓾂
	 */
	FilletInfo doObj;
	for (int i = 0; i < infoA.length; i++)
	    for (int j = 0; j < infoB.length; j++) {
		doObj = new FilletInfo(infoA[i], infoB[j]);
		if (debug)
		    System.out.println("fillet doing at each FilletInfo");
		doObj.getFillets();
	    }
	
	return fillets.toJgclFilletObject3DArray(false);
    }

    /**
     * 2ȖʊԂ̃tBbg𓾂
     *
     * @param	surfaceA	Ȗ A
     * @param	uSectA		Ȗ A ̑ΏۂƂȂŨp[^
     * @param	vSectA		Ȗ A ̑ΏۂƂȂṼp[^
     * @param	sideA		Ȗ A ̂ǂ瑤ɃtBbg𐶐邩
     * @param	surfaceB	Ȗ B
     * @param	uSectB		Ȗ B ̑ΏۂƂȂŨp[^
     * @param	vSectB		Ȗ B ̑ΏۂƂȂṼp[^
     * @param	sideB		Ȗ B ̂ǂ瑤ɃtBbg𐶐邩
     * @param	raidus		tBbg̔a
     * @return			2 Ȗʂ̃tBbg̔z
     * @see	JgclParametricSurface3D
     * @see	JgclParameterSection
     * @see	JgclWhichSide
     * @see	JgclFilletObject2D
     */
    static JgclFilletObject3D[] fillet(JgclParametricSurface3D surfaceA,
				       JgclParameterSection uSectA,
				       JgclParameterSection vSectA,
				       int sideA,
				       JgclParametricSurface3D surfaceB,
				       JgclParameterSection uSectB,
				       JgclParameterSection vSectB,
				       int sideB,
				       double radius)
	throws JgclIndefiniteSolution
    {
	/*
	 * ł͋ȐEȖʈȊŐȖʂB
	 * LȖʂɂẮAꂼ̃tBbgɔCB
	 */
	if (debug)
	    System.out.println("fillet start");

	int typeA = surfaceA.type();
	int typeB = surfaceB.type();

	switch (typeA) {
	case JgclParametricSurface3D.PLANE_3D:
	case JgclParametricSurface3D.SPHERICAL_SURFACE_3D:
	case JgclParametricSurface3D.CYLINDRICAL_SURFACE_3D:
	case JgclParametricSurface3D.CONICAL_SURFACE_3D:
	case JgclParametricSurface3D.PURE_BEZIER_SURFACE_3D:
	case JgclParametricSurface3D.BSPLINE_SURFACE_3D:
	case JgclParametricSurface3D.SURFACE_OF_LINEAR_EXTRUSION_3D:
	case JgclParametricSurface3D.SURFACE_OF_REVOLUTION_3D:
	case JgclParametricSurface3D.RECTANGULAR_TRIMMED_SURFACE_3D:
	    switch (typeB) {
	    case JgclParametricSurface3D.PLANE_3D:
	    case JgclParametricSurface3D.SPHERICAL_SURFACE_3D:
	    case JgclParametricSurface3D.CYLINDRICAL_SURFACE_3D:
	    case JgclParametricSurface3D.CONICAL_SURFACE_3D:
	    case JgclParametricSurface3D.PURE_BEZIER_SURFACE_3D:
	    case JgclParametricSurface3D.BSPLINE_SURFACE_3D:
	    case JgclParametricSurface3D.SURFACE_OF_LINEAR_EXTRUSION_3D:
	    case JgclParametricSurface3D.SURFACE_OF_REVOLUTION_3D:
	    case JgclParametricSurface3D.RECTANGULAR_TRIMMED_SURFACE_3D:
		/*
		 * {NXtBbg
		 */
		JgclFiltSrfSrf3D doObj = new JgclFiltSrfSrf3D(surfaceA, uSectA, vSectA, sideA,
							      surfaceB, uSectB, vSectB, sideB,
							      radius);
		if (debug)
		    System.out.println("fillet doing");

		return doObj.getFillets();
	    }
	    throw new JgclNotSupported();
	}
	throw new JgclNotSupported();
    }
}

// end of file
