/*
 * QFe萔Œ`ꂽxNg\
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclHomogeneousVector2D.java,v 1.19 2000/04/26 09:38:57 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.PrintWriter;

/**
 * QFe萔Œ`ꂽxNg\NXB
 *
 * @version $Revision: 1.19 $, $Date: 2000/04/26 09:38:57 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclLiteralVector2D
 */
public class JgclHomogeneousVector2D extends JgclVector2D {

    /**
     * WX B
     * @serial
     */
    private double wx;

    /**
     * WY B
     * @serial
     */
    private double wy;


    /**
     * W B
     * @serial
     */
    private double w;

    /**
     * wx, wy, w ݒ肷B
     * @param wx	WX 
     * @param wy	WY 
     * @param w	W 
     */
    private void setArgs(double wx, double wy, double w) {
	this.wx = wx;
	this.wy = wy;
	this.w = w;
    }

    /**
     * (wx/w, wy/w) Œ`IuWFNg\zB
     * 
     * @param wx	WX 
     * @param wy	WY 
     * @param w	W 
     */
    public JgclHomogeneousVector2D(double wx, double wy, double w) {
	super();
	setArgs(wx, wy, w);
    }

    /**
     * (c[0]/c[2], c[1]/c[2]) Œ`IuWFNg\zB
     * 
     * @param c	̔z
     */
    public JgclHomogeneousVector2D(double[] c) {
	super();
	setArgs(c[0], c[1], c[2]);
    }

    /**
     * (wx/w, wy/w) Œ`IuWFNg\zB
     * 
     * @param wx	WX 
     * @param wy	WY 
     * @param w	W 
     * @param confirmedAsUnitized	悤ƂxNg
     *					PʃxNgł邱ƂĂȂ <code>true</code>A
     *					Ȃ <code>false</code>
     */
    JgclHomogeneousVector2D(double wx, double wy, double w,
			    boolean confirmedAsUnitized) {
	super(confirmedAsUnitized);

	setArgs(wx, wy, w);
    }

    /**
     * (c[0]/c[2], c[1]/c[2]) Œ`IuWFNg\zB
     * 
     * @param c	̔z
     * @param confirmedAsUnitized	悤ƂxNg
     *					PʃxNgł邱ƂĂȂ <code>true</code>A
     *					Ȃ <code>false</code>
     */
    JgclHomogeneousVector2D(double[] c, boolean confirmedAsUnitized) {
	super(confirmedAsUnitized);

	setArgs(c[0], c[1], c[2]);
    }

    /**
     * X ԂB
     * 
     * @return	X 
     */
    public double x() {
	return wx/w;
    }

    /**
     * Y ԂB
     * 
     * @return	Y 
     */
    public double y() {
	return wy/w;
    }

    /**
     * WX ԂB
     * 
     * @return	WX 
     */
    public double wx() {
	return wx;
    }

    /**
     * WY ԂB
     * 
     * @return	WY 
     */
    public double wy() {
	return wy;
    }

    /**
     * W ԂB
     * 
     * @return	W 
     */
    public double w() {
	return w;
    }

    /**
     * ̃xNgA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclVector2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclVector2D vec;
	if (reverseTransform == false)
	    vec = transformationOperator.transform(this);
	else
	    vec = transformationOperator.reverseTransform(this);
	return new JgclHomogeneousVector2D((this.w * vec.x()), (this.w * vec.y()), this.w);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName() + " "
                       + wx() + " "
                       + wy() + " "
                       + w()  + " End");
    }
}

