/*
 * Q : Ȑ̌_\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntersectionPoint2D.java,v 1.31 2000/04/26 09:38:58 hideit Exp $
 *
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * Q : Ȑ̌_\NXB
 * <p>
 * ̃NX̃CX^X́A
 * _̎ԏł̍Wl_ coordinatesA
 * ̋Ȑł̈ʒu_ pointOnCurve1A
 * ̋Ȑł̈ʒu_ pointOnCurve2
 * ێB
 * </p>
 *
 * @version $Revision: 1.31 $, $Date: 2000/04/26 09:38:58 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclOverlapCurve2D
 */

public class JgclIntersectionPoint2D extends JgclPoint2D implements JgclCurveCurveInterference2D {
    /**
     * ԏł̍WlB
     * @serial
     */
    private final JgclPoint2D coordinates;

    /**
     * ̋Ȑ (Ȑ1) ł̈ʒuB
     * @serial
     */
    private final JgclPointOnCurve2D pointOnCurve1;

    /**
     * ̋Ȑ (Ȑ2) ł̈ʒuB
     * @serial
     */
    private final JgclPointOnCurve2D pointOnCurve2;

    /**
     * ̃CX^X̊etB[h̒l
     * ݂ɐ̂Ƃꂽ̂ł邩ǂ`FbNB
     * <p>
     * Ȃꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * @see	JgclInvalidArgumentValue
     */
    private void checkPoints() {
	if (!this.coordinates.identical(this.pointOnCurve1) ||
	    !this.coordinates.identical(this.pointOnCurve2) ||
	    !this.pointOnCurve1.identical(this.pointOnCurve2))
	    throw new JgclInvalidArgumentValue();
    }

    /**
     * Ȑ̌_̍WlƊeȐ̏ł̈ʒu^ăIuWFNg\zB
     * <p>
     * doCheck  true ̏ꍇɂ́A
     * etB[hɒlݒ肵
     * {@link #checkPoints() checkPoints()} ĂяoB
     * </p>
     * 
     * @param coordinates	ԏł̍Wl
     * @param pointOnCurve1	̋Ȑ (Ȑ1) ł̈ʒu
     * @param pointOnCurve2	̋Ȑ (Ȑ2) ł̈ʒu
     * @param doCheck		̃`FbN邩ǂ̃tO
     */
    JgclIntersectionPoint2D(JgclPoint2D coordinates,
			    JgclPointOnCurve2D pointOnCurve1,
			    JgclPointOnCurve2D pointOnCurve2,
			    boolean doCheck) {
        super();
        this.coordinates = coordinates;
        this.pointOnCurve1 = pointOnCurve1;
        this.pointOnCurve2 = pointOnCurve2;
	if (doCheck)
	    checkPoints();
    }

    /**
     * Ȑ̌_̊eȐ̏ł̈ʒu^ăIuWFNg\zB
     * <p>
     * _̎ԏł̍WĺAꂼ̋Ȑ̓_̒_ƂȂB
     * </p>
     * <p>
     * doCheck  true ̏ꍇɂ́A
     * etB[hɒlݒ肵
     * {@link #checkPoints() checkPoints()} ĂяoB
     * </p>
     * 
     * @param pointOnCurve1	̋Ȑ (Ȑ1) ł̈ʒu
     * @param pointOnCurve2	̋Ȑ (Ȑ2) ł̈ʒu
     * @param doCheck		̃`FbN邩ǂ̃tO
     */
    JgclIntersectionPoint2D(JgclPointOnCurve2D pointOnCurve1,
			    JgclPointOnCurve2D pointOnCurve2,
			    boolean doCheck) {
        super();
        this.pointOnCurve1 = pointOnCurve1;
        this.pointOnCurve2 = pointOnCurve2;
        this.coordinates = this.pointOnCurve1.linearInterpolate(this.pointOnCurve2, 0.5);
	if (doCheck)
	    checkPoints();
    }

    /**
     * Ȑ̌_̍WlƊeȐ̏ł̃p[^l^ăIuWFNg\zB
     * <p>
     * doCheck  true ̏ꍇɂ́A
     * etB[hɒlݒ肵
     * {@link #checkPoints() checkPoints()} ĂяoB
     * </p>
     * 
     * @param coordinates	ԏł̍Wl
     * @param curve1		̋Ȑ (Ȑ1)
     * @param param1		Ȑ1 ̃p[^l
     * @param curve2		̋Ȑ (Ȑ2)
     * @param param2		Ȑ2 ̃p[^l
     * @param doCheck		̃`FbN邩ǂ̃tO
     */
    JgclIntersectionPoint2D(JgclPoint2D coordinates,
			    JgclParametricCurve2D curve1, double param1,
			    JgclParametricCurve2D curve2, double param2,
			    boolean doCheck) {
        super();
        this.coordinates = coordinates;
        this.pointOnCurve1 = new JgclPointOnCurve2D(curve1, param1, doCheckDebug);
        this.pointOnCurve2 = new JgclPointOnCurve2D(curve2, param2, doCheckDebug);
	if (doCheck)
	    checkPoints();
    }

    /**
     * Ȑ̌_̊eȐ̏ł̃p[^l^ăIuWFNg\zB
     * <p>
     * _̎ԏł̍WĺAꂼ̋Ȑ̓_̒_ƂȂB
     * </p>
     * <p>
     * doCheck  true ̏ꍇɂ́A
     * etB[hɒlݒ肵
     * {@link #checkPoints() checkPoints()} ĂяoB
     * </p>
     * 
     * @param curve1		̋Ȑ (Ȑ1)
     * @param param1		Ȑ1 ̃p[^l
     * @param curve2		̋Ȑ (Ȑ2)
     * @param param2		Ȑ2 ̃p[^l
     * @param doCheck		̃`FbN邩ǂ̃tO
     * @param doCheck		̃`FbN邩ǂ̃tO
     */
    JgclIntersectionPoint2D(JgclParametricCurve2D curve1, double param1,
			    JgclParametricCurve2D curve2, double param2,
			    boolean doCheck) {
        super();
        this.pointOnCurve1 = new JgclPointOnCurve2D(curve1, param1, doCheckDebug);
        this.pointOnCurve2 = new JgclPointOnCurve2D(curve2, param2, doCheckDebug);
        this.coordinates = this.pointOnCurve1.linearInterpolate(this.pointOnCurve2, 0.5);
	if (doCheck)
	    checkPoints();
    }

    /**
     * ̓_ X WlԂB
     *
     * @return	_ X Wl
     */
    public double x() {
        return coordinates.x();
    }

    /**
     * ̓_ Y WlԂB
     *
     * @return	_ Y Wl
     */
    public double y() {
        return coordinates.y();
    }

    /**
     * ̌_̎ԏł̍WlԂB
     * 
     * @return	ԏł̍Wl
     */
    public JgclPoint2D coordinates() {
        return coordinates;
    }

    /**
     * ̌_̋Ȑ1 ł̈ʒuԂB
     * 
     * @return Ȑ1 ł̈ʒu
     */
    public JgclPointOnCurve2D pointOnCurve1() {
        return pointOnCurve1;
    }

    /**
     * ̌_̋Ȑ2 ł̈ʒuԂB
     * 
     * @return Ȑ2 ł̈ʒu
     */
    public JgclPointOnCurve2D pointOnCurve2() {
        return pointOnCurve2;
    }

    /**
     * ̊_ł邩ۂԂB
     *
     * @return	_Ȃ̂ŁA true
     * @see	#isOverlapCurve()
     */
    public boolean isIntersectionPoint() {
	return true;
    }

    /**
     * ̊I[o[bvł邩ۂԂB
     *
     * @return	I[o[bvł͂Ȃ_Ȃ̂ŁA false
     * @see	#isIntersectionPoint()
     */
    public boolean isOverlapCurve() {
	return false;
    }

    /**
     * ̊_ɕϊB
     * <p>
     * gԂB
     * </p>
     *
     * @return	g
     */
    public JgclIntersectionPoint2D toIntersectionPoint() {
	return this;
    }

    /**
     * ̊I[o[bvɕϊB
     * <p>
     * _I[o[bvɕϊ邱Ƃ͂łȂ̂ null ԂB
     * </p>
     *
     * @return	 null
     */
    public JgclOverlapCurve2D toOverlapCurve() {
	return null;
    }

    /**
     * ̌_ pointOnCurve1  pointOnCurve2 _ԂB
     *
     * @return	pointOnCurve1  pointOnCurve2 _
     */
    public JgclIntersectionPoint2D exchange() {
	JgclIntersectionPoint2D ex =
	    new JgclIntersectionPoint2D(coordinates,
					pointOnCurve2, pointOnCurve1, doCheckDebug);
	return ex;
    }

    /**
     * ̊̈̋Ȑ (Ȑ1) ł̈ʒuA
     * ^ꂽϊɂĕϊ̂ɒuԂB
     * <p>
     * ̌_ pointOnCurve1 ̃p[^l sec ͈̔͂OĂꍇɂ
     * null ԂB
     * </p>
     *
     * @param sec	Ȑ1 ̃p[^
     * @param conv	Ȑ1 ̃p[^lϊIuWFNg
     * @return	Ȑ1 ̈ʒu^ꂽϊɂĕϊ̂ɒu
     */
    public JgclCurveCurveInterference2D trim1(JgclParameterSection sec,
					      JgclParameterConversion2D conv) {
	double param = pointOnCurve1.parameter();
	JgclParametricCurve2D curve =
	    (JgclParametricCurve2D)pointOnCurve1.geometry();
	JgclConditionOfOperation cond =
	    JgclConditionOfOperation.getCondition();

	cond.makeCopy(cond.getToleranceForDistanceAsObject()
		      .toToleranceForParameter(curve, param)).push();
	try {
	    if (!sec.isValid(param))
		return null;
	}
	finally {
	    JgclConditionOfOperation.pop();
	}
	JgclPointOnCurve2D poc = conv.convToPoint(param);
	return new JgclIntersectionPoint2D(poc, pointOnCurve2, doCheckDebug);
    }

    /**
     * ̊̑̋Ȑ (Ȑ2) ł̈ʒuA
     * ^ꂽϊɂĕϊ̂ɒuԂB
     * <p>
     * ̌_ pointOnCurve2 ̃p[^l sec ͈̔͂OĂꍇɂ
     * null ԂB
     * </p>
     *
     * @param sec	Ȑ2 ̃p[^
     * @param conv	Ȑ2 ̃p[^lϊIuWFNg
     * @return	Ȑ2 ̈ʒu^ꂽϊɂĕϊ̂ɒu
     */
    public JgclCurveCurveInterference2D trim2(JgclParameterSection sec,
					      JgclParameterConversion2D conv) {
	double param = pointOnCurve2.parameter();
	JgclParametricCurve2D curve =
	    (JgclParametricCurve2D)pointOnCurve2.geometry();
	JgclConditionOfOperation cond =
	    JgclConditionOfOperation.getCondition();

	cond.makeCopy(cond.getToleranceForDistanceAsObject()
		      .toToleranceForParameter(curve, param)).push();
	try {
	    if (!sec.isValid(param))
		return null;
	}
	finally {
	    JgclConditionOfOperation.pop();
	}
	JgclPointOnCurve2D poc = conv.convToPoint(param);
	return new JgclIntersectionPoint2D(pointOnCurve1, poc, doCheckDebug);
    }

    /**
     * ̊̈̋Ȑ (Ȑ1) ^ꂽȐɒuԂB
     * <p>
     * p[^lȂǂ͂̂܂܁B
     * </p>
     *
     * @param newCurve	Ȑ1 ɐݒ肷Ȑ
     * @return	Ȑ1u
     */
    public JgclCurveCurveInterference2D changeCurve1(JgclParametricCurve2D newCurve) {
	JgclPointOnCurve2D newPointOnCurve1 =
	    new JgclPointOnCurve2D(newCurve, this.pointOnCurve1.parameter(), doCheckDebug);

	return new JgclIntersectionPoint2D(newPointOnCurve1, this.pointOnCurve2, doCheckDebug);
    }

    /**
     * ̊̑̋Ȑ (Ȑ2) ^ꂽȐɒuԂB
     * <p>
     * p[^lȂǂ͂̂܂܁B
     * </p>
     *
     * @param newCurve	Ȑ2 ɐݒ肷Ȑ
     * @return	Ȑ2 u
     */
    public JgclCurveCurveInterference2D changeCurve2(JgclParametricCurve2D newCurve) {
	JgclPointOnCurve2D newPointOnCurve2 =
	    new JgclPointOnCurve2D(newCurve, this.pointOnCurve2.parameter(), doCheckDebug);

	return new JgclIntersectionPoint2D(this.pointOnCurve1, newPointOnCurve2, doCheckDebug);
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclPoint2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint2D tCoordinates =
	    this.coordinates.transformBy(reverseTransform,
					 transformationOperator, transformedGeometries);
	JgclPointOnCurve2D tPointOnCurve1 = 
	    (JgclPointOnCurve2D)this.pointOnCurve1.transformBy(reverseTransform,
							       transformationOperator,
							       transformedGeometries);
	JgclPointOnCurve2D tPointOnCurve2 =
	    (JgclPointOnCurve2D)this.pointOnCurve2.transformBy(reverseTransform,
							       transformationOperator,
							       transformedGeometries);
	return new JgclIntersectionPoint2D(tCoordinates,
					   tPointOnCurve1,
					   tPointOnCurve2,
					   doCheckDebug);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tcoordinates");
        coordinates.output(writer, indent + 2);
        writer.println(indent_tab + "\tpointOnCurve1");
        pointOnCurve1.output(writer, indent + 2);
        writer.println(indent_tab + "\tpointOnCurve2");
        pointOnCurve2.output(writer, indent + 2);
        writer.println(indent_tab + "End");
    }
}
