/*
 * 3D~ȐƃxWGȖʂ̌_߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntsCncBzs3D.java,v 1.15 2000/08/11 06:18:51 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;
import java.io.*;

/**
 * RF~ȐƃxWGȖʂ̌_߂NX
 * <p>
 * xWGȖʂ͕ʂƂ݂Ȃ܂ŕA
 * ܂͉~Ȑƕʂ̌ɋAB
 * A~Ȑ x ʂŋ߂_́AZ̏lƂāA
 * ŏIIɂ͎ZɂāA߂B
 * </p>
 * @version $Revision: 1.15 $, $Date: 2000/08/11 06:18:51 $
 * @author Information-technology Promotion Agency, Japan
 */
final class JgclIntsCncBzs3D {
    /**
     * Ȑ(~Ȑ̂ǂ炩)
     */
    JgclParametricCurve3D dA;

    /**
     * xWGȖ
     */
    JgclPureBezierSurface3D dB;

    /**
     * _ێ邽߂̃Xg\
     */
    JgclCurveSurfaceInterferenceList solutions;

    /**
     * ̌덷
     */
    double dTol;

    /**
     * ̌덷2
     */
    double dTol2;

    /**
     * p[^̌덷
     */
    double pTol;

    /**
     * _̋Ȑ̓_
     */
    JgclPoint3D sApnt;

    /**
     * _̋Ȗʏ̓_
     */
    JgclPoint3D sBpnt;

    /**
     * ϊꂽxWGȖ
     */
    JgclPureBezierSurface3D bzsL;

    /**
     * ϊ
     */
    JgclCartesianTransformationOperator3D transform;

    private static final int UNKNOWN = 0;
    private static final int BEZIER = 1;
    private static final int LINE = 2;
    private static final int POINT = 3;
    private static final int PLANER = 4;

    /**
     * ~ȐƃxWGȖʂ^鎖ɂČ߂邽߂
     * IuWFNg\zB
     *
     * @param curve ~Ȑ
     * @param bzs   xWGȖ
     */
    JgclIntsCncBzs3D(JgclParametricCurve3D curve,
		     JgclPureBezierSurface3D bzs) {
	//
	// tB[hȂǂ̏ݒ
	//
	super();

	this.dA = curve;
	this.dB = bzs;
	JgclConditionOfOperation cond =
	    JgclConditionOfOperation.getCondition();
	dTol2 = cond.getToleranceForDistance2();
	dTol = cond.getToleranceForDistance();
	pTol = cond.getToleranceForParameter();

	JgclAxis2Placement3D position;
	if (curve instanceof JgclLine3D) {
	    JgclLine3D line = (JgclLine3D)curve;
	    position = new JgclAxis2Placement3D(line.pnt(),
						line.dir().verticalVector().unitized(),
						line.dir().unitized());
	}
	else if (curve instanceof JgclConic3D){
	    position = ((JgclConic3D)curve).position();
	}
	else
	    throw new JgclFatal();

	transform = new JgclCartesianTransformationOperator3D(position);
	solutions = new JgclCurveSurfaceInterferenceList(curve, bzs);
    }

    /**
     * xWGȖʂ𕽖ʂƂ݂ȂĂƂ̏߂̓NX
     */
    class BezierSurfaceInfo {
	private JgclPureBezierSurface3D bzs;
	private double usp;
	private double uep;
	private double vsp;
	private double vep;
	JgclEnclosingBox3D box;
	private PlaneBezier pb;
	private int currentType;

	/**
	 * xWGȖʁAu,v Jnp[^A
	 * u,v Ip[^Ȃǂ̏pāAIuWFNg\zB
	 */
	BezierSurfaceInfo(JgclPureBezierSurface3D bzs,
			  double usp, double uep,
			  double vsp, double vep) {
	    this.bzs = bzs;
	    this.usp = usp;
	    this.uep = uep;
	    this.vsp = vsp;
	    this.vep = vep;
	    this.box = bzs.approximateEnclosingBox();
	    this.currentType = UNKNOWN;
  	    this.pb = new PlaneBezier(bzs);
	}

	/**
	 * xWGȖʂǂ̂悤Ȍ`ɂ݂Ȃ邩𒲂ׂB
	 *
	 * @return     xWGȖʂǂ̂悤Ȍ`󂩂\߂̐
	 */
	int whatTypeIsBezierSurface() {
	    if (currentType != UNKNOWN)
		return currentType;

	    int u_uicp = bzs.uNControlPoints();
	    int v_uicp = bzs.vNControlPoints();
	    PlaneBezier pb;
	    JgclVector3D evec;

	    currentType = BEZIER;

	    /*
	     * make_refplane can change the way of making a plane with
	     * bi's parameter rectangle, but it is a little dangerous
	     * with freeform VS. freeform.
	     */
	    this.pb = pb = new PlaneBezier(bzs);
	    JgclPoint3D org = pb.origin();
	    JgclVector3D zaxis = pb.zaxis();
	    JgclVector3D[] xyz = pb.axis.axes();

	    /*
	     * just return if Bezier is not planar
	     */
	    for (int j = 0; j < v_uicp; j++)
		for (int i = 0; i < u_uicp; i++) {
		    evec = bzs.controlPointAt(i, j).subtract(org);
		    if (Math.abs(evec.dotProduct(zaxis)) > dTol)
			return currentType;
		}

	    /*
	     * Bezier is planar, so make the JgclPureBezierCurve3D
	     */
  	    currentType = POINT;

	    /*
	     * boundary curves
	     */
	    for (int i = 0; i < 4; i++) {
		int uicp = ((i % 2) == 0) ? u_uicp : v_uicp;
		JgclPoint3D pnt = null;
		if (pb.shape_info[i] == 0) {
		    pb.bcrv[i] = null;
		    continue;
		}

		JgclPoint2D[] pnt2d = new JgclPoint2D[uicp];
		double[] ws = new double[uicp];
		for (int j = 0; j < uicp; j++) {
		    switch (i) {
		    case 0:
			pnt = bzs.controlPointAt(j, 0);
			if (bzs.isRational())
			    ws[j] = bzs.weightAt(j, 0);
			break;
		    case 1: 
			pnt = bzs.controlPointAt(u_uicp-1, j);
			if (bzs.isRational())
			    ws[j] = bzs.weightAt(u_uicp-1, j);
			break;
		    case 2: 
			pnt = bzs.controlPointAt(u_uicp-1-j, v_uicp-1);
			if (bzs.isRational())
			    ws[j] = bzs.weightAt(u_uicp-1-j, v_uicp-1);
			break;
		    case 3: 
			pnt = bzs.controlPointAt(0, v_uicp-1-j);
			if (bzs.isRational())
			    ws[j] = bzs.weightAt(0, v_uicp-1-j);
			break;
		    }
		    evec = pnt.subtract(org);
		    pnt2d[j] = new JgclCartesianPoint2D
			(evec.dotProduct(xyz[0]), evec.dotProduct(xyz[1]));
		}

		if (bzs.isRational()) {
		    pb.bcrv[i] = new JgclPureBezierCurve2D(pnt2d, ws);
		}
		else {
		    pb.bcrv[i] = new JgclPureBezierCurve2D(pnt2d);
		}

		JgclVector2D s2e = pnt2d[uicp-1].subtract(pnt2d[0]).unitized();
		int j;
		for (j = 1; j < (uicp - 1); j++) {
		    JgclVector2D evec2 = pnt2d[j].subtract(pnt2d[0]);
		    double edot = evec2.dotProduct(s2e);
		    if (Math.abs(evec2.norm() - (edot * edot)) > dTol2)
			break;
		}
		pb.bcrv_is_line[i] = (j == (uicp - 1)) ? true : false;

		if (pb.bcrv_is_line[i]) {
		    currentType = LINE;
		}
		else {
		    currentType = PLANER;
		}
	    }
	    return currentType;
	}

	/**
	 * ߂ꂽ_ʏɏĂ邩ǂ𒲂ׂB
	 *
	 * @param      ʏɂ邩ǂ𒲂ׂ_
	 * @return     _ʏɂ邩ǂ̐^Ul
	 */
	private boolean isPointInPlane(JgclPoint3D point) {
	    if ((point.x() > (box.max().x() + dTol)) ||
		(point.y() > (box.max().y() + dTol)) ||
		(point.z() > (box.max().z() + dTol)) ||
		(point.x() < (box.min().x() - dTol)) ||
		(point.y() < (box.min().y() - dTol)) ||
		(point.z() < (box.min().z() - dTol))) {
		return false;
	    }

	    JgclVector3D evec = point.subtract(pb.origin());
	    JgclPoint2D point2d = new JgclCartesianPoint2D(evec.dotProduct(pb.axis.x()),
							   evec.dotProduct(pb.axis.y()));
  	    JgclVector2D dir = new JgclLiteralVector2D(0.70710678, 0.70710678);
	    JgclLine2D line2d = new JgclLine2D(point2d, dir);

	    /*
	     * saved_ipl_list check is needed
	     */
	    Vector saved_ipl_list = new Vector();
	    double saved_ipl = 0;

	    int icnt = 0;
	    for (int i = 0; i < 4; i++) {
		if (pb.bcrv[i] == null)
		    continue;
		JgclIntersectionPoint2D[] intp;
		try {
		    intp = line2d.intersect(pb.bcrv[i]);
		}
		catch (JgclIndefiniteSolution e) {
		    throw new JgclFatal();
		}
		if (intp.length <= 0)
		    continue;

		for (int j = 0; j < intp.length; j++) {
		    double ipl = intp[j].pointOnCurve1().parameter();
		    if (ipl > -dTol) {
			if (ipl < dTol) {
			    /*
			     * line's parameter = 0.0 : is_in = TRUE
			     */
			    return true;
			}

			/*
			 * ۑp[^ƐVp[^rāA
			 * ̃p[^͒ǉȂ
			 */
			int k;
			for (k = 0; k < saved_ipl_list.size(); k++) {
			    saved_ipl = ((Double)saved_ipl_list.elementAt(k)).doubleValue();
			    if (Math.abs(ipl - saved_ipl) < dTol)
				break;
			}
			if (k == saved_ipl_list.size()) {
			    saved_ipl_list.addElement(new Double(ipl));
			    icnt++;
			}
		    }
		}
	    }
  	    if (!((icnt % 2) != 0))
		return false;
	    return true;
	}

	/**
	 * 邩ǂ
	 *
	 * @param curve Ȑ(ۂ͒~Ȑ̂ǂ炩)
	 * @return      邩ǂ
	 */
	private boolean checkInterfere(JgclParametricCurve3D curve) {
	    // 
	    // ̎̏
	    // curve.checkInterfere(this);
	    // ƂƂ낾AParametricCurve3D ȉ̃NXׂĂ
	    // checkInterfereȂ΂Ȃ̂ŁAĂB
	    //
	    if (curve instanceof JgclLine3D)
		return ((JgclLine3D)curve).checkInterfere(this);
	    else if (curve instanceof JgclConic3D)
		return ((JgclConic3D)curve).checkInterfere(this);
	    else
		throw new JgclFatal();
	}

	/**
	 * _߂
	 *
	 * @param line 
	 */
	private void intersectLinePlane(JgclLine3D line) {
	    // gh3ints_linpln
	    JgclPoint3D origin = pb.origin();
	    JgclVector3D[] xyz = pb.axis.axes();
	    double eS, eT;
	    eT = ((origin.y() * xyz[0].z())
		  - (origin.z() * xyz[0].y()))
		/ ((xyz[1].z() * xyz[0].y())
		   - (xyz[1].y() * xyz[0].z()));

	    if (Math.abs(xyz[0].y()) > dTol)
		eS = -(origin.y() + (eT * xyz[1].y())) / xyz[0].y();
	    else
		eS = -(origin.z() + (eT * xyz[1].z())) / xyz[0].z();

	    // intersect_lin_pln
	    double x =  origin.x() + (eS *  xyz[0].x()) + (eT * xyz[1].x());
 	    JgclPoint3D point = new JgclCartesianPoint3D(x, 0, 0);

	    if (!this.isPointInPlane(point))
		return;

	    double ework = Math.sqrt(line.dir().norm());
	    JgclLine3D aLineL =
		new JgclLine3D(JgclPoint3D.origin,
			       new JgclLiteralVector3D(ework, 0, 0));

	    double aParam = x / aLineL.dir().x();
	    double bUParam = (usp + uep) / 2.0;
	    double bVParam = (vsp + vep) / 2.0;
	    PointInfo pi = new PointInfo(point, aParam, bUParam, bVParam);
	    if (refinePointInfo(pi)) {
		pi.pnt = transform.toEnclosed(pi.pnt);
		solutions.addAsIntersection(pi.pnt, pi.aParam,
					    pi.bUParam, pi.bVParam);
	    }
	    return;
	}

	/**
	 * _߂
	 *
	 * @param cnc ~Ȑ
	 */
	private void intersectConicPlane(JgclConic3D cnc) {
	    JgclIntersectionPoint3D[] intp =
		cnc.intersectConicPlane(new JgclPlane3D(pb.axis));
	    for (int i = 0; i < intp.length; i++) {
		if (!this.isPointInPlane(intp[i]))
		    continue;
  		JgclPoint3D point = intp[i].coordinates();
		double aParam = intp[i].pointOnCurve1().parameter();
  		double bUParam = (usp + uep) / 2.0;
  		double bVParam = (vsp + vep) / 2.0;
		PointInfo pi = new PointInfo(point, aParam, bUParam, bVParam);
      		if (refinePointInfo(pi)) {
		    pi.pnt = transform.toEnclosed(pi.pnt);
		    solutions.addAsIntersection(pi.pnt, pi.aParam,
    						pi.bUParam, pi.bVParam);
		}
  	    }
  	    return;
	}
    }

    /**
     * ߎȖʂ\NX
     */
    final class PlaneBezier {
	/**
	 * ߎʂ\ǏWn
	 */
	JgclAxis2Placement3D axis;

	/*
	 * boundary curves
	 * (0 : u = 0), (1 : v = 1), (2 : u = 1), (3 : v = 0)
	 */
	JgclPureBezierCurve2D[] bcrv;

	/*
	 * flags for whether each of boundaries is linear or not
	 */
	boolean[] bcrv_is_line;

	/**
	 * kނĂȂӂ̐
	 */
	int edge_cnt;

	/**
	 * shape_info[i] = 1 if i-th edge is not reduced
	 */
	int[] shape_info;

	/**
	 * xWGȖʂ^ăIuWFNg\zB
	 *
	 * @param xWGȖ
	 */
	PlaneBezier(JgclPureBezierSurface3D bzs) {
	    int u_uicp = bzs.uNControlPoints();
	    int v_uicp = bzs.vNControlPoints();

	    JgclPoint3D c00, c10, c01, c11;
	    double u0norm, v0norm, u1norm, v1norm;
	    JgclVector3D u0dir, v0dir, u1dir, v1dir;	/* vectors which connect corners */
	    int iu0dir, iv0dir, iu1dir, iv1dir;
	    int retrying = 0;
	    JgclVector3D udir = null;
	    JgclVector3D vdir = null;
	    
	    shape_info = new int[4];

	    bcrv_is_line = new boolean[4];
	    bcrv = new JgclPureBezierCurve2D[4];

	    /*
	     * make 4 vectors which connect 4 corners
	     *
	     *	         u1dir
	     *	    +<--------+
	     *	    |         ^
	     *	    |         |
	     *	    |v0dir    |v1dir
	     *	  ^ |         |
	     *	  | v         |
	     *	 v| +-------->+
	     *	    -->  u0dir
	     *	    u
	     */
	    c00 = bzs.controlPointAt(0, 0);
	    c10 = bzs.controlPointAt(u_uicp - 1, 0);
	    c01 = bzs.controlPointAt(0, v_uicp - 1);
	    c11 = bzs.controlPointAt(u_uicp - 1, v_uicp - 1);

	    u0dir = c10.subtract(c00);
	    v1dir = c11.subtract(c10);
	    u1dir = c01.subtract(c11);
	    v0dir = c00.subtract(c01);

	    /*
	     * select 2 vectors which are not reduced
	     */
	RETRY_IF_BALLOON:
	    do {
		u0norm = u0dir.norm(); iu0dir = (u0norm > dTol2) ? 1 : 0;
		v0norm = v0dir.norm(); iv0dir = (v0norm > dTol2) ? 1 : 0;
		u1norm = u1dir.norm(); iu1dir = (u1norm > dTol2) ? 1 : 0;
		v1norm = v1dir.norm(); iv1dir = (v1norm > dTol2) ? 1 : 0;
		edge_cnt = iu0dir + iv0dir + iu1dir + iv1dir;
		shape_info[0] = iu0dir;
		shape_info[3] = iv0dir;
		shape_info[2] = iu1dir;
		shape_info[1] = iv1dir;

		switch (edge_cnt) {
		case 4:		/* rectangular (has 4 edges) */
		    udir = u0dir;
		    vdir = v0dir;
		    break;

		case 3:		/* triangular (has 3 edges) */
		    if (iu0dir == 0) {
			udir = v1dir.multiply(-1);
			vdir = v0dir;
		    } else if (iv0dir == 0) {
			udir = u0dir;
			vdir = u1dir.multiply(-1);
		    } else {
			udir = u0dir;
			vdir = v0dir;
		    }
		    break;

		case 2:		/* football shape (has 2 edges) */
		    udir = vdir = null;
		    if (iu0dir == 1) {
			udir = bzs.controlPointAt(1, 0)
			    .subtract(bzs.controlPointAt(0, 0));
		    }
		    if (iv0dir == 1) {
			if (udir == null) {
			    udir = bzs.controlPointAt(0, 1)
				.subtract(bzs.controlPointAt(0, 0));
			} else {
			    vdir = bzs.controlPointAt(0, 1)
				.subtract(bzs.controlPointAt(0, 0));
			    break;
			}
		    }
		    if (iu1dir == 1) {
			if (udir == null) {
			    udir = bzs.controlPointAt(u_uicp-2, v_uicp-1)
				.subtract(bzs.controlPointAt(u_uicp-1, v_uicp-1));

			} else {
			    if (iu0dir == 1)
				vdir = bzs.controlPointAt(1, v_uicp-1)
				    .subtract(bzs.controlPointAt(0, v_uicp-1));
			    else
				vdir = bzs.controlPointAt(u_uicp-2, v_uicp-1)
				    .subtract(bzs.controlPointAt(u_uicp-1, v_uicp-1));
			    break;
			}
		    } else {	/* if (iv1dir == 1) */
			if (iv0dir == 1)
			    vdir = bzs.controlPointAt(u_uicp-1, 1)
				.subtract(bzs.controlPointAt(u_uicp-1, 0));
			else
			    vdir = bzs.controlPointAt(u_uicp-1, v_uicp-2)
				.subtract(bzs.controlPointAt(u_uicp-1, v_uicp-1));
		    }
		    break;

		default:		/* has 1 edge */
		case 0:		/* balloon shape (has no edge) */
		    if (retrying == 1)
			return;
		    retrying = 1;

		    /*
		     * make 4 vectors from neighbour points at 4 corners
		     */
		    u0dir = bzs.controlPointAt(1, 0)
			.subtract(bzs.controlPointAt(0, 0));
		    v0dir = bzs.controlPointAt(0, 1)
			.subtract(bzs.controlPointAt(0, 0));
		    u1dir = bzs.controlPointAt(u_uicp-2, v_uicp-1)
			.subtract(bzs.controlPointAt(u_uicp-1, v_uicp-1));
		    v1dir = bzs.controlPointAt(u_uicp-1, v_uicp-2)
			.subtract(bzs.controlPointAt(u_uicp-1, v_uicp-1));
		    continue RETRY_IF_BALLOON;
		}
		break RETRY_IF_BALLOON;
	    } while (true);

	    udir = udir.unitized();
	    vdir = vdir.unitized();
	    axis = new JgclAxis2Placement3D(c00, udir.crossProduct(vdir),udir);
	}

	/**
	 * ǏWň_Ԃ
	 *
	 * @return ǏWň_
	 */
	JgclPoint3D origin() {
	    return axis.location();
	}

	/**
	 * ǏWnzԂ
	 *
	 * @return ǏWnz
	 */
	JgclVector3D zaxis() {
	    return axis.z();
	}
    }

    /**
     * _̏\NX
     */
    final class PointInfo {
	/**
	 * 3D coordinates
	 */
	JgclPoint3D pnt;

	/**
	 * parameter of curve A
	 */
	double aParam;

	/**
	 * U parameter of surface B
	 */
	double bUParam;

	/**
	 * V parameter of surface B
	 */
	double bVParam;

	/**
	 * _ƋȐ̃p[^AȖʏu, vp[^^
	 * IuWFNg\zB
	 */
	PointInfo(JgclPoint3D pnt, double aParam, double bUParam, double bVParam) {
	    this.pnt = pnt;
	    this.aParam = aParam;
	    this.bUParam = bUParam;
	    this.bVParam = bVParam;
	}
    }

    /**********************************************************************
     *
     * Definitions of private function
     *
     **********************************************************************/

    /**
     * ꂽȖʂƋȐ̌_߂(intersect_linpln)
     *
     * @param bsi xWGȖʏ
     */
    private void intersect_dA_plane(BezierSurfaceInfo bsi) {
	// Line or Conic 𔻒f Dispatch 
	if (dA instanceof JgclLine3D)
	    bsi.intersectLinePlane((JgclLine3D)dA);
	else if (dA instanceof JgclConic3D)
	    bsi.intersectConicPlane((JgclConic3D)dA);
	else
	    throw new JgclFatal();

	return;
    }

    /**
     * nl_func
     */
    private class nlFunc implements JgclRealFunction {
	private nlFunc() {
	    super();
	}

	public double[] evaluate(double[] parameter) {
	    JgclVector3D evec = sApnt.subtract(sBpnt);
	    double[] vec = new double[3];
	    vec[0] = evec.x();
	    vec[1] = evec.y();
	    vec[2] = evec.z();

	    return vec;
	}
    }

   /**
     * dnl_func
     */
    private class dnlFunc implements JgclRealFunction {
	int idx;
	private dnlFunc(int idx) {
	    super();
	    this.idx = idx;
	}
	public double[] evaluate(double[] parameter) {
	    JgclVector3D aTang;
	    JgclVector3D[] bTang = new JgclVector3D[3];

	    if (dA instanceof JgclLine3D) {
		aTang = ((JgclLine3D)dA).dnlFunc
		    (dA.parameterDomain().force(parameter[0]));
	    }
	    else if (dA instanceof JgclConic3D) {
		aTang = ((JgclConic3D)dA).dnlFunc
		    (dA.parameterDomain().force(parameter[0]));
	    }
	    else
		throw new JgclFatal();

  	    bTang = bzsL.tangentVector(dB.uParameterDomain().force(parameter[1]),
				       dB.vParameterDomain().force(parameter[2]));
	    switch (idx) {
	    case 0:
		return new double[]{aTang.x(), -bTang[0].x(), -bTang[1].x()};
	    case 1:
		return new double[]{aTang.y(), -bTang[0].y(), -bTang[1].y()};
	    case 2:
		return new double[]{aTang.z(), -bTang[0].z(), -bTang[1].z()};
	    default:
		throw new JgclFatal();

	    }
	}
    }

    /**
     * cnv_func
     */
    private class cnvFunc implements JgclBooleanFunctionWithRealVariables {
	private cnvFunc() {
	    super();
	}

	public boolean evaluate(double[] parameter) {
  	    if (dA instanceof JgclLine3D)
  		sApnt = ((JgclLine3D)dA).nlFunc
  		    (dA.parameterDomain().force(parameter[0]));
  	    else if (dA instanceof JgclConic3D)
  		sApnt = ((JgclConic3D)dA).nlFunc
  		    (dA.parameterDomain().force(parameter[0]));
  	    else
  		throw new JgclFatal();

  	    sBpnt = bzsL.coordinates(dB.uParameterDomain().force(parameter[1]),
				     dB.vParameterDomain().force(parameter[2]));

	    return sApnt.identical(sBpnt);
	}
    }

    /**
     * setback_params
     */
    private void setbackParams(PointInfo pi, double[] param) {
	JgclPoint3D aPnt = null;
	JgclPoint3D bPnt = null;

	pi.aParam = dA.parameterDomain().force(param[0]);
	pi.bUParam = dB.uParameterDomain().force(param[1]);
	pi.bVParam = dB.vParameterDomain().force(param[2]);

	if (dA instanceof JgclLine3D) {
	    aPnt = ((JgclLine3D)dA).nlFunc(pi.aParam);
	}
	else if (dA instanceof JgclConic3D) {
	    aPnt = ((JgclConic3D)dA).nlFunc(pi.aParam);
	}
	bPnt = bzsL.coordinates(pi.bUParam, pi.bVParam);

	pi.pnt = aPnt.linearInterpolate(bPnt, 0.5);
    }

    /**
     * ̐s(refine_pointinfo)
     *
     * @param pi _
     */
    boolean refinePointInfo(PointInfo pi)
    {
	double[] param = new double[3];
	param[0] = pi.aParam;
	param[1] = pi.bUParam;
	param[2] = pi.bVParam;
  	nlFunc nl_func = new nlFunc();
	JgclRealFunction[] dnl_func = new JgclRealFunction[3];
	dnl_func[0] = new dnlFunc(0);
	dnl_func[1] = new dnlFunc(1);
	dnl_func[2] = new dnlFunc(2);
	cnvFunc cnv_func = new cnvFunc();

	param = JgclMath.solveSimultaneousEquations(nl_func, dnl_func,
						    cnv_func, param);
	if (param == null)
	    return false;
	setbackParams(pi, param);
	return true;
    }

    /**
     * _𓾂(get_intersection)
     *
     * @param crnt_bi xWGȖʏ
     * @param level   Kw
     */
    void getIntersections(BezierSurfaceInfo crnt_bi) {
	BezierSurfaceInfo bi00, bi01, bi10, bi11;
	boolean ci00, ci01, ci10, ci11;
	/*
	 * is current bezier regarded as plane ?
	 */
  	if (crnt_bi.whatTypeIsBezierSurface() != BEZIER) {
    	    intersect_dA_plane(crnt_bi);
	    return;
	}

	/*
	 * generate children
	 */
	double half_point = 0.5;	
	double ug_half = (crnt_bi.usp + crnt_bi.uep) / 2.0;
	double vg_half = (crnt_bi.vsp + crnt_bi.vep) / 2.0;

    RETRY:
	do {
	    JgclPureBezierSurface3D[] geomB = crnt_bi.bzs.vDivide(half_point);
	    JgclPureBezierSurface3D[] bzs0 = geomB[0].uDivide(half_point);
	    JgclPureBezierSurface3D[] bzs1 = geomB[1].uDivide(half_point);

	    bi00 = new BezierSurfaceInfo(bzs0[0],
					 crnt_bi.usp, ug_half,
					 crnt_bi.vsp, vg_half);
	    bi01 = new BezierSurfaceInfo(bzs0[1],
					 ug_half, crnt_bi.uep,
					 crnt_bi.vsp, vg_half);
	    bi10 = new BezierSurfaceInfo(bzs1[0],
					 crnt_bi.usp, ug_half,
					 vg_half, crnt_bi.vep);
	    bi11 = new BezierSurfaceInfo(bzs1[1],
					 ug_half, crnt_bi.uep,
					 vg_half, crnt_bi.vep);

	    ci00 = bi00.checkInterfere(dA);
	    ci01 = bi01.checkInterfere(dA);
	    ci10 = bi10.checkInterfere(dA);
	    ci11 = bi11.checkInterfere(dA);

	    if (half_point > 0.45) {
		if ((ci00 != true) && (ci01 != true)
		    && (ci10 != true) && (ci11 != true)) {
		    half_point = 0.4;
		    ug_half = (0.6 * crnt_bi.usp) + (0.4 * crnt_bi.uep);
		    vg_half = (0.6 * crnt_bi.vsp) + (0.4 * crnt_bi.vep);
		    continue RETRY;
		}
	    }
	    break RETRY;
	} while(true);

	/*
	 * recursive call
	 */
  	if (ci00 == true) getIntersections(bi00);
  	if (ci01 == true) getIntersections(bi01);
  	if (ci10 == true) getIntersections(bi10);
  	if (ci11 == true) getIntersections(bi11);
  	return;
    }

    /**
     * xWGȖʂɕϊ(transform_bezier)
     *
     * @param curve Ȑ(~Ȑ)
     * @param bzs   xWGȖ
     * @return      ϊꂽxWGȖ
     */
    JgclPureBezierSurface3D transformBezier(JgclParametricCurve3D curve,
					    JgclPureBezierSurface3D bzs) {
	int uncp = bzs.uNControlPoints();
	int vncp = bzs.vNControlPoints();

	JgclPoint3D[][] cp = new JgclPoint3D[uncp][vncp];
	for (int i = 0; i < uncp; i++)
	    for (int j = 0; j < vncp; j++)
		cp[i][j] = transform.toLocal(bzs.controlPointAt(i, j));

	if (!bzs.isRational()) {
	    return new JgclPureBezierSurface3D(cp);
	}
	else {
	    return new JgclPureBezierSurface3D(cp, bzs.weights());
	}
    }

    /*********************************************************************
     *
     * Body (defined as external, since this is called from gh3intsBssBss.c)
     *
     **********************************************************************/

    /**
     * ~ȐƃxWGȖʂ̌_𓾂
     *
     * @param dA Conic          A
     * @param dB Bezier Surface B
     * @return   _̔z
     */
    JgclCurveSurfaceInterferenceList intsCncBzs() {
	// Preparation
	// Initialize Tree & Make Roots
    	bzsL = transformBezier(dA, dB);
	BezierSurfaceInfo dBRoot = new BezierSurfaceInfo(bzsL, 0.0, 1.0, 0.0, 1.0);

	// check interfere
	boolean hasInterfere;
	if (dA instanceof JgclLine3D)
	    hasInterfere = ((JgclLine3D)dA).checkInterfere(dBRoot);
	else if (dA instanceof JgclConic3D)
	    hasInterfere = ((JgclConic3D)dA).checkInterfere(dBRoot);
	else
	    throw new JgclFatal();

	//get intersection
	if (hasInterfere)
	    getIntersections(dBRoot);

	// Make Results
	return solutions;
    }

    /**
     * ~ȐƃxWGȖʂ̌_𓾂
     *
     * @param cnc ~Ȑ
     * @param bzs xWGȖ
     * @return    _̔z
     */
    static JgclIntersectionPoint3D[] intersection(JgclConic3D cnc,
						  JgclPureBezierSurface3D bzs,
						  boolean doExchange)
    {
	JgclIntsCncBzs3D doObj = new JgclIntsCncBzs3D(cnc, bzs);
	return doObj.intsCncBzs().toJgclIntersectionPoint3DArray(doExchange);
    }

    /**
     * ƃxWGȖʂ̌_𓾂
     *
     * @param line 
     * @param bzs  xWGȖ
     * @return     _̔z
     */
    static JgclIntersectionPoint3D[] intersection(JgclLine3D line,
						  JgclPureBezierSurface3D bzs,
						  boolean doExchange)
    {
	JgclIntsCncBzs3D doObj = new JgclIntsCncBzs3D(line, bzs);
	return doObj.intsCncBzs().toJgclIntersectionPoint3DArray(doExchange);
    }
}
/* end of file */
