/*
 * 2D̉~Ȑm̌_߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntsCncCnc2D.java,v 1.7 2000/04/26 09:39:01 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.util.Enumeration;

/**
 * 2D̉~Ȑm̌_߂NX
 *
 * @version $Revision: 1.7 $, $Date: 2000/04/26 09:39:01 $
 * @author Information-technology Promotion Agency, Japan
 */

abstract class JgclIntsCncCnc2D {

    /**
     *  ̌W𓾂
     *
     * @param eccoef	̌W
     * @return		̉
     */
    protected JgclComplex[] getRoot(double[] eccoef) {
	JgclComplexPolynomial poly;
	JgclComplex[] root;

	// get a complex polynomial
	try {
	    poly = new JgclComplexPolynomial(eccoef);
	}
	catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}

	// solve equation
	if (poly.degree() < 3) {
	    // quadratic case
	    root = poly.getRootsIfQuadric();
	} else {
	    // other cases
	    try {
		root = poly.getRootsByDKA();
	    }
	    catch (JgclComplexPolynomial.DKANotConverge e) {
		root = e.getValues();
	    }
	    catch (JgclComplexPolynomial.ImpossibleEquation e) {
		throw new JgclFatal();
	    }
	    catch (JgclComplexPolynomial.IndefiniteEquation e) {
		throw new JgclFatal();
	    }
	}

	return root;
    }

    /**
     *  _i[Vectorzɕϊ
     *
     * @param		intervec _i[Vector
     * @param 		doExchange _pointOnCurve1,2邩ǂ
     * @return		l߂̌W
     */
    protected JgclIntersectionPoint2D[] vectorToArray(Vector intervec,
						      boolean doExchange)
    {
 	JgclIntersectionPoint2D[] intersectPoints = new 
 	    JgclIntersectionPoint2D[intervec.size()];
 	intervec.copyInto(intersectPoints);
	if (doExchange) {
	    for (int i = 0; i < intersectPoints.length; i++)
		intersectPoints[i] = intersectPoints[i].exchange();
	}
	return intersectPoints;
    }

    /**
     * ߂_dĂȂǂmF
     * 
     * @param inter	_
     * @param intervec	_̃xNg
     * @return		dȂ <code>true</code>,
     *		        Ȃ <code>false<code>
     * @see		JgclIntersectionPoint2D
     * @see		JgclPointOnCurve2D
     * @see		Vector
     */
    protected boolean checkUnique(JgclIntersectionPoint2D inter, 
				  Vector intervec) {
	Enumeration en = intervec.elements();
	double paramA = inter.pointOnCurve1().parameter();
	double paramB = inter.pointOnCurve2().parameter();
	JgclParametricCurve2D curveA = inter.pointOnCurve1().basisCurve();
	JgclParametricCurve2D curveB = inter.pointOnCurve2().basisCurve();

	while (en.hasMoreElements()) {
	    JgclIntersectionPoint2D obj = 
		(JgclIntersectionPoint2D) en.nextElement();

	    JgclPointOnCurve2D pointA = obj.pointOnCurve1();
	    if (curveA.identicalParameter(paramA, pointA.parameter()))
		return false;

	    JgclPointOnCurve2D pointB = obj.pointOnCurve2();
	    if (curveB.identicalParameter(paramB, pointB.parameter()))
		return false;
	}
	return true;
    }
}
