/*
 * 2D|Cm̌_߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntsPolPol2D.java,v 1.12 2000/04/26 09:39:02 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 2D|Cm̌_߂NX
 *
 * @version $Revision: 1.12 $, $Date: 2000/04/26 09:39:02 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclIntsPolPol2D {
    private JgclPolyline2D dA;
    private JgclVector2D[] dA_uvecs;
    private double[] dA_lengs;
    private JgclEnclosingBox2D dA_enrc;
    private JgclPolyline2D dB;
    private JgclVector2D[] dB_uvecs;
    private double[] dB_lengs;
    private JgclEnclosingBox2D dB_enrc;

    private JgclIntsPolPol2D(JgclPolyline2D dA, JgclPolyline2D dB) {
	this(dA, null, null, null, dB, null, null, null);
    }

    private JgclIntsPolPol2D(JgclPolyline2D dA, JgclVector2D[] dA_uvecs,
			     double[] dA_lengs, JgclEnclosingBox2D dA_enrc,
			     JgclPolyline2D dB, JgclVector2D[] dB_uvecs,
			     double[] dB_lengs, JgclEnclosingBox2D dB_enrc) {
	super();

	this.dA = dA;
	this.dA_uvecs = dA_uvecs;
	this.dA_lengs = dA_lengs;
	this.dA_enrc = dA_enrc;

	this.dB = dB;
	this.dB_uvecs = dB_uvecs;
	this.dB_lengs = dB_lengs;
	this.dB_enrc = dB_enrc;
    }

    private class SegmentInfo {
	private JgclBoundedLine2D bln;	/* a segment */
	private JgclVector2D udir;	/* unitized vector */
	private double leng;		/* length of segment */
	private double tol;		/* tolerance */
	private JgclEnclosingBox2D box;	/* enclosing box */

	private SegmentInfo(JgclPoint2D spnt, JgclPoint2D epnt, JgclVector2D udir, double leng) {
	    super();
	    double d_tol = spnt.getToleranceForDistance();

	    if (udir == null) {
		this.udir = epnt.subtract(spnt);
		this.leng = this.udir.length();
		if (this.leng > d_tol)
		    this.udir = this.udir.divide(this.leng);
		else
		    this.udir = JgclVector2D.zeroVector;
	    } else {
		this.udir = udir;
		this.leng = leng;
	    }
	    if (this.leng <= d_tol) {
		this.tol = -1.0;
		bln = null;
		box = null;
	    } else {
		this.tol = d_tol / this.leng;
		bln = new JgclBoundedLine2D(spnt, epnt, JgclGeometry.doCheckDebug);
		box = bln.enclosingBox();
	    }
	}

	private SegmentInfo(JgclPoint2D spnt, JgclPoint2D epnt) {
	    this(spnt, epnt, null, 0.0);
	}
    }

    private JgclCurveCurveInterferenceList
    getInterference(boolean doRoughCheck) {
	JgclCurveCurveInterferenceList interferenceList
	    = new JgclCurveCurveInterferenceList(dA, dB);

	if (doRoughCheck) {
	    if (dA_enrc == null)
		dA_enrc = dA.enclosingBox();
	    if (dB_enrc == null)
		dB_enrc = dB.enclosingBox();

	    if (!dA_enrc.hasIntersection(dB_enrc))
		return interferenceList;
	}

	int Anseg = dA.nSegments();	/* # of segments of A */
	int Bnseg = dB.nSegments();	/* # of segments of B */

	SegmentInfo Asi;		/* a segment of A */
	SegmentInfo[] Bsi;		/* array of segments of B */

	JgclCurveCurveInterference2D intf;

	int i, j;			/* loop counter */


	Bsi = new SegmentInfo[Bnseg];
	for (i = 0; i < Bnseg; i++) {
	    if (dB_uvecs == null)
		Bsi[i] = new SegmentInfo(dB.pointAt(i), dB.pointAt(i+1));
	    else
		Bsi[i] = new SegmentInfo(dB.pointAt(i), dB.pointAt(i+1), dB_uvecs[i], dB_lengs[i]);
	}

	/*
	 * for each segment of dA
	 */
	for (i = 0; i < Anseg; i++) {
	    if (dA_uvecs == null)
		Asi = new SegmentInfo(dA.pointAt(i), dA.pointAt(i+1));
	    else
		Asi = new SegmentInfo(dA.pointAt(i), dA.pointAt(i+1), dA_uvecs[i], dA_lengs[i]);

	    if (Asi.tol < 0.0)
		continue;

	    if ((dB_enrc != null) || doRoughCheck)
		if (!Asi.box.hasIntersection(dB_enrc))
		    continue;

	    /*
	     * for each segment of dB
	     */
	    for (j = 0; j < Bnseg; j++) {
		if (Bsi[j].tol < 0.0)
		    continue;

		if (!Asi.box.hasIntersection(Bsi[j].box))
		    continue;

		intf = Asi.bln.interfere1(Bsi[j].bln, Asi.udir, Bsi[j].udir,
					  Asi.leng, Bsi[j].leng);
		if (intf == null)
		    continue;

		if (intf.isIntersectionPoint()) {
		    /*
		     * intersect
		     */
		    JgclIntersectionPoint2D ints = intf.toIntersectionPoint();
		    interferenceList.addAsIntersection
			(ints.coordinates(),
			 ints.pointOnCurve1().parameter() + i,
			 ints.pointOnCurve2().parameter() + j,
			 Asi.tol, Bsi[j].tol);
		} else {
		    /*
		     * overlap
		     */
		    JgclOverlapCurve2D ovlp = intf.toOverlapCurve();
		    interferenceList.addAsOverlap
			(ovlp.start1() + i,
			 ovlp.start2() + j,
			 ovlp.increase1(),
			 ovlp.increase2(),
			 Asi.tol, Bsi[j].tol,
			 Asi.tol, Bsi[j].tol);
		}
	    }
	}

	interferenceList.removeOverlapsContainedInOtherOverlap();
	interferenceList.removeIntersectionsContainedInOverlap();

	return interferenceList;
    }

    /**
     * 2|Č_𓾂
     *
     * @param poly1	|C1
     * @param poly2	|C2
     * @return		_̔z
     * @see		JgclIntersectionPoint2D
     */
    static JgclIntersectionPoint2D[] intersection(JgclPolyline2D poly1, JgclPolyline2D poly2,
						  boolean doExchange) {
	JgclIntsPolPol2D doObj = new JgclIntsPolPol2D(poly1, poly2);
	return doObj.getInterference(true).toJgclIntersectionPoint2DArray(doExchange);
    }

    /**
     * 2|C̊𓾂
     *
     * @param poly1	|C1
     * @param poly2	|C2
     * @return		2Ȑ̊̔z
     * @see		JgclCurveCurveInterference2D
     */
    static JgclCurveCurveInterference2D[] interference(JgclPolyline2D poly1,
					     JgclPolyline2D poly2) {
	JgclIntsPolPol2D doObj = new JgclIntsPolPol2D(poly1, poly2);
	return doObj.getInterference(true).toJgclCurveCurveInterference2DArray(false);
    }

    /**
     * 2|C̊𓾂()
     *
     * @param dA	|C1
     * @param dA_uvecs	eZOg̐KxNg
     * @param dA_lengs	eZOg̒
     * @param dA_enrc	|C̑ݔ͈͂`
     * @param dB	|C2
     * @param dB_uvecs	eZOg̐KxNg
     * @param dB_lengs	eZOg̒
     * @param dB_enrc	|C̑ݔ͈͂`
     * @return		2Ȑ̊̔z
     * @see		JgclCurveCurveInterference2D
     * @see		JgclPolyline2D
     * @see		JgclVector2D
     * @see		JgclEnclosingBox2D
     */
    static JgclCurveCurveInterference2D[] interference(JgclPolyline2D dA, JgclVector2D[] dA_uvecs,
					     double[] dA_lengs, JgclEnclosingBox2D dA_enrc,
					     JgclPolyline2D dB, JgclVector2D[] dB_uvecs,
					     double[] dB_lengs, JgclEnclosingBox2D dB_enrc) {
	JgclIntsPolPol2D doObj = new JgclIntsPolPol2D(dA, dA_uvecs, dA_lengs, dA_enrc,
						      dB, dB_uvecs, dB_lengs, dB_enrc);
	return doObj.getInterference(false).toJgclCurveCurveInterference2DArray(false);
    }
}
