/*
 * 񎟌̃ItZbgvZNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclOfst2D.java,v 1.12 2000/08/11 06:18:54 shikano Exp $
 */

package jp.go.ipa.jgcl;

/**
 * 񎟌̃ItZbgvZNX
 *
 * @version $Revision: 1.12 $, $Date: 2000/08/11 06:18:54 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclOfst2D {
    
    /**
     * ItZbgȐ
     */
    private JgclParametricCurve2D curve;
    
    /**
     * ItZbg̈
     */
    private JgclParameterSection pint;
    
    /**
     * ItZbg
     */
    private int side;
    
    /**
     * ItZbg̒
     */
    private double magni;
    
    /**
     * 덷
     */
    private JgclToleranceForDistance tolerance;
	
    /*
     * TvOϐ
     */
//    private JgclPoint2D[] sampling_points;
    private JgclPolyline2D poly;
    private double[] sampling_parameters;

    /**
     *	RXgN^
     *
     * @param     curve     ItZbgȐ
     * @param	  pint	    ItZbg
     * @param	  magni	    ItZbg
     * @param	  side	    ItZbg̕
     * @param	  tolerance 덷
     */
    JgclOfst2D(JgclParametricCurve2D curve,
	       JgclParameterSection pint,
	       double magni,
	       int side,
	       JgclToleranceForDistance tolerance){
	curve.checkValidity(pint);
	this.curve = curve;
	this.pint = pint;
	this.side = side;
	this.magni = magni;
	this.tolerance = tolerance;
    }
    
    /**
     * ItZbgȐ߂
     *
     * @return	   ItZbgȐ
     */
    private JgclBsplineCurve2D offset_bsc(){
	
	// TvOϐvZ
	set_sample_variables();
	
	// ItZbgϐvZ
	JgclPoint2D[] offset_points = set_offset_points();
	double[] offset_parameters = set_offset_parameters(offset_points);

	// ԋߎ
	JgclBsplineCurve2D obsc = approx_bsc(offset_points,offset_parameters);
	
	return obsc;
    }
    
    /**
     * TvOϐvZ
     *
     */
    private void set_sample_variables(){
	double[] parameter;
	int i,j;
	
	// |Cɕϊ
	poly = curve.toPolyline(pint,tolerance);

	// TvOp^߂
	sampling_parameters = new double[poly.nPoints()];
	
	for(i=0;i<poly.nPoints();i++)
	    sampling_parameters[i] = 
		((JgclPointOnCurve2D)poly.pointAt(i)).parameter();
    }
    
    /**
     * ItZbg_vZ
     *
     * @return    ItZbg_
     */
    private JgclPoint2D[] set_offset_points(){
	
	JgclPoint2D[] offset_points = 
	    new JgclPoint2D[sampling_parameters.length];

	for(int i=0;i<sampling_parameters.length;i++)
	    offset_points[i] = make_offset_point(sampling_parameters[i]);

	return offset_points;
    }
	
    /**
     * ItZbgp^vZ
     *
     * @param   offset_points ItZbg_
     * @return                ItZbgp^
     */
    private double[] set_offset_parameters(JgclPoint2D[] offset_points){
	
	double[] parameters = new double[offset_points.length];
	parameters[0] = 0.0;
	JgclPoint2D source_point = offset_points[0];
	
	for(int i=1;i<offset_points.length;i++){
	    parameters[i] +=
		offset_points[i].distance(source_point)
		    + parameters[i-1];
	    source_point = offset_points[i];
	}
	
	double[] offset_parameters = new double[parameters.length];
	double lower = pint.lower();
	double interval = pint.increase();
	double maxlength = parameters[parameters.length-1];
	
	for(int i=0;i<parameters.length;i++){
	    offset_parameters[i] = 
		lower + (parameters[i]/maxlength) * interval;
	}

	return offset_parameters;
    }
    
    /**
     * ItZbg_BXvCȐŋߎ
     *
     * @param  offset_points     ItZbg_
     * @param  offset_parameters ItZbgp[^
     * @return		         ItZbgȐ
     */
    private JgclBsplineCurve2D approx_bsc(JgclPoint2D[] offset_points,
					  double[] offset_parameters){
 	
	// ߎ֐ɓnvZ
	JgclToleranceForDistance mid_tol = comp_mid_tol();
	
	// [_̐ڐxNg
	JgclVector2D[] EndVector = new JgclVector2D[2];
	EndVector[0] = curve.tangentVector(pint.start());
	EndVector[1] = curve.tangentVector(pint.end());

	// Ă
	if(poly.isClosed()){
	    JgclPoint2D[] closed_offset_points = 
		new JgclPoint2D[offset_points.length-1];
	    for(int i=0;i<offset_points.length-1;i++)
		closed_offset_points[i] = offset_points[i];
	    offset_points = closed_offset_points;
	}

	// ߎBXvCIuWFNg쐬
	JgclBsplineCurve2D bsc = 
	    new JgclBsplineCurve2D(offset_points,
				   offset_parameters,
				   EndVector,
				   poly.isClosed(),
				   tolerance,
				   mid_tol);

	return bsc;
    }
    
    /**
     * ~ʂ܂ł̋H߂
     *
     * @param  points	TvO_
     * @param  index	~l_̃CfbNX
     * @return		~ʂ܂ł̋
     */
    private double get_circular_arc_height(JgclPoint2D[] points,int index){

	double height;
	double leng01,leng02;
	JgclCircle2D circle;

	try{
	    circle = new JgclCircle2D(points[index],
				      points[index+1],
				      points[index+2]);
	}catch (JgclInvalidArgumentValue e){
	    return 0;
	}


	leng01 = points[index].distance(points[index+1])/2;
	leng02 = points[index+1].distance(points[index+2])/2;
	if(leng01 > leng02)
	    height = circle.radius() - Math.sqrt((circle.radius()*circle.radius()) - (leng01 * leng01));
	else 
	    height = circle.radius() - Math.sqrt((circle.radius()*circle.radius()) - (leng02 * leng02));
	
	return height;
    }
    
    /**
     * ߎ֐ɓn߂
     *
     * @return		 ߎ֐ɓn
     */
    private JgclToleranceForDistance comp_mid_tol(){
        double mid_tol;
        double height;
        int i,j;
        
        if(poly.nPoints() < 3)
            return tolerance;
        
        mid_tol = 0.0;
	
        for(i=2,j=0;i<poly.nPoints();i++,j++){
            height = get_circular_arc_height(poly.points(),j);
	    
            if((i == 2)||(mid_tol < height))
                mid_tol = height;
        }
	
        // ~܂͑ȉ~Ńp[^͈͂Q΂̂Ƃ
	
        /*
           Ăꍇ͓_̔z͈ȉ̂悤ɂȂĂ
	   
	                      0    1    2    c
	   c  n-3    n-2    n-1
	   
	   ܂_̍ŏƍŌ͓_ĂB
	   ̂ߕĂƂ
	   n-2    0    1
	   ̏ꍇ̌덷ׂKvB
	   */ 
	
        if(curve.isClosed() == true){
            JgclPoint2D[] cross_boundary_points = new JgclPoint2D[3];
            cross_boundary_points[0] 
		= poly.pointAt(poly.nPoints() - 2);
	    //sampling_points[sampling_points.length-2];
            cross_boundary_points[1] = poly.pointAt(0);
            cross_boundary_points[2] = poly.pointAt(1);
	    
            height = get_circular_arc_height(cross_boundary_points,0);
            if(mid_tol < height)
		mid_tol = height;
        }
        
        mid_tol += tolerance.value();
	return new JgclToleranceForDistance(mid_tol);
    }
    
    /**
     * ̃p[^lɑ΂ItZbg_vZ
     *
     * @param param    p[^
     * @return	       ItZbg_
     */
    private JgclPoint2D make_offset_point(double param){
	JgclVector2D tng = curve.tangentVector(param);
	tng = tng.unitized();
	
	JgclLiteralVector2D offset_dir;
	
	if(side == JgclWhichSide.LEFT)
	    offset_dir = new JgclLiteralVector2D(-1*tng.y(),tng.x());
	else if(side == JgclWhichSide.RIGHT)
	    offset_dir = new JgclLiteralVector2D(tng.y(),-1*tng.x());
	else 
	    throw new JgclInvalidArgumentValue();

	offset_dir = (JgclLiteralVector2D)offset_dir.unitized();
	offset_dir = (JgclLiteralVector2D)offset_dir.multiply(magni);
	
	JgclPoint2D cnt_pnt = curve.coordinates(param);
	JgclPoint2D offset_point = cnt_pnt.add(offset_dir);
	
	return offset_point;
    }
    
    /**
     * ItZbgȐԂ
     *
     * @return	    ItZbgȐ
     */
    JgclBsplineCurve2D offset(){
	if(magni == 0.0)
	    return curve.toBsplineCurve(pint);
	else
	    return offset_bsc();
    }	 
}
