/*
 * Ȑ̓_ƋԂ̃XgNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclParameterRangeOnCurveList.java,v 1.5 2000/04/26 09:39:14 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * Ȑ̓_ƋԂ̃XgNX
 *
 * @version $Revision: 1.5 $, $Date: 2000/04/26 09:39:14 $
 * @author Information-technology Promotion Agency, Japan
 */
class JgclParameterRangeOnCurveList
{
    /**
     * Ȑ݂̑Ԃ̎
     */
    int dimension;

    /**
     * Ȑ
     */
    JgclParametricCurve curve;

    /**
     * Ȑ̒`
     */
    JgclParameterDomain parameterDomain;

    /**
     * ̋e덷 (IuWFNg\zꂽ_ł)
     */
    JgclToleranceForDistance dTol;

    /**
     * _̃Xg
     */
    Vector listOfPoints;

    /**
     * Ԃ̃Xg
     */
    Vector listOfSections;

    /*
     * IuWFNg\z
     *
     * @param	curve	Ȑ
     */
    JgclParameterRangeOnCurveList(JgclParametricCurve curve)
    {
	if (curve == null)
	    throw new JgclNullArgument();

	this.dimension = curve.dimension();
	this.curve = curve;
	this.parameterDomain = curve.parameterDomain();

	JgclConditionOfOperation cond = JgclConditionOfOperation.getCondition();
	this.dTol = cond.getToleranceForDistanceAsObject();

	this.listOfPoints = new Vector();
	this.listOfSections = new Vector();
    }

    /**
     * Ȑ̂p[^lt߂ł̃p[^̋e덷߂B
     *
     * ToleranceForDistance Zo
     *
     * @param	curve	Ȑ
     * @param	param	p[^l
     */
    private double getToleranceForParameter(JgclParametricCurve curve, double param)
    {
	if (dimension == 2) {
	    return dTol.toToleranceForParameter((JgclParametricCurve2D)curve, param).value();
	} else {
	    return dTol.toToleranceForParameter((JgclParametricCurve3D)curve, param).value();
	}
    }

    /*
     * _̃p[^lƂ݂Ȃ邩ۂAɊւ萔
     */
    private static final int PARAMETERS_NOT_IDENTICAL = 0x0;
    private static final int PARAMETERS_IDENTICAL     = 0x1;
    private static final int PARAMETERS_CROSSBOUNDARY = 0x2;

    /**
     * _̃p[^lƂ݂Ȃ邩ۂA\
     */
    class ParametricalIdentityOfTwoPoints {
	/**
	 * _̃p[^lƂ݂Ȃ邩ۂA\
	 */
	private int value;

	/**
	 * IuWFNg\z
	 */
	ParametricalIdentityOfTwoPoints() {
	    setNonIdentical();
	}

	/**
	 * _̃p[^lƂ݂ȂȂ̂Ƃ
	 */
	private void setNonIdentical() {
	    value = PARAMETERS_NOT_IDENTICAL;
	}

	/**
	 * _̃p[^lƂ݂Ȃ̂Ƃ
	 */
	private void setIdentical() {
	    value |= PARAMETERS_IDENTICAL;
	}

	/**
	 * _̃p[^lȐ̋ÊׂƂ
	 */
	private void setCrossBoundary()
	{
	    value |= PARAMETERS_CROSSBOUNDARY;
	}

	/**
	 * _̃p[^lƂ݂Ȃ邩ۂ
	 */
	private boolean isIdentical()
	{
	    return ((value & PARAMETERS_IDENTICAL) != 0);
	}

	/**
	 * _̃p[^lȐ̋Eׂۂ
	 */
	private boolean isCrossBoundary()
	{
	    return ((value & PARAMETERS_CROSSBOUNDARY) != 0);
	}
    }

    /**
     * _̏
     */
    class PointInfo
    {
	/**
	 * _̍Wl (null Ȃ)
	 */
	JgclPoint coord;

	/**
	 * _̋Ȑł̃p[^l
	 */
	double param;

	/**
	 * Ȑ param t߂ł̃p[^̋e덷
	 */
	double pTol;

	/**
	 * IuWFNg\z
	 *
	 * @param	coord	_̍Wl (null Ȃ)
	 * @param	param	_̋Ȑł̃p[^l
	 */
	PointInfo(JgclPoint coord,
		  double param)
	{
	    this.coord = coord;	// null Ȃ
	    this.param = param;

	    this.pTol = getToleranceForParameter(curve, param);
	}

	/**
	 * IuWFNg\z
	 *
	 * @param	coord	_̍Wl (null Ȃ)
	 * @param	param	_̋Ȑł̃p[^l
	 * @param	pTol	Ȑ param t߂ł̃p[^̋e덷
	 */
	PointInfo(JgclPoint coord,
		  double param,
		  double pTol)
	{
	    this.coord = coord;	// null Ȃ
	    this.param = param;
	    this.pTol = pTol;
	}

	/**
	 * _̃p[^lƂ݂Ȃ邩ۂAɂĂ̏𓾂
	 *
	 * @param	mate	_̏
	 */
	private ParametricalIdentityOfTwoPoints getParametricalIdentityWith(PointInfo mate)
	{
	    ParametricalIdentityOfTwoPoints result =
		new ParametricalIdentityOfTwoPoints();

	    if (this == mate) {
		result.setIdentical();
		return result;
	    }

	    double diff = Math.abs(this.param - mate.param);
	    double pTol = Math.max(this.pTol, mate.pTol);

	    if ((parameterDomain.isPeriodic() == true) &&
		(Math.abs(diff - parameterDomain.section().absIncrease()) < pTol))
		result.setCrossBoundary();

	    if ((result.isCrossBoundary() == true) || (diff < pTol))
		result.setIdentical();

	    return result;
	}

	/**
	 * _Ƃ݂Ȃ邩ۂ
	 *
	 * @param	mate	_̏
	 */
	private boolean isIdenticalWith(PointInfo mate)
	{
	    if ((this.coord != null) && (mate.coord != null)) {
		if (dimension == 2) {
		    if (((JgclPoint2D)this.coord).identical((JgclPoint2D)mate.coord) != true)
			return false;
		}
		else
		{
		    if (((JgclPoint3D)this.coord).identical((JgclPoint3D)mate.coord) != true)
			return false;
		}
	    }

	    return this.getParametricalIdentityWith(mate).isIdentical();
	}

	/**
	 * ԂɊ܂܂Ă邩ۂ
	 *
	 * @param	mate	
	 * @return	ԂɊ܂܂ trueAłȂ false
	 */
	boolean isContainedIn(SectionInfo ovlp)
	{
	    if (this.isIdenticalWith(ovlp.headPoint) == true)
		return true;

	    if (this.isIdenticalWith(ovlp.tailPoint) == true)
		return true;

	    double ovlpLower;
	    double ovlpUpper;

	    if (ovlp.headPoint.param < ovlp.tailPoint.param)
	    {
		ovlpLower = ovlp.headPoint.param - ovlp.headPoint.pTol;
		ovlpUpper = ovlp.tailPoint.param + ovlp.tailPoint.pTol;
	    }
	    else
	    {
		ovlpLower = ovlp.tailPoint.param - ovlp.tailPoint.pTol;
		ovlpUpper = ovlp.headPoint.param + ovlp.headPoint.pTol;
	    }

	    if (ovlp.crossBoundary == true)
	    {
		double swap = ovlpLower; ovlpLower = ovlpUpper; ovlpUpper = swap;
	    }

	    if ((this.param < ovlpLower) && (ovlpUpper < this.param))
		return false;

	    return true;
	}
    }

    /**
     * _ǉ
     *
     * ɗ^ꂽ_ƓƂ݂Ȃ_ɑ݂Ƃɂ́A
     * ɗ^ꂽ_͒ǉȂ
     *
     * @param	thePoint	_
     */
    void addPoint(PointInfo thePoint)
    {
	for (Enumeration e = listOfPoints.elements(); e.hasMoreElements();)
	    if (thePoint.isIdenticalWith((PointInfo)e.nextElement()) == true)
		return;

	listOfPoints.addElement(thePoint);
    }

    /**
     * _ǉ
     *
     * ɗ^ꂽ_ƓƂ݂Ȃ_ɑ݂Ƃɂ́A
     * ɗ^ꂽ_͒ǉȂ
     *
     * @param	coord	_̍Wl (null Ȃ)
     * @param	param	_̋Ȑł̃p[^l
     */
    void addAsPoint(JgclPoint coord,
		    double param)
    {
	/*** Debug
	coord.output(System.out);

	if (dimension == 2)
	{
	    ((JgclParametricCurve2D)curve).coordinates(param).output(System.out);
	}
	else
	{
	    ((JgclParametricCurve3D)curve).coordinates(param).output(System.out);
	}
	***/

	addPoint(new PointInfo(coord, param));
    }

    /**
     * _ǉ
     *
     * ɗ^ꂽ_ƓƂ݂Ȃ_ɑ݂Ƃɂ́A
     * ɗ^ꂽ_͒ǉȂ
     *
     * @param	coord	_̍Wl (null Ȃ)
     * @param	param	_̋Ȑł̃p[^l
     * @param	pTol	Ȑ param t߂ł̃p[^̋e덷
     */
    void addAsPoint(JgclPoint coord,
		    double param,
		    double pTol)
    {
	addPoint(new PointInfo(coord, param, pTol));
    }

    /**
     * ԂɊ܂܂Ă_폜
     */
    void removePointsContainedInSection()
    {
	Vector clonedList = (Vector)(listOfPoints.clone());
	listOfPoints.removeAllElements();

	for (Enumeration e1 = clonedList.elements(); e1.hasMoreElements();)
	{
	    PointInfo point = (PointInfo)e1.nextElement();
	    boolean contained = false;

	    for (Enumeration e2 = listOfSections.elements(); e2.hasMoreElements();)
	    {
		if (point.isContainedIn((SectionInfo)e2.nextElement()) == true)
		{
		    contained = true;
		    break;
		}
	    }

	    if (contained != true)
		listOfPoints.addElement(point);
	}
    }

    /**
     * Ԃ̏
     */
    class SectionInfo
    {
	/**
	 * Ԃ̊Jn_
	 */
	PointInfo headPoint;

	/**
	 * Ԃ̏I_
	 */
	PointInfo tailPoint;

	/**
	 * ԂȐ̎̋Eׂł邩ۂBׂłΐ^
	 */
	private boolean crossBoundary;

	/**
	 * IuWFNg\z
	 *
	 * @param	headParam	Ԃ̊Jn_̋Ȑł̃p[^l
	 * @param	increaseParam	Ԃ̋Ȑł̃p[^l
	 */
	SectionInfo(double headParam,
		    double increaseParam)
	{
	    headParam = parameterDomain.wrap(headParam);
	    double tailParam = parameterDomain.wrap(headParam + increaseParam);

	    this.headPoint = new PointInfo(null, headParam);
	    this.tailPoint = new PointInfo(null, tailParam);

	    if (((headParam > tailParam) && (increaseParam > 0)) ||
		((headParam < tailParam) && (increaseParam < 0)))
		this.crossBoundary = true;
	    else
		this.crossBoundary = false;
	}

	/**
	 * IuWFNg\z
	 *
	 * @param	headParam	Ԃ̊Jn_̋Ȑł̃p[^l
	 * @param	increaseParam	Ԃ̋Ȑł̃p[^l
	 * @param	headPTol	Ȑ̊Jn_t߂ł̃p[^̋e덷
	 * @param	tailPTol	Ȑ̏I_t߂ł̃p[^̋e덷
	 */
	SectionInfo(double headParam,
		    double increaseParam,
		    double headPTol,
		    double tailPTol)
	{
	    headParam = parameterDomain.wrap(headParam);
	    double tailParam = parameterDomain.wrap(headParam + increaseParam);

	    this.headPoint = new PointInfo(null, headParam, headPTol);
	    this.tailPoint = new PointInfo(null, tailParam, tailPTol);

	    if (((headParam > tailParam) && (increaseParam > 0)) ||
		((headParam < tailParam) && (increaseParam < 0)))
		this.crossBoundary = true;
	    else
		this.crossBoundary = false;
	}

	/**
	 * crossBoundary ̒lXV
	 *
	 * @param	mate	
	 * @param	identity	p[^̓ꐫ
	 */
	private void setCrossBoundaryFlags(SectionInfo mate,
					   ParametricalIdentityOfTwoPoints identity)
	{
	    if ((mate.crossBoundary == true) || (identity.isCrossBoundary() == true))
		this.crossBoundary = true;
	}

	/*
 	 * p[^̑lvZĕԂ
	 *
	 * @return	p[^̑l
	 */
	private double computeIncrease()
	{
	    double increase = this.tailPoint.param - this.headPoint.param;

	    if ((parameterDomain.isPeriodic() == true) && (this.crossBoundary == true))
	    {
		if (increase > 0.0)
		    increase -= parameterDomain.section().absIncrease();
		else
		    increase += parameterDomain.section().absIncrease();
	    }

	    return increase;
	}

	/**
	 * ^ꂽԂqĂ΁Athis Ƀ}[W
	 *
	 * @param	mate	
	 * @return	qĂ trueAłȂ false
	 */
	boolean mergeIfConnectWith(SectionInfo mate)
	{
	    if (this == mate)
		return false;

	    ParametricalIdentityOfTwoPoints identity;

	    // this   mate
	    // -----------
	    // Head - Head	: this.increase = this.increase - mate.increase;
	    identity = this.headPoint.getParametricalIdentityWith(mate.headPoint);
	    if (identity.isIdentical() == true)
	    {
		this.headPoint = mate.tailPoint;
		this.setCrossBoundaryFlags(mate, identity);
		return true;
	    }

	    // Head - Tail	: this.increase = this.increase + mate.increase;
	    identity = this.headPoint.getParametricalIdentityWith(mate.tailPoint);
	    if (identity.isIdentical() == true)
	    {
		this.headPoint = mate.headPoint;
		this.setCrossBoundaryFlags(mate, identity);
		return true;
	    }

	    // Tail - Head	: this.increase = this.increase + mate.increase;
	    identity = this.tailPoint.getParametricalIdentityWith(mate.headPoint);
	    if (identity.isIdentical() == true)
	    {
		this.tailPoint = mate.tailPoint;
		this.setCrossBoundaryFlags(mate, identity);
		return true;
	    }

	    // Tail - Tail	: this.increase = this.increase - mate.increase;
	    identity = this.tailPoint.getParametricalIdentityWith(mate.tailPoint);
	    if (identity.isIdentical() == true)
	    {
		this.tailPoint = mate.headPoint;
		this.setCrossBoundaryFlags(mate, identity);
		return true;
	    }

	    return false;
	}

	/**
	 * ̋ԂɊ܂܂Ă邩ۂ
	 *
	 * @param	mate	
	 * @return	̋ԂɊ܂܂ trueAłȂ false
	 */
	boolean isContainedIn(SectionInfo mate)
	{
	    if (mate == this)
		return false;

	    double mateLower;
	    double mateUpper;

	    if (mate.crossBoundary == false)
	    {
		if (this.crossBoundary == true)
		{
		    /*
		     * mate:  |---------------|
		     * this: - -|          |- - -
		     */
		    return false;
		}

		if (mate.headPoint.param < mate.tailPoint.param)
		{
		    mateLower = mate.headPoint.param - mate.headPoint.pTol;
		    mateUpper = mate.tailPoint.param + mate.tailPoint.pTol;
		}
		else
		{
		    mateLower = mate.tailPoint.param - mate.tailPoint.pTol;
		    mateUpper = mate.headPoint.param + mate.headPoint.pTol;
		}
		if ((this.headPoint.param < mateLower) || (mateUpper < this.headPoint.param) ||
		    (this.tailPoint.param < mateLower) || (mateUpper < this.tailPoint.param))
		{
		    /*
		     * mate:  |---------------|
		     * this:       |-------------|
		     */
		    return false;
		}
	    }
	    else
	    {
		if (mate.headPoint.param < mate.tailPoint.param)
		{
		    mateLower = mate.tailPoint.param - mate.tailPoint.pTol;
		    mateUpper = mate.headPoint.param + mate.headPoint.pTol;
		}
		else
		{
		    mateLower = mate.headPoint.param - mate.headPoint.pTol;
		    mateUpper = mate.tailPoint.param + mate.tailPoint.pTol;
		}
		if (((mateUpper < this.headPoint.param) && (this.headPoint.param < mateLower)) ||
		    ((mateUpper < this.tailPoint.param) && (this.tailPoint.param < mateLower)))
		{
		    /*
		     * mate: ----|    |----------
		     * this:       |--------|
		     */
		    return false;
		}

		if (this.crossBoundary == false)
		{
		    if (((mateUpper < this.headPoint.param) || (mateUpper < this.tailPoint.param)) &&
			((this.headPoint.param < mateLower) || (this.tailPoint.param < mateLower)))
		    {
			/*
			 * mate: ----|    |----------
			 * this:  |----------|
			 */
			return false;
		    }
		}
	    }

	    return true;
	}
    }

    /**
     * Ԃǉ
     *
     * ɗ^ꂽ P ƐڑĂƂ݂Ȃ Q ɑ݂Ƃɂ́A
     * P  Q }[W
     *
     * @param	theSection	
     */
    void addSection(SectionInfo theSection)
    {
	while (true) {
	    SectionInfo mergedMate = null;

	    for (Enumeration e = listOfSections.elements(); e.hasMoreElements();) {
		SectionInfo mate = (SectionInfo)e.nextElement();
		if (theSection.mergeIfConnectWith(mate) == true) {
		    mergedMate = mate;
		    break;
		}
	    }

	    if (mergedMate == null)
		break;

	    listOfSections.removeElement(mergedMate);
	}

	listOfSections.addElement(theSection);
    }

    /**
     * Ԃǉ
     *
     * ɗ^ꂽ P ƐڑĂƂ݂Ȃ Q ɑ݂Ƃɂ́A
     * P  Q }[W
     *
     * @param	headParam	Ԃ̊Jn_̋Ȑł̃p[^l
     * @param	increaseParam	Ԃ̋Ȑł̃p[^l
     */
    void addAsSection(double headParam,
		      double increaseParam)
    {
	addSection(new SectionInfo(headParam, increaseParam));
    }

    /**
     * Ԃǉ
     *
     * ɗ^ꂽ P ƐڑĂƂ݂Ȃ Q ɑ݂Ƃɂ́A
     * P  Q }[W
     *
     * @param	headParam	Ԃ̊Jn_̋Ȑł̃p[^l
     * @param	increaseParam	Ԃ̋Ȑł̃p[^l
     * @param	headPTol	Ȑ̊Jn_t߂ł̃p[^̋e덷
     * @param	tailPTol	Ȑ̏I_t߂ł̃p[^̋e덷
     */
    void addAsSection(double headParam,
		      double increaseParam,
		      double headPTol,
		      double tailPTol)
    {
	addSection(new SectionInfo(headParam, increaseParam, headPTol, tailPTol));
    }

    /**
     * ̋ԂɊ܂܂ĂԂ폜
     */
    void removeSectionsContainedInOtherSection()
    {
	Vector clonedList = (Vector)(listOfSections.clone());
	listOfSections.removeAllElements();

	for (Enumeration e1 = clonedList.elements(); e1.hasMoreElements();)
	{
	    SectionInfo section = (SectionInfo)e1.nextElement();
	    boolean contained = false;

	    for (Enumeration e2 = clonedList.elements(); e2.hasMoreElements();)
	    {
		if (section.isContainedIn((SectionInfo)e2.nextElement()) == true)
		{
		    contained = true;
		    break;
		}
	    }

	    if (contained != true)
		listOfSections.addElement(section);
	}
    }

    /**
     * _ƋԂ̃Xg JgclParameterRangeOnCurve2D ̔zƂĕԂ
     */
    JgclParameterRangeOnCurve2D[] toJgclParameterRangeOnCurve2DArray()
    {
	if (dimension != 2)
	    throw new JgclDimensionsMismatch();

	int totalSize = listOfPoints.size() + listOfSections.size();
	int i;

	JgclParameterRangeOnCurve2D[] result = new JgclParameterRangeOnCurve2D[totalSize];
	i = 0;

	for (Enumeration e = listOfPoints.elements(); e.hasMoreElements();)
	{
	    PointInfo point = (PointInfo)e.nextElement();
	    result[i++] = (point.coord == null)
		? new JgclPointOnCurve2D((JgclParametricCurve2D)curve, point.param,
					 JgclGeometry.doCheckDebug)
		: new JgclPointOnCurve2D((JgclPoint2D)point.coord,
					 (JgclParametricCurve2D)curve, point.param,
					 JgclGeometry.doCheckDebug);
	}

	for (Enumeration e = listOfSections.elements(); e.hasMoreElements();)
	{
	    SectionInfo ovlp = (SectionInfo)e.nextElement();
	    result[i++] = new JgclParameterSectionOnCurve2D((JgclParametricCurve2D)curve,
							    ovlp.headPoint.param, ovlp.computeIncrease(),
							    false);
	}

	return result;
    }

    /**
     * _ƋԂ̃Xgׂē_Ƃ JgclPointOnCurve2D ̔zƂĕԂ
     */
    JgclPointOnCurve2D[] toJgclPointOnCurve2DArray()
    {
	if (dimension != 2)
	    throw new JgclDimensionsMismatch();

	int totalSize = listOfPoints.size() + (listOfSections.size() * 2);
	int i;

	JgclPointOnCurve2D[] result = new JgclPointOnCurve2D[totalSize];
	i = 0;

	for (Enumeration e = listOfPoints.elements(); e.hasMoreElements();)
	{
	    PointInfo point = (PointInfo)e.nextElement();
	    result[i++] = (point.coord == null)
		? new JgclPointOnCurve2D((JgclParametricCurve2D)curve, point.param,
					 JgclGeometry.doCheckDebug)
		: new JgclPointOnCurve2D((JgclPoint2D)point.coord,
					 (JgclParametricCurve2D)curve, point.param,
					 JgclGeometry.doCheckDebug);
	}

	for (Enumeration e = listOfSections.elements(); e.hasMoreElements();)
	{
	    SectionInfo ovlp = (SectionInfo)e.nextElement();
	    result[i++] = new JgclPointOnCurve2D((JgclParametricCurve2D)curve,
						 ovlp.headPoint.param,
						 JgclGeometry.doCheckDebug);
	    result[i++] = new JgclPointOnCurve2D((JgclParametricCurve2D)curve,
						 ovlp.tailPoint.param,
						 JgclGeometry.doCheckDebug);
	}

	return result;
    }

    /**
     * _ƋԂ̃Xg JgclParameterRangeOnCurve3D ̔zƂĕԂ
     */
    JgclParameterRangeOnCurve3D[] toJgclParameterRangeOnCurve3DArray()
    {
	if (dimension != 3)
	    throw new JgclDimensionsMismatch();

	int totalSize = listOfPoints.size() + listOfSections.size();
	int i;

	JgclParameterRangeOnCurve3D[] result = new JgclParameterRangeOnCurve3D[totalSize];
	i = 0;

	for (Enumeration e = listOfPoints.elements(); e.hasMoreElements();)
	{
	    PointInfo point = (PointInfo)e.nextElement();
	    result[i++] = (point.coord == null)
		? new JgclPointOnCurve3D((JgclParametricCurve3D)curve, point.param,
					 JgclGeometry.doCheckDebug)
		: new JgclPointOnCurve3D((JgclPoint3D)point.coord,
					 (JgclParametricCurve3D)curve, point.param,
					 JgclGeometry.doCheckDebug);
	}

	for (Enumeration e = listOfSections.elements(); e.hasMoreElements();)
	{
	    SectionInfo ovlp = (SectionInfo)e.nextElement();
	    result[i++] = new JgclParameterSectionOnCurve3D((JgclParametricCurve3D)curve,
							    ovlp.headPoint.param, ovlp.computeIncrease(),
							    false);
	}

	return result;
    }

    /**
     * _ƋԂ̃Xgׂē_Ƃ JgclPointOnCurve3D ̔zƂĕԂ
     */
    JgclPointOnCurve3D[] toJgclPointOnCurve3DArray()
    {
	if (dimension != 3)
	    throw new JgclDimensionsMismatch();

	int totalSize = listOfPoints.size() + (listOfSections.size() * 2);
	int i;

	JgclPointOnCurve3D[] result = new JgclPointOnCurve3D[totalSize];
	i = 0;

	for (Enumeration e = listOfPoints.elements(); e.hasMoreElements();)
	{
	    PointInfo point = (PointInfo)e.nextElement();
	    result[i++] = (point.coord == null)
		? new JgclPointOnCurve3D((JgclParametricCurve3D)curve, point.param,
					 JgclGeometry.doCheckDebug)
		: new JgclPointOnCurve3D((JgclPoint3D)point.coord,
					 (JgclParametricCurve3D)curve, point.param,
					 JgclGeometry.doCheckDebug);
	}

	for (Enumeration e = listOfSections.elements(); e.hasMoreElements();)
	{
	    SectionInfo ovlp = (SectionInfo)e.nextElement();
	    result[i++] = new JgclPointOnCurve3D((JgclParametricCurve3D)curve,
						 ovlp.headPoint.param,
						 JgclGeometry.doCheckDebug);
	    result[i++] = new JgclPointOnCurve3D((JgclParametricCurve3D)curve,
						 ovlp.tailPoint.param,
						 JgclGeometry.doCheckDebug);
	}

	return result;
    }

    /**
     * JgclParameterRangeOnCurve2D ̔z񂩂_o
     *
     * @param	array	JgclParameterRangeOnCurve2D ̔z
     */
    static Vector extractPoints(JgclParameterRangeOnCurve2D[] array)
    {
	Vector result = new Vector();

	for (int i = 0; i < array.length; i++)
	    if (array[i].isPoint() == true)
		result.addElement(array[i]);

	return result;
    }

    /**
     * JgclParameterRangeOnCurve2D ̔z񂩂Ԃo
     *
     * @param	array	JgclParameterRangeOnCurve2D ̔z
     */
    static Vector extractSections(JgclParameterRangeOnCurve2D[] array)
    {
	Vector result = new Vector();

	for (int i = 0; i < array.length; i++)
	    if (array[i].isSection() == true)
		result.addElement(array[i]);

	return result;
    }

    /**
     * JgclParameterRangeOnCurve3D ̔z񂩂_o
     *
     * @param	array	JgclParameterRangeOnCurve3D ̔z
     */
    static Vector extractPoints(JgclParameterRangeOnCurve3D[] array)
    {
	Vector result = new Vector();

	for (int i = 0; i < array.length; i++)
	    if (array[i].isPoint() == true)
		result.addElement(array[i]);

	return result;
    }

    /**
     * JgclParameterRangeOnCurve3D ̔z񂩂Ԃo
     *
     * @param	array	JgclParameterRangeOnCurve3D ̔z
     */
    static Vector extractSections(JgclParameterRangeOnCurve3D[] array)
    {
	Vector result = new Vector();

	for (int i = 0; i < array.length; i++)
	    if (array[i].isSection() == true)
		result.addElement(array[i]);

	return result;
    }
}

// end of file
