/*
 * R : pgbNȐ̂p[^Ԃ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclParameterSectionOnCurve3D.java,v 1.5 2000/04/26 09:39:14 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : pgbNȐ̂p[^Ԃ\NX
 * <p>
 * ̃NX̃CX^X́A
 * Ȑ
 * ̏̃p[^
 * ێB
 * </p>
 *
 * @version $Revision: 1.5 $, $Date: 2000/04/26 09:39:14 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclParameterSectionOnCurve3D implements JgclParameterRangeOnCurve3D {
    /**
     * ȐƂ̃p[^Ԃ\gȐB
     */
    private JgclTrimmedCurve3D trc;

    /**
     * Ȑp[^Ԃ^ɃIuWFNg\zB
     * <p>
     * ̃RXgN^Ăяo邱Ƃ͂ȂB
     * </p>
     */
    private JgclParameterSectionOnCurve3D() {
	trc = null;
    }

    /**
     * ȐƂ̏̃p[^ԂgȐ^ăIuWFNg\zB
     * <p>
     * doCheck ̒l͎QƂȂB
     * </p>
     *
     * @param trc	Ȑ̂Ԃ\gȐ
     * @param doCheck	`FbN邩ǂ
     */
    JgclParameterSectionOnCurve3D(JgclTrimmedCurve3D trc,
				  boolean doCheck) {
	super();
	this.trc = trc;
    }

    /**
     * ȐƂ̏̃p[^Ԃ^ăIuWFNg\zB
     * <p>
     * doCheck ̒l͎QƂȂB
     * </p>
     *
     * @param curve	Ȑ
     * @param section	Ȑ̃p[^
     * @param doCheck	`FbN邩ǂ
     */
    JgclParameterSectionOnCurve3D(JgclParametricCurve3D curve,
				  JgclParameterSection section,
				  boolean doCheck) {
	super();
	this.trc = new JgclTrimmedCurve3D(curve, section);
    }

    /**
     * ȐƂ̏̃p[^Ԃ^ăIuWFNg\zB
     * <p>
     * doCheck ̒l͎QƂȂB
     * </p>
     *
     * @param curve	Ȑ
     * @param start	Ȑ̃p[^Ԃ̊Jnl
     * @param inc	Ȑ̃p[^Ԃ̑l
     * @param doCheck	`FbN邩ǂ
     */
    public JgclParameterSectionOnCurve3D(JgclParametricCurve3D curve,
					 double start,
					 double inc,
					 boolean doCheck) {
	super();
	this.trc = new JgclTrimmedCurve3D(curve, new JgclParameterSection(start, inc));
    }

    /**
     * ̋Ԃ̑ΏۂƂȂĂȐԂB
     *
     * @return	Ȑ
     */
    public JgclParametricCurve3D curve() {
	return trc.basisCurve();
    }

    /**
     * ̃p[^Ԃ̊JnlԂB
     *
     * @return	p[^Ԃ̊Jnl
     */
    public double start() {
	return trc.tParam1();
    }

    /**
     * ̃p[^Ԃ̏IlԂB
     *
     * @return	p[^Ԃ̏Il
     */
    public double end() {
	return trc.tParam2();
    }

    /**
     * ̃p[^Ԃ̑lԂB
     *
     * @return	p[^Ԃ̑l
     */
    public double increase() {
	return end() - start();
    }

    /**
     * ̃p[^Ԃu_vۂԂB
     *
     * @return	 false
     */
    public boolean isPoint() {
	return false;
    }

    /**
     * ̃p[^ԂuԁvۂԂB
     *
     * @return	 true
     */
    public boolean isSection() {
	return true;
    }
}

// end of file
