/*
 * pgbNȋȖʂ̃NXKw̃[gƂȂ钊ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclParametricSurface.java,v 1.15 2000/04/26 09:39:15 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * pgbNȋȖʂ̃NXKw̃[gƂȂ钊ۃNXB
 * <p>
 * ̃NX́A̎lŕ\p[^̑g (u, v) ̒lɂāA
 * ʒu肳Ȗ P(u, v) Sʂ\B
 * </p>
 *
 * @version $Revision: 1.15 $, $Date: 2000/04/26 09:39:15 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclParameterDomain
 * @see	JgclParametricCurve
 */

public abstract class JgclParametricSurface extends JgclGeometry {
    /**
     * U ̃p[^`
     * <p>
     * KvɉăLbV
     * </p>
     * @serial
     */
    private JgclParameterDomain uDomain;

    /**
     * V ̃p[^`
     * <p>
     * KvɉăLbV
     * </p>
     * @serial
     */
    private JgclParameterDomain vDomain;

    /**
     * ^ɃIuWFNg\zB
     */
    protected JgclParametricSurface() {
	super();
	initFields();
    }

    /**
     * private ȃtB[hB
     */
    private void initFields() {
	uDomain = null;
	vDomain = null;
    }

    /**
     * ̋Ȗʂ U ̃p[^`ԂB
     * 
     * @return	U ̃p[^`
     */
    public JgclParameterDomain uParameterDomain() {
	if (uDomain == null) {
	    uDomain = getUParameterDomain();
	}
	return uDomain;
    }

    /**
     * ̋Ȗʂ V ̃p[^`ԂB
     * 
     * @return	V ̃p[^`
     */
    public JgclParameterDomain vParameterDomain() {
	if (vDomain == null) {
	    vDomain = getVParameterDomain();
	}
	return vDomain;
    }

    /**
     * ȖʂۂԂB
     * <p>
     *  true ԂB
     * </p>
     *
     * @return	ȖʂȂ̂ŁA <code>true</code>
     */
    public boolean isSurface() {
	return true;
    }

    /**
     * pgbNۂԂB
     * <p>
     *  true ԂB
     * </p>
     * 
     * @return	pgbNȂ̂ŁA <code>true</code>
     */
    public boolean isParametric() {
	return true;
    }

    /**
     * ̋Ȗʂ U ɗLۂԂB
     * 
     * @return	U ɗLł trueAłȂ false
     */
    public boolean isUFinite() {
	return uParameterDomain().isFinite();
    }

    /**
     * ̋Ȗʂ V ɗLۂԂB
     * 
     * @return	V ɗLł trueAłȂ false
     */
    public boolean isVFinite() {
	return vParameterDomain().isFinite();
    }

    /**
     * ̋Ȗʂ U ɖۂԂB
     * 
     * @return	U ɖł trueAłȂ false
     */
    public boolean isUInfinite() {
	return uParameterDomain().isInfinite();
    }

    /**
     * ̋Ȗʂ V ɖۂԂB
     * 
     * @return	V ɖł trueAłȂ false
     */
    public boolean isVInfinite() {
	return vParameterDomain().isInfinite();
    }

    /**
     * ̋Ȗʂ U ɎIۂԂ
     * 
     * @return	U ɎIł trueAłȂ false
     */
    public boolean isUPeriodic() {
	return uParameterDomain().isPeriodic();
    }

    /**
     * ̋Ȗʂ V ɎIۂԂ
     * 
     * @return	V ɎIł trueAłȂ false
     */
    public boolean isVPeriodic() {
	return vParameterDomain().isPeriodic();
    }

    /**
     * ̋Ȗʂ U ɔIۂԂ
     * 
     * @return	U ɔIł trueAłȂ false
     */
    public boolean isUNonPeriodic() {
	return uParameterDomain().isNonPeriodic();
    }

    /**
     * ̋Ȗʂ V ɔIۂԂ
     * 
     * @return	V ɔIł trueAłȂ false
     */
    public boolean isVNonPeriodic() {
	return vParameterDomain().isNonPeriodic();
    }

    /**
     * ^ꂽp[^A̋Ȗʂ U ̒`̓ɂ邩ۂԂB
     * <p>
     * value ALȃp[^Ԃ̒[_ɂꍇɂ́uvƔfB
     * </p>
     * <p>
     * e덷ƂāAݐݒ肳Ă鉉Źup[^l̋e덷vQƂB
     * </p>
     * 
     * @param value	p[^l
     * @return		value  U ̒`̓ɂ trueAłȂ false
     * @see	JgclConditionOfOperation
     * @see	JgclParameterDomain#isValid(double)
     */
    public boolean isValidUParameter(double value) {
	return uParameterDomain().isValid(value);
    }

    /**
     * ^ꂽp[^A̋Ȗʂ V ̒`̓ɂ邩ۂԂB
     * <p>
     * value ALȃp[^Ԃ̒[_ɂꍇɂ́uvƔfB
     * </p>
     * <p>
     * e덷ƂāAݐݒ肳Ă鉉Źup[^l̋e덷vQƂB
     * </p>
     * 
     * @param value	p[^l
     * @return		value  V ̒`̓ɂ trueAłȂ false
     * @see	JgclConditionOfOperation
     * @see	JgclParameterDomain#isValid(double)
     */
    public boolean isValidVParameter(double value) {
	return vParameterDomain().isValid(value);
    }

    /**
     * ^ꂽp[^lA̋Ȗʂ U ̒`ɑ΂ėLۂ𒲂ׂB
     * 
     * @param value	Ũp[^l
     * @exception JgclParameterOutOfRange	p[^`OĂ
     * @see	JgclParameterDomain#checkValidity(double)
     */
    public void checkUValidity(double value) {
	uParameterDomain().checkValidity(value);
    }

    /**
     * ^ꂽp[^lA̋Ȗʂ V ̒`ɑ΂ėLۂ𒲂ׂB
     * 
     * @param value	Ṽp[^l
     * @exception JgclParameterOutOfRange	p[^`OĂ
     * @see	JgclParameterDomain#checkValidity(double)
     */
    public void checkVValidity(double value) {
	vParameterDomain().checkValidity(value);
    }

    /**
     * ^ꂽp[^ԂA̋Ȗʂ U ̒`ɑ΂ėLۂ𒲂ׂB
     * <p>
     * section ̑l͕ł\ȂB
     * </p>
     * 
     * @param section	Ũp[^
     * @exception JgclParameterOutOfRange	p[^Ԃ`OĂ
     * @exception JgclInvalidArgumentValue	p[^Ԃ̒A蒷
     *						(Iȏꍇ̂)
     * @see	JgclParameterDomain#checkValidity(JgclParameterSection)
     */
    public void checkUValidity(JgclParameterSection section) {
	uParameterDomain().checkValidity(section);
    }

    /**
     * ^ꂽp[^ԂA̋Ȗʂ V ̒`ɑ΂ėLۂ𒲂ׂB
     * <p>
     * section ̑l͕ł\ȂB
     * </p>
     * 
     * @param section	Ṽp[^
     * @exception JgclParameterOutOfRange	p[^Ԃ`OĂ
     * @exception JgclInvalidArgumentValue	p[^Ԃ̒A蒷
     *						(Iȏꍇ̂)
     * @see	JgclParameterDomain#checkValidity(JgclParameterSection)
     */
    public void checkVValidity(JgclParameterSection section) {
	vParameterDomain().checkValidity(section);
    }

    /**
     * ̋Ȗʂ U ̃p[^`Ԃۃ\bhB
     *
     * @return	̋Ȗʂ U ̃p[^`
     */
    abstract JgclParameterDomain getUParameterDomain();

    /**
     * ̋Ȗʂ V ̃p[^`Ԃۃ\bhB
     *
     * @return	̋Ȗʂ V ̃p[^`
     */
    abstract JgclParameterDomain getVParameterDomain();
}
