/*
 * Q̓_\ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclPoint2D.java,v 1.43 2000/08/15 08:47:39 shikano Exp $
 *
 */

package jp.go.ipa.jgcl;

/**
 * Q̓_\ۃNXB
 *
 * @version $Revision: 1.43 $, $Date: 2000/08/15 08:47:39 $
 * @author Information-technology Promotion Agency, Japan
 * @see JgclVector2D
 */

public abstract class JgclPoint2D extends JgclPoint {
    /**
     * Q̌_ (0, 0)B
     */
    public static final JgclPoint2D origin;

    /**
     * static ȃtB[hɒlݒ肷B
     */
    static {
	origin = new JgclCartesianPoint2D(0.0, 0.0);
    }

    /**
     * IuWFNg\zB
     */
    protected JgclPoint2D(){
	super();
    }

    /**
     * ԂB
     * <p>
     *  2 ԂB
     * </p>
     *
     * @return	QȂ̂ŁA 2
     */
    public int dimension() {
        return 2;
    }

    /**
     * QۂԂ
     *
     * <p>
     *  true ԂB
     * </p>
     * 
     * @return		QȂ̂ŁA <code>true</code>
     */
    public boolean is2D() {
        return true;
    }

    /**
     * _ X WlԂۃ\bhB
     *
     * @return	_ X Wl
     */
    public abstract double x();

    /**
     * _ Y WlԂۃ\bhB
     *
     * @return	_ Y Wl
     */
    public abstract double y();

    /**
     * ̓_ɗ^ꂽxNg𑫂_ԂB
     *
     * @param vector	_ɑxNg
     * @return	^ꂽxNg𑫂_ (this + vector)
     */
    public JgclPoint2D add(JgclVector2D vector) {
        return new JgclCartesianPoint2D(x() + vector.x(),
					y() + vector.y());
    }

    /**
     * ̓_^ꂽxNg_ԂB
     *
     * @param vector	_xNg
     * @return	^ꂽxNg_ (this - vector)
     */
    public JgclPoint2D subtract(JgclVector2D vector) {
        return new JgclCartesianPoint2D(x() - vector.x(),
					y() - vector.y());
    }

    /**
     * ̓_Ɨ^ꂽ_Ƃ̍ԂB
     *
     * @param mate	鑊̓_
     * @return	_̍ (this - mate)
     */
    public JgclVector2D subtract(JgclPoint2D mate) {
        return new JgclLiteralVector2D(x() - mate.x(),
				       y() - mate.y());
    }

    /**
     * ̓_ɗ^ꂽXP[悶_ԂB
     *
     * @param scale	XP[
     * @return	(this * scale)
     */
    public JgclPoint2D multiply(double scale) {
        return new JgclCartesianPoint2D(x() * scale,
					y() * scale);
    }

    /**
     * ̓_^ꂽXP[Ŋ_ԂB
     *
     * @param scale	XP[
     * @return	(this / scale)
     */
    public JgclPoint2D divide(double scale) {
        return new JgclCartesianPoint2D(x() / scale,
					y() / scale);
    }

    /**
     * ̓_Ɨ^ꂽ_Ő^ԂʂԂB
     *
     * @param mate	`Ԃ̑ƂȂ_
     * @param weightForThis	gɑ΂d (ɑ΂d݂ 1 - weightForThis)
     * @return	`Ԃʂ̓_ (weightForThis * this + (1 - weightForThis) * mate)
     */
    public JgclPoint2D linearInterpolate(JgclPoint2D mate,
					 double weightForThis) {
	double weightForMate = 1.0 - weightForThis;
        return new JgclCartesianPoint2D(
	    this.x() * weightForThis + mate.x() * weightForMate,
	    this.y() * weightForThis + mate.y() * weightForMate);
    }

    /**
     * ̓_Ɨ^ꂽ_̒_ԂB
     *
     * @param mate	_߂鑊ƂȂ_
     * @return	_ (0.5 * this + 0.5 * mate)
     */
    public JgclPoint2D midPoint(JgclPoint2D mate) {
        return linearInterpolate(mate, 0.5);
    }

    /**
     * Q_̓ꐫ𔻒肷B
     *
     * @param mate	̑ΏۂƂȂ_
     * @return	this  mate űe덷vȓ
     *		̓_łƂ݂Ȃ trueAȂ false
     * @see	JgclConditionOfOperation
     */ 
    public boolean identical(JgclPoint2D mate) {
        return distance2(mate) < getToleranceForDistance2();
    }

    /**
     * ̓_Q̃xNg (JgclVector2D) ɕϊB
     *
     * @return	_̃xNgƂ݂ȂxNg
     */
    public JgclVector2D toVector2D() {
        return new JgclLiteralVector2D(x(), y());
    }

    /**
     * ̓_^ꂽȐւ̓e_߂B
     *
     * @param mate	eΏۂ̋Ȑ
     * @return	w肳ꂽȐւ̓e_ (݂ȂƂ͒0̔zԂ)
     * @exception JgclIndefiniteSolution	sł
     */
    public JgclPointOnCurve2D[] project(JgclParametricCurve2D mate)
	throws JgclIndefiniteSolution
    {
	return mate.projectFrom(this);
    }

    /**
     * ̓_^ꂽȐ̏ɏĂ邩ǂԂB
     *
     * @param mate	Ώۂ̋Ȑ
     * @return	Ȑ̏ɏĂ trueAłȂ false
     */
    public boolean isOn(JgclParametricCurve2D mate) {
	JgclPointOnCurve2D prjp = mate.nearestProjectFrom(this);

	if (prjp != null && identical(prjp))
	    return true;

	if (false) {	// Kv??
	    if (mate.isFinite() && mate.isNonPeriodic()) {	// LŔI
		// mate must be a bounded curve
		JgclBoundedCurve2D bnd = (JgclBoundedCurve2D)mate;

		if (identical(bnd.startPoint()))
		    return true;
		if (identical(bnd.endPoint()))
		    return true;
	    }
	}

	return false;
    }

    /**
     * ̓_uȊȂȐv̓ɂ邩ǂԂB
     * <p>
     * _ȐɏĂꍇɂ́uɂv̂ƂB
     * </p>
     * <p>
     * ȂAmate ȊȂƂ́AĂяoŕۏ؂KvB
     * </p>
     *
     * @param mate	Ώۂ̕Ȑ
     * @return	Ȑ̓ɂ trueAłȂ false
     * @exception	JgclOpenCurve	mate ͊JȐł
     */
    public boolean isIn(JgclParametricCurve2D mate) throws JgclOpenCurve {
	if (mate.isClosed() != true)
	    throw new JgclOpenCurve("mate is open");

	if (this.isOn(mate) == true) {
	    return true;
	}

	return this.pointIsInsideOf(mate);
    }

    /**
     * ̓_uȊȂȐv̓ɂ邩ǂԂB
     * <p>
     * _ȐɏĂꍇɂ́uOɂv̂ƂB
     * </p>
     * <p>
     * ȂAmate ȊȂƂ́AĂяoŕۏ؂KvB
     * </p>
     *
     * @param mate	Ώۂ̕Ȑ
     * @return	Ȑ̓ɂ trueAłȂ false
     * @exception	JgclOpenCurve	mate ͊JȐł
     */
    public boolean isInsideOf(JgclParametricCurve2D mate) throws JgclOpenCurve {
	if (mate.isClosed() != true)
	    throw new JgclOpenCurve("mate is open");

	if (this.isOn(mate) == true) {
	    return false;
	}

	return this.pointIsInsideOf(mate);
    }

    /**
     * ̓_uȊȂȐv̓ɂ邩ǂԂB
     * <p>
     * ȂAmate ȊȂƂ́AĂяoŕۏ؂KvB
     * </p>
     *
     * @param mate	Ώۂ̕Ȑ
     * @return	Ȑ̓ɂ trueAłȂ false
     * @exception	JgclOpenCurve	mate ͊JȐł
     */
    private boolean pointIsInsideOf(JgclParametricCurve2D mate) throws JgclOpenCurve {
	int inside = 0;
	int outside = 0;

	for (int i = 0; i < 3; i++) {
	    JgclLine2D lin =
		new JgclLine2D(this, new JgclLiteralVector2D(1.0, (i * 0.1)));

	    try {
		JgclIntersectionPoint2D[] ints = lin.intersect(mate);
		int nPositiveInts = 0;
		for (int j = 0; j < ints.length; j++) {
		    if (ints[j].pointOnCurve1().parameter() > 0.0)
			nPositiveInts++;
		}
		if ((nPositiveInts % 2) == 1) {
		    inside++;
		} else {
		    outside++;
		}
	    } catch (JgclIndefiniteSolution e) {
	    }
	}

	return (inside > outside) ? true : false;
    }

    /**
     * ̓_Ɨ^ꂽ_Ƃ̊Ԃ̋ԂB
     *
     * @param mate	߂_
     * @return	this - mate Ԃ̋
     */
    public double distance(JgclPoint2D mate) {
	return Math.sqrt(distance2(mate));
    }

    /**
     * ̓_Ɨ^ꂽ_Ƃ̊Ԃ̋̎ԂB
     *
     * @param mate	̎߂_
     * @return	this - mate Ԃ̋̎
     */
    public double distance2(JgclPoint2D mate) {
        double dx, dy;

        dx = x() - mate.x();
        dy = y() - mate.y();

	return (dx * dx + dy * dy);
    }

    /**
     * ^ꂽ_̒ŁA̓_ł_ԂB
     *
     * @param pnts	_
     * @return	ł_
     */
    public JgclPoint2D longestPoint(JgclPoint2D[] pnts) {
        return longestPoint(pnts, 0, pnts.length - 1);
    }

    /**
     * ^ꂽ_̎w͈̔͂̒ŁA̓_ł_ԂB
     *  
     * @param pnts	_
     * @param start	Jn_̃CfbNX (0 ~ pnts.length - 1)
     * @param end	I_̃CfbNX (0 ~ pnts.length - 1, start <= end)
     * @return	ł_
     */
    public JgclPoint2D longestPoint(JgclPoint2D[] pnts,
                                    int start, int end) {
        double max_dist, dist;
        int index;

        if ((start < 0) || (end >= pnts.length)) {
            throw new JgclInvalidArgumentValue();
        }

        max_dist = distance2(pnts[start]);
        index = start;

        for (int i = start + 1; i <= end; i++) {
            if ((dist = distance2(pnts[i])) > max_dist) {
                max_dist = dist;
                index = i;
            }
        }

        return pnts[index];
    }

    /**
     * _Q̕xNgԂB
     * <p>
     * (start == end) ̏ꍇɂ́A[xNgԂB
     * </p>
     *
     * @param points	_Q
     * @param start	Jn_̃CfbNX (0 ~ points.length - 1)
     * @param end	I_̃CfbNX (0 ~ points.length - 1, start <= end)
     * @return	̒PʕxNg
     */
    static JgclVector2D collinear(JgclPoint2D[] points,
                                  int start, int end) {
        if ((start < 0) || (points.length <= end)) {
            throw new JgclInvalidArgumentValue();
        }

        if ((end - start) <= 1) {
            return JgclVector2D.zeroVector;
        }

        JgclConditionOfOperation condition =
            JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        double dTol2 = dTol * dTol;

        JgclPoint2D basisPoint = points[start];
        JgclPoint2D longestPoint =
            basisPoint.longestPoint(points, start + 1, end);
        JgclVector2D uax = longestPoint.subtract(basisPoint);

        if (uax.norm() < dTol2) {
            return JgclVector2D.zeroVector;
        }
        uax = uax.unitized();

        JgclVector2D evec;
        double ecrs;

        for (int i = start + 1; i <= end; i++) {
            evec = points[i].subtract(points[start]);
            ecrs = evec.zOfCrossProduct(uax);
            if ((ecrs * ecrs) > dTol2) {
                return null;
            }
        }

        return uax;
    }

    /**
     * O_̓_߂B
     * <p>
     * pnt2, pnt3 ̂ꂩ null ̏ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * <p>
     * ܂AO_Ԃɂꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     *
     * @param pnt2	_2
     * @param pnt3	_3
     * @return	this, pnt2, pnt3 ̓_
     */
    public JgclPoint2D center(JgclPoint2D pnt2, JgclPoint2D pnt3) {
	// (pnt1, pnt2) ̒_ʂAline(pnt1, pnt2) ɐȒƁA
	// (pnt2, pnt3) ̒_ʂAline(pnt2, pnt3) ɐȒ̌_́A
	// 3 _̓_

	if ((pnt2 == null) || (pnt3 == null))
	    throw new JgclInvalidArgumentValue("There is a null argument.");

	if (identical(pnt2) || identical(pnt3) || pnt2.identical(pnt3))
	    throw new JgclInvalidArgumentValue("Points are collinear.");

	JgclVector2D vec2 = subtract(pnt2);
	JgclVector2D vec3 = subtract(pnt3);

	if (vec2.identicalDirection(vec3))
	    throw new JgclInvalidArgumentValue("Points are collinear.");

	JgclLine2D line2 = new JgclLine2D(linearInterpolate(pnt2, 0.5),
					  vec2.verticalVector());

	JgclLine2D line3 = new JgclLine2D(linearInterpolate(pnt3, 0.5),
					  vec3.verticalVector());

	try {
	    JgclIntersectionPoint2D isec = line2.intersect1Line(line3);
	    return isec.coordinates();
	}
	catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();
	}
    }

    /**
     * O_̓_߂B
     * <p>
     * pnt1, pnt2, pnt3 ̂ꂩ null ̏ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * <p>
     * ܂AO_Ԃɂꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     *
     * @param pnt1	_1
     * @param pnt2	_2
     * @param pnt3	_3
     * @return	O_̓_
     */
    public static JgclPoint2D center(JgclPoint2D pnt1,
				     JgclPoint2D pnt2,
				     JgclPoint2D pnt3)
    {
	if (pnt1 == null)
	    throw new JgclInvalidArgumentValue("There is a null argument.");
	return pnt1.center(pnt2, pnt3);
    }

    /**
     * ̓_ (x, y)  z = 0 ƂāA3D B
     *
     * @return	3D _ (x, y, 0)
     */
    JgclPoint3D to3D() {
	return new JgclCartesianPoint3D(x(), y(), 0.0);
    }

    /**
     * ̓_ (x, y)  3D B
     *
     * @param z	Z ̒l
     * @return	3D _ (x, y, z)
     */
    JgclPoint3D to3D(double z) {
	return new JgclCartesianPoint3D(x(), y(), z);
    }

    /**
     * ̓_ JgclCartesianPoint2D ̃IuWFNgɕϊB
     *
     * @return	ϊ_
     */
    JgclCartesianPoint2D literal() {
	return new JgclCartesianPoint2D(x(), y());
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected abstract JgclPoint2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries);

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    public synchronized JgclPoint2D
    transformBy(boolean reverseTransform,
		JgclCartesianTransformationOperator2D transformationOperator,
		java.util.Hashtable transformedGeometries)
    {
	if (transformedGeometries == null)
	    return this.doTransformBy(reverseTransform,
				      transformationOperator,
				      transformedGeometries);

	JgclPoint2D transformed = (JgclPoint2D)transformedGeometries.get(this);
	if (transformed == null) {
	    transformed = this.doTransformBy(reverseTransform,
					     transformationOperator,
					     transformedGeometries);
	    transformedGeometries.put(this, transformed);
	}
	return transformed;
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    public synchronized JgclPoint2D
    transformBy(JgclCartesianTransformationOperator2D transformationOperator,
		java.util.Hashtable transformedGeometries)
    {
	return this.transformBy(false,
				transformationOperator,
				transformedGeometries);
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŋtϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŋtϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŋtϊ̂ԂB
     * </p>
     *
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	tϊ̊􉽗vf
     */
    public synchronized JgclPoint2D
    reverseTransformBy(JgclCartesianTransformationOperator2D transformationOperator,
		       java.util.Hashtable transformedGeometries)
    {
	return this.transformBy(true,
				transformationOperator,
				transformedGeometries);
    }

    /**
     * _A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * ΏۂƂȂ_ transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     *  transformationOperator ŕϊ̂ԂB
     * ΏۂƂȂ邪 transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     * ɑΏۂƂȂ_ transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param points	_
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     */
    public static JgclPoint2D[]
    transform(JgclPoint2D[] points,
	      boolean reverseTransform,
	      JgclCartesianTransformationOperator2D transformationOperator,
	      java.util.Hashtable transformedGeometries)
    {
	JgclPoint2D[] tPoints = new JgclPoint2D[points.length];
	for (int i = 0; i < points.length; i++)
	    tPoints[i] = points[i].transformBy(reverseTransform,
					       transformationOperator,
					       transformedGeometries);
	return tPoints;
    }

    /**
     * _A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * ΏۂƂȂ_ transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     *  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł͑ΏۂƂȂ_L[A
     * ̕ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * ΏۂƂȂ邪 transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     * ɑΏۂƂȂ_ transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param points	_
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     */
    public static JgclPoint2D[]
    transform(JgclPoint2D[] points,
	      JgclCartesianTransformationOperator2D transformationOperator,
	      java.util.Hashtable transformedGeometries)
    {
	return transform(points, false, transformationOperator, transformedGeometries);
    }

    /**
     * _A^ꂽ􉽓IϊZqŋtϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * ΏۂƂȂ_ transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     *  transformationOperator ŋtϊ̂ԂB
     * ̍ۂɃ\bhł͑ΏۂƂȂ_L[A
     * ̕ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * ΏۂƂȂ邪 transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     * ɑΏۂƂȂ_ transformationOperator ŋtϊ̂ԂB
     * </p>
     *
     * @param points	_
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     */
    public static JgclPoint2D[]
    reverseTransform(JgclPoint2D[] points,
		     JgclCartesianTransformationOperator2D transformationOperator,
		     java.util.Hashtable transformedGeometries)

    {
	return transform(points, true, transformationOperator, transformedGeometries);
    }

    /**
     * JgclCartesianPoint2D ̃CX^X𐶐B
     *
     * @param x	X 
     * @param y	Y 
     * @return	JgclCartesianPoint2D ̃CX^X
     */
    public static JgclCartesianPoint2D of(double x,
					  double y) {
	return new JgclCartesianPoint2D(x, y);
    }

    /**
     * JgclCartesianPoint2D ̃CX^X𐶐B
     *
     * @param components	X, Y̔z (vf 2)
     * @return	JgclCartesianPoint2D ̃CX^X
     */
    public static JgclCartesianPoint2D of(double[] components) {
	return new JgclCartesianPoint2D(components);
    }
}
