/*
 * Q : pgbNȐ̏ɂ_\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclPointOnCurve2D.java,v 1.32 2000/08/11 06:18:56 shikano Exp $
 *
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * Q : pgbNȐ̏ɂ_\NXB
 * <p>
 * ̃NX̃CX^X́A
 * _̏ĂpgbNȐ ({@link JgclParametricCurve2D JgclParametricCurve2D})
 * basisCurve ƁA
 * ̃pgbNȐł̓_̃p[^l parameter ێB
 * </p>
 *
 * @version $Revision: 1.32 $, $Date: 2000/08/11 06:18:56 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclPointOnPoint2D
 */

public class JgclPointOnCurve2D extends JgclPointOnGeometry2D implements JgclParameterRangeOnCurve2D {
    /**
     * _̏ĂpgbNȐB
     * @serial
     */
    private JgclParametricCurve2D basisCurve;

    /**
     * pgbNȐł̓_̃p[^lB
     * @serial
     */
    private double parameter;

    /**
     * _̏ĂpgbNȐ
     * ̏ł̓_̃p[^l^ăIuWFNg\zB
     * <p>
     * JgclPointOnGeometry2D ɂ point  null ɐݒ肳B
     * </p>
     * <p>
     * doCheck  true ̏ꍇɂ́A̒lɑ΂Ĉȉ̌sȂB
     * <ul>
     * <li>	basisCurve  null ̏ꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * <li>	parameter  basisCurve ̃p[^`OĂꍇɂ́A
     *		JgclParameterOutOfRange ̗O𔭐B
     * </ul>
     * </p>
     * 
     * @param basisCurve	_̏ĂpgbNȐ
     * @param parameter	pgbNȐł̓_̃p[^l
     * @param doCheck	̒l̑Ó`FbN邩ǂ̃tO
     * @see	JgclInvalidArgumentValue
     * @see	JgclParameterOutOfRange
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParametricCurve2D#coordinates(double)
     * @see	JgclPoint2D#identical(JgclPoint2D)
     */
    JgclPointOnCurve2D(JgclParametricCurve2D basisCurve,
                       double parameter,
                       boolean doCheck)
    {
        this(null, basisCurve, parameter, doCheck);
    }

    /**
     * _̍Wl
     * _̏ĂpgbNȐ
     * ̏ł̓_̃p[^l^ăIuWFNg\zB
     * <p>
     * point  null ł\ȂB
     * </p>
     * <p>
     * doCheck  true ̏ꍇɂ́A̒lɑ΂Ĉȉ̌sȂB
     * <ul>
     * <li>	basisCurve  null ̏ꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * <li>	parameter  basisCurve ̃p[^`OĂꍇɂ́A
     *		JgclParameterOutOfRange ̗O𔭐B
     * <li>	point  null łȂA
     *		point  basisCurve  parameter ɑΉ_vȂꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * </ul>
     * </p>
     * 
     * @param point	_̍Wl
     * @param basisCurve	_̏ĂpgbNȐ
     * @param parameter	pgbNȐł̓_̃p[^l
     * @param doCheck	̒l̑Ó`FbN邩ǂ̃tO
     * @see	JgclInvalidArgumentValue
     * @see	JgclParameterOutOfRange
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParametricCurve2D#coordinates(double)
     * @see	JgclPoint2D#identical(JgclPoint2D)
     */
    JgclPointOnCurve2D(JgclPoint2D point,
                       JgclParametricCurve2D basisCurve,
                       double parameter,
                       boolean doCheck)
    {
        super(point);
        if (doCheck == true) {
            JgclConditionOfOperation condition
                = JgclConditionOfOperation.getCondition();
            double pTol = condition.getToleranceForParameter();
            
            if (basisCurve == null) {
                throw new JgclInvalidArgumentValue("basisCurve is null.");
            }
            basisCurve.checkValidity(parameter);
            if (point != null) {
                if (!point.identical(basisCurve.coordinates(parameter))) {
                    throw new JgclInvalidArgumentValue("point is not consistent with parameter.");
                }
            }
        }
        this.basisCurve = basisCurve;
        this.parameter = parameter;
    }

    /**
     * _̏ĂpgbNȐ
     * ̏ł̓_̃p[^l^ăIuWFNg\zB
     * <p>
     * JgclPointOnGeometry2D ɂ point  null ɐݒ肳B
     * </p>
     * <p>
     * ̒lɑ΂Ĉȉ̌sȂB
     * <ul>
     * <li>	basisCurve  null ̏ꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * <li>	parameter  basisCurve ̃p[^`OĂꍇɂ́A
     *		JgclParameterOutOfRange ̗O𔭐B
     * </ul>
     * </p>
     * 
     * @param basisCurve	_̏ĂpgbNȐ
     * @param parameter	pgbNȐł̓_̃p[^l
     * @see	JgclInvalidArgumentValue
     * @see	JgclParameterOutOfRange
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParametricCurve2D#coordinates(double)
     * @see	JgclPoint2D#identical(JgclPoint2D)
     */
    public JgclPointOnCurve2D(JgclParametricCurve2D basisCurve,
                              double parameter)
    {
        this(null, basisCurve, parameter);
    }

    /**
     * _̍Wl
     * _̏ĂpgbNȐ
     * ̏ł̓_̃p[^l^ăIuWFNg\zB
     * <p>
     * point  null ł\ȂB
     * </p>
     * <p>
     * ̒lɑ΂Ĉȉ̌sȂB
     * <ul>
     * <li>	basisCurve  null ̏ꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * <li>	parameter  basisCurve ̃p[^`OĂꍇɂ́A
     *		JgclParameterOutOfRange ̗O𔭐B
     * <li>	point  null łȂA
     *		point  basisCurve  parameter ɑΉ_vȂꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * </ul>
     * </p>
     * 
     * @param point	_̍Wl
     * @param basisCurve	_̏ĂpgbNȐ
     * @param parameter	pgbNȐł̓_̃p[^l
     * @see	JgclInvalidArgumentValue
     * @see	JgclParameterOutOfRange
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParametricCurve2D#coordinates(double)
     * @see	JgclPoint2D#identical(JgclPoint2D)
     */
    public JgclPointOnCurve2D(JgclPoint2D point,
                              JgclParametricCurve2D basisCurve,
                              double parameter)
    {
        this(point, basisCurve, parameter, true);
    }

    /**
     * x[XƂȂ`vfԂB
     * <p>
     * ʂƂĕԂ`vf
     * JgclParametricCurve2D ̃CX^XłB
     * </p>
     *
     * @return	x[XƂȂ`vf
     * @see	#basisCurve()
     */
    public JgclGeometry geometry() {
    	return basisCurve();
    }

    /**
     * x[XƂȂpgbNȐԂB
     *
     * @return	x[XƂȂpgbNȐ
     * @see	#geometry()
     */
    public JgclParametricCurve2D basisCurve() {
        return basisCurve;
    }

    /**
     * Ȑł̓_̃p[^lԂB
     *
     * @return	Ȑł̓_̃p[^l
     */
    public double parameter() {
        return parameter;
    }

    /**
     * x[XƂȂ`vfɑ΂񂩂_̍Wl߂B
     *
     * @return	x[XƂȂ`vfɑ΂񂩂狁߂_̍Wl
     */
    JgclPoint2D coordinates() {
        JgclPoint2D coord;
        try {
            coord = basisCurve.coordinates(parameter);
        }
        catch (JgclParameterOutOfRange e) {
            throw new JgclFatal();
        }
        return coord;
    }

    /**
     * _ۂԂB
     *
     * @return	 true
     */
    public boolean isPoint() {
	return true;
    }

    /**
     * ԂۂԂB
     *
     * @return	 false
     */
    public boolean isSection() {
	return false;
    }

    /**
     * ̐_Ƒ̐_p[^Iɓꂩǂ𒲂ׂB
     * <p>
     * x[XƂȂȐقȂꍇ <code>false</code> ԂB
     * </p>
     * <p>
     * this  mate ̎ԏ̍Wl̍A
     * ݐݒ肳Ă鉉Z̋̋e덷ȏł
     * <code>false</code> ԂB
     * </p>
     * <p>
     * this  mate ̓̃p[^l̊Ԃ̋Ȑ̓̂肪A
     * ݐݒ肳Ă鉉Z̋̋e덷ȏł
     * <code>false</code> ԂB
     * </p>
     * <p>
     * L̂łȂ <code>true</code> ԂB
     * </p>
     *
     * @return	ł <code>true</code>AłȂ <code>false</code>
     * @see	JgclPoint2D#identical(JgclPoint2D)
     * @see	JgclParametricCurve2D#identicalParameter(double, double)
     */
    boolean parametricallyIdentical(JgclPointOnCurve2D mate) {
	if (basisCurve() != mate.basisCurve())
	    return false;

	if (!identical(mate))
	    return false;

	if (!basisCurve().identicalParameter(parameter(), mate.parameter()))
	    return false;

	return true;
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclPoint2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint2D tPoint = this.point();
	if (tPoint != null)
	    tPoint = tPoint.transformBy(reverseTransform,
					transformationOperator, transformedGeometries);
	JgclParametricCurve2D tBasisCurve =
	    this.basisCurve.transformBy(reverseTransform,
					transformationOperator, transformedGeometries);
	return new JgclPointOnCurve2D(tPoint, tBasisCurve, this.parameter, doCheckDebug);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tpoint");
        coordinates().output(writer, indent + 2);
        writer.println(indent_tab + "\tbasisCurve");
        basisCurve.output(writer, indent + 2);
        writer.println(indent_tab + "\tparameter\t" + parameter);
        writer.println(indent_tab + "End");
    }
}
