/*
 * P : _̏ɂ_\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclPointOnPoint1D.java,v 1.23 2000/08/11 06:18:57 shikano Exp $
 *
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * P : _̏ɂ_\NX
 * <p>
 * ̃NX̃CX^X́A
 * _̏Ă_ ({@link JgclPoint1D JgclPoint1D})
 * basisPoint ێB
 * </p>
 *
 * @version $Revision: 1.23 $, $Date: 2000/08/11 06:18:57 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclPointOnPoint1D extends JgclPointOnGeometry1D {
    /**
     * _̏Ă_B
     * @serial
     */
    private JgclPoint1D basisPoint;

    /**
     * _̏Ă_^ăIuWFNg\zB
     * <p>
     * JgclPointOnGeometry1D ɂ point  null ɐݒ肳B
     * </p>
     * <p>
     * doCheck  true ̏ꍇɂ́A̒lɑ΂Ĉȉ̌sȂB
     * <ul>
     * <li>	basisPoint  null ̏ꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * <li>	point  null łȂA
     *		point  basisPoint vȂꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * </ul>
     * </p>
     *
     * @param basisPoint _̏Ă_
     * @param doCheck	̒l̑Ó`FbN邩ǂ̃tO
     * @see	JgclInvalidArgumentValue
     * @see	JgclPoint1D#identical(JgclPoint1D)
     */
    JgclPointOnPoint1D(JgclPoint1D basisPoint, boolean doCheck)
    {
        this(null, basisPoint, doCheck);
    }

    /**
     * _̍Wl
     * _̏Ă_^ăIuWFNg\zB
     * <p>
     * point  null ł\ȂB
     * </p>
     * <p>
     * doCheck  true ̏ꍇɂ́A̒lɑ΂Ĉȉ̌sȂB
     * <ul>
     * <li>	basisPoint  null ̏ꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * <li>	point  null łȂA
     *		point  basisPoint vȂꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * </ul>
     * </p>
     *
     * @param point	__̍Wl
     * @param basisPoint _̏Ă_
     * @param doCheck	̒l̑Ó`FbN邩ǂ̃tO
     * @see	JgclInvalidArgumentValue
     * @see	JgclPoint1D#identical(JgclPoint1D)
     */
    JgclPointOnPoint1D(JgclPoint1D point,
		       JgclPoint1D basisPoint,
		       boolean doCheck)
    {
        super(point);

        if (doCheck == true) {
            if (basisPoint == null) {
                throw new JgclInvalidArgumentValue();
            }
            if (point != null) {
                if (!point.identical(basisPoint)) {
                    throw new JgclInvalidArgumentValue();
                }
            }
        }
        this.basisPoint = basisPoint;
    }

    /**
     * _̏Ă_^ăIuWFNg\zB
     * <p>
     * JgclPointOnGeometry1D ɂ point  null ɐݒ肳B
     * </p>
     * <p>
     * ̒lɑ΂Ĉȉ̌sȂB
     * <ul>
     * <li>	basisPoint  null ̏ꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * <li>	point  null łȂA
     *		point  basisPoint vȂꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * </ul>
     * </p>
     *
     * @param basisPoint _̏Ă_
     * @see	JgclInvalidArgumentValue
     * @see	JgclPoint1D#identical(JgclPoint1D)
     */
    public JgclPointOnPoint1D(JgclPoint1D basisPoint)
    {
        this(null, basisPoint);
    }

    /**
     * _̍Wl
     * _̏Ă_^ăIuWFNg\zB
     * <p>
     * point  null ł\ȂB
     * </p>
     * <p>
     * ̒lɑ΂Ĉȉ̌sȂB
     * <ul>
     * <li>	basisPoint  null ̏ꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * <li>	point  null łȂA
     *		point  basisPoint vȂꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * </ul>
     * </p>
     *
     * @param point	__̍Wl
     * @param basisPoint _̏Ă_
     * @see	JgclInvalidArgumentValue
     * @see	JgclPoint1D#identical(JgclPoint1D)
     */
    public JgclPointOnPoint1D(JgclPoint1D point, JgclPoint1D basisPoint)
    {
        this(point, basisPoint, true);
    }

    /**
     * x[XƂȂ`vfԂB
     * <p>
     * ʂƂĕԂ`vf
     * JgclPoint1D ̃CX^XłB
     * </p>
     *
     * @return	x[XƂȂ`vf
     * @see	#basisPoint()
     */
    public JgclGeometry geometry() {
    	return basisPoint();
    }

    /**
     * x[XƂȂ_ԂB
     *
     * @return x[XƂȂ_
     * @see	#geometry()
     */
    public JgclPoint1D basisPoint() {
        return basisPoint;
    }

    /**
     * x[XƂȂ`vfɑ΂񂩂_̍Wl߂B
     *
     * @return	x[XƂȂ`vfɑ΂񂩂狁߂_̍Wl
     * @see	#basisPoint()
     */
    JgclPoint1D coordinates() {
        return basisPoint();
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        basisPoint.output(writer, indent + 2);
        writer.println("End");
    }
}
