/*
 * Q : _̏ɂ_\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclPointOnPoint2D.java,v 1.26 2000/08/11 06:18:57 shikano Exp $
 *
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * Q : _̏ɂ_\NX
 * <p>
 * ̃NX̃CX^X́A
 * _̏Ă_ ({@link JgclPoint2D JgclPoint2D})
 * basisPoint ێB
 * </p>
 *
 * @version $Revision: 1.26 $, $Date: 2000/08/11 06:18:57 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclPointOnCurve2D
 */

public class JgclPointOnPoint2D extends JgclPointOnGeometry2D {
    /**
     * _̏Ă_B
     * @serial
     */
    private JgclPoint2D basisPoint;

    /**
     * _̏Ă_^ăIuWFNg\zB
     * <p>
     * JgclPointOnGeometry2D ɂ point  null ɐݒ肳B
     * </p>
     * <p>
     * doCheck  true ̏ꍇɂ́A̒lɑ΂Ĉȉ̌sȂB
     * <ul>
     * <li>	basisPoint  null ̏ꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * <li>	point  null łȂA
     *		point  basisPoint vȂꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * </ul>
     * </p>
     *
     * @param basisPoint _̏Ă_
     * @param doCheck	̒l̑Ó`FbN邩ǂ̃tO
     * @see	JgclInvalidArgumentValue
     * @see	JgclPoint2D#identical(JgclPoint2D)
     */
    JgclPointOnPoint2D(JgclPoint2D basisPoint, boolean doCheck)
    {
        this(null, basisPoint, doCheck);
    }

    /**
     * _̍Wl
     * _̏Ă_^ăIuWFNg\zB
     * <p>
     * point  null ł\ȂB
     * </p>
     * <p>
     * doCheck  true ̏ꍇɂ́A̒lɑ΂Ĉȉ̌sȂB
     * <ul>
     * <li>	basisPoint  null ̏ꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * <li>	point  null łȂA
     *		point  basisPoint vȂꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * </ul>
     * </p>
     *
     * @param point	__̍Wl
     * @param basisPoint _̏Ă_
     * @param doCheck	̒l̑Ó`FbN邩ǂ̃tO
     * @see	JgclInvalidArgumentValue
     * @see	JgclPoint2D#identical(JgclPoint2D)
     */
    JgclPointOnPoint2D(JgclPoint2D point,
                       JgclPoint2D basisPoint,
                       boolean doCheck) 
    {
        super(point);
        if (doCheck == true) {
            if (basisPoint == null) {
                throw new JgclInvalidArgumentValue();
            }
            if (point != null) {
                if (!point.identical(basisPoint)) {
                    throw new JgclInvalidArgumentValue();
                }
            }
        }
        this.basisPoint = basisPoint;
    }

    /**
     * _̏Ă_^ăIuWFNg\zB
     * <p>
     * JgclPointOnGeometry2D ɂ point  null ɐݒ肳B
     * </p>
     * <p>
     * ̒lɑ΂Ĉȉ̌sȂB
     * <ul>
     * <li>	basisPoint  null ̏ꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * <li>	point  null łȂA
     *		point  basisPoint vȂꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * </ul>
     * </p>
     *
     * @param basisPoint _̏Ă_
     * @see	JgclInvalidArgumentValue
     * @see	JgclPoint2D#identical(JgclPoint2D)
     */
    public JgclPointOnPoint2D(JgclPoint2D basisPoint) 
    {
        this(null, basisPoint);
    }

    /**
     * _̍Wl
     * _̏Ă_^ăIuWFNg\zB
     * <p>
     * point  null ł\ȂB
     * </p>
     * <p>
     * ̒lɑ΂Ĉȉ̌sȂB
     * <ul>
     * <li>	basisPoint  null ̏ꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * <li>	point  null łȂA
     *		point  basisPoint vȂꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * </ul>
     * </p>
     *
     * @param point	__̍Wl
     * @param basisPoint _̏Ă_
     * @see	JgclInvalidArgumentValue
     * @see	JgclPoint2D#identical(JgclPoint2D)
     */
    public JgclPointOnPoint2D(JgclPoint2D point, JgclPoint2D basisPoint)
    {
        this(point, basisPoint, true);
    }

    /**
     * x[XƂȂ`vfԂB
     * <p>
     * ʂƂĕԂ`vf
     * JgclPoint2D ̃CX^XłB
     * </p>
     *
     * @return	x[XƂȂ`vf
     * @see	#basisPoint()
     */
    public JgclGeometry geometry() {
    	return basisPoint();
    }

    /**
     * x[XƂȂ_ԂB
     *
     * @return x[XƂȂ_
     * @see	#geometry()
     */
    public JgclPoint2D basisPoint() {
        return basisPoint;
    }

    /**
     * x[XƂȂ`vfɑ΂񂩂_̍Wl߂B
     *
     * @return	x[XƂȂ`vfɑ΂񂩂狁߂_̍Wl
     * @see	#basisPoint()
     */
    JgclPoint2D coordinates() {
        return basisPoint();
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclPoint2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint2D tPoint = this.point();
	if (tPoint != null)
	    tPoint = tPoint.transformBy(reverseTransform,
					transformationOperator, transformedGeometries);
	JgclPoint2D tBasisPoint =
	    this.basisPoint.transformBy(reverseTransform,
					transformationOperator, transformedGeometries);

	return new JgclPointOnPoint2D(tPoint, tBasisPoint, doCheckDebug);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        basisPoint.output(writer, indent + 2);
        writer.println("End");
    }
}
