/*
 * R : pgbNȖʂ̏ɂ_\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclPointOnSurface3D.java,v 1.35 2000/08/11 06:18:57 shikano Exp $
 *
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : pgbNȖʂ̏ɂ_\NXB
 * <p>
 * ̃NX̃CX^X́A
 * _̏ĂpgbNȖ ({@link JgclParametricSurface3D JgclParametricSurface3D})
 * basisSurface ƁA
 * ̃pgbNȖʏł̓_̃p[^l (uParameter, vParameter) ێB
 * </p>
 *
 * @version $Revision: 1.35 $, $Date: 2000/08/11 06:18:57 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclPointOnPoint3D
 * @see	JgclPointOnCurve3D
 */

public class JgclPointOnSurface3D extends JgclPointOnGeometry3D {
    /**
     * _̏ĂpgbNȖʁB
     * @serial
     */
    private JgclParametricSurface3D basisSurface;

    /**
     * pgbNȖʏł̓_ U ̃p[^lB
     * @serial
     */
    private double uParameter;

    /**
     * pgbNȖʏł̓_ V ̃p[^lB
     * @serial
     */
    private double vParameter;

    /**
     * _̏ĂpgbNȖʂ
     * ̏ł̓_̃p[^l^ăIuWFNg\zB
     * <p>
     * JgclPointOnGeometry3D ɂ point  null ɐݒ肳B
     * </p>
     * <p>
     * doCheck  true ̏ꍇɂ́A̒lɑ΂Ĉȉ̌sȂB
     * <ul>
     * <li>	basisSurface  null ̏ꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * <li>	(uParameter, vParameter)  basisSurface ̃p[^`OĂꍇɂ́A
     *		JgclParameterOutOfRange ̗O𔭐B
     *		AbasisSurface ȐEȖʂ̏ꍇɂ́Ã`FbN͍sȂȂB
     * </ul>
     * </p>
     * 
     * @param basisSurface	_̏ĂpgbNȖ
     * @param uParameter	pgbNȖʏł̓_ U ̃p[^l
     * @param vParameter	pgbNȖʏł̓_ V ̃p[^l
     * @param doCheck	̒l̑Ó`FbN邩ǂ̃tO
     * @see	JgclInvalidArgumentValue
     * @see	JgclParameterOutOfRange
     * @see	JgclParametricSurface#checkUValidity(double)
     * @see	JgclParametricSurface#checkVValidity(double)
     * @see	JgclParametricSurface3D#coordinates(double, double)
     * @see	JgclPoint3D#identical(JgclPoint3D)
     */
    JgclPointOnSurface3D(JgclParametricSurface3D basisSurface,
                         double uParameter, double  vParameter,
                         boolean doCheck)
    {
        this(null, basisSurface, uParameter, vParameter, doCheck);
    }

    /**
     * _̍Wl
     * _̏ĂpgbNȖʂ
     * ̏ł̓_̃p[^l^ăIuWFNg\zB
     * <p>
     * point  null ł\ȂB
     * </p>
     * <p>
     * doCheck  true ̏ꍇɂ́A̒lɑ΂Ĉȉ̌sȂB
     * <ul>
     * <li>	basisSurface  null ̏ꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * <li>	(uParameter, vParameter)  basisSurface ̃p[^`OĂꍇɂ́A
     *		JgclParameterOutOfRange ̗O𔭐B
     *		AbasisSurface ȐEȖʂ̏ꍇɂ́Ã`FbN͍sȂȂB
     * <li>	point  null łȂA
     *		point  basisSurface  (uParameter, vParameter) ɑΉ_vȂꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * </ul>
     * </p>
     * 
     * @param point	_̍Wl
     * @param basisSurface	_̏ĂpgbNȖ
     * @param uParameter	pgbNȖʏł̓_ U ̃p[^l
     * @param vParameter	pgbNȖʏł̓_ V ̃p[^l
     * @param doCheck	̒l̑Ó`FbN邩ǂ̃tO
     * @see	JgclInvalidArgumentValue
     * @see	JgclParameterOutOfRange
     * @see	JgclParametricSurface#checkUValidity(double)
     * @see	JgclParametricSurface#checkVValidity(double)
     * @see	JgclParametricSurface3D#coordinates(double, double)
     * @see	JgclPoint3D#identical(JgclPoint3D)
     */
    JgclPointOnSurface3D(JgclPoint3D point,
                         JgclParametricSurface3D basisSurface,
                         double uParameter, double vParameter,
                         boolean doCheck)
    {
        super(point);
        if (doCheck == true) {
            JgclConditionOfOperation condition
                = JgclConditionOfOperation.getCondition();
            double pTol = condition.getToleranceForParameter();

            if (basisSurface == null) {
                throw new JgclInvalidArgumentValue();
            }
	    if (basisSurface.type() != JgclParametricSurface3D.CURVE_BOUNDED_SURFACE_3D) {
		basisSurface.checkUValidity(uParameter);
		basisSurface.checkVValidity(vParameter);
	    }
            if (point != null) {
                if (!point.identical(basisSurface.coordinates
                                     (uParameter, vParameter))) {
                    throw new JgclInvalidArgumentValue();
                }
            }
        }
        this.basisSurface = basisSurface;
        this.uParameter = uParameter;
        this.vParameter = vParameter;
    }

    /**
     * _̏ĂpgbNȖʂ
     * ̏ł̓_̃p[^l^ăIuWFNg\zB
     * <p>
     * JgclPointOnGeometry3D ɂ point  null ɐݒ肳B
     * </p>
     * <p>
     * <ul>
     * <li>	basisSurface  null ̏ꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * <li>	(uParameter, vParameter)  basisSurface ̃p[^`OĂꍇɂ́A
     *		JgclParameterOutOfRange ̗O𔭐B
     * </ul>
     * </p>
     * 
     * @param basisSurface	_̏ĂpgbNȖ
     * @param uParameter	pgbNȖʏł̓_ U ̃p[^l
     * @param vParameter	pgbNȖʏł̓_ V ̃p[^l
     * @see	JgclInvalidArgumentValue
     * @see	JgclParameterOutOfRange
     * @see	JgclParametricSurface#checkUValidity(double)
     * @see	JgclParametricSurface#checkVValidity(double)
     */
    public JgclPointOnSurface3D(JgclParametricSurface3D basisSurface,
				double uParameter, double vParameter)
    {
        this(null, basisSurface, uParameter, vParameter);
    }

    /**
     * _̏ĂpgbNȖʂ
     * ̏ł̓_̃p[^l^ăIuWFNg\zB
     * <p>
     * JgclPointOnGeometry3D ɂ point  null ɐݒ肳B
     * </p>
     * <p>
     * doCheck  true ̏ꍇɂ́A̒lɑ΂Ĉȉ̌sȂB
     * <ul>
     * <li>	basisSurface  null ̏ꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * <li>	(U p[^l, V p[^l)  basisSurface ̃p[^`OĂꍇɂ́A
     *		JgclParameterOutOfRange ̗O𔭐B
     *		AbasisSurface ȐEȖʂ̏ꍇɂ́Ã`FbN͍sȂȂB
     * </ul>
     * </p>
     * 
     * @param basisSurface	_̏ĂpgbNȖ
     * @param pairOfParameters	pgbNȖʏł̓_ (U p[^l, V p[^l)
     * @param doCheck    ̃`FbN邩ǂ̃tO
     * @see	JgclInvalidArgumentValue
     * @see	JgclParameterOutOfRange
     * @see	JgclParametricSurface#checkUValidity(double)
     * @see	JgclParametricSurface#checkVValidity(double)
     */
    JgclPointOnSurface3D(JgclParametricSurface3D basisSurface,
			 JgclPoint2D pairOfParameters,
			 boolean doCheck)
    {
        this(null, basisSurface, pairOfParameters.x(), pairOfParameters.y(), doCheck);
    }

    /**
     * _̏ĂpgbNȖʂ
     * ̏ł̓_̃p[^l^ăIuWFNg\zB
     * <p>
     * JgclPointOnGeometry3D ɂ point  null ɐݒ肳B
     * </p>
     * <p>
     * <ul>
     * <li>	basisSurface  null ̏ꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * <li>	(U p[^l, V p[^l)  basisSurface ̃p[^`OĂꍇɂ́A
     *		JgclParameterOutOfRange ̗O𔭐B
     *		AbasisSurface ȐEȖʂ̏ꍇɂ́Ã`FbN͍sȂȂB
     * </ul>
     * </p>
     * 
     * @param basisSurface	_̏ĂpgbNȖ
     * @param pairOfParameters	pgbNȖʏł̓_ (U p[^l, V p[^l)
     * @see	JgclInvalidArgumentValue
     * @see	JgclParameterOutOfRange
     * @see	JgclParametricSurface#checkUValidity(double)
     * @see	JgclParametricSurface#checkVValidity(double)
     */
    public JgclPointOnSurface3D(JgclParametricSurface3D basisSurface,
				JgclPoint2D pairOfParameters)
    {
        this(null, basisSurface, pairOfParameters.x(), pairOfParameters.y());
    }

    /**
     * _̍Wl
     * _̏ĂpgbNȖʂ
     * ̏ł̓_̃p[^l^ăIuWFNg\zB
     * <p>
     * point  null ł\ȂB
     * </p>
     * <p>
     * <ul>
     * <li>	basisSurface  null ̏ꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * <li>	(uParameter, vParameter)  basisSurface ̃p[^`OĂꍇɂ́A
     *		JgclParameterOutOfRange ̗O𔭐B
     *		AbasisSurface ȐEȖʂ̏ꍇɂ́Ã`FbN͍sȂȂB
     * <li>	point  null łȂA
     *		point  basisSurface  (uParameter, vParameter) ɑΉ_vȂꍇɂ́A
     *		JgclInvalidArgumentValue ̗O𔭐B
     * </ul>
     * </p>
     * 
     * @param point	_̍Wl
     * @param basisSurface	_̏ĂpgbNȖ
     * @param uParameter	pgbNȖʏł̓_ U ̃p[^l
     * @param vParameter	pgbNȖʏł̓_ V ̃p[^l
     * @see	JgclInvalidArgumentValue
     * @see	JgclParameterOutOfRange
     * @see	JgclParametricSurface#checkUValidity(double)
     * @see	JgclParametricSurface#checkVValidity(double)
     * @see	JgclParametricSurface3D#coordinates(double, double)
     * @see	JgclPoint3D#identical(JgclPoint3D)
     */
    public JgclPointOnSurface3D(JgclPoint3D point,
				JgclParametricSurface3D basisSurface,
				double uParameter, double vParameter)
    {
        this(point, basisSurface, uParameter, vParameter, true);
    }

    /**
     * x[XƂȂ`vfԂB
     * <p>
     * ʂƂĕԂ`vf
     * JgclParametricSurface3D ̃CX^XłB
     * </p>
     *
     * @return	x[XƂȂ`vf
     * @see	#basisSurface()
     */
    public JgclGeometry geometry() {
        return basisSurface();
    }

    /**
     * x[XƂȂpgbNȖʂԂB
     *
     * @return x[XƂȂpgbNȖ
     * @see	#geometry()
     */
    public JgclParametricSurface3D basisSurface() {
        return basisSurface;
    }

    /**
     * Ȗʏł̓_ U ̃p[^lԂB
     *
     * @return	Ȗʏł̓_ U ̃p[^l
     */
    public double uParameter() {
        return uParameter;
    }

    /**
     * Ȗʏł̓_ V ̃p[^lԂB
     *
     * @return	Ȗʏł̓_ V ̃p[^l
     */
    public double vParameter() {
        return vParameter;
    }

    /**
     * Ȗʏł̓_ UV p[^lԂB
     * <p>
     * ʂƂēz̗vf 2 ŁA
     * ŏ̗vf U ̃p[^lA
     * Ԗڂ̗vf V ̃p[^l
     * B
     * </p>
     *
     * @return Ȗʏł̓_ UV p[^l
     */
    public double[] parameters() {
        double [] param = { uParameter, vParameter };
        return param;
    }

    /**
     * x[XƂȂ`vfɑ΂񂩂_̍Wl߂B
     *
     * @return	x[XƂȂ`vfɑ΂񂩂狁߂_̍Wl
     */
    JgclPoint3D coordinates() {
        JgclPoint3D coord;
        try {
            coord = basisSurface.coordinates(uParameter, vParameter);
        }
        catch (JgclParameterOutOfRange e) {
            throw new JgclFatal();
        }
        return coord;
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclPoint3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint3D tPoint = this.point();
	if (tPoint != null)
	    tPoint = tPoint.transformBy(reverseTransform,
					transformationOperator, transformedGeometries);
	JgclParametricSurface3D tBasisSurface =
	    this.basisSurface.transformBy(reverseTransform,
					  transformationOperator, transformedGeometries);
	return new JgclPointOnSurface3D(tPoint,
					tBasisSurface,
					this.uParameter, this.vParameter,
					doCheckDebug);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tpoint");
        coordinates().output(writer, indent + 2);
        writer.println(indent_tab + "\tbasisSurface");
        basisSurface.output(writer, indent + 2);
        writer.println(indent_tab + "\tuParameter\t" + uParameter);
        writer.println(indent_tab + "\tvParameter\t" + vParameter);
        writer.println(indent_tab + "End");
    }
}
