/*
 * l؏̊Kw\\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclQuadTree.java,v 1.4 2000/04/26 09:39:22 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * l؏̊Kw\\NXB
 * <p>
 * ňl؂́A
 *  (root) ƌĂ΂A̃m[hƂāA
 * em[hl̎qm[hƂłf[^\łB
 * </p>
 * <p>
 * l؏̃m[h́ÃNX̓NX
 * {@link JgclQuadTree.Node JgclQuadTree.Node}
 * ̃CX^XłB
 * ̃m[hɂ́Ãm[h́uf[^vƂāA
 * Cӂ̃IuWFNg () ֘AÂ邱ƂłB
 * </p>
 *
 * @version $Revision: 1.4 $, $Date: 2000/04/26 09:39:22 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclBinaryTree
 */

class JgclQuadTree {
    /**
     * root m[hB
     */
    private Node root;

    /**
     * ^ꂽIuWFNg root m[h́uf[^vƂ񕪖؂\zB
     *
     * @param data	root m[h́uf[^vƂIuWFNg
     */
    JgclQuadTree(Object data) {
	super();
	root = new Node(null, data);
    }

    /**
     * ̎l؂ root m[hԂB
     * 
     * @return	root m[h
     */
    Node rootNode() {
	return root;
    }

    /**
     * l؏̂̃m[h\ JgclQuadTree ̓NXB
     * <p>
     * m[h͎l̎qm[hƂł (ȂĂ\Ȃ) B
     * </p>
     * <p>
     * ܂Am[hɂ́Ãm[h́uf[^vƂāA
     * Cӂ̃IuWFNg () ֘AÂ邱ƂłB
     * </p>
     * @see	JgclQuadTree
     */
    class Node {
	/**
	 * ̃m[h́uf[^vƂĊ֘AtꂽIuWFNgB
	 */
	private final Object data;

	/**
	 * em[hB
	 */
	private final Node parent;

	/**
	 * 0 Ԃ߂̎qm[hB
	 */
	private Node child0;

	/**
	 * 1 Ԃ߂̎qm[hB
	 */
	private Node child1;

	/**
	 * 2 Ԃ߂̎qm[hB
	 */
	private Node child2;

	/**
	 * 3 Ԃ߂̎qm[hB
	 */
	private Node child3;

	/**
	 * ^ꂽIuWFNguf[^vƂm[h\zB
	 * <p>
	 * data  null ł\ȂB
	 * </p>
	 * <p>
	 * parent  null ł\ȂB
	 * </p>
	 *
	 * @param data	m[h́uf[^vƂIuWFNg
	 * @param parent	em[h
	 */
	Node(Node parent, Object data) {
	    super();
	    this.data = data;
	    this.parent = parent;
	}

	/**
	 * ̃m[h́uf[^vԂB
	 *
	 * @return	m[h́uf[^v
	 */
	Object data() {
	    return data;
	}

	/**
	 * ̃m[h̐em[hԂB
	 * <p>
	 * em[h null ł邩ȂB
	 * </p>
	 *
	 * @return	em[h
	 */
	Node parent() {
	    return parent;
	}

	/**
	 * n Ԃ߂̎qm[hԂB
	 * <p>
	 * n ̒l 0  3 łȂ΂ȂȂB
	 * łȂꍇɂ JgclInvalidArgumentValue ̗O𔭐B
	 * </p>
	 *
	 * @param n	qm[h̔ԍ
	 * @return	n Ԃ߂̎qm[h
	 * @see	JgclInvalidArgumentValue
	 */
	synchronized Node child(int n) {
	    switch (n) {
	    case 0:
		return child0;
	    case 1:
		return child1;
	    case 2:
		return child2;
	    case 3:
		return child3;
	    }
	    throw new JgclInvalidArgumentValue();
	}

	/**
	 * ^ꂽm[hÃm[h n Ԗڂ̎qm[hƂĐݒ肷B
	 * <p>
	 * n ̒l 0  3 łȂ΂ȂȂB
	 * łȂꍇɂ JgclInvalidArgumentValue ̗O𔭐B
	 * </p>
	 * <p>
	 * child  null ł\ȂB
	 * </p>
	 *
	 * @param n	qm[h̔ԍ
	 * @param child	n Ԃ߂̃m[hƂĐݒ肷m[h
	 * @see	JgclInvalidArgumentValue
	 */
	synchronized void child(int n, Node child) {
	    switch (n) {
	    case 0:
		child0 = child;
		break;
	    case 1:
		child1 = child;
		break;
	    case 2:
		child2 = child;
		break;
	    case 3:
		child3 = child;
		break;
	    default:
		throw new JgclInvalidArgumentValue();		
	    }
	}

	/**
	 * ̃m[h n Ԗڂ̎qm[hVɐB
	 * <p>
	 * data ŗ^ꂽIuWFNgVɐqm[h́uf[^vƂȂB
	 * </p>
	 * <p>
	 * n ̒l 0  3 łȂ΂ȂȂB
	 * łȂꍇɂ JgclInvalidArgumentValue ̗O𔭐B
	 * </p>
	 * <p>
	 * ̃m[hɂł n Ԗڂ̎qm[hݒ肳Ăꍇɂ
	 * JgclFatal ̗O𔭐B
	 * </p>
	 * 
	 * @param data	Vɐm[h́uf[^v
	 * @return	n Ԗڂ̎qƂĐVɐm[h
	 * @see	JgclInvalidArgumentValue
	 * @see	JgclFatal
	 */
	synchronized Node makeChild(int n, Object data) {
	    if (child(n) != null)
		throw new JgclFatal();

	    Node child = new Node(this, data);
	    child(n, child);
	    return child;
	}
    }
}
