/*
 * ϐъěWł鑽\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclRealPolynomial.java,v 1.23 2000/04/26 09:39:22 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * ϐъěWł鑽\NXB
 * <p>
 * ̃NX́At ϐƂ n ̑ :
 * <pre>
 *	P(t) = A0 + A1 * t + A2 * t^2 + ... + An * t^n
 * </pre>
 * \B
 * </p>
 * <p>
 * ̃NX̃CX^X́A
 * ̊ěW Ai (i = 0, ..., n) ̒l܂ގz coef B
 * coef ɂ́A̒Ⴂ̌WlɊi[̂ƂB
 * ܂Acoef[i] ɂ i ̍̌W Ai ̒li[B
 * </p>
 *
 * @version $Revision: 1.23 $, $Date: 2000/04/26 09:39:22 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclComplexPolynomial
 */
public class JgclRealPolynomial extends java.lang.Object implements JgclRealFunctionWithOneVariable {
    /**
     * ěWl̔zB
     * <p>
     * ̒ႢWɊi[B
     * ܂Acoef[i] ɂ i ̍̌Wli[B
     * </p>
     */
    private double[] coef;

    /**
     * ěWlKĂ邩ۂA\tOB
     * <p>
     * ̑͊Oɂ͌ȂB
     * </p>
     */
    private boolean normalized;

    /**
     * ^ȂŃIuWFNg\zB
     * <p>
     * ̃RXgN^g邱Ƃ͂ȂB
     * </p>
     */
    private JgclRealPolynomial() {
	this.coef = null;
	this.normalized = false;
    }

    /**
     * ěWl܂ޔz^ăIuWFNg\zB
     * <p>
     * coef ɂ́A̒Ⴂ̌WlɊi[Ă̂ƂB
     * </p>
     *
     * @param	coef	̊ěWl̔z
     * @param	normalized	ěWlKĂ邩ۂA\tO
     */
    private JgclRealPolynomial(double[] coef, boolean normalized) {
	this.coef = (double[])coef.clone();
	this.normalized = normalized;
    }

    /**
     * ěWl܂ޔz^ăIuWFNg\zB
     * <p>
     * coef ɂ́A̒Ⴂ̌WlɊi[Ă̂ƂB
     * ܂Acoef[i] ɂ i ̍̌Wli[ĂB
     * </p>
     * <p>
     * coef  null ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * ܂Acoef ̗vf 1 菬ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param	coef	̊ěWl̔z
     * @see	JgclInvalidArgumentValue
     */
    public JgclRealPolynomial(double[] coef)
    {
	if (coef == null)
	    throw new JgclInvalidArgumentValue("Array of coefficients is null.");

	if (coef.length < 1)
	    throw new JgclInvalidArgumentValue("Size of array of coefficients is zero.");

	this.coef = (double[])coef.clone();
	this.normalized = false;
    }

    /**
     * ěWl܂ޓ񎟌z^ăIuWFNg\zB
     * <p>
     * coef[i][j] ɂ j ڂ̑ i ̍̌W̒li[Ă̂ƂB
     * </p>
     * <p>
     * dimension ŗ^鎟ɑΉWlő𐶐B
     * ܂A鑽 i ̍̌W coef[i][dimension] ɂȂB
     * </p>
     * <p>
     * coef  null ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * ܂Acoef ̗vf 1 菬ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * ɁAdimension ̒l 0 菬A
     * 邢 (coef[0].length - 1) 傫ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param	coef	̊ěWl̓񎟌z [][]
     * @param	dimension	𐶐鎟 (0 x[X)
     */
    public JgclRealPolynomial(double[][] coef,
			      int dimension) throws JgclInvalidArgumentValue {
	if (coef == null)
	    throw new JgclInvalidArgumentValue("Array of coefficients is null.");

	if (coef.length < 1)
	    throw new JgclInvalidArgumentValue("Size of array of coefficients is zero.");

	if ((dimension < 0) || (coef[0].length <= dimension))
	    throw new JgclInvalidArgumentValue("Wrong dimension.");

	this.coef = new double[coef.length];
	for (int i = 0; i < coef.length; i++)
	    this.coef[i] = coef[i][dimension];
	this.normalized = false;
    }

    /**
     * 2 ̊ěWl^ăIuWFNg\zB
     * <p>
     * ̃RXgN^Ő鑽͕̎K 2 łB
     * </p>
     *
     * @param	coef0	0 ̌Wl
     * @param	coef1	1 ̌Wl
     * @param	coef2	2 ̌Wl
     */
    public JgclRealPolynomial(double coef0,
			      double coef1,
			      double coef2) {
	this.coef = new double[3];
	this.coef[0] = coef0;
	this.coef[1] = coef1;
	this.coef[2] = coef2;
    }

    /**
     * ̑̎ԂB
     *
     * @return	̎
     */
    public int degree() {
	return this.coef.length - 1;
    }

    /**
     * ̑̎w̎̍̌W̒lԂB
     * <p>
     * coef[degree] ̒lԂB
     * </p>
     *
     * @param	degree	
     * @return	w̎̍̌Wl
     */
    public double coefficientAt(int degree) {
	return this.coef[degree];
    }

    /**
     * ̑̎w͈̔͂̎̍̌W̒lԂB
     * <p>
     * lower  upper ܂ł̍̌WlԂB
     * </p>
     *
     * @param	lower	̉
     * @param	upper	̏
     * @return	w̎̍̌Wl̔z
     */
    public double[] coefficientsBetween(int lower,
					int upper) {
	int n = upper - lower + 1;
	double[] result = new double[n];
	for (int i = 0; i < n; i++)
	    result[i] = this.coef[lower + i];
	return result;
    }

    /**
     * ̑A^ꂽp[^lŕ]B
     * <p>
     * ^ꂽp[^l t ɂ邱̑̒l P(t) ԂB
     * </p>
     *
     * @param parameter	p[^l
     * @return	^ꂽp[^lő]l
     */
    public double evaluate(double parameter) {
	double value = this.coef[this.degree()];
	for (int i = (this.degree() - 1); i >= 0; i--)
	    value = (value * parameter) + this.coef[i];
	return value;
    }

    /**
     * ̑ӂƂ񎟕 (A0 + A1 * t + A2 * t^2 = 0) B
     * <p>
     * ̑ 2 łȂ null ԂB
     * </p>
     * <p>
     * ʂƂēźA̎܂ށB
     * āA̔z̒ 0 Ȃ 2 łB
     * ݂Ȃꍇ͒ 0 ̔zԂB
     * </p>
     * <p>
     * mustHaveRoots ̒l true ̏ꍇɂ́A
     * ʎɂȂ邱ƂȂA
     * coef[2], coef[1] ̐ΒlƂ
     * 0 ɂȂȂ̂ƂĕB
     * āȀꍇɂ́A͕̐K 1 ȏƂȂB
     * </p>
     *
     * @param mustHaveRoots	KĂƂ݂ȂǂtO
     * @return	̔z
     * @see	#getRootsIfQuadric()
     * @see	#getAlwaysRootsIfQuadric()
     */
    private double[] getRootsIfQuadric(boolean mustHaveRoots) {
	if (degree() != 2)
	    return null;

	double[] normalCoef = new double[3];	// normalized coefficients
	double maxValue;			// max. absolute value of coefficients
	double[] roots;				// solutions

	/*
	 * normalize coefficients
	 */
	maxValue = (Math.abs(coef[2]) > Math.abs(coef[1]))
	          ? Math.abs(coef[2]) : Math.abs(coef[1]);
	maxValue = (maxValue > Math.abs(coef[0])) ? maxValue : Math.abs(coef[0]);

	normalCoef[2] = coef[2] / maxValue;
	normalCoef[1] = coef[1] / maxValue;
	normalCoef[0] = coef[0] / maxValue;

	/*
	 * look the magnitude of each coefficient
	 */
	if (Math.abs(normalCoef[2]) < JgclMachineEpsilon.DOUBLE) {
	    if (!mustHaveRoots && Math.abs(normalCoef[1]) < JgclMachineEpsilon.DOUBLE) {
		/*
		 * A0 = 0
		 */
		roots = new double[0];
	    } else {
		/*
		 * A0 + A1 * t = 0
		 */
		roots = new double[1];
		roots[0] = - normalCoef[0] / normalCoef[1];
	    }
	} else {
	    /*
	     * A0 + A1 * t + A2 * t^2 = 0
	     */
	    double discriminant = normalCoef[1] * normalCoef[1] - 4.0 * normalCoef[2] * normalCoef[0];

	    if (!mustHaveRoots && discriminant < (- JgclMachineEpsilon.DOUBLE)) {
		/*
		 * roots are complex
		 */
		roots = new double[0]; 
	    } else {
		/*
		 * roots are real
		 */
		int nRoots; // # of solutions
		double[] twoRoots = new double[2];
		boolean secondByAdding;

		if (discriminant > (JgclMachineEpsilon.DOUBLE * JgclMachineEpsilon.DOUBLE)) {
		    nRoots = 2;
		} else {
		    discriminant = 0.0;
		    nRoots = 1;
		}
		discriminant = Math.sqrt(discriminant);

		if (normalCoef[1] > 0.0) {
		    twoRoots[0] = (- normalCoef[1]) - discriminant;
		    secondByAdding = true;
		} else {
		    twoRoots[0] = (- normalCoef[1]) + discriminant;
		    secondByAdding = false;
		}
		twoRoots[0] /= 2.0 * normalCoef[2];

		if (Math.abs(twoRoots[0]) > JgclMachineEpsilon.DOUBLE) {
		    twoRoots[1] = (normalCoef[0] / normalCoef[2]) / twoRoots[0];
		} else {
		    if (secondByAdding == true) {
			twoRoots[1] = (- normalCoef[1]) + discriminant;
		    } else {
			twoRoots[1] = (- normalCoef[1]) - discriminant;
		    }
		    twoRoots[1] /= 2.0 * normalCoef[2];
		}

		roots = new double[nRoots];

		if (nRoots == 1) {
		    roots[0] = (twoRoots[0] + twoRoots[1]) / 2.0;
		} else {
		    roots[0] = twoRoots[0];
		    roots[1] = twoRoots[1];
		}
	    }
	}

	return roots;
    }

    /**
     * ̑ӂƂ񎟕 (A0 + A1 * t + A2 * t^2 = 0) B
     * <p>
     * ̑ 2 łȂ null ԂB
     * </p>
     * <p>
     * ʂƂēźA̎܂ށB
     * āA̔z̒ 0 Ȃ 2 łB
     * ݂Ȃꍇ͒ 0 ̔zԂB
     * </p>
     *
     * @return	̔z
     * @see	#getAlwaysRootsIfQuadric()
     */
    public double[] getRootsIfQuadric() {
	return getRootsIfQuadric(false);
    }

    /**
     * ̑ӂƂ񎟕 (A0 + A1 * t + A2 * t^2 = 0) B
     * <p>
     * ̑ 2 łȂ null ԂB
     * </p>
     * <p>
     * ̃\bh́A
     * {Iɂ {@link #getRootsIfQuadric() getRootsIfQuadric()} Ɠł邪A
     * KĂƂ݂ȂĉB
     * Ȃ킿AʎɂȂ邱ƂȂA
     * coef[2], coef[1] ̐ΒlƂ
     * 0 ɂȂȂ̂ƂĕB
     * āA͕̐K 1 Ȃ 2 ƂȂB
     * </p>
     *
     * @return	̔z
     * @see	#getRootsIfQuadric()
     */
    public double[] getAlwaysRootsIfQuadric() {
	return getRootsIfQuadric(true);
    }

    /**
     * ̑ɂāAΒl 0 Ƃ݂Ȃ鍂̌W菜ԂB
     * <p>
     * ̃\bhԂ̊ěWĺA
     * ̐Βl̍ől 1 ɂȂ悤ɐKꂽ̂ɂȂB
     * </p>
     * <p>
     * ̃\bhł́A
     * ̑
     * ěW̐Βl̍ől 1 ɂȂ悤ȐKsȂƂɁA
     * W̐Βl JgclMachineEpsilon.DOUBLE 菬Ȃ悤
     * 菜B
     * </p>
     * <p>
     * ̑
     * ěW̐Βl̍ől JgclMachineEpsilon.DOUBLE 菬ꍇɂ
     * 0 ̍̌Wl 0  0 ԂB
     * ܂A
     * ěW̐Βl̍ől̂ 0 ̍ŁA
     * ׂ̂Ă̍̌Wl Ai  ((|Ai| / |A0|) &lt; JgclMachineEpsilon.DOUBLE)
     * łꍇɂ
     * 0 ̍̌Wl 0  0 ԂB
     * </p>
     *
     * @return	Βl 0 Ƃ݂Ȃ鍂̌W菜
     * @see	JgclMachineEpsilon#DOUBLE
     */
    public JgclRealPolynomial normalize() {
	/*
	 * if this has been normalized, return this
	 */
	if (this.normalized == true)
	    return this;

	/*
	 * get absolute min. & max. value
	 */
	int minIdx, maxIdx;
	double minVal, maxVal;

	minIdx = maxIdx = this.degree();
	minVal = maxVal = Math.abs(this.coef[this.degree()]);

	for (int i = (this.degree() - 1); i >= 0; i--) {
	    double absVal = Math.abs(this.coef[i]);
	    if (absVal < minVal) {
		minIdx = i;
		minVal = absVal;
	    }
	    if (maxVal < absVal) {
		maxIdx = i;
		maxVal = absVal;
	    }
	}

	/*
	 * if all values are same & zero, return zero polynomial
	 */
	if ((minIdx == maxIdx) &&
	    (maxVal < JgclMachineEpsilon.DOUBLE)) {
	    double[] zeroCoef = new double[1];
	    zeroCoef[0] = 0.0;
	    return new JgclRealPolynomial(zeroCoef, true);
	}

	int actualDegree = this.degree() + 1;

	while (--actualDegree >= 0) {
	    if (Math.abs(this.coef[actualDegree] / maxVal) > JgclMachineEpsilon.DOUBLE)
		break;
	}

	if (actualDegree == 0) {
	    double[] zeroCoef = new double[1];
	    zeroCoef[0] = 0.0;
	    return new JgclRealPolynomial(zeroCoef, true);
	}

	double[] normalizedCoef = new double[actualDegree + 1];
	for (int i = 0; i <= actualDegree; i++)
	    normalizedCoef[i] = this.coef[i] / maxVal;
	return new JgclRealPolynomial(normalizedCoef, true);
    }

    /**
     * ̑Ƒ̑́uav\ԂB
     * <p>
     * ̑ P(t) Ƒ̑ Q(t) ̘a P(t) + Q(t) ԂB
     * </p>
     *
     * @param mate	̑
     * @return	(this + mate)
     */
    public JgclRealPolynomial add(JgclRealPolynomial mate) {
	int ijk;

	if (mate.degree() > degree())
	    return mate.add(this);

        if ((degree() < 0) || (mate.degree() < 0))
            throw new JgclFatal();

        double newCoef[] = new double[degree() + 1];

	for (ijk = 0; ijk <= mate.degree(); ijk++)
            newCoef[ijk] = coef[ijk] + mate.coef[ijk];

	for ( ; ijk <= degree(); ijk++)
            newCoef[ijk] = coef[ijk];

        return new JgclRealPolynomial(newCoef, false);
    }

    /**
     * ̑Ƒ̑́uv\ԂB
     * <p>
     * ̑ P(t) Ƒ̑ Q(t) ̍ P(t) - Q(t) ԂB
     * </p>
     *
     * @param mate	̑
     * @return	(this - mate)
     */
    public JgclRealPolynomial subtract(JgclRealPolynomial mate) {
	return this.add(mate.multiply(-1));
    }

    /**
     * ̑ɗ^ꂽlԂB
     * <p>
     * ̑ P(t)  val  val *  P(t) ԂB
     * </p>
     *
     * @param val	̊ěWɂl
     * @return	(this * val)
     */
    public JgclRealPolynomial multiply(double val) {
	int ijk;
        if (degree() < 0)
            throw new JgclFatal();

        double newCoef[] = new double[degree() + 1];

	for (ijk = 0; ijk <= degree(); ijk++)
            newCoef[ijk] = val * coef[ijk];

        return new JgclRealPolynomial(newCoef, false);
    }

    /**
     * ̑Ƒ̑́uρv\ԂB
     * <p>
     * ̑ P(t) Ƒ̑ Q(t) ̐ P(t) * Q(t) ԂB
     * </p>
     *
     * @param mate	̑
     * @return	(this * mate)
     */
    public JgclRealPolynomial multiply(JgclRealPolynomial mate) {
	int ijk, klm;
	int idx;

        if ((degree() < 0) || (mate.degree() < 0)) {
            throw new JgclFatal();
        }

	int newDegree = degree() + mate.degree();
        double newCoef[] = new double[newDegree+1];

	for (ijk = 0; ijk <= newDegree; ijk++)
            newCoef[ijk] = 0.0;

	for (ijk = 0; ijk <= degree(); ijk++)
	    for (klm = 0; klm <= mate.degree(); klm++) {
		idx = ijk + klm;
		newCoef[idx] += coefficientAt(ijk) * mate.coefficientAt(klm);
	    }

        return new JgclRealPolynomial(newCoef, false);
    }

    /**
     * ̑̈ꎟ֐\ԂB
     * <p>
     * ̑̎ 0 ̏ꍇɂ́A
     * 0 ̍̌Wl 0 ł 0 ԂB
     * </p>
     *
     * @return	ꎟ֐\
     */
    public JgclRealPolynomial derive() {
        if (degree() < 0) {
            throw new JgclFatal();
        }

	double[] newCoef;

	if (degree() == 0) {
	    newCoef = new double[1];
	    newCoef[0] = 0.0;
	} else {
	    newCoef = new double[degree()];
	    for (int ijk = 1; ijk <= degree(); ijk++)
		newCoef[ijk - 1] = ijk * coef[ijk];
	}

	return new JgclRealPolynomial(newCoef, false);
    }

    /**
     * ̍ Newton-Raphson @ɂċ߂悤ƂۂɁA
     * ̎ZɎsƂO () NXB
     */
    public class NRNotConverge extends JgclException {
	/**
	 * ł؂ۂ̍̐lB
	 * @serial
	 */
	private double value;

	/**
	 * ł؂ۂ̍̐l^ăIuWFNg\zB
	 *
	 * @param	value	ł؂ۂ̍̐l
	 */
	private NRNotConverge(double value) {
	    super();
	    this.value = value;
	}

	/**
	 * ł؂ۂ̍̐lԂB
	 *
	 * @return	ł؂ۂ̍̐l
	 */
	public double getValue() {
	    return this.value;
	}
    }

    /**
     * ̑ӂƂ̍ Newton-Raphson @ɂĈ߂B
     *
     * @param initialGuess	̍̏l
     * @return	̎l
     * @exception NRNotConverge	ZȂ
     */
    public double getOneRootByNR(double initialGuess)
        throws NRNotConverge
    {
	double root = initialGuess;
	double epsilon = JgclMachineEpsilon.DOUBLE;
	int maxIteration = 50;
	double value;		/* value of polynomial */
	double absVal;		/* absolute of value */
	double deriv;		/* 1st derivative of polynomial */
	double tempVal;		/* temporary value */
	double absTempVal;	/* absolute of temporary value */
	double coef;		/* a coefficient */
	double delta;		/* delta at root */

	/*
	 * iteractive refinement by Newton-Raphson method
	 */
	for (int iteration = 0; iteration < maxIteration; iteration++) {
	    value = coefficientAt(degree());
	    deriv = value;
	    delta = 0.0;

	    for (int j = degree() - 1; j >= 0; j--) {
		tempVal = value * root;
		coef = coefficientAt(j);
		value = tempVal + coef;
		absTempVal = Math.abs(tempVal);
		if (j > 0)
		    deriv = (deriv * root) + value;
		delta = Math.abs(root) * delta +
		    epsilon * (absTempVal + JgclMath.maxOf3(Math.abs(coef),
									     absTempVal,
									     Math.abs(value)));
	    }

	    absVal = Math.abs(value);
	    if (((absVal < epsilon) && (delta  < epsilon)) || (absVal < delta)) {
		return root;
	    }

	    if (Math.abs(deriv) > epsilon) {
		root = root - value / deriv;
	    } else {
		root = root - value / JgclMath.copySign(epsilon, deriv);
	    }
	}

	throw this.new NRNotConverge(root);
    }

    /**
     * ̕𕡑fɕϊB
     * <p>
     * ʂƂē镡f̊ěW̋̒l 0 łB
     * </p>
     *
     * @return	f
     */
    public JgclComplexPolynomial toComplexPolynomial() {
	JgclComplex[] complexCoef = new JgclComplex[this.coef.length];
	for (int i = 0; i < this.coef.length; i++)
	    complexCoef[i] = new JgclComplex(this.coef[i]);
	try {
	    return new JgclComplexPolynomial(complexCoef);
	}
	catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal("Can not create a complex polynomial.");
	}
    }

    /**************************************************************************
     *
     * Debug
     *
     **************************************************************************/
    /* Debug : getRootsIfQuadric */
    private static void debugGetRootsIfQuadric(String argv[]) {
	double[] coef = new double[argv.length];
	for (int i = 0; i < argv.length; i++)
	    coef[i] = Double.valueOf(argv[i]).doubleValue();

	try {
	    JgclRealPolynomial poly = new JgclRealPolynomial(coef);
	    double[] result = poly.getRootsIfQuadric();
	    if (result != null) {
		for (int i = 0; i < result.length; i++)
		    System.out.println("result : " + result[i] +
				       ", evaluate : " + poly.evaluate(result[i]));
	    }
	}
	catch (JgclInvalidArgumentValue e) {
	    System.err.println(e);
	}
    }

    /* Debug : getOneRootByNR */
    private static void debugGetOneRootByNR(String argv[]) {
	double[] coef = new double[argv.length];
	for (int i = 0; i < argv.length; i++)
	    coef[i] = Double.valueOf(argv[i]).doubleValue();

	try {
	    JgclRealPolynomial poly = new JgclRealPolynomial(coef);
	    double result = poly.getOneRootByNR(0.0);
	    System.out.println("result : " + result + ", evaluate : " + poly.evaluate(result));
	}
	catch (JgclInvalidArgumentValue e) {
	    System.err.println(e);
	}
	catch (JgclRealPolynomial.NRNotConverge e) {
	    System.err.println(e);
	}
    }

    /* Debug */
    /**
     * fobOpCvOB
     */
    public static void main(String argv[]) {
	debugGetRootsIfQuadric(argv);
	debugGetOneRootByNR(argv);
    }
}

/* end of file */
