/*
 * Q : q̎Op`̏W\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclSetOfTriangles2D.java,v 1.13 2000/04/26 09:39:23 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.*;
import java.util.*;

/**
 * Q : q̎Op`̏W\NXB
 *
 * @version $Revision: 1.13 $, $Date: 2000/04/26 09:39:23 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclSetOfTriangles2D extends JgclNonParametricSurface2D {
    /**
     * Op`Q̈ʑ\OtB
     * @serial
     */
    private JgclEmbeddedGraph graph;

    /**
     * E̊OƂȂʁB
     * @serial
     */
    private Face outerFace;

    /**
     * Op`̒_\NXB
     * <p>
     * ̃NX̃CX^X́A
     * _̍Wl coordinates
     * ێB
     * </p>
     */
    public class Vertex extends JgclEmbeddedGraph.Vertex {
	/**
	 * WlB
	 */
	private JgclPoint2D coordinates;

	/**
	 * ^ɃIuWFNg\zB
	 * <p>
	 * coordinates ɂ null B
	 * </p>
	 */
	protected Vertex() {
	    // call superclass's constructor with parent
	    JgclSetOfTriangles2D.this.graph.super();
	    this.coordinates = null;
	}

	/**
	 * ̒_̕ƂĐݒ肳Ă钸_̃tB[hɐlB
	 * <p>
	 * super.fillFieldsOfReplica() ĂяoɁA
	 * ̒_ coordinates 
	 * ̒_̕ coordinates ƂB
	 * </p>
	 */
	protected void fillFieldsOfReplica() {
	    super.fillFieldsOfReplica();
	    Vertex replica = (Vertex)this.getReplica();
	    replica.coordinates = this.coordinates;
	}

	/**
	 * ̒_̍Wlݒ肷B
	 *
	 * @param coordinates	Wl
	 */
	public void setCoordinates(JgclPoint2D coordinates) {
	    this.coordinates = coordinates;
	}

	/**
	 * ̒_ɐݒ肳ĂWlԂB
	 *
	 * @return	Wl
	 */
	public JgclPoint2D getCoordinates() {
	    return this.coordinates;
	}

	/**
	 * ̒_芪Op`̔zԂB
	 * <p>
	 * ʂƂēzɂ́ȀŎOp`i[B
	 * </p>
	 * <p>
	 * Op`ɖʂȂӏvfɂ null B
	 * </p>
	 *
	 * @return	_芪Op`̔z
	 */
	public Face[] getFacesInCCW() {
	    Vector faces = getFaceCycleInCCW();
	    Face[] result = new Face[faces.size()];
	    for (int i = 0; i < faces.size(); i++) {
		if ((result[i] = (Face)faces.elementAt(i)) == outerFace)
		    result[i] = null;
	    }
	    return result;
	}

	/**
	 * ̒_芪ӂ̔zԂB
	 * <p>
	 * ʂƂēzɂ́Ȁŕӂi[B
	 * </p>
	 *
	 * @return	_芪ӂ̔z
	 */
	public Edge[] getEdgesInCCW() {
	    Vector edges = getEdgeCycleInCCW();
	    Edge[] result = new Edge[edges.size()];
	    for (int i = 0; i < edges.size(); i++)
		result[i] = (Edge)edges.elementAt(i);
	    return result;
	}
    }

    /**
     * Op`\NXB
     */
    public class Face extends JgclEmbeddedGraph.Face {
	/**
	 * ^ɃIuWFNg\zB
	 */
	protected Face() {
	    // call superclass's constructor with parent
	    JgclSetOfTriangles2D.this.graph.super();
	}

	/**
	 * ̎Op`芪ӂ̔zԂB
	 * <p>
	 * ʂƂēz̗vf 3 ŁA
	 * ̏ŕӂi[B
	 * </p>
	 *
	 * @return	Op`芪ӂ̔z
	 */
	public Edge[] getEdgesInCCW() {
	    Edge[] result = new Edge[3];
	    Vector edges = getEdgeCycleInCCW();
	    for (int i = 0; i < 3; i++)
		result[i] = (Edge)edges.elementAt(i);
	    return result;
	}

	/**
	 * ̎Op`芪_̔zԂB
	 * <p>
	 * ʂƂēz̗vf 3 ŁA
	 * ̏Œ_i[B
	 * </p>
	 *
	 * @return	Op`芪_̔z
	 */
	public Vertex[] getVerticesInCCW() {
	    Vertex[] result = new Vertex[3];
	    Vector vertices = getVertexCycleInCCW();
	    for (int i = 0; i < 3; i++)
		result[i] = (Vertex)vertices.elementAt(i);
	    return result;
	}
    }

    /**
     * Op`̕ӂ\NXB
     */
    public class Edge extends JgclEmbeddedGraph.Edge {
	/**
	 * ^ɃIuWFNg\zB
	 */
	protected Edge() {
	    // call superclass's constructor with parent
	    JgclSetOfTriangles2D.this.graph.super();
	}

	/**
	 * ̕ӂ̗[̒_ԂB
	 * <p>
	 * ʂƂēz̗vf 2 łB
	 * </p>
	 *
	 * @return ӂ̗[̒_̔z
	 */
	public Vertex[] getVerticesOfStartEnd() {
	    JgclEmbeddedGraph.Vertex[] vertices = getVertices();
	    Vertex[] result = new Vertex[2];
	    for (int i = 0; i < 2; i++)
		result[i] = (Vertex)vertices[i];
	    return result;
	}

	/**
	 * ̕ӂ̗̎Op`ԂB
	 * <p>
	 * ʂƂēz̗vf 2 łB
	 * </p>
	 * <p>
	 * ̕ӂ̂ǂ瑤Op`ɖʂȂꍇɂ
	 * z̗vf̒lƂ null B
	 * </p>
	 *
	 * @return ӂ̗̎Op`̔z
	 */
	public Face[] getFacesOfLeftRight() {
	    JgclEmbeddedGraph.Face[] faces = getFaces();
	    Face[] result = new Face[2];
	    for (int i = 0; i < 2; i++) {
		if ((result[i] = (Face)faces[i]) == outerFace)
		    result[i] = null;
	    }
	    return result;
	}
    }

    /**
     * Otł̐VȒ_^Ӂ^ʂ̐ɁA
     * ̃NX̊YNX̃CX^X\zĕԂIuWFNg
     * 𐶐B
     *
     * @return	Otł̐VȒ_^Ӂ^ʂ̐SIuWFNg
     */
    private JgclEmbeddedGraph.GraphItemMaker makeGraphItemMaker() {
	return new JgclEmbeddedGraph.GraphItemMaker() {
	    JgclSetOfTriangles2D parent = JgclSetOfTriangles2D.this;
	    // g̓NXg
	    public JgclEmbeddedGraph.Vertex newVertex() { return parent.new Vertex(); }
	    public JgclEmbeddedGraph.Face   newFace()   { return parent.new Face(); }
	    public JgclEmbeddedGraph.Edge   newEdge()   { return parent.new Edge(); }
	};
    }

    /**
     * ^ɃIuWFNg\z邱Ƃ͂łȂB
     */
    private JgclSetOfTriangles2D() {
	super();
    }

    /**
     * iq̓_Ԃ^A
     * 𒸓_ƂOp`̏WƂăIuWFNg\zB
     * <p>
     * grid ̈ꎟځ^񎟌ڂ̂ꂩ̗vf 2 菬ꍇɂ
     * JgclInvalidArgumentValue ̗OԂB
     * </p>
     *
     * @param grid	iq̓_
     * @see	JgclInvalidArgumentValue
     */
    public JgclSetOfTriangles2D(JgclPoint2D[][] grid)
    {
	super();

	int columnSize = grid.length;
	int rowSize = grid[0].length;

	if (rowSize < 2) {
	    throw new JgclInvalidArgumentValue("Row size of grid is less than 2.");
	}

	if (columnSize < 2) {
	    throw new JgclInvalidArgumentValue("Column size of grid is less than 2.");
	}

	graph = new JgclEmbeddedGraph(makeGraphItemMaker());

	JgclEmbeddedGraph.Vertex vertices[][] = new JgclEmbeddedGraph.Vertex[columnSize][rowSize];

	JgclEmbeddedGraph.Result firstVF = graph.makeVertexFace();
	outerFace = (Face)firstVF.face;
	vertices[0][0] = firstVF.vrtx;
	((Vertex)vertices[0][0]).setCoordinates(grid[0][0]);

	// debug
	// System.out.println(outerFace);

	try {
	    for (int c = 1, c_ = 0; c < columnSize; c++, c_++) {
		vertices[c][0] = graph.makeEdgeVertex(outerFace, vertices[c_][0]).vrtx;
		((Vertex)vertices[c][0]).setCoordinates(grid[c][0]);
	    }

	    for (int r = 1, r_ = 0; r < rowSize; r++, r_++) {
		for (int c = 0, c_ = (- 1); c < columnSize; c++, c_++) {
		    vertices[c][r] = graph.makeEdgeVertex(outerFace, vertices[c][r_]).vrtx;
		    ((Vertex)vertices[c][r]).setCoordinates(grid[c][r]);

		    if (c > 0) {
			Face rectangle =
			    (Face)graph.makeEdgeFace(outerFace, vertices[c_][r], vertices[c][r]).face;
			graph.makeEdgeFace(rectangle, vertices[c_][r_], vertices[c][r]);
		    }
		}
	    }
	}
	catch (JgclInvalidArgumentValue e) {
	}
    }

    /**
     * ̎Op`̏W܂ގOp` Enumeration ԂB
     *
     * @return  Op` Enumeration
     */
    public Enumeration faceElements() {
	return new Enumeration() {
	    Enumeration e = graph.faceElements();
	    Object nextNonOuterFace = null;

	    public boolean hasMoreElements() {
		if (nextNonOuterFace != null)
		    return true;

		if (e.hasMoreElements() == false)
		    return false;

		Object obj = e.nextElement();
		if ((Face)obj != outerFace) {
		    nextNonOuterFace = obj;
		    return true;
		} else {
		    nextNonOuterFace = null;
		    return e.hasMoreElements();
		}
	    }

	    public java.lang.Object nextElement() {
		Object obj;

		if (nextNonOuterFace != null) {
		    obj = nextNonOuterFace;
		    nextNonOuterFace = null;
		    return obj;
		}

		obj = e.nextElement();
		if ((Face)obj != outerFace)
		    return obj;
		else
		    return e.nextElement();
	    }
	};
    }

    /**
     * ̎Op`̏W܂ޒ_ Enumeration ԂB
     *
     * @return  _ Enumeration
     */
    public Enumeration vertexElements() {
	return graph.vertexElements();
    }

    /**
     * ̎Op`̏W܂ޕӂ Enumeration ԂB
     *
     * @return  ӂ Enumeration
     */
    public Enumeration edgeElements() {
	return graph.edgeElements();
    }

    /**
     * ̎Op`̏W܂ޒ_̐ԂB
     *
     * @return  _̐
     */
    public int getNumberOfVertices() {
	return graph.getNumberOfVertices();
    }

    /**
     * ̎Op`̏W܂ގOp`̐ԂB
     *
     * @return  Op`̐
     */
    public int getNumberOfFaces() {
	return graph.getNumberOfFaces() - 1;
    }

    /**
     * ̎Op`̏W܂ޕӂ̐ԂB
     *
     * @return  ӂ̐
     */
    public int getNumberOfEdges() {
	return graph.getNumberOfEdges();
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	 true
     */
    public boolean isFreeform() {
	return true;
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

	throw new JgclNotSupported();	// output
    }
}

/* end of file */
