/*
 * R : q̎Op`̏W\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclSetOfTriangles3D.java,v 1.15 2000/04/26 09:39:23 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.*;
import java.util.*;

/**
 * R : q̎Op`̏W\NXB
 *
 * @version $Revision: 1.15 $, $Date: 2000/04/26 09:39:23 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclSetOfTriangles3D extends JgclNonParametricSurface3D {
    /**
     * Op`Q̈ʑ\OtB
     * @serial
     */
    private JgclEmbeddedGraph graph;

    /**
     * E̊OƂȂʁB
     * @serial
     */
    private Face outerFace;

    /**
     * Op`̒_\NXB
     * <p>
     * ̃NX̃CX^X́A
     * <ul>
     * <li>	_̍Wl coordinates
     * <li>	ŜƂĂ邩ۂtO killed
     * </ul>
     * ێB
     * </p>
     */
    public class Vertex extends JgclEmbeddedGraph.Vertex {
	/**
	 * WlB
	 */
	private JgclPoint3D coordinates;

	/**
	 * ŜƂĂ邩ۂtOB
	 */
	private boolean killed;

	/**
	 * ^ɃIuWFNg\zB
	 * <p>
	 * coordinates ɂ null B
	 * killed  false ƂB
	 * </p>
	 */
	protected Vertex() {
	    // call superclass's constructor with parent
	    JgclSetOfTriangles3D.this.graph.super();
	    this.coordinates = null;
	    this.killed = false;
	}

	/**
	 * ̒_̕ƂĐݒ肳Ă钸_̃tB[hɐlB
	 * <p>
	 * super.fillFieldsOfReplica() ĂяoɁA
	 * ̒_̊etB[h̒lȂΉtB[hɑB
	 * </p>
	 */
	protected void fillFieldsOfReplica() {
	    super.fillFieldsOfReplica();
	    Vertex replica = (Vertex)this.getReplica();
	    replica.coordinates = this.coordinates;
	    replica.killed = this.killed;
	}

	/**
	 * ̒_̍Wlݒ肷B
	 *
	 * @param coordinates	Wl
	 */
	public void setCoordinates(JgclPoint3D coordinates) {
	    this.coordinates = coordinates;
	}

	/**
	 * ̒_ɐݒ肳ĂWlԂB
	 *
	 * @return	Wl
	 */
	public JgclPoint3D getCoordinates() {
	    return this.coordinates;
	}

	/**
	 * ̒_uŜƂ邩ۂvݒ肷B
	 *
	 * @param killed	ŜƂ邩ۂ
	 */
	void setKilled(boolean killed) {
	    this.killed = killed;
	}

	/**
	 * ̒_uŜƂĂ邩ۂvԂB
	 *
	 * @param killed	ŜƂĂ邩ۂ
	 */
	boolean isKilled() {
	    return this.killed;
	}

	/**
	 * ̒_芪Op`̔zԂB
	 * <p>
	 * ʂƂēzɂ́ȀŎOp`i[B
	 * </p>
	 * <p>
	 * Op`ɖʂȂӏvfɂ null B
	 * </p>
	 *
	 * @return	_芪Op`̔z
	 */
	public Face[] getFacesInCCW() {
	    Vector faces = getFaceCycleInCCW();
	    Face[] result = new Face[faces.size()];
	    for (int i = 0; i < faces.size(); i++) {
		if ((result[i] = (Face)faces.elementAt(i)) == outerFace)
		    result[i] = null;
	    }
	    return result;
	}

	/**
	 * ̒_芪ӂ̔zԂB
	 * <p>
	 * ʂƂēzɂ́Ȁŕӂi[B
	 * </p>
	 *
	 * @return	_芪ӂ̔z
	 */
	public Edge[] getEdgesInCCW() {
	    Vector edges = getEdgeCycleInCCW();
	    Edge[] result = new Edge[edges.size()];
	    for (int i = 0; i < edges.size(); i++)
		result[i] = (Edge)edges.elementAt(i);
	    return result;
	}
    }

    /**
     * Op`\NXB
     * <p>
     * ̃NX̃CX^X́A
     * ŜƂĂ邩ۂtO killed
     * ێB
     * </p>
     */
    public class Face extends JgclEmbeddedGraph.Face {
	/**
	 * ŜƂĂ邩ۂtOB
	 */
	private boolean killed;

	/**
	 * ^ɃIuWFNg\zB
	 * <p>
	 * killed  false ƂB
	 * </p>
	 */
	protected Face() {
	    // call superclass's constructor with parent
	    JgclSetOfTriangles3D.this.graph.super();
	    this.killed = false;
	}

	/**
	 * ̎Op`̕ƂĐݒ肳ĂOp`̃tB[hɐlB
	 * <p>
	 * super.fillFieldsOfReplica() ĂяoɁA
	 * ̖ʂ killed ̒lA killed ɑB
	 * </p>
	 */
	protected void fillFieldsOfReplica() {
	    super.fillFieldsOfReplica();
	    Face replica = (Face)this.getReplica();
	    replica.killed = this.killed;
	}

	/**
	 * ̎Op`uŜƂ邩ۂvݒ肷B
	 *
	 * @param killed	ŜƂ邩ۂ
	 */
	void setKilled(boolean killed) {
	    this.killed = killed;
	}

	/**
	 * ̎Op`uŜƂĂ邩ۂvԂB
	 *
	 * @param killed	ŜƂĂ邩ۂ
	 */
	boolean isKilled() {
	    return this.killed;
	}

	/**
	 * ̎Op`芪ӂ̔zԂB
	 * <p>
	 * ʂƂēz̗vf 3 ŁA
	 * ̏ŕӂi[B
	 * </p>
	 *
	 * @return	Op`芪ӂ̔z
	 */
	public Edge[] getEdgesInCCW() {
	    Edge[] result = new Edge[3];
	    Vector edges = getEdgeCycleInCCW();
	    for (int i = 0; i < 3; i++)
		result[i] = (Edge)edges.elementAt(i);
	    return result;
	}

	/**
	 * ̎Op`芪_̔zԂB
	 * <p>
	 * ʂƂēz̗vf 3 ŁA
	 * ̏Œ_i[B
	 * </p>
	 *
	 * @return	Op`芪_̔z
	 */
	public Vertex[] getVerticesInCCW() {
	    Vertex[] result = new Vertex[3];
	    Vector vertices = getVertexCycleInCCW();
	    for (int i = 0; i < 3; i++)
		result[i] = (Vertex)vertices.elementAt(i);
	    return result;
	}

	/**
	 * ^ꂽӂ̎Op`\Oӂ̓̈ӂłƂāA
	 * ̕ӂ̑Ζʂɂ钸_ԂB
	 * <p>
	 * ^ꂽӂ̎Op`芪̂ł͂Ȃꍇɂ null ԂB
	 * </p>
	 *
	 * @param edge	Op`芪
	 * @return	edge ̑Ζʂɂ钸_
	 */
	public Vertex getFarVertex(Edge edge) {
	    Vertex[] vrtcs = this.getVerticesInCCW();
	    Vertex[] edgeVrtcs = edge.getVerticesOfStartEnd();

	    for (int i = 0; i < 3; i++)
		if ((vrtcs[i].isIdentWith(edgeVrtcs[0]) != true) &&
		    (vrtcs[i].isIdentWith(edgeVrtcs[1]) != true))
		    return vrtcs[i];

	    return null;
	}

	/**
	 * ^ꂽӂ̎Op`\Oӂ̓̈ӂłƂāA
	 * ̕ӂ̎n_яI_ł (QԂł) pxԂB
	 * <p>
	 * ʂƂēz̗vf 2 łB
	 * </p>
	 * <p>
	 * ^ꂽӂ̎Op`芪̂ł͂Ȃꍇɂ null ԂB
	 * </p>
	 * <p>
	 * _ coordinates  JgclPointOnSurface3D ̃CX^XłȂ΂ȂȂB
	 * łȂꍇɂ ClassCastException ̗O𔭐B
	 * </p>
	 *
	 * @param edge	Op`芪
	 * @return	ӂ̎n_^I_̂QԂł̊px
	 */
	public double[] getAnglesOfStartEndIn2D(Edge edge) {
	    Vertex[] vrtcs = this.getVerticesInCCW();
	    Vertex[] edgeVrtcs = edge.getVerticesOfStartEnd();
	    Vertex far = null;

	    for (int i = 0; i < 3; i++) {
		if ((vrtcs[i].isIdentWith(edgeVrtcs[0]) != true) &&
		    (vrtcs[i].isIdentWith(edgeVrtcs[1]) != true)) {
		    far = vrtcs[i];
		    break;
		}
	    }

	    if (far == null)
		return null;

	    JgclPointOnSurface3D crd3D;
	    JgclPoint2D[] crds2D = new JgclPoint2D[3];

	    crd3D = (JgclPointOnSurface3D)edgeVrtcs[0].getCoordinates();
	    crds2D[0] = JgclPoint2D.of(crd3D.parameters());

	    crd3D = (JgclPointOnSurface3D)edgeVrtcs[1].getCoordinates();
	    crds2D[1] = JgclPoint2D.of(crd3D.parameters());

	    crd3D = (JgclPointOnSurface3D)far.getCoordinates();
	    crds2D[3] = JgclPoint2D.of(crd3D.parameters());

	    JgclVector2D[] vctrs2D = new JgclVector2D[2];
	    double[] angles2D = new double[2];

	    vctrs2D[0] = crds2D[1].subtract(crds2D[0]);
	    vctrs2D[1] = crds2D[2].subtract(crds2D[0]);
	    angles2D[0] = vctrs2D[0].angleWith(vctrs2D[1]);
	    if (angles2D[0] > Math.PI)
		angles2D[0] = (Math.PI * 2) - angles2D[0];

	    vctrs2D[0] = crds2D[0].subtract(crds2D[1]);
	    vctrs2D[1] = crds2D[2].subtract(crds2D[1]);
	    angles2D[1] = vctrs2D[0].angleWith(vctrs2D[1]);
	    if (angles2D[1] > Math.PI)
		angles2D[1] = (Math.PI * 2) - angles2D[1];

	    return angles2D;
	}
    }

    /**
     * Op`̕ӂ\NXB
     * <p>
     * ̃NX̃CX^X́A
     * ŜƂĂ邩ۂtO killed
     * ێB
     * </p>
     */
    public class Edge extends JgclEmbeddedGraph.Edge {
	/**
	 * ŜƂĂ邩ۂtOB
	 */
	private boolean killed;

	/**
	 * ^ɃIuWFNg\zB
	 * <p>
	 * killed  false ƂB
	 * </p>
	 */
	protected Edge() {
	    // call superclass's constructor with parent
	    JgclSetOfTriangles3D.this.graph.super();
	    this.killed = false;
	}

	/**
	 * ̕ӂ̕ƂĐݒ肳Ăӂ̃tB[hɐlB
	 * <p>
	 * super.fillFieldsOfReplica() ĂяoɁA
	 * ̖ʂ killed ̒lA killed ɑB
	 * </p>
	 */
	protected void fillFieldsOfReplica() {
	    super.fillFieldsOfReplica();
	    Edge replica = (Edge)this.getReplica();
	    replica.killed = this.killed;
	}

	/**
	 * ̕ӂuŜƂ邩ۂvݒ肷B
	 *
	 * @param killed	ŜƂ邩ۂ
	 */
	void setKilled(boolean killed) {
	    this.killed = killed;
	}

	/**
	 * ̕ӂuŜƂĂ邩ۂvԂB
	 *
	 * @param killed	ŜƂĂ邩ۂ
	 */
	boolean isKilled() {
	    return this.killed;
	}

	/**
	 * ̕ӂ̗[̒_ԂB
	 * <p>
	 * ʂƂēz̗vf 2 łB
	 * </p>
	 *
	 * @return ӂ̗[̒_̔z
	 */
	public Vertex[] getVerticesOfStartEnd() {
	    JgclEmbeddedGraph.Vertex[] vertices = getVertices();
	    Vertex[] result = new Vertex[2];
	    for (int i = 0; i < 2; i++)
		result[i] = (Vertex)vertices[i];
	    return result;
	}

	/**
	 * ̕ӂ̗̎Op`ԂB
	 * <p>
	 * ʂƂēz̗vf 2 łB
	 * </p>
	 * <p>
	 * ̕ӂ̂ǂ瑤Op`ɖʂȂꍇɂ
	 * z̗vf̒lƂ null B
	 * </p>
	 *
	 * @return ӂ̗̎Op`̔z
	 */
	public Face[] getFacesOfLeftRight() {
	    JgclEmbeddedGraph.Face[] faces = getFaces();
	    Face[] result = new Face[2];
	    for (int i = 0; i < 2; i++) {
		if ((result[i] = (Face)faces[i]) == outerFace)
		    result[i] = null;
	    }
	    return result;
	}

	/**
	 * ̕ӂΊpƂʎlp`̑Ίpό`sB
	 * <p>
	 * ̕ӂΊpƂʎlp`̎̕Op`
	 * ̕ӂƂ͈قȂ̑ΊppɕύXB
	 * </p>
	 * <p>
	 * ʂƂēӂ́AVΊp\B
	 * ̕ӂɗɎOp`ȂꍇA
	 * ̕ӂΊpƂlp`ʂłȂꍇɂ
	 * Ίpό`łȂ̂ŁA null ԂB
	 * </p>
	 * <p>
	 * Ίpό`ɍsȂA̕ӂƂ͈قȂVӂԂꍇɂ́A
	 * ̃\bȟĂяoȍ~A̕ӂɃANZX邱Ƃ͂łȂB
	 * </p>
	 *
	 * @return	Vɐ
	 */
	public Edge flipDiagonal() {
	    Face[] faces = this.getFacesOfLeftRight();
	    Face leftFace  = faces[0];
	    Face rightFace = faces[1];

	    if ((leftFace == null) || (rightFace == null))
		return null;

	    double[] anglesInLF = leftFace.getAnglesOfStartEndIn2D(this);
	    double[] anglesInRF = leftFace.getAnglesOfStartEndIn2D(this);

	    if ((!((anglesInLF[0] + anglesInRF[0]) < Math.PI)) ||
		(!((anglesInLF[1] + anglesInRF[1]) < Math.PI)))
		return null;	// ʂłȂ

	    Vertex startV = leftFace.getFarVertex(this);
	    Vertex endV   = rightFace.getFarVertex(this);

	    JgclSetOfTriangles3D.this.graph.killEdgeFace(this, rightFace);

	    JgclEmbeddedGraph.Result resultMEF =
		JgclSetOfTriangles3D.this.graph.makeEdgeFace(leftFace,
							     startV, endV);
	    Edge newEdge = (Edge)resultMEF.edge;
	    newEdge.setKilled(this.isKilled());
	    newEdge.setUserData(this.getUserData());

	    Face newFace = (Face)resultMEF.face;
	    newFace.setKilled(rightFace.isKilled());
	    newFace.setUserData(rightFace.getUserData());

	    return newEdge;
	}
    }

    /**
     * Otł̐VȒ_^Ӂ^ʂ̐ɁA
     * ̃NX̊YNX̃CX^X\zĕԂIuWFNg
     * 𐶐B
     *
     * @return	Otł̐VȒ_^Ӂ^ʂ̐SIuWFNg
     */
    private JgclEmbeddedGraph.GraphItemMaker makeGraphItemMaker() {
	return new JgclEmbeddedGraph.GraphItemMaker() {
	    JgclSetOfTriangles3D parent = JgclSetOfTriangles3D.this;
	    // g̓NXg
	    public JgclEmbeddedGraph.Vertex newVertex() { return parent.new Vertex(); }
	    public JgclEmbeddedGraph.Face   newFace()   { return parent.new Face(); }
	    public JgclEmbeddedGraph.Edge   newEdge()   { return parent.new Edge(); }
	};
    }

    /**
     * ^ɃIuWFNg\z邱Ƃ͂łȂB
     */
    private JgclSetOfTriangles3D() {
	super();
    }

    /**
     * iq̓_Ԃ^A
     * 𒸓_ƂOp`̏WƂăIuWFNg\zB
     * <p>
     * mesh ̈ꎟځ^񎟌ڂ̂ꂩ̗vf 2 菬ꍇɂ
     * JgclInvalidArgumentValue ̗OԂB
     * </p>
     *
     * @param mesh	iq̓_
     * @see	JgclInvalidArgumentValue
     */
    public JgclSetOfTriangles3D(JgclMesh3D mesh)
    {
	super();

	int columnSize = mesh.uNPoints();
	int rowSize = mesh.vNPoints();

	if (rowSize < 2) {
	    throw new JgclInvalidArgumentValue("Row size of mesh is less than 2.");
	}

	if (columnSize < 2) {
	    throw new JgclInvalidArgumentValue("Column size of mesh is less than 2.");
	}

	this.graph = new JgclEmbeddedGraph(makeGraphItemMaker());

	JgclEmbeddedGraph.Vertex vertices[][] = new JgclEmbeddedGraph.Vertex[columnSize][rowSize];

	JgclEmbeddedGraph.Result firstVF = graph.makeVertexFace();
	this.outerFace = (Face)firstVF.face;
	vertices[0][0] = firstVF.vrtx;
	((Vertex)vertices[0][0]).setCoordinates(mesh.pointAt(0, 0));

	// debug
	// System.out.println(outerFace);

	try {
	    for (int c = 1, c_ = 0; c < columnSize; c++, c_++) {
		vertices[c][0] = graph.makeEdgeVertex(outerFace, vertices[c_][0]).vrtx;
		((Vertex)vertices[c][0]).setCoordinates(mesh.pointAt(c, 0));
	    }

	    for (int r = 1, r_ = 0; r < rowSize; r++, r_++) {
		for (int c = 0, c_ = (- 1); c < columnSize; c++, c_++) {
		    vertices[c][r] = graph.makeEdgeVertex(outerFace, vertices[c][r_]).vrtx;
		    ((Vertex)vertices[c][r]).setCoordinates(mesh.pointAt(c, r));

		    if (c > 0) {
			Face rectangle =
			    (Face)graph.makeEdgeFace(outerFace, vertices[c_][r], vertices[c][r]).face;
			graph.makeEdgeFace(rectangle, vertices[c_][r_], vertices[c][r]);
		    }
		}
	    }
	}
	catch (JgclInvalidArgumentValue e) {
	}
    }

    /**
     * Ȗʏ̃_ȓ_Q^A
     * 𒸓_ƂOp`̏WƂăIuWFNg\zB
     *
     * @param pointsOnSurface	Ȗʏ̃_ȓ_Q
     */
    public JgclSetOfTriangles3D(Enumeration pointsOnSurface)
    {
	super();
	createDulaunay(pointsOnSurface, 1,
		       neverBeAccessedArg,
		       neverBeAccessedArg,
		       neverBeAccessedArg);
    }

    /**
     * Ȗʏ̃_ȓ_Q^A
     * 𒸓_ƂOp`̏WƂăIuWFNg\zB
     *
     * @param pointsOnSurface	Ȗʏ̃_ȓ_Q
     * @param xScale	Op`̏W쐬ۂ̂QWl X ̏kڔ{
     * @param yScale	Op`̏W쐬ۂ̂QWl Y ̏kڔ{
     */
    public JgclSetOfTriangles3D(Enumeration pointsOnSurface,
				double xScale,
				double yScale)
    {
	super();
	createDulaunay(pointsOnSurface, 2,
		       xScale,
		       yScale,
		       neverBeAccessedArg);

    }

    /**
     * Ȗʏ̃_ȓ_Q^A
     * 𒸓_ƂOp`̏WƂăIuWFNg\zB
     *
     * @param pointsOnSurface	Ȗʏ̃_ȓ_Q
     * @param xScale	Op`̏W쐬錳ƂȂ Voronoi }쐬ۂ̂QWl X ̏kڔ{
     * @param yScale	Op`̏W쐬錳ƂȂ Voronoi }쐬ۂ̂QWl Y ̏kڔ{
     * @param radiusScale	Op`̏W쐬錳ƂȂ Voronoi }͂މ~̔ȃ傫K肷{
     */
    public JgclSetOfTriangles3D(Enumeration pointsOnSurface,
				double xScale,
				double yScale,
				double radiusScale)
    {
	super();
	createDulaunay(pointsOnSurface, 3,
		       xScale,
		       yScale,
		       radiusScale);
    }

    /**
     * ANZX邱Ƃ̂ȂB
     */
    private static final double neverBeAccessedArg = Double.NaN;

    /**
     * Ȗʏ̃_ȓ_Q^A
     * 𒸓_ƂOp`̏W쐬B
     *
     * @param pointsOnSurface	Ȗʏ̃_ȓ_Q
     * @param constractorTypeOfVoronoi	Op`̏W쐬錳ƂȂ Voronoi }쐬ۂ̃RXgN^̃^Cv
     * @param xScale	Op`̏W쐬錳ƂȂ Voronoi }쐬ۂ̂QWl X ̏kڔ{
     * @param yScale	Op`̏W쐬錳ƂȂ Voronoi }쐬ۂ̂QWl Y ̏kڔ{
     * @param radiusScale	Op`̏W쐬錳ƂȂ Voronoi }͂މ~̔ȃ傫K肷{
     */
    private void createDulaunay(final Enumeration pointsOnSurface,
				int constractorTypeOfVoronoi,
				double xScale,
				double yScale,
				double radiusScale)
    {
	final Vector points3D = new Vector();	// 3D Point ̃Xg

	Enumeration points2D = new Enumeration() {
	    public boolean hasMoreElements() {
		return pointsOnSurface.hasMoreElements();
	    }

	    public java.lang.Object nextElement() {
		JgclPointOnSurface3D pos =
		    (JgclPointOnSurface3D)pointsOnSurface.nextElement();
		points3D.addElement(pos);
		return new JgclCartesianPoint2D(pos.parameters());
	    }
	};					// 2D Point ̗

	/*
	 * Voronoi }
	 */
	JgclVoronoiDiagram2D voronoi;

	switch (constractorTypeOfVoronoi) {
	case 1:
	    voronoi = new JgclVoronoiDiagram2D(new JgclEmbeddedGraph(), points2D);
	    break;

	case 2:
	    voronoi = new JgclVoronoiDiagram2D(new JgclEmbeddedGraph(), points2D,
					       xScale, yScale);
	    break;

	case 3:
	    voronoi = new JgclVoronoiDiagram2D(new JgclEmbeddedGraph(), points2D,
					       xScale, yScale, radiusScale);
	    break;

	default:
	    throw new JgclInvalidArgumentValue("constructor type of Voronoi diagram is wrong.");
	}

	/*
	// Debug
	int i = 0;
	for (Enumeration e = voronoi.getGraph().edgeElements();
	     e.hasMoreElements();) {
	    JgclEmbeddedGraph.Edge edge = (JgclEmbeddedGraph.Edge)e.nextElement();
	    JgclEmbeddedGraph.Face[] faces = edge.getFaces();
	    if (faces[0] == faces[1])
		System.out.println("error");

	    JgclEmbeddedGraph.Vertex[] vrtcs = edge.getVertices();
	    JgclVoronoiDiagram2D.VPoint vpnt0 =
		(JgclVoronoiDiagram2D.VPoint)vrtcs[0].getUserData();
	    JgclVoronoiDiagram2D.VPoint vpnt1 =
		(JgclVoronoiDiagram2D.VPoint)vrtcs[1].getUserData();
	    JgclPoint2D crd0 = vpnt0.getCoordinates();
	    JgclPoint2D crd1 = vpnt1.getCoordinates();

	    if (crd0.identical(crd1) != true) {
		System.out.println("JgclLine2D	lin" + i);
		System.out.println("\tpnt\t" + crd0.x() + " " + crd0.y());
		System.out.println("\tpnt\t" + crd1.x() + " " + crd1.y());
		System.out.println("End");
	    }
	    i++;
	}
	// Debug
	*/

	/*
	 * Dulaunay }ɕϊ
	 */
	this.graph = new JgclEmbeddedGraph(makeGraphItemMaker());

	JgclDulaunayDiagram2D dulaunay =
	    new JgclDulaunayDiagram2D(this.graph, voronoi);

	/*
	 * Vertex ɏ
	 */
	for (Enumeration e = this.graph.vertexElements();
	     e.hasMoreElements();) {
	    Vertex vrtx = (Vertex)e.nextElement();
	    JgclDulaunayDiagram2D.DVertex dvrtx = 
		(JgclDulaunayDiagram2D.DVertex)vrtx.getUserData();
	    vrtx.setCoordinates((JgclPointOnSurface3D)points3D.elementAt(dvrtx.getIndex()));
	}

	/*
	 * outerFace 
	 */
	this.outerFace = null;

	for (Enumeration e = this.graph.faceElements();
	     e.hasMoreElements();) {
	    Face face = (Face)e.nextElement();
	    if (face.getUserData() == null) {
		this.outerFace = face;
		break;
	    }
	}

	/*
	// Debug
	int i = 0;
	for (Enumeration e = this.graph.edgeElements();
	     e.hasMoreElements();) {
	    Edge edge = (Edge)e.nextElement();
	    Vertex[] vrtcs = edge.getVerticesOfStartEnd();
	    JgclDulaunayDiagram2D.DVertex dvrtx0 =
		(JgclDulaunayDiagram2D.DVertex)vrtcs[0].getUserData();
	    JgclDulaunayDiagram2D.DVertex dvrtx1 =
		(JgclDulaunayDiagram2D.DVertex)vrtcs[1].getUserData();
	    JgclPoint2D crd0 = dvrtx0.getCoordinates();
	    JgclPoint2D crd1 = dvrtx1.getCoordinates();

	    System.out.println("JgclLine2D	lin" + i);
	    System.out.println("\tpnt\t" + crd0.x() + " " + crd0.y());
	    System.out.println("\tpnt\t" + crd1.x() + " " + crd1.y());
	    System.out.println("End");
	    i++;
	}
	// Debug
	*/

	/*
	 * this.graph  Dulaunay }̏폜
	 */
	dulaunay.stripGeometries();
    }

    /**
     * ̎Op`̏W܂ގOp` Enumeration ԂB
     *
     * @return  Op` Enumeration
     */
    public Enumeration faceElements() {
	return new Enumeration() {
	    Enumeration e = graph.faceElements();
	    Object nextNonOuterFace = null;

	    public boolean hasMoreElements() {
		if (nextNonOuterFace != null)
		    return true;

		if (e.hasMoreElements() == false)
		    return false;

		Object obj = e.nextElement();
		if ((Face)obj != outerFace) {
		    nextNonOuterFace = obj;
		    return true;
		} else {
		    nextNonOuterFace = null;
		    return e.hasMoreElements();
		}
	    }

	    public java.lang.Object nextElement() {
		Object obj;

		if (nextNonOuterFace != null) {
		    obj = nextNonOuterFace;
		    nextNonOuterFace = null;
		    return obj;
		}

		obj = e.nextElement();
		if ((Face)obj != outerFace)
		    return obj;
		else
		    return e.nextElement();
	    }
	};
    }

    /**
     * ̎Op`̏W܂ޒ_ Enumeration ԂB
     *
     * @return  _ Enumeration
     */
    public Enumeration vertexElements() {
	return graph.vertexElements();
    }

    /**
     * ̎Op`̏W܂ޕӂ Enumeration ԂB
     *
     * @return  ӂ Enumeration
     */
    public Enumeration edgeElements() {
	return graph.edgeElements();
    }

    /**
     * ̎Op`̏W܂ޒ_̐ԂB
     *
     * @return  _̐
     */
    public int getNumberOfVertices() {
	return graph.getNumberOfVertices();
    }

    /**
     * ̎Op`̏W܂ގOp`̐ԂB
     *
     * @return  Op`̐
     */
    public int getNumberOfFaces() {
	return graph.getNumberOfFaces() - 1;
    }

    /**
     * ̎Op`̏W܂ޕӂ̐ԂB
     *
     * @return  ӂ̐
     */
    public int getNumberOfEdges() {
	return graph.getNumberOfEdges();
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	 true
     */
    public boolean isFreeform() {
	return true;
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

	throw new JgclNotSupported();	// output
    }

    // Main Programs for Debugging
    /**
     * fobOpCvOB
     */
    public static void main(String[] args) {
	JgclPlane3D surface = new JgclPlane3D(new JgclCartesianPoint3D(0.0, 0.0, 0.0),
					      new JgclLiteralVector3D(0.0, 0.0, 1.0));
	Vector pointsOnSurface = new Vector();

	for (int u = 0; u < 5; u++)
	    for (int v = 0; v < 5; v++)
		if (v != u)
		    pointsOnSurface.addElement(new JgclPointOnSurface3D(surface,
									(u * 1.0),
									(v * 1.0),
									doCheckDebug));

	JgclSetOfTriangles3D stri =
	    new JgclSetOfTriangles3D(pointsOnSurface.elements());

	int i = 0;
	for (Enumeration e = stri.edgeElements(); e.hasMoreElements();) {
	    JgclSetOfTriangles3D.Edge edge =
		(JgclSetOfTriangles3D.Edge)e.nextElement();
	    JgclSetOfTriangles3D.Vertex[] vrtcs = edge.getVerticesOfStartEnd();
	    JgclPoint3D pnt0 = vrtcs[0].getCoordinates();
	    JgclPoint3D pnt1 = vrtcs[1].getCoordinates();

	    System.out.println("JgclLine3D	lin" + i);
	    System.out.println("\tpnt\t" + pnt0.x() + " " + pnt0.y() + " " + pnt0.z());
	    System.out.println("\tpnt\t" + pnt1.x() + " " + pnt1.y() + " " + pnt1.z());
	    System.out.println("End");
	    i++;
	}
    }
}

/* end of file */
