/*
 * R : ʂ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclSphericalSurface3D.java,v 1.57 2000/08/11 06:19:02 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : ʂ\NXB
 * <p>
 * ʂ́A̒S̈ʒuƋǏ X/Y/Z ̕ǏWn
 * (zuA{@link JgclAxis2Placement3D JgclAxis2Placement3D}) position 
 * a radius Œ`B
 * </p>
 * <p>
 * ʂ
 * U ̃p[^`͗LŎIłA
 * ̃vC}ȗLԂ [0, (2 * )] łB
 * V ̃p[^`͗LŔIłA
 * ̗LԂ [(-  / 2), ( / 2)] łB
 * </p>
 * <p>
 * (u, v) p[^Ƃ鋅 P(u, v) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(u, v) = c + radius * (cos(v) * (cos(u) * x + sin(u) * y) + sin(v) * z)
 * </pre>
 * ŁAc, x, y, z ͂ꂼ
 * <pre>
 *	c : position.location()
 *	x : position.x()
 *	y : position.y()
 *	z : position.z()
 * </pre>
 * \B
 * </p>
 *
 * @version $Revision: 1.57 $, $Date: 2000/08/11 06:19:02 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclSphericalSurface3D extends JgclElementarySurface3D {
    /**
     * aB
     * @serial
     */
    private double radius;

    /**
     * aݒ肷B
     * <p>
     * radius ̒lA
     * ݐݒ肳Ă鉉Z̋̋e덷ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     *
     * @param radius	a
     * @see	JgclInvalidArgumentValue
     */
    private void setRadius(double radius)
    {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol = condition.getToleranceForDistance();

	if (radius < dTol) {
	    throw new JgclInvalidArgumentValue();
	}
	this.radius = radius;
    }

    /**
     * ǏWnƔa^ăIuWFNg\zB
     * <p>
     * position  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * radius ̒lA
     * ݐݒ肳Ă鉉Z̋̋e덷ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * 
     * @param position	SƋǏ X/Y/Z ̕ǏWn
     * @param radius	a
     * @see	JgclInvalidArgumentValue
     */
    public JgclSphericalSurface3D(JgclAxis2Placement3D position,
				  double radius)
    {
	super(position);
	setRadius(radius);
    }

    /**
     * SƔa^ăIuWFNg\zB
     * <p>
     * \z~̋Ǐ X/Y/Z ́̕AWn X/Y/Z ̕ƂB
     * </p>
     * <p>
     * cntr  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * radius ̒lA
     * ݐݒ肳Ă鉉Z̋̋e덷ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * 
     * @param center	S
     * @param radius	a
     * @see	JgclInvalidArgumentValue
     */
    public JgclSphericalSurface3D(JgclPoint3D cntr, double radius)
    {
	this(new JgclAxis2Placement3D(cntr,
				      JgclVector3D.zUnitVector,
				      JgclVector3D.xUnitVector),
	     radius);
    }

    /**
     * ̋ʂ̔aԂB
     * 
     * @return	a
     */
    public double radius() {
	return this.radius;
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^lA̋Ȗʂ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uParam	U p[^l
     * @param vParam	V p[^l
     * @return		Wl
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint3D coordinates(double uParam, double vParam) {
	checkVValidity(vParam);
	JgclCartesianTransformationOperator3D gtrans = toGlobal();
	double x = radius * Math.cos(uParam) * Math.cos(vParam);
	double y = radius * Math.sin(uParam) * Math.cos(vParam);
	double z = radius * Math.sin(vParam);
	JgclPoint3D pnt = new JgclCartesianPoint3D(x, y, z);

	return gtrans.transform(pnt);
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ł̐ڃxNgƂ́Ap[^ U/V ̊eXɂĂ̈ꎟΓ֐łB
     * </p>
     * <p>
     * ʂƂĕԂz̗vf 2 łB
     * z̍ŏ̗vfɂ U p[^ɂĂ̐ڃxNgA
     * Ԗڂ̗vfɂ V p[^ɂĂ̐ڃxNg܂ށB
     * </p>
     * <p>
     * ^ꂽp[^lA̋Ȗʂ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param uParam	U p[^l
     * @param vParam	V p[^l
     * @return		ڃxNg̔z
     * @see	JgclParameterOutOfRange
     */
    public JgclVector3D[] tangentVector(double uParam, double vParam) {
	checkVValidity(vParam);
	JgclCartesianTransformationOperator3D gtrans = toGlobal();
	double dux = -radius * Math.sin(uParam) * Math.cos(vParam);
	double duy = radius * Math.cos(uParam) * Math.cos(vParam);
	double dvx = -radius * Math.cos(uParam) * Math.sin(vParam);
	double dvy = -radius * Math.sin(uParam) * Math.sin(vParam);
	double dvz = radius * Math.cos(vParam);

	JgclVector3D dup = new JgclLiteralVector3D(dux, duy, 0.0);
	JgclVector3D dvp = new JgclLiteralVector3D(dvx, dvy, dvz);

	JgclVector3D[] tang = {gtrans.transform(dup), gtrans.transform(dvp)};
	return tang;
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̖@xNgԂB
     * <p>
     * ̃\bhԂ@xNǵAKꂽPʃxNgłB 
     * </p>
     * <p>
     * ^ꂽp[^lA̋Ȗʂ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		Kꂽ@xNg
     * @see	JgclParameterOutOfRange
     */
    public JgclVector3D normalVector(double uParam, double vParam)
    {
	checkVValidity(vParam);
	JgclPoint3D pnt = coordinates(uParam, vParam);

	return pnt.subtract(position().location()).unitized();
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̎ȗԂB
     * <p>
     * ̎ȗ (principalCurvature1, principalCurvature2) ̒l͂ǂ (- 1 / radius) łB
     * xNg1 (principalDirection1) ɂ U p[^ɂĂ̐ڃxNg̒PʃxNgA
     * xNg2 (principalDirection2) ɂ V p[^ɂĂ̐ڃxNg̒PʃxNg
     * ԂB
     * </p>
     * <p>
     * ^ꂽp[^lA̋Ȗʂ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		ȗ
     * @see	JgclParameterOutOfRange
     */
    public JgclSurfaceCurvature3D curvature(double uParam, double vParam) {
	checkVValidity(vParam);
	JgclVector3D[] tangent = tangentVector(uParam, vParam);

	return new JgclSurfaceCurvature3D(-1.0/radius, tangent[0].unitized(),
					  -1.0/radius, tangent[1].unitized());
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̕Γ֐ԂB
     * <p>
     * ^ꂽp[^lA̋Ȗʂ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		Γ֐
     * @see	JgclParameterOutOfRange
     */
    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam) {
	checkVValidity(vParam);
	JgclCartesianTransformationOperator3D gtrans = toGlobal();
	double x = radius * Math.cos(uParam) * Math.cos(vParam);
	double y = radius * Math.sin(uParam) * Math.cos(vParam);
	double z = radius * Math.sin(vParam);
	// dux =  -radius * sin(u) * cos(v) = -y
	// duy =   radius * cos(u) * cos(v) = x
	// duux = -radius * cos(u) * cos(v) = -x
	// duuy = -radius * sin(u) * cos(v) = -y
	double dvx = -radius * Math.cos(uParam) * Math.sin(vParam);
	double dvy = -radius * Math.sin(uParam) * Math.sin(vParam);
	double dvz = radius * Math.cos(vParam);
	// dvvx = -radius * cos(u) * cos(v) = -x
	// dvvy = -radius * sin(u) * cos(v) = -y
	// dvvz = -radius * sin(v) = -z
	// duvx =  radius * sin(u) * sin(v) = -dvy
	// duvy = -radius * cos(u) * sin(v) = dvx

	JgclPoint3D pnt = new JgclCartesianPoint3D(x, y, z);
	JgclVector3D dup = new JgclLiteralVector3D(-y, x, 0.0);
	JgclVector3D dvp = new JgclLiteralVector3D(dvx, dvy, dvz);
	JgclVector3D duup = new JgclLiteralVector3D(-x, -y, 0.0);
	JgclVector3D duvp = new JgclLiteralVector3D(-dvy, dvx, 0.0);
	JgclVector3D dvvp = new JgclLiteralVector3D(-x, -y, -z);

	return new JgclSurfaceDerivative3D(gtrans.transform(pnt),
					   gtrans.transform(dup),
					   gtrans.transform(dvp),
					   gtrans.transform(duup),
					   gtrans.transform(duvp),
					   gtrans.transform(dvvp));
    }

    /**
     * ^ꂽ_炱̋Ȗʂւ̓e_߂B
     * <p>
     * ^ꂽ_̋ʂ̒SɈvȂA
     * ɓ̓e_ԂB
     * </p>
     * <p>
     * ^ꂽ_Ƃ̋ʂ̒SƂ̋A
     * ݐݒ肳Ă鉉Z̋̋e덷
     * ꍇɂ́A
     * p[^l (0, 0) ̓_ suitable Ƃ
     * JgclIndefiniteSolution ̗O𓊂B
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     * @exception	JgclIndefiniteSolution	s (e̓_ʂ̒SɈv)
     */
    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point)
	throws JgclIndefiniteSolution
    {
	JgclCartesianTransformationOperator3D gtrans = toGlobal();
	JgclPoint3D lpoint = gtrans.reverseTransform(point);

	// direction vector from center to point
	JgclVector3D eduvec = lpoint.toVector3D();

	// check length & unitize
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol = Math.abs(condition.getToleranceForDistance());
	double aTol = condition.getToleranceForAngle();

	if (eduvec.length() < dTol) {
	    // any point
	    JgclPointOnSurface3D p;

	    try {
		p = new JgclPointOnSurface3D(this, 0, 0, doCheckDebug);
	    }
	    catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }

 	    throw new JgclIndefiniteSolution(p);
	}

	eduvec = eduvec.unitized();
	// eduvec = (cos(u)*cos(v), sin(u)*cos(v), sin(v))

	double sin_v = eduvec.z();
	double v = Math.asin(sin_v);
	JgclPointOnSurface3D foot1, foot2;

	if (v < -Math.PI + aTol || Math.PI - aTol < v) {
	    // north pole or south pole
	    foot1 = new JgclPointOnSurface3D(this, 0, v, doCheckDebug);
	    foot2 = new JgclPointOnSurface3D(this, 0, -v, doCheckDebug);
	}
	else {
	    double u = Math.atan2(eduvec.y(), eduvec.x());
	    if (u < 0)
		u += 2*Math.PI;

	    foot1 = new JgclPointOnSurface3D(this, u, v, doCheckDebug);
	    u += Math.PI;
	    if (u >= 2*Math.PI)
		u -= 2*Math.PI;
	    foot2 = new JgclPointOnSurface3D(this, u, -v, doCheckDebug);
	}

 	JgclPointOnSurface3D[] proj = { foot1, foot2 };

	return proj;
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽ덷ŕʋߎiq_QԂB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * ^ꂽp[^ԂȖʂ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param tol	̋e덷
     * @return	̋Ȗʂ̎w̋Ԃ𕽖ʋߎiq_Q
     * @see	JgclPointOnSurface3D
     * @see	JgclParameterOutOfRange
     */
    public JgclMesh3D
	toMesh(JgclParameterSection uPint, JgclParameterSection vPint,
	       JgclToleranceForDistance tol)
    {
	JgclPointOnSurface3D[][] mesh;
	double vStart = vPint.start();
	double vEnd = vPint.end();
	double uParam, uDelta;
	double vParam, vDelta;
	double rad;
	int u_npnts, v_npnts;
	int i, j;

	rad = maxRadius(vPint);	// Ṽp[^Ԃ̒ōł傫Ȕa

	/*
	 * ꂼ̕ŁAKvȕ_𓾂B
	 */
	u_npnts = JgclCircle2D.toPolylineNDivision(rad, uPint.increase(), tol) + 1;
	v_npnts = JgclCircle2D.toPolylineNDivision(radius(), vPint.increase(), tol) + 1;

	/*
	 * ꂼ̕ u_npnts, v_npnts p[^Ċiq_\B
	 * (~ʂ̃|Cߎ̓p[^ƂȂ͂ł)
	 */
	mesh = new JgclPointOnSurface3D[u_npnts][v_npnts];

	uDelta = uPint.increase() / (u_npnts - 1);
	vDelta = vPint.increase() / (v_npnts - 1);

	uParam = uPint.start();
	for (i = 0; i < u_npnts; i++) {
	    vParam = vStart;
	    for (j = 0; j < v_npnts; j++) {
		try {
		    mesh[i][j] = new JgclPointOnSurface3D(this, uParam, vParam, doCheckDebug);
		} catch (JgclInvalidArgumentValue e) {
		    throw new JgclFatal();
		}
		if (j == (v_npnts - 2))
		    vParam = vEnd;
		else
		    vParam += vDelta;
	    }
	    if (i == (u_npnts - 2))
		uParam = uPint.end();
	    else
		uParam += uDelta;
	}

	return new JgclMesh3D(mesh, false);
    }

    /**
     * ̋ʂ́A^ꂽ V ̃p[^Ԃ̒ł̍ł傫ȔaԂB
     * <p>
     * ^ꂽp[^ԂȖʂ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param vPint	V ̃p[^
     * @return		ő唼a
     * @see	JgclParameterOutOfRange
     */
    private double maxRadius(JgclParameterSection vPint)
    {
	double vLow, vUpp, rad;

	checkVValidity(vLow = vPint.lower());
	checkVValidity(vUpp = vPint.upper());
	if (vLow <= 0.0 && vUpp >= 0.0)
	    rad = radius();
	else if (Math.abs(vLow) < Math.abs(vUpp))
	    rad = radius() * Math.cos(vLow);
	else
	    rad = radius() * Math.cos(vUpp);

	return rad;
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂɍČL Bspline ȖʂԂB
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @return		̋Ȗʂ̎w̋ԂČL Bspline Ȗ
     */
    public JgclBsplineSurface3D
	toBsplineSurface(JgclParameterSection uPint,
			 JgclParameterSection vPint)
    {
	JgclCircle2D circle2D =
	    new JgclCircle2D(JgclAxis2Placement2D.origin, this.radius());

	JgclBsplineCurve2D uBsplineCurve2D = circle2D.toBsplineCurve(uPint);
	int uDegree = uBsplineCurve2D.degree();
	boolean uPeriodic = uBsplineCurve2D.isPeriodic();
	int uNPoints = uBsplineCurve2D.nControlPoints();

	// vBsplineCurve2D : x -> x, y -> z
	JgclBsplineCurve2D vBsplineCurve2D = circle2D.toBsplineCurve(vPint);
	int vDegree = vBsplineCurve2D.degree();
	boolean vPeriodic = vBsplineCurve2D.isPeriodic();
	int vNPoints = vBsplineCurve2D.nControlPoints();

	JgclPoint3D[][] controlPoints = new JgclPoint3D[uNPoints][vNPoints];
	double[][] weights = new double[uNPoints][vNPoints];

	JgclCartesianTransformationOperator3D localTransformationOperator =
	    this.position().toCartesianTransformationOperator(1.0);

	for (int vi = 0; vi < vNPoints; vi++) {
	    JgclPoint2D vPoint = vBsplineCurve2D.controlPointAt(vi);
	    double scale = vPoint.x() / this.radius();
	    for (int ui = 0; ui < uNPoints; ui++) {
		JgclPoint2D uPoint = uBsplineCurve2D.controlPointAt(ui);
		JgclPoint3D localPoint =
		    JgclPoint3D.of(scale * uPoint.x(),
				   scale * uPoint.y(),
				   vPoint.y());
		controlPoints[ui][vi] = localTransformationOperator.toEnclosed(localPoint);
		weights[ui][vi] = vBsplineCurve2D.weightAt(vi) * uBsplineCurve2D.weightAt(ui);
	    }
	}

	return new JgclBsplineSurface3D(uBsplineCurve2D.knotData(),
					vBsplineCurve2D.knotData(),
					controlPoints, weights);
    }

    /**
     * ^ꂽ_̋Ȗʏɂ邩ۂ`FbNB
     * 
     * @param point	ΏۂƂȂ_
     * @return		^ꂽ_̋Ȗʏɂ trueAłȂ false
     */
    boolean checkSolution(JgclPoint3D point) {
 	double dTol = getToleranceForDistance();
 	return Math.abs(point.distance(point.origin) - this.radius()) < dTol;
    }

    /**
     * ̏Ȗʂ (\ꂽ) RȐ̌_\㐔𐶐B
     * 
     * @param poly	xWGȐ邢͂aXvCȐ̂ZOg̑\̔z
     * @return		̏Ȗʂ poly ̌_\㐔̍
     */
    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
 	JgclRealPolynomial xPoly = poly[0].multiply(poly[0]);
 	JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
 	JgclRealPolynomial zPoly = poly[2].multiply(poly[2]);
 	double radius2 = this.radius() * this.radius();
 	boolean isPoly = poly.length < 4;
 	int degree = xPoly.degree();
 	double[] coef = new double[degree + 1];
 	if (isPoly) {
 	    for (int j = 0; j <= degree; j++) {
 		coef[j] = xPoly.coefficientAt(j) +
 			  yPoly.coefficientAt(j) +
 			  zPoly.coefficientAt(j);
 	    }
 	    coef[0] -= radius2;
 	} else {
 	    JgclRealPolynomial wPoly = poly[3].multiply(poly[3]);
 	    for (int j = 0; j <= degree; j++) {
 		coef[j] = xPoly.coefficientAt(j) +
 			  yPoly.coefficientAt(j) +
 			  zPoly.coefficientAt(j) -
 			  (radius2 * wPoly.coefficientAt(j));
 	    }
 	}
 	return new JgclRealPolynomial(coef);
    }

    /**
     * ̋ȖʂƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate)
	throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̋ȖʂƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋ʂ̒S^ꂽւ̋ DAʂ̔a R Ƃ
     * <ul>
     * <li> |D - R| ̋e덷΁A_ԂB
     * <li> D  R ΁A_ԂB
     * <li> D  R 傫΁A_͂ȂB
     * </ul>
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
	JgclPoint3D[] int_pnt;         // intersection point 
	double dTol = getToleranceForDistance();
		
	// project sphere's center to line 
	JgclPoint3D center = position().location();
	JgclPointOnCurve3D pA = mate.project1From(center);

	// distance between sphere'center & projected point
	double distance = pA.distance(center);
	
	// intersect line & sphere ? 
	if(Math.abs(radius() - distance) < dTol){
	    int_pnt = new JgclPoint3D[1];
	    int_pnt[0] = pA;
	}
	else if(radius() > distance){
	    int_pnt = new JgclPoint3D[2];
	    JgclVector3D unitVector = 
		mate.dir().unitized();       // line's unit vector 
	    JgclPoint3D line_pnt = mate.pnt();
	    
	    double offset =
		Math.sqrt(radius()*radius() - distance*distance);
	    
	    JgclVector3D dir_vec = unitVector.multiply(offset);
	    	   
	    int_pnt[0] = pA.add(dir_vec);
	    int_pnt[1] = pA.subtract(dir_vec);
	}else{
	    int_pnt = new JgclPoint3D[0];
	}

	JgclIntersectionPoint3D[] return_pnt = new JgclIntersectionPoint3D[int_pnt.length];

	for(int i=0;i<int_pnt.length;i++){

	    double dU,dV,dT;

	    // calculate parameter dT
	    JgclVector3D pnt_to_int = int_pnt[i].subtract(mate.pnt());
	    dT = pnt_to_int.length()/mate.dir().length();
	    if(pnt_to_int.dotProduct(mate.dir()) < 0.0)
		dT *= -1;
	    
	    // transform intersection point to sphere's local coordinates
	    JgclCartesianTransformationOperator3D trans =
		new JgclCartesianTransformationOperator3D(position(),1.0);
	    JgclPoint3D transformed_int_pnt = trans.reverseTransform(int_pnt[i]);
	    
	    // calculate parameter dV
	    JgclVector3D center_to_int = transformed_int_pnt.toVector3D();

	    JgclVector3D unit_center_to_int = center_to_int.unitized();

	    dV = Math.asin(unit_center_to_int.z());

	    // calculate parameter dU
	    JgclVector2D dir2D = center_to_int.to2D();
	    JgclVector2D center_to_int_2D = dir2D.unitized();
	    dU = Math.acos(center_to_int_2D.x());
	    if(center_to_int_2D.y() < 0.0)
		dU = 2*Math.PI - dU;
	    	    	    
	    // point on line 
	    JgclPointOnCurve3D PonC = new JgclPointOnCurve3D(int_pnt[i],mate,dT,doCheckDebug);
	    
	    // point on surface
	    JgclPointOnSurface3D PonS = 
		new JgclPointOnSurface3D(int_pnt[i],this,dU,dV,doCheckDebug);
	    
	    // intersection point
	    if(doExchange)
		return_pnt[i] = new JgclIntersectionPoint3D(int_pnt[i],PonC,PonS,doCheckDebug);
	    else
		return_pnt[i] = new JgclIntersectionPoint3D(int_pnt[i],PonS,PonC,doCheckDebug);
	}
	    
	return return_pnt;
    }

    /**
     * ̋ȖʂƑ̋Ȗʂ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȖʂӏɂẮA (JgclIntersectionCurve3D) ԂB
     * </p>
     * <p>
     * ȖʂڂӏɂẮA_ (JgclIntersectionPoint3D) Ԃ邱ƂB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return		 (܂͌_) ̔z
     * @exception	JgclIndefiniteSolution	mate ʂŁA҂I[o[bvĂAsł
     * @see		JgclIntersectionCurve3D
     * @see		JgclIntersectionPoint3D
     */
    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate)
	 throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̋ȖʂƑ̋Ȗ () ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ʂ̃NX́u vs. ʁv̌\bh
     * {@link JgclPlane3D#intersect(JgclSphericalSurface3D, boolean)
     * JgclPlane3D.intersect(JgclSphericalSurface3D, boolean)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ () ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * 񋅖ʂ̒SԂ̋Ɠ񋅖ʂ̔a̍A
     * ƂɌݐݒ肳Ă鉉Z̋̋e덷菬ꍇɂ́A
     * 񋅖ʂ̓I[o[bvĂ̂ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     * <p>
     * []
     * <br>
     * 񋅖ʂ̒SԂ̋Ɠ񋅖ʂ̔a̘a邢͍ɂāA
     * ̐ŏꍇŁA􉽓IɉĂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     * @exception	JgclIndefiniteSolution	҂I[o[bvĂAsł
     * @see	JgclElementarySurface3D#curveToIntersectionCurve(JgclParametricCurve3D, JgclElementarySurface3D, boolean)
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate, boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	double d_tol = getToleranceForDistance();
	JgclVector3D vector2 = position().location().subtract(mate.position().location());
	double dist = vector2.length();
	if (dist < d_tol) {
	    if (Math.abs(radius() - mate.radius()) < d_tol) {
		/*
		 * 2 spheres are coincident
		 */
		JgclCircle3D res = new JgclCircle3D(position(), (radius() + mate.radius()) / 2.0);
		JgclIntersectionCurve3D ints = curveToIntersectionCurve(res, mate, doExchange);
		throw new JgclIndefiniteSolution(ints);
	    }
	    /*
	     * no intersection
	     */
	    return new JgclSurfaceSurfaceInterference3D[0];
	}

	double Ar = radius();
	double Br = mate.radius();
	JgclVector3D vector = vector2.divide(dist);
	if ((Math.abs(dist - (Ar + Br)) < d_tol) ||
	    (Math.abs(dist - (Ar - Br)) < d_tol) ||
	    (Math.abs(dist - (Br - Ar)) < d_tol)) {
	    /*
	     * intersection is a point
	     */
	    JgclPoint3D Aint, Bint;
	    if (Math.abs(dist - (Ar + Br)) < d_tol) {
		Aint = position().location().subtract(vector.multiply(Ar));
		Bint = mate.position().location().add(vector.multiply(Br));
	    } else if (Math.abs(dist - (Ar - Br)) < d_tol) {
		Aint = position().location().subtract(vector.multiply(Ar));
		Bint = mate.position().location().subtract(vector.multiply(Br));
	    } else {	// Math.abs(dist - (Br - Ar)) < d_tol
		Aint = position().location().add(vector.multiply(Ar));
		Bint = mate.position().location().add(vector.multiply(Br));
	    }
	    JgclPoint3D res = Aint.linearInterpolate(Bint, 0.5);
	    double[] params = pointToParameter(Aint);
	    JgclPointOnSurface3D ponA
		= new JgclPointOnSurface3D(Aint, this, params[0], params[1], doCheckDebug);
	    params = mate.pointToParameter(Bint);
	    JgclPointOnSurface3D ponB
		= new JgclPointOnSurface3D(Bint, mate, params[0], params[1], doCheckDebug);
	    JgclIntersectionPoint3D intp;
	    if (!doExchange)
		intp = new JgclIntersectionPoint3D(res, ponA, ponB, doCheckDebug);
	    else
		intp = new JgclIntersectionPoint3D(res, ponB, ponA, doCheckDebug);
	    JgclSurfaceSurfaceInterference3D[] sol = {intp};
	    return sol;
	}

	if ((dist < (Ar + Br)) && (dist > Math.abs(Ar - Br))) {
	    /*
	     * intersection is a circle
	     */
	    double Adist = Math.abs((Ar * Ar - Br * Br + dist * dist) / (2.0 * dist));
	    JgclPoint3D Apnt = position().location().subtract(vector.multiply(Adist));
	    double Bdist = Math.abs((Br * Br - Ar * Ar + dist * dist) / (2.0 * dist));
	    JgclPoint3D Bpnt = mate.position().location().add(vector.multiply(Bdist));
	    JgclPoint3D loc = Apnt.linearInterpolate(Bpnt, 0.5);
	    JgclVector3D axis = vector2;
	    JgclVector3D refDir;
	    if ((Math.abs(axis.y()) < d_tol) && (Math.abs(axis.z()) < d_tol))
		refDir = JgclVector3D.zUnitVector;
	    else
		refDir = JgclVector3D.xUnitVector;
	    JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(loc, axis, refDir);
	    double radius
		= Math.sqrt(((Ar * Ar - Adist * Adist) + (Br * Br - Bdist * Bdist)) / 2.0);
	    JgclCircle3D res = new JgclCircle3D(a2p, radius);
	    JgclIntersectionCurve3D ints = curveToIntersectionCurve(res, mate, doExchange);
	    JgclSurfaceSurfaceInterference3D[] sol = {ints};
	    return sol;
	}

	/*
	 * no intersection
	 */
	return new JgclSurfaceSurfaceInterference3D[0];
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsSphCyl3D#intersection(JgclSphericalSurface3D, JgclCylindricalSurface3D, boolean)
     * JgclIntsSphCyl3D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate,
						 boolean doExchange) {
	return JgclIntsSphCyl3D.intersection(this, mate, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsSphCon3D JgclIntsSphCon3D}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate,
						 boolean doExchange) {
	JgclIntsSphCon3D doObj = new JgclIntsSphCon3D(this, mate);
	return doObj.getInterference(doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (xWGȖ) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsQrdBzs3D#intersection(JgclElementarySurface3D, JgclPureBezierSurface3D, boolean)
     * JgclIntsQrdBzs3D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (xWGȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate,
						 boolean doExchange) {
	return JgclIntsQrdBzs3D.intersection(this, mate, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (aXvCȖ) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsSrfBss3D#intersection(JgclElementarySurface3D, JgclBsplineSurface3D, boolean)
     * JgclIntsSrfBss3D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (aXvCȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate,
						 boolean doExchange) {
	return JgclIntsSrfBss3D.intersection(this, mate, doExchange);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂItZbgȖʂ
     * ^ꂽ덷ŋߎ Bspline Ȗʂ߂B
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.FRONT/BACK)
     * @param tol     	̋e덷
     * @return		̋Ȗʂ̎w̋`Ԃ̃ItZbgȖʂߎ Bspline Ȗ
     * @see	JgclWhichSide
     */
    public JgclBsplineSurface3D
	offsetByBsplineSurface(JgclParameterSection uPint,
			       JgclParameterSection vPint,
			       double magni,
			       int side,
			       JgclToleranceForDistance tol)
    {
	JgclOfst3D doObj = new JgclOfst3D(this,uPint,vPint,magni,side,tol);
	return doObj.offset();
    }
    
    /**
     * ̋Ȗʂ U p[^̈ʒuɂ铙p[^ȐԂB
     * <p>
     * ̓p[^Ȑ͉~ʂƂȂ邽߃gȐƂĕԂB
     * ̂߂ɂ̓p[^Ȑ̃p[^`悪 [0, ] ƂȂĂ܂A
     *  V ̃p[^` [(-  / 2), ( / 2)] ƍȂȂĂ܂̂ŁA
     * 舵ɂ͒ӂKvłB
     * </p>
     *
     * @param uParam	U ̃p[^l
     * @return	w U p[^lł̓p[^Ȑ
     */
    public JgclParametricCurve3D uIsoParametricCurve(double uParam) {
	JgclCartesianTransformationOperator3D trns = position().toCartesianTransformationOperator();

	JgclPoint3D cntr = position().location();	// center point of Circle
	JgclVector3D xVec
	    = position().x().multiply(Math.cos(uParam)).add(position().y().multiply(Math.sin(uParam)));
	xVec = trns.toEnclosed(xVec);				// X axis of Circle
	JgclVector3D yVec = trns.toEnclosed(position().z());	// Y axis
	JgclVector3D zVec = xVec.crossProduct(yVec);		// Z axis
	JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(cntr, zVec, xVec);
	JgclCircle3D cir = new JgclCircle3D(a2p, radius());
	JgclParameterSection sec = new JgclParameterSection(- Math.PI / 2.0, Math.PI);
	return new JgclTrimmedCurve3D(cir, sec);
    }

    /**
     * ̋Ȗʂ V p[^̈ʒuɂ铙p[^ȐԂB
     *
     * @param vParam	V ̃p[^l
     * @return	w V p[^lł̓p[^Ȑ
     */
    public JgclParametricCurve3D vIsoParametricCurve(double vParam)
	throws JgclReducedToPoint
    {
	checkVValidity(vParam);

	JgclCartesianTransformationOperator3D trns = position().toCartesianTransformationOperator();

	JgclPoint3D cntr = new JgclCartesianPoint3D(0.0, 0.0, radius() * Math.sin(vParam));
	cntr = trns.toEnclosed(cntr);	// center of Circle
	double cRadius = radius() * Math.cos(vParam);
	if (cRadius <= getToleranceForDistance()) {
	    throw new JgclReducedToPoint(cntr);
	}
	JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(cntr, position().z(), position().x());
	return new JgclCircle3D(a2p, cRadius);
    }

    /**
     * ̋Ȗʂ U ̃p[^`ԂB
     * <p>
     * LŎIȒ`ԂB
     * </p>
     *
     * @return	̋Ȗʂ U ̃p[^`
     */
    JgclParameterDomain getUParameterDomain() {
	try {
	    return new JgclParameterDomain(true, 0, 2*Math.PI);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * ̋Ȗʂ V ̃p[^`ԂB
     * <p>
     * LŔIȒ`ԂB
     * </p>
     *
     * @return	̋Ȗʂ V ̃p[^`
     */
    JgclParameterDomain getVParameterDomain() {
	try {
	    return new JgclParameterDomain(false, -Math.PI/2, Math.PI);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricSurface3D#SPHERICAL_SURFACE_3D JgclParametricSurface3D.SPHERICAL_SURFACE_3D}
     */
    int type() {
	return SPHERICAL_SURFACE_3D;
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽ덷ŕʋߎ_QԂB
     * <p>
     * ʂƂē_Q͈ʂɁAʑIɂ􉽓IɂAiqł͂ȂB
     * </p>
     * <p>
     * scalingFactor ́A͗pł͂ȂAo͗p̈łB
     * scalingFactor ɂ́Avf 2 ̔z^B
     * scalingFactor[0] ɂ U ̏kڔ{A
     * scalingFactor[1] ɂ V ̏kڔ{ԂB
     * ̒l͉炩̐Βlł͂ȂA
     * p[^̐iޑx T ɑ΂āA
     * U/V ɂĎԏŋȖʏ̓_iޑx Pu/Pv \ΒlłB
     * ܂Ap[^ T iނƁA
     * ԏł̋Ȗʏ̓_ U ł Pu (scalingFactor[0])A
     * V ł Pv (scalingFactor[1]) iނƂ\ĂB
     * T ̑傫͖Ȃ̂ŁA̒lQƂۂɂ́A
     * scalingFactor[0]  scalingFactor[1] ̔䂾pׂłB
     * ȂA̒l͂܂łڈłAȑx̂ł͂ȂB
     * </p>
     * <p>
     * ʂƂĕԂ Vector Ɋ܂܂evf
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D
     * ł邱Ƃ҂łB
     * </p>
     *
     * @param uParameterSection	U ̃p[^
     * @param vParameterSection	V ̃p[^
     * @param tolerance	̋e덷
     * @param scalingFactor	_QOp`ۂɗLpƎv U/V ̏kڔ{
     * @return	_Q܂ Vector
     * @see	JgclPointOnSurface3D
     */
    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection,
					JgclParameterSection vParameterSection,
					double tolerance,
					double[] scalingFactor) {
	Vector result = new Vector();

	JgclMesh3D mesh = this.toMesh(uParameterSection,
				      vParameterSection,
				      new JgclToleranceForDistance(tolerance));

	for (int u = 0; u < mesh.uNPoints(); u++)
	    for (int v = 0; v < mesh.vNPoints(); v++)
		result.addElement(mesh.pointAt(u, v));

	/*
	 * U ̍ő唼a𓾂
	 */
	double uCircleRadius;
	if (vParameterSection.start() > 0.0) {
	    uCircleRadius = this.radius() * Math.cos(vParameterSection.start());
	} else if (vParameterSection.end() < 0.0) {
	    uCircleRadius = this.radius() * Math.cos(vParameterSection.end());
	} else {
	    uCircleRadius = this.radius();
	}

	scalingFactor[0] = uCircleRadius; // * GH__PINT_INCRS(pint) / GH__PINT_INCRS(pint)

	/*
	 * V ̍ő唼a𓾂
	 */
	double vCircleRadius = this.radius();
	scalingFactor[1] = vCircleRadius; // * GH__PINT_INCRS(pint) / GH__PINT_INCRS(pint)

	return result;
    }

    /**
     * ̋ȖʂA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricSurface3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclAxis2Placement3D tPosition =
	    this.position().transformBy(reverseTransform,
					transformationOperator,
					transformedGeometries);
	double tRadius;
	if (reverseTransform != true)
	    tRadius = transformationOperator.transform(this.radius());
	else
	    tRadius = transformationOperator.reverseTransform(this.radius());
	return new JgclSphericalSurface3D(tPosition, tRadius);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tposition");
	position().output(writer, indent + 2);
        writer.println(indent_tab + "\tradius\t" + radius);
        writer.println(indent_tab + "End");
    }
}
