/*
 * R : XC[vʂ\ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclSweptSurface3D.java,v 1.21 2000/04/26 09:39:25 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * R : XC[vʂ\ۃNXB
 * <p>
 * XC[vʂƂ́A
 * RȐʂ̂RȐɉđ| (XC[v) OՂȖʂƂ݂Ȃ̂łB
 * </p>
 * <p>
 * ̃NX̃CX^X́A
 * XC[vׂRȐ sweptCurve
 * ێB
 * </p>
 *
 * @version $Revision: 1.21 $, $Date: 2000/04/26 09:39:25 $
 * @author Information-technology Promotion Agency, Japan
 */

public abstract class JgclSweptSurface3D extends JgclParametricSurface3D {
    /**
     * XC[vׂȐB
     * @serial
     */
    private JgclParametricCurve3D sweptCurve;

    /**
     * XC[vȐ^ăIuWFNg\zB
     * <p>
     * sweptCurve  null ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param sweptCurve	XC[vȐ
     * @see	JgclInvalidArgumentValue
     */
    protected JgclSweptSurface3D(JgclParametricCurve3D sweptCurve)
    {
	super();
	setSweptCurve(sweptCurve);
    }

    /**
     * XC[vȐtB[hɐݒ肷B
     * <p>
     * sweptCurve  null ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param sweptCurve	XC[vȐ
     * @see	JgclInvalidArgumentValue
     */
    private void setSweptCurve(JgclParametricCurve3D sweptCurve)
    {
	if (sweptCurve == null) {
	    throw new JgclInvalidArgumentValue();
	}
	this.sweptCurve = sweptCurve;
    }

    /**
     * ̋Ȗʂ́AXC[vȐԂB
     * 
     * @return		XC[vȐ
     */
    public JgclParametricCurve3D sweptCurve() {
	return sweptCurve;
    }

    /**
     * ̋ȖʂƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ̋Ȗʂ͈ʂɖȋȖʂƂȂ邱ƂA
     * ̏ꍇAIɂ͖ȎRȖʂƓlȈƂȂB
     * ʂɉƂ͓߁A܂̂ƂA
     * JgclImproperOperation ̗O𔭐B
     * </p>
     * <p>
     * ̋ȖʂƂ̌_߂ꍇ́A
     * ̋ȖʂȖʂƂ`LȖʂ
     * ȐEȖʂ𐶐A̋ȖʂƂ̌_Ƃċ߂ꂽB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     * @see	JgclImproperOperation
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) {
	throw new JgclImproperOperation();
    }

    /**
     * ̋ȖʂƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
	throw new JgclImproperOperation();
    }

    /**
     * ̋ȖʂƑ̋Ȑ (~Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (~Ȑ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclConic3D mate, boolean doExchange) {
	throw new JgclImproperOperation();
    }

    /**
     * ̋ȖʂƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
	throw new JgclImproperOperation();
    }

    /**
     * ̋ȖʂƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
	throw new JgclImproperOperation();
    }

    /**
     * ̋ȖʂƑ̋Ȗʂ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȖʂӏɂẮA (JgclIntersectionCurve3D) ԂB
     * </p>
     * <p>
     * ȖʂڂӏɂẮA_ (JgclIntersectionPoint3D) Ԃ邱ƂB
     * </p>
     * <p>
     * ̋Ȗʂ͈ʂɖȋȖʂƂȂ邱ƂA
     * ̏ꍇAIɂ͖ȎRȖʂƓlȈƂȂB
     * ʂɉƂ͓A
     * ܂ȎRȐ(|C)ƂĒ`Ȃ΂ȂȂ
     * \邽߁A܂̂ƂA
     * JgclImproperOperation ̗O𔭐B
     * </p>
     * <p>
     * ̋ȖʂƂ̌߂ꍇ́A
     * ̋ȖʂȖʂƂ`LȖʂ
     * ȐEȖʂ𐶐A̋ȖʂƂ̌Ƃċ߂ꂽB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return		 (܂͌_) ̔z
     * @see		JgclIntersectionCurve3D
     * @see		JgclIntersectionPoint3D
     * @see		JgclImproperOperation
     */
    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate) {
	throw new JgclImproperOperation();
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂƑ̋Ȗʂ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȖʂӏɂẮA (JgclIntersectionCurve3D) ԂB
     * </p>
     * <p>
     * ȖʂڂӏɂẮA_ (JgclIntersectionPoint3D) Ԃ邱ƂB
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param mate	̋Ȗ
     * @return		 (܂͌_) ̔z
     * @see		JgclIntersectionCurve3D
     * @see		JgclIntersectionPoint3D
     * @see		#changeTargetOfIntersection(JgclIntersectionPoint3D)
     * @see		#changeTargetOfIntersection(JgclIntersectionCurve3D)
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclParameterSection uPint,
						 JgclParameterSection vPint,
						 JgclParametricSurface3D mate) {
	JgclSurfaceSurfaceInterference3D[] results =
	    this.toBsplineSurface(uPint, vPint).intersect(mate);

	for (int i = 0; i < results.length; i++) {
	    if (results[i].isIntersectionPoint() == true) {
		results[i] = this.changeTargetOfIntersection(results[i].toIntersectionPoint());
	    } else {
		results[i] = this.changeTargetOfIntersection(results[i].toIntersectionCurve());
	    }
	}

	return results;
    }

    /**
     * ̋ȖʂƑ̋Ȗ () ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate, boolean doExchange) {
	throw new JgclImproperOperation();
    }

    /**
     * ̋ȖʂƑ̋Ȗ () ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate, boolean doExchange) {
	throw new JgclImproperOperation();
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate,
						 boolean doExchange) {
	throw new JgclImproperOperation();
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate, boolean doExchange) {
	throw new JgclImproperOperation();
    }

    /**
     * ̋ȖʂƑ̋Ȗ (xWGȖ) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ (xWGȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate,
						 boolean doExchange) {
	throw new JgclImproperOperation();
    }

    /**
     * ̋ȖʂƑ̋Ȗ (aXvCȖ) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ (aXvCȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate,
						 boolean doExchange) {
	throw new JgclImproperOperation();
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	XC[vȐR`ł trueAłȂ false
     */
    public boolean isFreeform() {
	return this.sweptCurve.isFreeform();
    }

    /**
     * ^ꂽ_A̋Ȗʂɑ΂_ɕϊB
     * <p>
     * ̃\bhԂ_́ȂΏۂłȂ
     * p[^l̋Ȗʂɑ΂̂ɕϊĂB
     * </p>
     *
     * @param ints	_
     * @return	Ώۂ̋ȖʂɕύX_
     * @see	#intersect(JgclParameterSection, JgclParameterSection, JgclParametricSurface3D)
     * @see	#changeTargetOfIntersection(JgclIntersectionCurve3D)
     */
    private JgclIntersectionPoint3D
    changeTargetOfIntersection(JgclIntersectionPoint3D ints)
    {
	double[] ownParams = this.pointToParameter(ints.coordinates());
	JgclPointOnGeometry3D pog1 = new JgclPointOnSurface3D(this,
							      ownParams[0],
							      ownParams[1],
							      doCheckDebug);
	return new JgclIntersectionPoint3D(ints.coordinates(),
					   pog1, ints.pointOnGeometry2(), doCheckDebug);
    }

    /**
     * ^ꂽA̋Ȗʂɑ΂ɕϊB
     * <p>
     * ^́ÂR\|Cł̂Ƒz肵ĂB
     * łȂꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * ̃\bhԂ́ȂΏۂłȂ
     * p[^l̋Ȗʂɑ΂̂ɕϊĂB
     * </p>
     *
     * @param ints	
     * @return	Ώۂ̋ȖʂɕύX
     * @see	JgclInvalidArgumentValue
     * @see	#intersect(JgclParameterSection, JgclParameterSection, JgclParametricSurface3D)
     * @see	#changeTargetOfIntersection(JgclIntersectionPoint3D)
     */
    private JgclIntersectionCurve3D
    changeTargetOfIntersection(JgclIntersectionCurve3D ints)
    {
	if (ints.curve3d().type() != JgclParametricCurve3D.POLYLINE_3D)
	    throw new JgclInvalidArgumentValue();

	JgclPolyline3D polyline3d = (JgclPolyline3D)ints.curve3d();
	JgclPoint2D[] ownParams = new JgclPoint2D[polyline3d.nPoints()];
	for (int i = 0; i < polyline3d.nPoints(); i++)
	    ownParams[i] = JgclPoint2D.of(this.pointToParameter(polyline3d.pointAt(i)));
	JgclPolyline2D curve2d1 = new JgclPolyline2D(ownParams, polyline3d.closed());

	return new JgclIntersectionCurve3D(ints.curve3d(),
					   this, curve2d1,
					   ints.basisSurface2(), ints.curve2d2(),
					   ints.masterRepresentation());
    }
}
