/*
 * Java Geometry Handling Library Test Environment
 * Judan Main Routine
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: Judan.java,v 1.6 2000/08/15 09:36:08 shikano Exp $
 */
package jp.co.sra.judan;

import java.util.Vector;
import java.io.*;
import jp.co.sra.judan.*;

/**
 * @version $Revision: 1.6 $
 * @author $Author: shikano $
 */

public class Judan extends java.lang.Object {
    /**
     * Debug flag
     */
    private static final boolean debugFlag = false;

    /**
     * ʂ𕶎Ƃďo͂邩ǂ̃tO
     */
    private boolean isOutputCharacter = false;

    /**
     * ʂLispSƂďo͂邩ǂ̃tO
     */
    private boolean isOutputLispSExpression = false;

    /**
     * ʂOtBbNXƂďo͂邩ǂ̃tO
     */
    private boolean isOutputVisual = false;

    /**
     * ͂t@Csǂ̃tO
     */
    private boolean isInputFromFile = false;

    /**
     * ̓t@C
     */
    private String fileName = null;

    /**
     * RXgN^(Ȃ)
     */
    public Judan() {
    }

    /**
     * gp@o͂
     */
    private void usage() {
        System.out.println("Usage: java Judan [-[c|l]v[f filename]]");
	System.exit(0);
    }

    /**
     * ̏s
     *
     * @param arg 1 ̃R}hC
     */
    private void processArgument(String arg) {
        for (int i = 1; i < arg.length(); i++) {
            switch(arg.charAt(i)) {
            case 'h' :
                {
                    usage();
		    break;
                }
            case 'c' :
                {
		    if (isOutputLispSExpression) {
			usage();
			break;
		    }

		    if (!isOutputCharacter) {
			if (debugFlag)
			    System.out.println("// Character String Output Mode is On!!");
			isOutputCharacter = true;
		    }
		    else
			usage();
		    break;
                }
            case 'l' :
                {
		    if (isOutputCharacter) {
			usage();
			break;
		    }

		    if (!isOutputLispSExpression) {
			if (debugFlag)
			    System.out.println("// Lisp S Expression Mode is On!!");
			isOutputLispSExpression = true;
		    }
		    else
			usage();
		    break;
                }
            case 'v' :
                {
		    if (!isOutputVisual) {
			if (debugFlag)
			    System.out.println("// Visual Output (Now use only Jun) Mode is On!!");
			isOutputVisual = true;
		    }
		    else
			usage();
		    break;
                }
            case 'f' :
                {
		    if (!isInputFromFile) {
			isInputFromFile = true;
		    }
		    else
			usage();
		    break;
                }
	    default :
		usage();
            }
        }
    }

    /**
     * ̏s
     *
     * @param args ׂẴR}hC
     */
    private void processArguments(String[] args) {
        int nArg = args.length;

        for (int i = 0; i < nArg; i++) {
            String arg = args[i];
            if (arg.charAt(0) == '-') {
                processArgument(arg);
            }
            else {
                if (!isInputFromFile)
                    usage();
                else
                    fileName = arg;
            }
        }
    }

    /**
     * ʂ𕶎Ƃďo͂邩ǂ̃tOԂ
     *
     * @return tO
     */
    public boolean isOutputCharacter() {
	return isOutputCharacter;
    }

    /**
     * ʂLispSƂďo͂邩ǂ̃tOԂ
     *
     * @return tO
     */
    public boolean isOutputLispSExpression() {
	return isOutputLispSExpression;
    }

    /**
     * ʂOtBbNXƂďo͂ǂ̃tOԂ
     *
     * @return tO
     */
    public boolean isOutputVisual() {
	return isOutputVisual;
    }

    /**
     * ͂tBAsǂtOԂ
     *
     * @return tO
     */
    public boolean isInputFromFile() {
	return isInputFromFile;
    }

    /**
     * t@CԂ
     *
     * @return t@C
     */
    public String getFileName() {
	return fileName;
    }

    /**
     * Main routine
     *
     * @param args R}hC
     */
    public static void main(String[] args) {

	Judan judan = new Judan();

        // ̏
        judan.processArguments(args);

        // p[TIuWFNg̐
	// tgGh
        JudanParser parser = null;
	String fileName = null;
        try {
            if (!judan.isInputFromFile())
                parser = new JudanParser(System.in);
	    else if ((fileName = judan.getFileName()) != null) 
                parser = new JudanParser(new FileReader(fileName));
	    else 
		System.out.println("Filename is needed.");
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
            throw new RuntimeException();
        }

 	JudanParsedInfo parsedInfo = null;
     	try {
  	    parsedInfo = parser.jgclFile();
	    if (debugFlag)
		System.out.println("// Successful Parse!!");
	}
	catch (ParseException e) {
	    System.out.println(e.getMessage());
	    System.out.println("Failure Parse!!");
	    throw new RuntimeException();	    
	}

	// t@C͌̏
        // ͂ɍsꂽ̏
        // IvVɂčsςB
	parsedInfo.execute(judan.isOutputCharacter(),
			   judan.isOutputLispSExpression(),
			   judan.isOutputVisual());
    }
}
