/*
 * Java Geometry Handling Library Test Environment
 * JudanMethod Object for Method "coordinate"
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanMethodCoordinate.java,v 1.2 2000/04/20 13:27:53 ryo Exp $
 */
package jp.co.sra.judan;

import java.lang.reflect.*;
import jp.go.ipa.jgcl.*;
import jp.co.sra.judan.*;
import java.awt.Color;

/**
 * @version $Revision: 1.2 $
 * @author $Author: ryo $
 */

public class JudanMethodCoordinate extends JudanMethod {

    /**
     * RXgN^
     *
     * @param geometry    􉽃IuWFNg
     * @param methodName  \bh̖O
     * @param argClasses  \bh̃NX
     * @param argEntities \bhɗ^̃IuWFNg
     */
    public JudanMethodCoordinate(JgclGeometry geometry,
				String methodName,
				Class[] argClasses,
				Object[] argEntities) {
	if (geometry instanceof JgclParametricCurve)
	    argClasses[0] = double.class;
	else if (geometry instanceof JgclParametricSurface) {
	    argClasses[0] = double.class;
	    argClasses[1] = double.class;
	}
	else {
	    throw new JgclFatal();
	}
	setFields(geometry, methodName, argClasses, argEntities);
    }

    /**
     * sʂ𕶎Ƃďo͂
     */
    public void output(){
	JgclGeometry resultGeom = (JgclGeometry)result;
  	resultGeom.output(System.out);
    }

    /**
     * sʂOtBbN
     */
    public JudanTransformer makeView() {
	resultView = new JudanTransformer(new JudanTransformerJun());
	resultView.transform((JgclGeometry)result, Color.red);
	resultView.transform(geometry, Color.green);
	return resultView;
    }
}
