/*
 * Java Geometry Handling Library Test Environment
 * JudanMethod Object for Method "tabcyl surface"
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanMethodTabcyl.java,v 1.2 2000/04/20 13:27:54 ryo Exp $
 */
package jp.co.sra.judan;

import java.lang.reflect.*;
import jp.go.ipa.jgcl.*;
import jp.co.sra.judan.*;

import java.awt.Color;
import sra.jun.opengl.objects.*;

/**
 * @version $Revision: 1.2 $
 * @author $Author: ryo $
 */

public class JudanMethodTabcyl extends JudanMethod {
    private final JgclBsplineCurve3D curve1;
    private final JgclBsplineCurve3D curve2;

    /**
     * RXgN^
     *
     * @param geometry    􉽃IuWFNg
     * @param methodName  \bh̖O
     * @param argClasses  \bh̃NX
     * @param argEntities \bhɗ^̃IuWFNg
     */
    public JudanMethodTabcyl(JgclGeometry geometry,
			     String methodName,
			     Class[] argClasses,
			     Object[] argEntities) {
  	if (!(geometry instanceof jp.go.ipa.jgcl.JgclBsplineCurve3D) ||
	    !(argEntities[0] instanceof jp.go.ipa.jgcl.JgclBsplineCurve3D)) {
	    throw new JgclFatal();
	}

	setFields(geometry, methodName, argClasses, argEntities);
	this.curve1 = (JgclBsplineCurve3D)geometry;
	this.curve2 = (JgclBsplineCurve3D)argEntities[0];
    }

    /**
     * sʂ𕶎Ƃďo͂
     */
    public void output() {
	JgclBsplineSurface3D bss = (JgclBsplineSurface3D)result;
	curve1.output(System.out);
	curve2.output(System.out);
	bss.output(System.out);
    }

    /**
     * sʂOtBbNXƂďo͂
     */
    public static void view(Object result,
			    JgclBsplineCurve3D curve1,
			    JgclBsplineCurve3D curve2) {
	JudanTransformer resultView = makeView(result, curve1, curve2);
	resultView.show();
    }

    /**
     * sʂ̃OtBbNX
     *
     * @param result	s(_܂͌̔z)
     */
    public static JudanTransformer makeView(Object result,
					    JgclBsplineCurve3D curve1,
					    JgclBsplineCurve3D curve2) {
	JgclBsplineSurface3D bss = (JgclBsplineSurface3D)result;
	JudanTransformer resultView =
	    new JudanTransformer(new JudanTransformerJun());
	resultView.transform(curve1, Color.red);
	resultView.transform(curve2, Color.yellow);
	resultView.transform(bss, Color.blue);
	return resultView;
    }

    /**
     * sʂ̃OtBbNX
     *
     * @param result	s(_܂͌̔z)
     */
    public JudanTransformer makeView() {
	return makeView(result, curve1, curve2);
    }
}
