/*
 * Java Geometry Handling Library Test Environment
 *
 * Judan Method Class (Wrapper for JudanMethod) and 
 * keeping methodName <=> Method class in Hashtable
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanMethodWrapper.java,v 1.7 2000/04/26 13:54:46 shikano Exp $
 */

package jp.co.sra.judan;

import java.lang.reflect.*;
import java.util.*;
import jp.go.ipa.jgcl.*;
import jp.co.sra.judan.*;

/**
 * @version $Revision: 1.7 $
 * @author $Author: shikano $
 */
public class JudanMethodWrapper extends java.lang.Object {

    /**
     * Jgcl\bh
     * ۃNXȂ̂ŁAۂɂ̓TuNXoCh
     */
    JudanMethod method = null;

    /**
     * \bhƃ\bhNX̑ΉێĂ߂
     * nbVe[u
     * 
     * V\bhIuWFNgƂɂ́A
     * ɓo^āAJudanMethod NX̃TuNXƂ
     * ۃ\bhI[oCh
     * 
     * @see Hashtable
     */
    static Hashtable table = new Hashtable();
    static {
	table.put("length", "jp.co.sra.judan.JudanMethodLength");
	table.put("coordinates", "jp.co.sra.judan.JudanMethodCoordinate");
	table.put("tangentVector", "jp.co.sra.judan.JudanMethodTangentVector");
	table.put("curvature", "jp.co.sra.judan.JudanMethodCurvature");
	table.put("torsion", "jp.co.sra.judan.JudanMethodTorsion");
	table.put("normalVector", "jp.co.sra.judan.JudanMethodNormalVector");
	table.put("evaluation", "jp.co.sra.judan.JudanMethodEvaluation");
	table.put("singular", "jp.co.sra.judan.JudanMethodSingular");
	table.put("inflexion", "jp.co.sra.judan.JudanMethodInflexion");
	table.put("projectFrom", "jp.co.sra.judan.JudanMethodProjectFrom");
	table.put("toPolyline", "jp.co.sra.judan.JudanMethodToPolyline");
	table.put("intersect", "jp.co.sra.judan.JudanMethodIntersect");
	table.put("fillet", "jp.co.sra.judan.JudanMethodFillet");
	table.put("offsetByBsplineCurve", "jp.co.sra.judan.JudanMethodOffset2D");
	table.put("offsetByBsplineSurface", "jp.co.sra.judan.JudanMethodOffset3D");
	table.put("tabcylSurface", "jp.co.sra.judan.JudanMethodTabcyl");
	table.put("loftSurface", "jp.co.sra.judan.JudanMethodLoft");
    }

    /**
     * RXgN^
     *
     * @param geometry     􉽃IuWFNg
     * @param methodName   ׂ\bhIuWFNg̖O
     * @param argClasses   \bhIuWFNg̈̃NX
     * @param argEntities  \bhIuWFNg̈̃IuWFNg
     */
    public JudanMethodWrapper(JgclGeometry geometry, String methodName,
			   Class[] argClasses, Object[] argEntities) {

	// nbVe[u琶ׂ
	// \bhIuWFNg̃NX肷
	Class cls = null;
	try {
	    cls = Class.forName((String)table.get(methodName));
	}
	catch (ClassNotFoundException e) {
	    throw new JgclFatal(methodName + " not found");
	}

	// \bhIuWFNg𐶐邽߂
	// ̃RXgN^𓾂
	Class[] classes = {JgclGeometry.class, String.class,
			   Class[].class, Object[].class};
	Constructor ctor = null;
	try {
	    ctor = cls.getConstructor(classes);
	}
	catch (NoSuchMethodException e){
	    throw new JgclFatal();
 	}

	// \bhIuWFNg𓾂
 	Object[] objs = {geometry, methodName, argClasses, argEntities};
	try {
	    this.method = (JudanMethod)ctor.newInstance(objs);
	}
	catch (InstantiationException e) {
	    throw new JgclFatal();
	}
	catch (InvocationTargetException e) {
	    throw new JgclFatal();
	}
	catch (IllegalAccessException e) {
	    throw new JgclFatal();
	}
    }

    /**
     * \bhIuWFNgs
     */
    public void invoke() {
	method.invoke();
    }

    /**
     * sʂ𕶎Ƃďo͂
     */
    public void output() {
	method.output();
    }

    /**
     * sʂOtBbNƂďo͂
     */
    public void view() {
	method.view();
    }

    /**
     * sʂ̃OtBbNLispSƂďo͂
     */
    public void toLispSExpression() {
	method.toLispSExpression();
    }
}
