#!/bin/sh
# platform ... devuan dash
# GPL_3+
cat << 'EEE' > /dev/null
/* jf.sh ... make transparent window using compton. bourne-shell script.
 * Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

# 2-clause BSD license
# https://sites.google.com/site/jdisnard/realpath
cat << 'EEE' > /dev/null
/* Copyright 2010 Jon Disnard. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 * 
 *    1. Redistributions of source code must retain the above copyright notice, this list of
 *       conditions and the following disclaimer.
 * 
 *    2. Redistributions in binary form must reproduce the above copyright notice, this list
 *       of conditions and the following disclaimer in the documentation and/or other materials
 *       provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY Jon Disnard ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are those of the
 * authors and should not be interpreted as representing official policies, either expressed
 * or implied, of Jon Disnard.
 */
EEE
#-----jellyfish_setting
# search window(target_win) >>> if hit, exec action.(action_list)
# 223123(wid)  terminal_hit(comment) .. >>> while a b ...

#---window_search. see ./widgrub.sh -h
target_win=$(cat << 'EEE'
appname="xfce4-terminal"
focus=1
mouseover=1
comment="lvl_1"
---
appname="xfce4-terminal"
focus=0
mouseover=1
comment="lvl_2"
---
appname="xfce4-terminal"
mouseover=0
comment="lvl_3"
---
EEE
)

#---hit_action
action_list=$(cat << 'EEE'
while read a b
do

#...terminal
if [ "$b" = "lvl_1" ] ; then
		# opacity setting. add EHWM_proparty 'OPP_MY' using 'xprop'
		# 8s ... proparty mode is '8' and use as 'string'. see xprop -h.
	xprop -id $a -format OPP_MY 8s -set OPP_MY "90"
fi

if [ "$b" = "lvl_2" ] ; then
	xprop -id $a -format OPP_MY 8s -set OPP_MY "80"
fi
if [ "$b" = "lvl_3" ] ; then
	xprop -id $a -format OPP_MY 8s -set OPP_MY "60"
fi


done

EEE
)

#-----jellyfish_setting_end

trap '' HUP TERM	# for nohup

func_rlp() {
# '(' ... for local scope
(
# normalize locale
bk_lcl=`set`
export LC_ALL=C
export LANG=C
pf1='( eval "$bk_lcl" ; cat - )'

rlp_input='cat -'	
if [ "$#" != '0' ] ; then
	rlp_input='for ii
do
	printf "%s\000" "$ii"
done'
fi

# ...awk for detect input err.
eval "$rlp_input" | od -An -to1 -w16 -v | awk -v bf="$0" '
BEGIN{err=1} 
$0 ~ /000/ {err=0}
{print $0}
END{
	if(NR > 0 && err == 1 ) {
		printf("%s: link search err. \134000 not found. sleep.\n", bf) > "/dev/stderr"
		for(;;){
			system("sleep 1000")
		}
	}
}' | sed -e 's/ 000/@/g' | tr -d '\n' | 
	tr ' ' '\134' | tr '@' '\n' | while read -r rlp_A
do
	# fname ... dir
	rlp_fin=`printf "$rlp_A"'@'`
	rlp_fin="${rlp_fin%?}"

	#	normalize name to have dir data	(aaa.txt -> ./aaa.txt etc)
	rlp_fin="${rlp_fin%/}"
	if [ "${rlp_fin#*/}" = "$rlp_fin" ] ; then
		rlp_fin="./$rlp_fin"
	fi
	
	rlp_ftail=''	#file name only
	
	# kick err files
	if ! [ -e "$rlp_fin" ] ; then
#		echo "$0: link search err. file not found. '$rlp_fname'" > /dev/stderr
		printf '//%s\000' "$rlp_fin"
		continue
	fi
	
	# split dir + name. -f ... cant get ln, pipe etc.
	if ! [ -d "$rlp_fin" ] ; then		# -d ! not dir == files
	#	split dir + filename. and resolve soft link
	# ls --show-control-chars
	#	表示不可能な文字をそのまま表示 (プログラムが  'ls'  で  なかった
	#	り、出力が端末以外の場合は、これがデフォルト動作になる)
	#	...つまり、端末に表示せず変数等に代入する時は正確なファイル名が取得できるはず。

	#	-Lオプションはサイズや日付データのみでファイル名は対象外

		rlp_fname="$rlp_fin"
		while :		# recheck for multiple link (a -> b -> c etc)
		do

		if ! [ -h "$rlp_fname" ] ; then		# -h ... exist & link
			break
		fi


# 2-clause BSD license
# https://sites.google.com/site/jdisnard/realpath
# use 'ls -l' to get link-dst infomation.
# '->' use as string spliter	... http://pubs.opengroup.org/onlinepubs/9699919799/utilities/ls.html
# need LANG=c ? safety?
#	rlp_LANGbk="$LANG"
#	LANG="c"
		rlp_base=`/bin/ls -l "$rlp_fname" ; printf @`	# $() removes end '\n' (posix)
		rlp_base="${rlp_base%??}"	# aaa\n@ -> aaa	... ls add \n (like echo)
		rlp_count=`printf '%s\n' "$rlp_fname" | tr -c '>-' ' ' |
			sed -e 's/->/@/g' | tr -d -c '@' | wc -c`	# check '->' string(filename, username etc)
		rlp_count=$((rlp_count+1))
		
		for ii in `seq 1 $rlp_count `
		do
			rlp_base="${rlp_base#*->}"
		done
		rlp_fname='/'"${rlp_base#*/}"	# remove head ' '	ls disp filename (linkfile)

		done
		
		# if files, rlp_ftail != '', 
		rlp_ftail="${rlp_fname##*/}"	# filename only
		rlp_fdir="${rlp_fname%/*}"	# dirname only
	else
		# fin is dir.
		flp_fdir="$rlp_fin"
	fi
	
	# normalized. check path reallink
	# pwd -P: get full realpath. posix. (2001-?)
	# echo @ ... command substitution deletes lineend '\n, \n\n ...'.
	# http://pubs.opengroup.org/onlinepubs/9699919799/utilities/V3_chap02.html#tag_18_06_03
	# pwd permission... dir exec may make some problem. run at subshell.
	
	(
	for ii in skip		# jump emulate
	do
		cd "$rlp_fdir"
		if [ "$?" = "1" ] ; then
			echo "$0: link search err. dir access failed. ($rlp_fdir)" | eval "$pf1" > /dev/stderr
			printf '//%s\000' "$rlp_fdir"
			break
		fi		
		
		rlp_fpath=`pwd -P; printf '@'`
		if [ "$rlp_fpath" = '@' ] && [ "$err" != "" ] ; then
			echo "$0: link search err. pwd -P failed. ($rlp_fdir)" | eval "$pf1" > /dev/stderr
			printf '//%s\000' "$rlp_fdir"
			break
		fi
		
		rlp_fpath=${rlp_fpath%??}	# aaa\n@ -> aaa	... pwd add \n (like echo)
		rlp_fpath=${rlp_fpath%/}	# if aaa/ -> aaa etc
		rlp_fname="$rlp_fpath"'/'"$rlp_ftail"	# dir has end '/' ... 'aaa/' etc
		printf '%s\000' "$rlp_fname"
	done
	)
done | od -An -to1 -w16 -v | tr -d '\n' |
sed -e 's# 000#@#g' | tr ' ' '\134' | tr '@' '\n' | awk -v name="$0" '
	$0 ~ /^.057.057/ {
		gsub(/^.057.057/, "", $0)
		cmd="printf \047" $0 "\012\047 >/dev/stderr"
		printf "%s: link check err. file not found: ", name > "/dev/stderr"
		system(cmd)
		printf "//"
		}
	{print $0}' | eval "$pf1"
)
}

fpath=$(printf `func_rlp "$0"`'@')
fpath=${fpath%?}
fname=${fpath##*/}
fdir=${fpath%/*}'/'
cd "$fdir"

buf=`echo "$fdir" | tr -d -c ':'`
if [ "$buf" = "" ] ;then
	PATH="$fdir"":$PATH"
else
	echo "$0: err. fullpath includes ':'. move the folder to a place where the fullpath does not contain ':'" >/dev/stderr
	exit 1
fi




buf=`./rdopt "hkS:" "$@"`
eval "$buf"

if [ "$opt_h" = "1" ] ; then
cat << 'EEE'
HowTo (jf.sh.... jerryfish. make transparent window using compton)
opt: -h, -k(ill), -S(ignal)	(demands: xdotool, compton, xprop, wmctrl)
------
0. install compton. then copy ./compton.conf to ~/.config/compton.conf
1. disable 'composite processing' with wm if any. (xfwm, openbox etc.)
2. start compton by any of the following.
	~$ compton
	~$ compton -b (...background)
	~$ ./cptn (jf.sh folder script)

3. ~$ ./jf.sh	...or... ./jf.sh &
>>>	start program. terminal will get transparent window.
...if you want to change setting, edit 'jf.sh' directly. (see ./widgrub.sh -h)
...if you get signal err, use './jf.sh -S USR2'.

4. ~$ ./jf.sh -k	# >>>	stop & clear ./jf.sh

...	jf.sh traps 'SIGTERM' 'SIGHUP'. use '-k' to stop jf.sh.
trigger.sh: output one line data if mouse entered some window or focus changed
widgrub.sh: output windowID.
EEE
exit 0
fi

# 3691  1034 /bin/sh ./jf.sh
# 1034  1070 /bin/sh ./jf.sh
# 1034  1071 /bin/sh ./jf.sh
# 1070  1075 /bin/sh ./jf.sh

if [ "$opt_k" = "1" ] ; then
	# 自身は除外. psの出力がアレ。
	skipstr=`ps -eo pid,cmd | grep -v grep | grep $$`
	skipstr="${skipstr#*[! 	0123456789]}"
	
	base=`ps -eo ppid,pid,cmd | grep -- "$fname" | grep -v grep | grep -v -- "$skipstr"`
	base=`printf '%s\n' "$base" | awk '{print $1 " " $2}'`
	bufpp=`echo "$base" | awk '{print $1}' | sort | uniq`
	bufp=`echo "$base" | awk '{print $2}'`
	kickppid=""
	# 親が他の子になっているものを探す＝始祖以外を探す
	for ii in $bufpp
	do
		buf=`echo "$base" | awk -v ppid=$ii '$2 == ppid {print ppid}'`
		kickppid="$kickppid $buf"
	done
	
	# 始祖以外はdupなのでuniq -uで取り除ける。$$は-kなので、追加で切り捨てる。
	set -- $kickppid $bufpp
	tgt=`echo "$@" | tr ' ' '\n' | sort | uniq -u`

#	始祖グループを殺す
	for ii in $tgt
	do
		buf=`echo "$base" | awk -v ppid=$ii '$1 == ppid {print $2}'`
#	echo "$buf" > /dev/stderr
#	本体は影武者。死ぬと監視役が検知して関連プロセスを自動的に皆殺しする。
	if [ "$buf" != "" ] ; then
		kill -9 $buf
	fi
	done
	exit
fi


#---demands test
for ii in "xdotool -h" "xprop -root" "wmctrl -h" "compton -h" 'test -e ~/.config/compton.conf'
do
	eval "$ii >/dev/null 2>&1"
	if [ $? != 0 ] ; then
		echo "'$ii' failed. install plz. see -h"
		exit 1
	fi
done

# signal test
if [ "${opt_S:+e}" = "" ] ; then
	opt_S="USR1"
fi
sgn="$opt_S"

buf=0
trap 'buf=123' $sgn
kill -$sgn $$	# kill -USR1 $$
if [ "$buf" = "0" ] ; then
	echo "$0: err. this pg uses signal. signal $sgn test failed." >/dev/stderr
	echo "	enable $sgn or use option '-S USR2' or other." >/dev/stderr
	exit 1
fi
trap - $sgn




# ---main

mypid=$$
( ./trigger.sh  | ./widgrub.sh -S $sgn -i "$target_win" | 
eval "$action_list"
) &
tgt=$!


# if exit, kill process & clear all OPP_MY property.
# polling suicide. 'trap' work
( while :
do
perr=0
cerr=0
kill -0 $mypid >/dev/null 2>&1
	test $? = 0 || perr=1
kill -0 $tgt >/dev/null 2>&1
	test $? = 0 || cerr=1

if [ "$perr" = "1" ] && [ "$cerr" = "0" ] ; then	
	./killtree -s 9 $tgt
	cerr=1
fi
if [ "$perr" = "0" ] && [ "$cerr" = "1" ] ; then
	kill -KILL $mypid
	perr=1
fi

if [ "$perr" = "1" ] && [ "$cerr" = "1" ] ; then
	# clear proparty
#	set -- `wmctrl -l | awk '{print $1}'`
	set -- `xdotool search . 2>/dev/null`
	for ii
	do
		xprop -id $ii -remove OPP_MY 2>/dev/null
	done
	exit 0
fi

sleep 3
done ) &

cpid=$!
# dummy loop
while :
do
sleep 10
done
