#! /bin/sh
# platform ... devuan dash

# GPL_3
cat << 'EEE' > /dev/null
/* show_stack.sh ... show visible window stacking info. bourne-shell script.
 * Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE


# show_stack.sh ... disp data. no args. 
# dispnum wid sequence top/bottom
# exec 2>/dev/null

buf=`xprop -root | tr ',' ' ' | tr '[:blank:]' ' ' | awk '
$1 ~ /_NET_CLIENT_LIST_STACKING/ { gsub(/.*#/, "", $0); print "stack=\042 " $0 "\042"}
$1 ~ /_NET_CURRENT_DESKTOP/ {print "c_desktop=" $NF}
$1 ~ /_NET_ACTIVE_WINDOW/ {
	gsub(/,/, " ", $0 )
	gsub(/.*#/, "", $0 )
	print "f_win=" $1}
' `
eval "$buf"
# echo "$buf" >/dev/stderr
# ...stack="  0x1a00003  0x4600003  0x4e0000d  0x2a0000d  0x3e000ef  0x4200003  0x4608be2  0x4000003  0x4600066  0x1e00026  0x1e0002a  0x1e00030  0x1e00004  0x1e00022"
# f_win=0x4600066
# c_desktop=0

# 0x >> 123
# echo "$f_win"
f_win=$((f_win + 0))
# 15ms

# stack="  0x1c00003 ... " 
# stack nstack c_desktop
# デスクトップはworkspaceとかスクリーンとか仮想デスクトップとかいわれてる奴。
# 0:1.2で 0個目の物理接続マシンの1個目のxサーバ(rootウィンドウ)で2つめのスクリーン。

# 単体処理ならwhileよりもsedやawkの方が早いことが多い。バッファが効くから。
# プロセス起動のオーバーヘッドを加味してもね。
# 逆にバッファが邪魔ならwhileを使うといい。行で区切ってくれる。

# xpropからstackプロパティを取得して10進数へ。並び順とwmctrlから見える
# widを比較して存在を合体。
sqlist=`echo "$stack" | tr ' ' '\n' | grep ^0x | awk '{printf("%d x %d\n", $0, NR) }' `
# 33554435 x 1
# 69206019 x 2
# 69206234 x 3
# 81788941 x 4
# 
# echo "$sqlist"

# 18ms
# exit

buf=`wmctrl -l | awk '$2 != "-1" {print $1 " " $2}'`
dplist=`printf '%d %d\n' $buf `
# echo "$dplist"

# 69206019 1
# 71303171 0
# 73400323 0

# 25ms
# exit



# printf '%s\n' "$dplist" "$sqlist"  | sort -n | awk '
# BEGIN {a1=""; a2=""}
# $1 == a1 {print a2 " " a1 " " $3}
# { a1=$1 ; a2=$2}
# ' | sort -k 1.1,1n -k 3.2,3nr
# exit


# http://www.kt.rim.or.jp/~kbk/gawk-30/gawk_17.html#SEC170
# join

printf '%s\n' "$dplist" "$sqlist"  | awk '
BEGIN{ split("", data) ; split("", lines) }		#init data[] array@ tricky code but portable
{
    if (data[$1] == "") {
		data[$1] = $2 " " $1
		count++
		lines[count] = $1
	} else {
		data[$1] = "@" data[$1] " " $3
	}
}

END {
    for (i = 1; i <= count; i++) {
        print data[ lines[i] ]
	}
}
' | grep '@' | tr -d '@' | ./ssort 1n,3nr | awk '
NR == 1 {bfkey=$1; bf=$0 " top";next}
$1 != bfkey {bf = bf " bottom"; $0=$0 " top"}
{print bf;bf=$0;bfkey=$1}
END{print bf " bottom"} ' | 
awk -v cdisp="$c_desktop" -v f_win=$f_win '
$0 !~ /top/ && $0 !~ /bottom/ {$0=$0 " middle"}
$1 == cdisp {$0=$0 " current"}
$2 == f_win {$0=$0 " focus"}
{print $0}'
# 30ms

# 複雑みたいだけど、以外に早い。

# focus単体ならxdotoolが5msで早いけど、おまけ。
# screenNo	wid	sq	top	(current screen or not) (focus or not)

# 0 65011715 7 top current focus
# 0 69206238 6 current middle
# 0 73400520 2 bottom current
# 1 79691789 5 top
# 1 50331661 4 middle
# 1 73400323 3 bottom

