#!/bin/sh
# platform ... devuan dash
# GPL_3+
cat << 'EEE' > /dev/null
/* trigger.sh ... detect mouse action. bourne-shell script.
 * Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

#set -u	# not allow null vars. (echo "$asdf" ... err.)
bk_lcl=`set`
export LC_ALL=C
export LANG=C
# pf1='( eval "$bk_lcl" ; cat - )'		#  ... | eval "$pf1"

#optcheck--------
buf=$(cat << 'END'
#  opt	dfl type	( +additional command you want to test opt string)	
	-h	0	bool
	-v	0	bool	'#E vflg="$opt_v"'
	-p	3	int		'[ $opt_p -gt 0 ]'	'#E itv_pol="$opt_p"'
	-r	5	int		'[ $opt_r -gt 0 ]'	'#E itv_xdo="$opt_r"'

#	-b	"vvv"	str	'[ "$opt_b" != "bob" ]'
END
)
buf=`./ckopt "$buf"`
eval "$buf"

if [ "$opt_h" = "1" ] ; then
cat << 'EEE'
HowTo (trigger.sh. bourne-shell script)
opt: -h, -r(estart inerval), -p(olling interval), -v(erbose)
------
ex.) ~$ trigger.sh 	#	( -r 5 -p 3) >> dfl option
>>> (wid)65011951
>>> (3sec after) polling 3

output
	'xdotool search . behave %@ mouse-enter getmouselocation'
	'xdotool search . behave %@ focus getmouselocation'
	'echo "polling 3 sec"'

xdotool cant get new windows. restart every 5 seconds.
output polling msg every 3 sec.
0 sec is invalid. set big number. 
EEE
exit 0
fi

#	func_banzai -i 1 -o 3 -t $itv_xdo \
#		-sm '	echo "mousefocus $pid hw"	' \
#		-im '	echo "mousefocus $pid $msg"	' \
#		-em '	echo "mousefocus $pid gw"	' \
#		-df 0	\
#		-c "echo aaa"
# ディスクリプタ指定 iは親に、oは外部に sm im emはstartmsg, inter, end -c ループコマンド -t 再起動タイム
# -m ...メッセージ系。df チェックフラグ

func_banzai() {
(
	( sleep 1000 ) &
	buf=$!
	pid=`ps -p $buf -o pid,ppid | grep $buf | awk '{print $2}' `
	kill -9 $buf
	wait $buf
	ppid=`ps -p $pid -o pid,ppid | grep $pid | awk '{print $2}' `

while [ $# -ne 0 ]
	do
	if [ "$1" = "-o" ] ; then	#output
		shift
		d_out="$1"
		shift
		continue
	fi
	if [ "$1" = "-i" ] ; then	# infofd
		shift
		d_info="$1"
		shift
		continue
	fi
	if [ "$1" = "-t" ] ; then
		shift
		t="$1"
		shift
		continue
	fi
	if [ "$1" = "-c" ] ; then
		shift
		cmd="$1"
		shift
		continue
	fi
	if [ "$1" = "-sm" ] ; then
		shift
		smsg="$1"
		shift
		continue
	fi
	if [ "$1" = "-em" ] ; then
		shift
		emsg="$1"
		shift
		continue
	fi
	if [ "$1" = "-im" ] ; then
		shift
		imsg="$1"
		shift
		continue
	fi
	if [ "$1" = "-df" ] ; then
		shift
		deadflg="$1"
		shift
		continue
	fi
done

# start msg
	eval "$smsg"
		test "$?" = "0" || exit 1
	
	while :
	do
		err=0
		msg=""
		errmsg=""
		
# 起動
		eval "$cmd &"
		cpid=$!
# 首輪も起動.
		( sleep $t
		kill -0 "$cpid" >/dev/null 2>&1
		if [ "$?" = "0" ] ; then
			./killtree -s KILL "$cpid"
			exit 0
		else
			exit 1
		fi ) &
		wait $!
		# 死ぬ要素はパイプ先が閉じてる.
		err=$?	# 殺す前に死んでたら1 ... 多分パイプ先。...以外にも自滅とかもありえるから、一応メモ。
			test err = "0" || errmsg="info: $cpid is already dead. err=1"
		if [ "$deadflg" = "0" ] &&  [ "$err" = "1" ] ; then
# xdotoolでfocusがたまに勝手に死んでる。エラーを吐いて落ちてる。スキップフラグを追加。
# mouse以外にもdocusでxdoがよく自害してる。基本的にdeadflgは全て0で、パイプ先は個別に調査した方がいい。
			err=0
			msg="info: $cpid is already dead, but flg=0. err=0"
			( eval "$imsg" ) 2>/dev/null
		fi

# commander ck	後は自分の身の振り方
		msg="info: ping"
		( eval "$imsg" )	# ping. built-inは失敗で本体ごと落ちる奴が多い。ラップしとく。
			test "$?" = "0" || err=1	#司令部が死んでる。自害。

# output ck
		( printf '\n' ) >&$d_out 2>/dev/null	# 出口が死んでる。自害。
			test "$?" = "0" || errmsg="info: output discriptor destroied? err=1"
	
# suicide
		if [ "$err" = "1" ] ; then
			# どっかが死んでた。遺書と自害。
			msg="$errmsg"
			( eval "$imsg" ) 2>/dev/null
			( eval "$emsg" ) 2>/dev/null
			exit 1
		fi
	
# 正常なら報告と再ループ
		msg="info: timeup. $t sec. loop."
		eval "$imsg"
		sh -c ''	#while内のゾンビ対策。サブシェルを実行すると何故か消える。chldがとぶっぽい。
	done
)
}

func_commander() {
(
	# 自分の正確なpidを取得
	( sleep 1000 ) &
	buf=$!
	mypid=`ps -p $buf -o pid,ppid | grep $buf | awk '{print $2}' `
	kill -9 $buf
	wait $buf
	
	while read -r tag pid msg
	do
		echo "commander_info$mypid@ $tag $pid $msg" >&2
		# 元締めからの直々の挨拶 origin. pstreeが表示が楽になる。蜘蛛の子が散らない
		if [ "$tag" = "origin" ] && [ "$msg" = "hw" ] ; then 
			cmd_balse="( sleep 1 ; ./killtree -s KILL $pid ) &"
		fi	
		if [ "$msg" = "gw" ] ; then	#goodbye world
			break
		fi
	done
	
	# ... signal系が来たら多分落ちる。readはioブロッキングだけど伝統的に
	# sigを受けたら再開しない。歴史的に。c言語なら再開してくれるんだけど。RA_RESTART
	# 嫌ならwhile : でラップする。
	echo "commander_info$mypid@ allkill" >&2
	echo "" >&2
	eval "$cmd_balse"
	exit
)
}



#--main

infoout="/dev/null"
# infoout="/dev/pts/4"
if [ "$vflg" = "1" ] ; then
	infoout="/dev/stderr"
fi
oldfocus=""
oldover=""

# 肝。ディスクリプタ複製で複数メッセージラインを確保。双方向のラインも作成可能。
# ここでは現場から司令への一通メッセージと一般出力の二つ。司令から現場へは無い。
# 双方向を使いたいならexecで予約。 echo sss | ( exec 5>&1 ; echo aaa | read a ... echo bbb >&5 )
(
	( sleep 1000 ) &
	buf=$!
	pid=`ps -p $buf -o pid,ppid | grep $buf | awk '{print $2}' `
	kill -9 $buf
	wait $buf
	opid=$pid		#origin. 群全体の元締め。いるだけで何もしない。旗。pstreeで一覧が分かりやすい。
		# stopはcat - を殺すのが多分スマート。出口が死ねばみんな死ぬロジックにしてある。
		# commanderメッセージはstderrを何とかかんとか。
	(
	(
	echo "origin $opid hw"
	func_banzai -i 1 -o 3 -t $itv_xdo \
		-sm '	echo "mouseenter $pid hw"	' \
		-im '	echo "mouseenter $pid $msg"	' \
		-em '	echo "mouseenter $pid gw"	' \
		-df 0	\
		-c "xdotool search . behave %@ mouse-enter getmouselocation >&3 2>/dev/null" &

			# ck dead flg. focus... errdown if exit button pushed. bug?
#		-c "( xdotool search . behave %@ mouse-enter getmouselocation | 
#			func_editxdo menter ) >&3 2>/dev/null" &
	buf=$(cat <<- 'EEE'
xdotool search . behave %@ focus exec --sync xprop -root 32x ' @f@ $0\n' _NET_ACTIVE_WINDOW >&3 2>/dev/null
EEE
)
	func_banzai -i 1 -o 3 -t $itv_xdo \
		-sm '	echo "mousefocus $pid hw"	' \
		-im '	echo "mousefocus $pid $msg"	' \
		-em '	echo "mousefocus $pid gw"	' \
		-df 0	\
		-c "$buf" &
		# mouselocationとfocusで出力を変える。直接は難しいか。execでごまかす。focusは頻繁には変わらん。
		# time sh -c 'printf "ff " ; xdotool getmouselocation' ... 7ms
		# xdotool search . behave %@ focus exec sh -c 'xdotool getactivewindow' こっちがいいか。
		# xprop -root 32x '\t$0' _NET_ACTIVE_WINDOW		標準系。こっちの方がオーバーヘッドは少なそう。
		# したは3ms程度。上は8ms程度。
		# 下にすっか。
		# xdotool のexecがゾンビを作りまくる。trapでIGN設定か？...xdoには効かないみたい。
		# 別の方法。。。syncはどうだろ。。。 >> 正解。waitするみたい。
		
#		-c "( xdotool search . behave %@ focus getmouselocation |
#			func_editxdo mfocus ) >&3 2>/dev/null" &
	
	func_banzai -i 1 -o 3 -t $itv_pol \
		-sm '	echo "polling $pid hw"	' \
		-im '	echo "polling $pid $msg"	' \
		-em '	echo "polling $pid gw"	' \
		-df 0	\
		-c "echo 'polling $itv_pol' >&3 2>/dev/null ; sleep $((itv_pol + 2))" &
	
	#dummy
	# 存在しない場合はサブシェルがexit0なのでbanzai達がinit1の子になる。
	# ダミーを回せば縛っておける？
	while : ; do sleep 10 ; done

	) | func_commander ) 2> $infoout 3>&1 | while read aa bb
	do
		# ブランクは無視
		test "$aa" != "" || continue

		# pollは無条件許可
		if [ "$aa" = "polling" ] ; then
			echo "$aa $bb"
			continue
		fi

		# focus系.execで加工しといた。オーバーヘッドがかかる.結局mousegeoの出力をかえなきゃ判別できない。
		if [ "${bb%% *}" = "@f@" ] ; then
			buf=${bb##*@f@ }
			buf=`printf '%d' $buf`
				test "$buf" != "$oldfocus" || continue
			echo "$buf xdofocus"
			oldfocus="$buf"
			continue
		fi
		
		# over系。widだけチェック。focusはoverでも変わったら欲しい。
		bb=${bb##*:}
			test "$bb" != "$oldover" || continue
		echo "$bb xdoover"
		oldover="$bb"
	done | cat -
)
