#!/bin/sh
# platform ... devuan dash
# GPL_3+
cat << 'EEE' > /dev/null
/* widgrub.sh ... X window id search/filter. bourne-shell script.
 * Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

# normalize. locale etc.
set -u	# not allow null vars. (echo "$asdf" ... err.)
bk_lcl=`set`
export LC_ALL=C
export LANG=C

func_disp() {
(	
	# normal msg
	if [ "$#" = "0" ] ; then	
		( eval "$bk_lcl" ; cat - )
	return 0 ; fi
	
	# err msg
	if [ "$#" = "1" ] && [ "$1" = "-e" ] ; then	
		( eval "$bk_lcl" ; cat - ) >/dev/stderr
	return 0 ; fi
	
	# info
	if [ "$#" = "1" ] && [ "$1" = "-v" ] && [ "$opt_v" = "1" ]; then	
		( eval "$bk_lcl" ; cat - ) >/dev/stderr
	return 0 ; fi
	if [ "$#" = "1" ] && [ "$1" = "-v" ] && [ "$opt_v" != "1" ] ; then
	return 0 ; fi

	# err stop
	if [ "$#" -ge "2" ] && [ "$1" = "-E" ] ; then	
		printf '%s\n' "$2" | ( eval "$bk_lcl" ; cat - ) >/dev/stderr
		while :	; do sleep 1000 ; done
		#	mysrc.sh: optErr see -h. sleep 1000  ...etc
	exit 1 ; fi
	
	# others. -e -E -v
	func_disp -E "$0: 'func_disp()' syntax err ($*)" 
)
}


	
#optcheck--------
buf=`./rdopt "hf:i:svp:TS:" "$@"`
eval "$buf"


if [ "$opt_s" = "1" ] ; then
cat << EEE | func_disp
#----------- sample

### Display wid under the window
~$ cat sample1.ini
mouseover=1
comment="helloworld"
---

~$ widgrub.sh -f sample1.ini
>>> (push enter)
>>> 12345 helloworld


#### Display wid if (process=terminal && stack top && focused && not mouseover)
~$ widgrub.sh -i '
	# appname ... check WM_CLASS using xprop. first atom.
appname="xfce4-terminal"
stack="top"
focus=1
mouseover=0
---
'
>>> (push enter)
>>> 12345	(if window satisfy the conditions)


### multi (app=terminal && stack_top)  ||  ( app=firefox && focus )
~$ cat sample3.ini
stack="top"
appname="xfce4-terminal"
comment="term_hit"
---
comment="ff_detect"
appname="firefox"
focus=1
---

~$ widgrub.sh -f sample3.ini
>>> (push enter)
>>> 12345 term_hit	(if term is top window)
>>> 3333 ff_detect	(if firefox window focused)




#----- support command is as follows
	
 # foo	... linetop '#' means comment
 fullsearch=0	...0(def): wmctrl -l / 1(slow): xdotool search .
 appname="mousepad"	... WM_CLASS first atm. check xprop. exact match.
 wid=1234	... 1234, 0x3333 etc.
 mouseover='1'		...0 or 1 
 stack=top		...top/middle/bottom. window stack position.
 focus="1"		...0 or 1
 prop_name=WM_CLASS	... xprop _NET_WM_PID | grep "prop_data" etc
 prop_data='some123' ...single quote (raw literal. you cant use ')
 prop_name="WM_NAME"
 prop_data=title		...'prop' allows multi setting. 

 comment="abcde\n123"	...double quote (printf style. you cant use " )
 ---		... separator. 3-char hyphen.

## prop_name and prop_data are pair commands. set prop_name -> prop_data
## prop_name:	Exact name required. see 'xprop'	>> WM_CLA ... NG
## prop_data:	allow imperfect string.		>> firefo ... OK
## ...prop_name uses 'xprop' and prop_data uses its right hand string (grep).
EEE
	exit 0
fi


if [ "$opt_T" != "" ] ; then
opt_i=$(cat << 'EEE'
# prop_name=123
# prop_data=hhh
# prop_name='1234'
# prop_data=hhh@
# wid=1234	/ wid="input"
# stack="top"
# mouseover=1
# focus=1
# comment='unokk\012ko'		#... raw literal
# appname=aaa
# fullsearch=1

##prop_name=123
##prop_data='wer\n`ls`'
#comment="\062\060\071 _@@@"
#wid=1234
#stack='top'
#
#mouseover=1
#---
#comment="ovwindow\062@"
#mouseover=1
#---
##comment="ovwindow\062@"
##prop_name=WM_CLASS
##prop_data=termi
##fullsearch=1
#---
#comment="o@@vwindow\062@"
#appname="xfce4-terminal"
#fullsearch=1
#---

appname="xfce4-terminal"
mouseover=1
focus=1
comment="term_m1f1"
---
appname="xfce4-terminal"
mouseover=0
focus=1
comment="term_m0f1"
---
appname="xfce4-terminal"
focus=0
comment="term_f0"
---

EEE
)
fi



# ck opt_i is set or not at (-i '...' )
if [ "${opt_i+have}" = "have" ]  ; then
	ini="$opt_i"
fi
if [ "${opt_f+have}" = "have" ]  ; then
	ini=`cat "$opt_f"`
fi



if [ "$opt_h" = "1" ] || [ "$#" != "0" ] ; then
cat << 'EEE' | func_disp
HowTo (widgrub.sh X window id searcher/filter. bourne-shell script)
opt: -h, -i(ni), -f(ile, inifile), -v(erbose), -s(ample inifile), -S(ignal)
------
eg.) ~$ widgrub.sh -i 'mouseover=1 (newline) ---'
   >>>	(push enter) 1234 ... disp wid
...	When you run widgrub , it enters the standby state. If there is any
	stdin(trigger), output wid that matches the setting condition.

   # foo	... linetop '#' means comment
   fullsearch=0	...0(def): wmctrl -l / 1(slow): xdotool search .
   appname="mousepad"	... WM_CLASS first atm. check xprop. exact match.
   wid=1234	... 1234, 0x3333 etc.
   mouseover='1'		...0 or 1 
   stack=top		...top/middle/bottom. window stack position.
   focus="1"		...0 or 1
   prop_name=WM_CLASS	... xprop _NET_WM_PID | grep "prop_data" etc
   prop_data='some123' ...single quote (raw literal. you cant use ')
   comment="abcde\n123"	...double quote (printf style. you cant use " )
   ---		... separator. 3-char hyphen.

eg.) ~$ widgrub.sh -f myfile.ini -v	#>>>	read from file. see -s.
this pg uses wmctrl/xdotool/xprop. install plz.
EEE
exit 0
fi
if [ "${ini:+exist}" != "exist" ] ; then
	func_disp -E "$0: not found -i/-f opt. see -h. sleep 1000"
fi


if [ "${opt_p:+e}" = "" ] ; then
	opt_p=5	# polling interval sec
fi
itv="$opt_p"

printf '%d' "$itv" >/dev/null 2>&1
	test "$?" = "0" || ( func_disp -E "$0: err. subargs of -p is not num. sleep 1000" )

# signal test
if [ "${opt_S:+e}" = "" ] ; then
	opt_S="USR1"
fi
sgn="$opt_S"

buf=0
trap 'buf=123' $sgn
kill -$sgn $$	# kill -USR1 $$
if [ "$buf" = "0" ] ; then
	echo "$0: err. this pg uses signal. signal $sgn test failed." >/dev/stderr
	echo "	enable $sgn or use option '-S USR2' or other." >/dev/stderr
	exit 1
fi
trap - $sgn



# func_listprs "$ini" ... make cmd from ini
func_listprs(){

# 入力処理の前に順番を自動整形。prop系は最後に、commentはラスト。入力からfunciniを自動検索
# 要素から負荷の少ない順にfilterしていくため。

inlist=`printf '%s\n' "$1" | awk '$1 !~ /^#/ && $1 != "" {print $0}'`
buf=`printf '%s\n' "$inlist" | sed -e 's/=.*//g' | tr -d ' \t' | tr '\n' ' ' `
set -- $buf
	test $# != 0 || return
sqlist=""	# フィルター順マーカーをつける
for ii 
do
	bk="$PATH"
	PATH=""
	buf=`eval 'funcini_'"$ii -z" 2>/dev/null `	#funcini_wid -z ...rtn 0
	rtn="$?"
	PATH="$bk"
		test "$rtn" = "0" || ( func_disp -E "$0: err. invalid atom. ($ii)" )
	sqlist=`printf '%s\n%s\n' "$sqlist" "$buf $ii" `
done
sqlist=`printf '%s\n' "$sqlist" | awk '$1 != "" {print $0}'`
# 2 wid		...みたいな。速度とfunc名


#列連結	2 wid ---  wid=1234 ... 2 wid=1234
buf=`printf '%s\n' "$inlist" | sed -ne 's/=.*//p' | tr -d ' \t' | tr '\n' ' ' `
# widなどのラベル達
for ii in $buf
do
	buf=`printf '%s\n' "$inlist" | sed -ne '1p' `
	buf="${buf#*=}"
	buf=`printf '%s\n' "$sqlist" | sed -ne '1p'`"=$buf"
	sqlist=`printf '%s\n' "$sqlist" | sed -ne '1!p' `
	inlist=`printf '%s\n' "$inlist" | sed -ne '1!p' `
	inlist=`printf '%s\n%s\n' "$inlist" "$buf" `	#ところてん。
done
inlist=`printf '%s\n' "$inlist" `

#	z prop_name=123				1 wid=1234
#	z prop_name='wer\n`ls`'     2 mouseover=1 
#	1r comment="unokkko"        5 stack="top"
#	1 wid=1234            >>>   z prop_name=123
#	5 stack="top"               z prop_name='wer\n`ls`'
#	2 mouseover=1               1r comment="unokkko"

# sort. top list middle ついでに=をとっぱらって wid 1234形式に。
inlist=`printf '%s\n' "$inlist" | ( 
l_tl=""
l_ml=""
l_bl=""
while read -r aa
do
	buf="${aa%% *}"
	if [ "$buf" != "${buf%z}" ] ; then
		l_ml=$(printf '%s\n%s' "$l_ml" "$aa")
	elif [ "$buf" != "${buf%r}" ] ; then
		aa="${buf%?} ${aa#* }"
		l_bl=$(printf '%s\n%s' "$aa" "$l_bl")
	else
		printf '%b' "$aa" >/dev/null 2>&1
			test "$?" = "0" || ( func_disp -E "$0: bag. funcini rtn invalid ($aa)" )
		l_tl=$(printf '%s\n%s' "$aa" "$l_tl")
	fi
done
printf '%s\n' "$l_tl" | sort -n
printf '%s\n' "$l_ml"
printf '%s\n' "$l_bl" | sort -nr
) | awk '
$1 != "" {
	$1=""
	sub(/^ /,"", $0)
	sub(/=/," ", $0)
	print $0}' `

# 並べ替え完了なので出力。whileサブシェルなので << を使う。 done << EEE
# ヒアは'EEE'なら無展開、EEEなら展開。EEE $aaa EEE ---"$aaa" みたいな感じ。
while read -r lhs rhs	# right hand side
do
	# right ck
	
	# '系
	arg=""
	buf="${rhs#'*}"	# '123' etc
	if [ "$buf" != "$rhs" ] ; then		# str mode '123' etc
		buf="${rhs#'*'}"	# '123' etc
			test "$buf" != "$rhs" || ( func_disp -E "$0: err. invalid data. ($rhs)" )
		buf="${rhs%%$buf}"		# '123'	... omit '...' #q234
#		printf '@@_@%s\n' "$buf"
#			test "$buf" = "$aa" && ( func_disp -E "$0: err. invalid quote format ($aa)" )
		buf="${buf#?}"	#	123'
		buf="${buf%?}"	#	123
		arg="$buf"
	fi
	
	# "系
	exp='"*'	#	${rhs#"} ...展開されるのを防ぐため一旦放り込む
	buf="${rhs#$exp}"	# "123\t@@" etc
	if [ "$buf" != "$rhs" ] ; then		# printf mode
		exp='"*"'
		buf="${rhs#$exp}"	# '123' etc
			test "$buf" != "$rhs" || ( func_disp -E "$0: err. invalid data. ($rhs)" )
		buf="${rhs%%$buf}"		# 尻尾は切り落とす。#は無くてもdelされる
		# dqが必要なのは単なる文字列として扱いたい
		buf="${buf#?}"	#	12\3"
		buf="${buf%?}"	#	12\3
		arg=`printf '%b' "$buf"`	#	printf '12\3'
	fi

	# クォート無し系の始末. 適当に分割して尻尾は無視
	if [ "$arg" = "" ] ; then
		buf=`printf '%s\n' "$rhs" | tr '\t' ' '`
		arg="${buf%% *}"	#	123
	fi
	# filterとborder系作成. -z系のためにダミーの-gを
	funcini_"$lhs" -g "$arg"
done << EEE
$inlist
EEE
}
#	...でfuncini内部でfilterとborderが追加処理される.global変数



filter=""
border=""
xdoopt=""
g_needs=""
# funciniのルール ... -zがきたら優先度を返す。-3 0 41 z 200rなど
#	普通の数値は小さい方が強い。単体実行のms数値が適当。rtnとborderに。
#	zは触らないで欲しい、postfixのrは尻尾から。${buf##*[!rz]}で。
#	filter..echo 1234 | grep...系と,頭の場合の二通りを。
#	共通系で使いそうな変数はg_needsに登録。 wid_focusなど。組み立て時に共通化する。

funcini_fullsearch () {
# global
	if [ "$1" = "-z" ] ; then echo 125 ; return 0 ; fi
	shift
	
	if [ "$1" = "1" ] ; then
		border=`printf '900 fullsearch\n%s\n' "$border"`
	fi
	if [ "$1" != "0" ] && [ "$1" != "1" ] ; then
		func_disp -E "$0: err. invalid command value. (fullsearch=$1)"
		exit 1
	fi
}


funcini_wid () {
# global
	if [ "$1" = "-z" ] ; then echo 3 ; return 0 ; fi
	shift
	
	printf '%d' "$1" >/dev/null 2>&1
		test "$?" = "0" || ( func_disp -E "$0: err. invalid command value. (wid=$1)" )
	buf=$(($1 + 0))
	filter="$filter | grep $buf"
	border=`printf '3 %s\n%s\n' "echo $buf" "$border"`
}

funcini_mouseover () {
	# xdotool getmouselocation で取得可能
	if [ "$1" = "-z" ] ; then echo 5 ; return 0 ; fi
	shift

	printf '%d' "$1" >/dev/null 2>&1
		test "$?" = "0" || ( func_disp -E "$0: err. invalid command value. (mouseover=$1)" )

	buf=$(($1 + 0))
	g_needs="$g_needs wid_mouseover"
	if [ "$buf" = "1" ] ; then
		filter="$filter | "'grep $wid_mouseover '
		border=`printf '5 %s\n%s\n' 'echo $wid_mouseover' "$border"`
	fi
	if [ "$buf" = "0" ] ; then
		filter="$filter | "'grep -v $wid_mouseover '
		border=`printf '125 %s\n%s\n' 'xdotool search .' "$border"`
	fi
}

funcini_focus () {
# time xdotool getwindowfocus	
	if [ "$1" = "-z" ] ; then echo 7 ; return 0 ; fi
	shift

	printf '%d' "$1" >/dev/null 2>&1
		test "$?" = "0" || ( func_disp -E "$0: err. invalid command value. (focus=$1)" )

	g_needs="$g_needs wid_focus"
	buf=$(($1 + 0))
	if [ "$buf" = "1" ] ; then
		filter="$filter | "'grep $wid_focus '
		border=`printf '7 %s\n%s\n' 'echo $wid_focus' "$border"`
	fi
	if [ "$buf" = "0" ] ; then
		filter="$filter | "'grep -v $wid_focus '
		border=`printf '125 %s\n%s\n' 'xdotool search .' "$border"`
	fi
}


# class name pidはxdotoolが必須。propでもいけるけど超遅くなる
# 後処理が必要になるけどしょうがない。単体でできればなぁ。
# 一応できるのか。ばらしてwhileにかけるとか。遅くなりそう。
# 基本はwmctrlにすることで数を絞ってフィルターで改善
funcini_appname () {
	if [ "$1" = "-z" ] ; then echo 80 ; return 0 ; fi
	shift
	
	buf=`printf '%s' "$1" | sed -e "     
	s#'#'\"'\"'#g
	1 s/^/'/g
	$ s/$/'/g
	"`
	filter="$filter "'| while read a
	do
		buf=`xprop -id $a '"'"'@@$0\n'"'"' WM_CLASS 2>/dev/null`
		buf=${buf#*@@}
		buf=${buf#?}
		buf=${buf%?}
		test "$buf" = '"$buf || continue"'
		echo $a
	done'
	border=`printf '80 %s\n%s\n' 'xdotool search --classname '"$buf" "$border"`
}

#	stack系
funcini_stack () {
	if [ "$1" = "-z" ] ; then echo 10 ; return 0 ; fi
	shift
	
	buf=`echo "$1" | tr '[:upper:]' '[:lower:]'`
	
	g_needs="$g_needs wid_top wid_bottom wid_middle"
	if [ "$buf" != "top" ] ; then
		filter="$filter | "'grep $wid_top'
		border=`printf '10 %s\n%s\n' 'echo "$wid_top"' "$border"`
	fi
	if [ "$buf" = "bottom" ] ; then
		filter="$filter | grep "'$wid_bottom'
		border=`printf '10 %s\n%s\n' 'echo "$wid_bottom"' "$border"`
	fi
	if [ "$buf" = "middle" ] ; then
		filter="$filter | "'grep -v $wid_top | grep -v $wid_bottom'
		border=`printf '10 %s\n%s\n' 'echo "$wid_middle"' "$border"`
	fi
}

# propは特殊。複数回でるかも。name -> dataの順。
prop_flg=0
funcini_prop_name () {
	if [ "$1" = "-z" ] ; then echo z ; return 0 ; fi
	shift
	test "$prop_flg" = "0" || ( func_disp -E "$0: err. 1.prop_name -> 2.prop_data" )
	prop_flg="$1"	#WM_CLASSなど
}

funcini_prop_data () {
	if [ "$1" = "-z" ] ; then echo z ; return 0 ; fi
	shift
	test "$prop_flg" != "0" || ( func_disp -E "$0: err. 1.prop_name -> 2.prop_data" )

	buf=`func_pfout "$prop_flg" "$1" `
	filter="$filter | $buf "
	border=`printf '125 %s\n%s\n' 'xdotool search .' "$border"`
	prop_flg=0
}

funcini_comment () {
	if [ "$1" = "-z" ] ; then echo 1r ; return 0 ; fi
	shift
	buf=`printf '%s' "$1" | sed -e "     
	s#'#'\"'\"'#g
	1 s/^/'/g
	$ s/$/'/g
	"`
	border=`printf '125 %s\n%s\n' 'xdotool search .' "$border"`
	filter="$filter | awk -v cmt=$buf '{print "'$0 " " cmt}'"'"
}


# func_pfout 'accurate propname' 'grepdata'
# 泥臭いけどxpropでsed+grep. xprop -root 32x '\t$0' _NET_ACTIVE_WINDOW
# 系で取り出すのも可能だけど、ユーザーに負担がかかる。xprop標準から見た方がいい。

func_pfout() {
	
#--- out sample
#	... | ( prop_name='123' ; prop_data='hhh'
#	while read aa
#	do
#		buf=$(xprop -id "$aa" '@@$0+\n' "$prop_name" 2>/dev/null)
#		ck_err=$?
#		ck_data=$(printf '%s\n' "${buf#*@@}" | grep "$prop_data" )
#		if [ "$ck_err" = "0" ] && [ "$ck_data" != "" ] ; then
#			printf '%s\n' "$aa"
#		fi
#	done )
#	prop系はxpropから取得するしかない。文字列取得タイプなのでごちゃごちゃしてる。

# xprop WM_CLASS -id 1234 ...
# WM_CLA:  no such atom on any window.
# WM_CLASS(WINDOW):  111 222
# WM_CLASS(STRING) = "xfce4-terminal", "Xfce4-terminal"
# エラーを標準に吐き出すクソ仕様。フォーマット指定

buf="s#'#'\"'\"'#g
1 s/^/'/g
$ s/$/'/g"
(
	pname=`echo "$1" | sed -e "$buf"`
	pdata=`echo "$2" | sed -e "$buf"`
	buf=`cat << 'EEE'
while read aa
do
	buf=$(xprop -id "$aa" '@@$0+\n' "$prop_name" 2>/dev/null)
	ck_err=$?
	ck_data=$(printf '%s\n' "${buf#*@@}" | grep "$prop_data" )
	if [ "$ck_err" = "0" ] && [ "$ck_data" != "" ] ; then
		printf '%s\n' "$aa"
	fi
done )
EEE
`
	printf '%s\n%s' "( prop_name=$pname ; prop_data=$pdata" "$buf"
)
}

# eval 単体で50ms程度。少し思いか.共通系作成用。
func_gneeds() {
(
# stack系
buf=`echo "$@" | grep wid_top`
if [ "$buf" != "" ] ; then
	cat <<- 'EEE'
	buf=`./show_stack.sh | awk '$1 == 0 {print $0}'`
	wid_top=`echo "$buf" | awk '$0 ~ /top/{print $2}'`
	wid_bottom=`echo "$buf" | awk '$0 ~ /bottom/{print $2}'`
	wid_middle=`echo "$buf" | awk '$0 ~ /middle/{print $2}'`
	EEE
fi

# awkとどっちが早いかな。20ms程度で5ms程度早いけど、スパなので却下。
# if [ "$buf" != "" ] ; then
# 	cat <<- 'EEE'
# 	buf=`./show_stack.sh | awk '
# 	BEGIN { buf="" }
# 	$1 != 0	{ next }
# 	$0 ~ /top/	{print "wid_top=" $2}
# 	$0 ~ /middle/	{buf=buf " " $2}
# 	$0 ~ /bottom/	{print "wid_bottom=" $2}
# 	END {
# 		sub(/ /, "", buf)
# 		gsub(/ /, "\n", buf)
# 		print "wid_middle=\042" buf "\042" }'`
# 	EEE
# fi

# stack系以外。残り
for ii
do
	if [ "$ii" = "wid_mouseover" ] ; then
		cat <<- 'EEE'
		wid_mouseover=`xdotool getmouselocation | tr ':' ' ' | awk '{print $NF}'`
		EEE
		continue
	fi
	if [ "$ii" = "wid_focus" ] ; then
		cat <<- 'EEE'
		wid_focus=`xprop -root '\t$0\n' _NET_ACTIVE_WINDOW | awk '{printf("%d\n",$2)}'`
		EEE
		continue
	fi
done
)
}





#-----main

block=""
border=""
filter=""
g_cmds=""
g_needs=""
#--- prs ini. use '<<' to save g_cmds data (avoid subshell probrem)
while read -r aa
do
	if [ "$aa" != "---" ] ; then
		block=`printf '%s\n%s\n' "$block" "$aa"`
		continue
	fi
	
	##### ---スプリッタ発見。一塊を処理。
	func_listprs "$block"
	# cmd組み立て. 先頭を決める

	# fullsearchが無ければ簡易サーチ高速化を追加。
	buf=`printf '%s\n' "$border" | awk '$2 == "fullsearch" {print $0}'`
	if [ "$buf" = "" ] ; then
		buf=`echo "$g_needs" | grep wid_top`
		if [ "$buf" != "" ] ; then
			border=`printf '15 %s\n%s\n' 'printf "%s\n%s\n%s\n" "$wid_top" "$wid_middle" "$wid_bottom"' "$border"`
		fi
	fi
	
	buf=`printf '%s\n' "$border" | sort -n | sed -ne '1p;q'`
	buf=${buf#* }
	# border + filter
	buf="$buf""$filter"
	
	# add & ... パッキング
	if [ "$buf" != "" ] ; then
		buf='( '"$buf"' ) & 2>/dev/null'
	fi
	# g_needsは全部終わってから
	g_cmds=`printf '%s\n%s\n' "$g_cmds" "$buf"`

	block=""
	border=""
	filter=""
done << EEE
$ini
EEE
# *************

# eval "$g_cmds"
# exit
# fgで100ms+...bgだと+40ms 程度。いけるか。
# つまり一回要求がくる度に40msかかる。
# wait allをかけるか？どっちでも。 かけるとpcへの負荷はへる。

# init wid_data 追加. 重複削除
buf=`printf '%s\n' "$g_needs" | tr ' ' '\n' | sort | uniq `
buf=`func_gneeds $buf`
g_cmds=`printf '%s\n\n%s\n' "$buf" "$g_cmds"`		# ...共通系を追加


# trap, lock追加. 内部処理が多分重いので行列禁止。散れ。
g_cmds="$g_cmds

: &		# for nullcmds, dummydata
wait
kill -$sgn"' $tgtpid'	# read待ちのpid
# exit


# info
(
	printf '%s\n\n###########\n' "$ini"
	printf '# Execute the following script every time when there is one line input\n'
	printf '###########\n\n'
	printf '%s\n#############\n' "$g_cmds"
) | func_disp -v



#---mainloop
(
# trap doesn't be helitated to subshell without IGN setting.
# get subshell(this) pid
( sleep 1000 ) &
buf=$!
tgtpid=`ps -p $buf -o ppid | awk 'NR == 2 {print $1}' ` # dub while pid
kill -KILL $buf

lockkey=0
skipflg=0
trap -- 'lockkey=0' $sgn

# readは敏感。sigでトラップすると環境によっては割り込み終了でrtn=1.
# rtn 1はeofとsigとで外部から見分けがつかない。
# trapでフラグ操作して身元を証明可能にしとく。...
# 否。eofは外が発行するから入力が閉じるはず。readで再テストすればいい。
# サブシェルで被っておけば、サブが終了か明示的に 0<&-しないかEOFがこない限り
# stdinは閉じない。


# while read aa ... see below. aa string s not used. on/off only
while :
do
	read aa
	if [ "$?" != "0" ] ; then
		# for check stdin is open or not. EOF ck
		if [ "$skipflg" = "1" ] ; then	# ラストがスキップされていたら再チェック。高速マウス移動とか。
			aa="skip_feedback"
		else
			read aa
			test "$?" = "0" || break
		fi
	fi
#	echo lock@$lockkey
	if [ "$lockkey" != "0" ] ; then
		echo "ignore input. search script is busy. lockkey=$lockkey" | func_disp -v
		skipflg=1
		continue
	fi
	
	skipflg=0
	lockkey=1	# if bg is complete, send USR1 >> trap lockkey=0
	( eval "$g_cmds" ) &
	sh -c ''	# wait zombi. bg process.
done ) | func_disp


#	( eval "$g_cmds" ) & ... send sigUSR1 to 'while loop'.
#	if shell waited at 'read', signal may destroy wait blocking(not restart io wait)
#	RA_RESTART sigaction is set by posix, but sigaction is relaied on 
#	apps.(B-shell, C-shell etc)
#	'read' comm returns 0 or 1+upper. shell rtn errno isnt exact.(EINER etc)
#	if get rtn 1(err), you cant judge if killed by signal /or get EOF from stdin.
#	so test 'read' for check if stdin(pipe, |) is open or not.
#	if get EOF, first 'read/shell' process close pipe input. close descripter (0<&-)
#	you will fail to next run 'read' cmd.
#	
#	 | 1----0 read ...  | 1<--EOFmsg-- read(get sig)  ...  | .close.(no ref).close. read
#	
