/*
 * Decompiled with CFR 0.152.
 */
package bits;

import bits.Clause;
import bits.IBooleanVariable;
import bits.IClause;
import bits.IProblem;
import bits.Problem;
import bits.exceptions.BitArraySingleClearerException;

public class BitArraySingleClearer
extends Problem
implements IProblem {
    public BitArraySingleClearer(IBooleanVariable[] array) throws Exception {
        if (array == null) {
            throw new BitArraySingleClearerException("Null array passed to constructor");
        }
        int bits = array.length;
        if (bits == 0) {
            throw new BitArraySingleClearerException("Array of length zero passed to constructor");
        }
        IProblem problem = Problem.newProblem();
        IClause clause = Clause.newClause();
        int i = 0;
        while (i < bits) {
            clause = clause.or(array[i]);
            ++i;
        }
        problem.addClause(clause);
        i = 0;
        while (i < bits) {
            int j = i + 1;
            while (j < bits) {
                problem.addClause(Clause.newClause().or(array[i]).or(array[j]));
                ++j;
            }
            ++i;
        }
        this.setClauses(problem.getClauses());
    }
}

