/*
 * Decompiled with CFR 0.152.
 */
package bits;

import bits.BitFixer;
import bits.BooleanLiteral;
import bits.Clause;
import bits.IBooleanVariable;
import bits.IClause;
import bits.IProblem;
import bits.Problem;
import bits.exceptions.BitExclusiveSelectorException;
import java.util.ArrayList;

public class BitExclusiveSelector
extends Problem
implements IProblem {
    public BitExclusiveSelector(ArrayList<IBooleanVariable> bitArrayList) throws Exception {
        this(bitArrayList.toArray(new IBooleanVariable[0]));
    }

    public BitExclusiveSelector(IBooleanVariable x, IBooleanVariable y) throws Exception {
        this(new IBooleanVariable[]{x, y});
    }

    public BitExclusiveSelector(IBooleanVariable x, IBooleanVariable y, IBooleanVariable z) throws Exception {
        this(new IBooleanVariable[]{x, y, z});
    }

    public BitExclusiveSelector(IBooleanVariable[] bitArrayList) throws Exception {
        IProblem problem;
        if (bitArrayList == null || bitArrayList.length == 0) {
            throw new BitExclusiveSelectorException("Null or empty partition passed to constructor.");
        }
        if (bitArrayList.length == 1) {
            problem = new BitFixer(bitArrayList[0], true);
        } else {
            int listSize = bitArrayList.length;
            BooleanLiteral.getBooleanLiteral(bitArrayList[0], false);
            problem = Problem.newProblem();
            IClause build1 = Clause.newClause();
            IBooleanVariable[] iBooleanVariableArray = bitArrayList;
            int n = bitArrayList.length;
            int n2 = 0;
            while (n2 < n) {
                IBooleanVariable curr = iBooleanVariableArray[n2];
                build1.add((BooleanLiteral)BooleanLiteral.getBooleanLiteral(curr, false));
                ++n2;
            }
            problem.addClause(build1);
            int i = 0;
            while (i < listSize) {
                BooleanLiteral curr = (BooleanLiteral)BooleanLiteral.getBooleanLiteral(bitArrayList[i], true);
                int j = i + 1;
                while (j < listSize) {
                    IClause build2 = Clause.newClause();
                    build2.add(curr);
                    build2.add((BooleanLiteral)BooleanLiteral.getBooleanLiteral(bitArrayList[j], true));
                    problem.addClause(build2);
                    ++j;
                }
                ++i;
            }
        }
        this.setClauses(problem.getClauses());
    }
}

