/*
 * Decompiled with CFR 0.152.
 */
package bits;

import bits.IClause;
import bits.IProblem;
import bits.Problem;
import bits.exceptions.ConjunctionException;
import java.util.ArrayList;

public class Conjunction
extends Problem
implements IProblem {
    private static IProblem and(IProblem[] p) throws Exception {
        if (p == null) {
            throw new ConjunctionException("Null IProblem array passed to and method.");
        }
        IProblem res = null;
        int i = 0;
        while (i < p.length) {
            if (p[i] != null) {
                if (res == null) {
                    res = Problem.newProblem();
                }
                int j = 0;
                while (j < p[i].numberOfClauses()) {
                    IClause c = p[i].getClause(j);
                    if (c != null && !res.contains(c)) {
                        res.addClauseVoid(c);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return res;
    }

    public Conjunction(ArrayList<IProblem> problemList) throws Exception {
        this(problemList.toArray(new IProblem[0]));
    }

    public Conjunction(IProblem problem) throws Exception {
        super.setClauses(problem.getClauses());
    }

    public Conjunction(IProblem p1, IProblem p2) throws Exception {
        this(new IProblem[]{p1, p2});
    }

    public Conjunction(IProblem p1, IProblem p2, IProblem p3) throws Exception {
        this(new IProblem[]{p1, p2, p3});
    }

    public Conjunction(IProblem p1, IProblem p2, IProblem p3, IProblem p4) throws Exception {
        this(new IProblem[]{p1, p2, p3, p4});
    }

    public Conjunction(IProblem[] group) throws Exception {
        IProblem p = Conjunction.and(group);
        if (p != null) {
            this.setClauses(p.getClauses());
        }
    }
}

