/*
 * Decompiled with CFR 0.152.
 */
package bits;

import bits.Conjunction;
import bits.Disjunction;
import bits.IProblem;
import bits.Problem;
import bits.ProblemDenier;
import bits.ProblemDifferencer;
import bits.exceptions.ExclusiveDisjunctionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExclusiveDisjunction
extends Problem
implements IProblem {
    public ExclusiveDisjunction(IProblem problem) throws Exception {
        this.setClauses(problem.getClauses());
    }

    public ExclusiveDisjunction(IProblem first, IProblem second) throws Exception {
        if (first == null || second == null) {
            throw new ExclusiveDisjunctionException("Null IProblem was passed to constructor.");
        }
        this.setClauses(new Disjunction(new ProblemDifferencer(first, second), new ProblemDifferencer(second, first)).getClauses());
    }

    public ExclusiveDisjunction(IProblem first, IProblem second, IProblem third) throws Exception {
        this(new IProblem[]{first, second, third});
    }

    public ExclusiveDisjunction(IProblem[] array) throws Exception {
        this(Arrays.asList(array));
    }

    public ExclusiveDisjunction(List<IProblem> list) throws Exception {
        if (list == null || list.size() == 0) {
            throw new ExclusiveDisjunctionException("Null IProblem was passed to constructor.");
        }
        if (list.size() == 1) {
            this.setClauses(list.get(0).getClauses());
        } else {
            IProblem problem1 = list.get(0);
            Problem problem2 = new Problem(problem1);
            int i = 1;
            while (i < list.size()) {
                problem2 = new Conjunction(problem2, new ProblemDenier(list.get(i)));
                ++i;
            }
            Problem problem3 = new ProblemDenier(problem1);
            ArrayList<IProblem> list2 = new ArrayList<IProblem>();
            int i2 = 1;
            while (i2 < list.size()) {
                list2.add(list.get(i2));
                ++i2;
            }
            problem3 = new Conjunction(problem3, new ExclusiveDisjunction((List<IProblem>)list2));
            Disjunction problem = new Disjunction(problem2, problem3);
            this.setClauses(problem.getClauses());
        }
    }
}

