/*
 * Decompiled with CFR 0.152.
 */
package bits;

import bits.BooleanLiteral;
import bits.Clause;
import bits.IBooleanLiteral;
import bits.IBooleanVariable;
import bits.IClause;
import bits.IProblem;
import bits.exceptions.UnsolvableProblemException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;

public class KSatReader {
    private Map<IBooleanLiteral, Integer> BL2sat4jLiteral = new HashMap<IBooleanLiteral, Integer>();
    private List<IBooleanLiteral> booleanLiterals = new ArrayList<IBooleanLiteral>();
    private List<IBooleanVariable> booleanVariables = null;
    private Map<IBooleanVariable, Integer> BV2sat4jVariable = new HashMap<IBooleanVariable, Integer>();
    private int numberOfLiterals = 0;
    private int numberOfVariables = 0;
    private Map<Integer, IBooleanLiteral> sat4jLiteral2BL = new HashMap<Integer, IBooleanLiteral>();
    private IBooleanVariable[] sat4jVariable2BV = null;
    private ISolver solver = null;

    public KSatReader(ISolver solver) {
        this.solver = solver;
    }

    public String decode(int[] dimacs) {
        Clause cl = new Clause();
        int i = 0;
        while (i < dimacs.length) {
            try {
                cl.add((BooleanLiteral)this.getBL(dimacs[i]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return ((Object)cl).toString();
    }

    public IBooleanLiteral getBL(int literal) {
        return this.sat4jLiteral2BL.get(new Integer(literal));
    }

    public List<IBooleanLiteral> getBooleanLiteralsArrayList() {
        return this.booleanLiterals;
    }

    public List<IBooleanVariable> getBooleanVariablesArrayList() {
        return this.booleanVariables;
    }

    public IBooleanVariable getBV(int variable) {
        return this.sat4jVariable2BV[variable - 1];
    }

    public int getNumberOfLiterals() {
        return this.numberOfLiterals;
    }

    public int getNumberOfVariables() {
        return this.numberOfVariables;
    }

    public int getSat4jLiteral(IBooleanLiteral il) {
        return this.BL2sat4jLiteral.get(il);
    }

    public int getSat4jVariable(IBooleanVariable ib) {
        return this.BV2sat4jVariable.get(ib);
    }

    public org.sat4j.specs.IProblem parseInstance(IProblem problem) throws UnsolvableProblemException {
        try {
            ArrayList<IBooleanVariable> bvArrayList = new ArrayList<IBooleanVariable>();
            int i = 0;
            while (i < problem.numberOfClauses()) {
                IClause clause = problem.getClause(i);
                if (clause != null) {
                    int j = 0;
                    while (j < clause.size()) {
                        IBooleanVariable bv = clause.getLiteralAt(j).getBooleanVariable();
                        if (!bvArrayList.contains(bv)) {
                            bvArrayList.add(bv);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.booleanVariables = bvArrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.numberOfVariables = this.getBooleanVariablesArrayList().size();
        this.sat4jVariable2BV = new IBooleanVariable[this.numberOfVariables];
        int i = 0;
        while (i < this.numberOfVariables) {
            this.BV2sat4jVariable.put(this.getBooleanVariablesArrayList().get(i), new Integer(i + 1));
            this.sat4jVariable2BV[i] = this.getBooleanVariablesArrayList().get(i);
            ++i;
        }
        i = 0;
        while (i < problem.getClauses().size()) {
            IClause currClause = problem.getClause(i);
            int j = 0;
            while (j < currClause.size()) {
                IBooleanLiteral currBL = null;
                try {
                    currBL = currClause.getLiteralAt(j);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!this.getBooleanLiteralsArrayList().contains(currBL)) {
                    this.getBooleanLiteralsArrayList().add(currBL);
                }
                ++j;
            }
            ++i;
        }
        this.numberOfLiterals = this.getBooleanLiteralsArrayList().size();
        i = 0;
        while (i < this.numberOfLiterals) {
            IBooleanLiteral currBL = this.getBooleanLiteralsArrayList().get(i);
            Integer objSat4jLiteral = new Integer((currBL.isBarred() ? -1 : 1) * this.getSat4jVariable(currBL.getBooleanVariable()));
            this.BL2sat4jLiteral.put(currBL, objSat4jLiteral);
            this.sat4jLiteral2BL.put(objSat4jLiteral, currBL);
            ++i;
        }
        this.solver.newVar(this.numberOfVariables);
        i = 0;
        while (i < problem.size()) {
            IClause currClause = problem.getClause(i);
            VecInt currIvi = new VecInt();
            int j = 0;
            while (j < currClause.size()) {
                IBooleanLiteral currBL = null;
                try {
                    currBL = currClause.getLiteralAt(j);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                currIvi.push(this.getSat4jLiteral(currBL));
                ++j;
            }
            try {
                this.solver.addClause(currIvi);
            }
            catch (ContradictionException e) {
                int[] d = new int[currIvi.size()];
                currIvi.copyTo(d);
            }
            ++i;
        }
        return this.solver;
    }

    public ArrayList<IBooleanLiteral> toBooleanLiterals(int[] dimacs) {
        ArrayList<IBooleanLiteral> cl = new ArrayList<IBooleanLiteral>();
        int i = 0;
        while (i < dimacs.length) {
            try {
                cl.add(this.getBL(dimacs[i]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return cl;
    }
}

