/*
 * Decompiled with CFR 0.152.
 */
package jdd.graph;

import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import jdd.graph.AttributeExplorer;
import jdd.graph.Edge;
import jdd.graph.Graph;
import jdd.graph.GraphIO;
import jdd.graph.Node;
import jdd.graph.NodeExtra3Comparator;
import jdd.graph.Tree;
import jdd.util.Test;
import jdd.util.math.Matrix;

public class ShortestPath {
    private static TreeSet initialize_single_source(Graph graph, Node node, boolean bl) {
        AttributeExplorer.setAllNodesExtra3(graph, Double.POSITIVE_INFINITY);
        if (bl) {
            AttributeExplorer.setAllNodesExtra1(graph, 0);
        }
        TreeSet<Node> treeSet = new TreeSet<Node>(NodeExtra3Comparator.nodeExtra3Comparator);
        treeSet.add(node);
        node.extra3 = 0.0;
        return treeSet;
    }

    public static Tree bellman_ford(Graph graph, Node node) {
        TreeSet treeSet = ShortestPath.initialize_single_source(graph, node, false);
        Tree tree = new Tree(graph);
        int n = graph.numOfNodes() - 1;
        for (int i = 0; i < n; ++i) {
            Enumeration enumeration = graph.getEdges().elements();
            while (enumeration.hasMoreElements()) {
                Edge edge = (Edge)enumeration.nextElement();
                if (!(edge.n2.extra3 > edge.n1.extra3 + edge.weight)) continue;
                edge.n2.extra3 = edge.n1.extra3 + edge.weight;
                tree.add(edge.n1, edge.n2);
            }
        }
        tree.extractTree();
        return tree;
    }

    public static Vector dijkstra(Graph graph, Node node) {
        TreeSet treeSet = ShortestPath.initialize_single_source(graph, node, true);
        Tree tree = new Tree(graph);
        while (!treeSet.isEmpty()) {
            Node node2 = (Node)treeSet.first();
            treeSet.remove(node2);
            node2.extra1 = 1;
            Edge edge = node2.firstOut;
            while (edge != null) {
                if (edge.n1.extra3 + edge.weight < edge.n2.extra3) {
                    edge.n2.extra3 = edge.n1.extra3 + edge.weight;
                    tree.add(edge.n1, edge.n2);
                    if (edge.n2.extra1 == 0) {
                        treeSet.add(edge.n2);
                    }
                }
                edge = edge.next;
            }
        }
        tree.extractTree();
        return tree;
    }

    public static Matrix floyd_warshall(Graph graph) {
        int n = 0;
        int n2 = graph.numOfNodes();
        Matrix matrix = new Matrix(n2, n2, Double.POSITIVE_INFINITY);
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            ((Node)enumeration.nextElement()).extra1 = n++;
        }
        for (int i = 0; i < n2; ++i) {
            matrix.set(i, i, 0.0);
        }
        Enumeration enumeration2 = graph.getEdges().elements();
        while (enumeration2.hasMoreElements()) {
            Edge edge = (Edge)enumeration2.nextElement();
            matrix.set(edge.n2.extra1, edge.n1.extra1, edge.weight);
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n2; ++k) {
                    double d = matrix.get(j, i);
                    double d2 = matrix.get(j, k);
                    double d3 = matrix.get(i, k);
                    matrix.set(j, k, Math.min(d2, d + d3));
                }
            }
        }
        return matrix;
    }

    public static void internal_test() {
        Test.start("ShortestPath");
        Graph graph = GraphIO.loadEdgeList("data/p596.pcg");
        Node node = graph.findNode("V1");
        Node node2 = graph.findNode("V2");
        Node node3 = graph.findNode("V3");
        Node node4 = graph.findNode("V4");
        Node node5 = graph.findNode("V5");
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                ShortestPath.dijkstra(graph, node);
            } else {
                ShortestPath.bellman_ford(graph, node);
            }
            Test.check(node.extra3 == 0.0, "ShortestPath Dijkstra/Bellman-Ford (1)");
            Test.check(node.extra3 < node4.extra3, "ShortestPath Dijkstra/Bellman-Ford (2)");
            Test.check(node4.extra3 < node5.extra3, "ShortestPath Dijkstra/Bellman-Ford (3)");
            Test.check(node5.extra3 < node2.extra3, "ShortestPath Dijkstra/Bellman-Ford (4)");
            Test.check(node2.extra3 < node3.extra3, "ShortestPath Dijkstra/Bellman-Ford (5)");
        }
        graph = GraphIO.loadEdgeList("data/p626.pcg");
        Matrix matrix = ShortestPath.floyd_warshall(graph);
        Test.check(matrix.get(0, 4) == 8.0, "floyd_warshall (1)");
        Test.check(matrix.get(2, 1) == -4.0, "floyd_warshall (2)");
        Test.check(matrix.get(4, 3) == -2.0, "floyd_warshall (3)");
        Test.check(matrix.get(2, 0) == -3.0, "floyd_warshall (4)");
        Test.end();
    }
}

