/*
 * Decompiled with CFR 0.152.
 */
package bits;

import bits.IBooleanLiteral;
import bits.IBooleanVariable;
import bits.exceptions.BooleanLiteralException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class BooleanLiteral
implements IBooleanLiteral {
    private static HashSet<IBooleanLiteral> instances = new HashSet();
    private boolean barred;
    private IBooleanVariable BV;

    public static IBooleanLiteral getBooleanLiteral(IBooleanVariable bv, boolean barred) throws BooleanLiteralException {
        if (bv == null) {
            throw new BooleanLiteralException("Null IBooleanVariable was passed to getBooleanLiteral method.");
        }
        Object[] inarray = BooleanLiteral.getInstances().toArray();
        int i = 0;
        while (i < inarray.length) {
            IBooleanLiteral nx = (IBooleanLiteral)inarray[i];
            if (nx.isBarred() == barred && nx.getBooleanVariable() != null && nx.getBooleanVariable().equals(bv)) {
                return nx;
            }
            ++i;
        }
        return new BooleanLiteral(bv, barred);
    }

    public static HashSet<IBooleanLiteral> getInstances() {
        return instances;
    }

    public static void interpret(List<?> list) throws BooleanLiteralException {
        if (list == null) {
            throw new BooleanLiteralException("Null List was passed to interpret method.");
        }
        int i = 0;
        while (i < list.size()) {
            IBooleanLiteral ibool = (IBooleanLiteral)list.get(i);
            try {
                ibool.load();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public static void listLiterals() {
        IBooleanLiteral[] ary = BooleanLiteral.getInstances().toArray(new BooleanLiteral[0]);
        List<IBooleanLiteral> lis = Arrays.asList(ary);
        Collections.sort(lis);
        System.out.println(lis);
    }

    public static void reset(List<?> list) throws BooleanLiteralException {
        if (list == null) {
            throw new BooleanLiteralException("Null List was passed to reset method.");
        }
        int i = 0;
        while (i < list.size()) {
            IBooleanLiteral ibool = (IBooleanLiteral)list.get(i);
            try {
                ibool.getBooleanVariable().setValue(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    private BooleanLiteral(IBooleanVariable bv, boolean barred) throws BooleanLiteralException {
        if (bv == null) {
            throw new BooleanLiteralException("Null IBooleanVariable was passed to constructor.");
        }
        this.BV = bv;
        this.barred = barred;
        BooleanLiteral.getInstances().add(this);
    }

    @Override
    public int compareTo(Object o) {
        String oName;
        String thisName = this.getBooleanVariable().getName();
        if (thisName.compareTo(oName = ((IBooleanLiteral)o).getBooleanVariable().getName()) != 0) {
            return thisName.compareTo(oName);
        }
        if (this.isBarred() == ((IBooleanLiteral)o).isBarred()) {
            return 0;
        }
        if (this.isBarred() && !((IBooleanLiteral)o).isBarred()) {
            return -1;
        }
        return 1;
    }

    @Override
    public IBooleanLiteral complement() throws BooleanLiteralException {
        return BooleanLiteral.getBooleanLiteral(this.getBooleanVariable(), !this.barred);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof IBooleanLiteral)) {
            return false;
        }
        IBooleanLiteral bo = (IBooleanLiteral)o;
        IBooleanVariable bov = bo.getBooleanVariable();
        if (bov == null) {
            return false;
        }
        if (bo.isBarred() != this.isBarred()) {
            return false;
        }
        return bov.equals(this.getBooleanVariable());
    }

    @Override
    public boolean evaluate() {
        if (this.getBooleanVariable().getValue() && !this.isBarred()) {
            return true;
        }
        return !this.getBooleanVariable().getValue() && this.isBarred();
    }

    @Override
    public IBooleanVariable getBooleanVariable() {
        return this.BV;
    }

    @Override
    public boolean isBarred() {
        return this.barred;
    }

    @Override
    public void load() {
        this.getBooleanVariable().setValue(!this.isBarred());
    }

    public ArrayList<ArrayList<IBooleanLiteral>> multiply(ArrayList<ArrayList<IBooleanLiteral>> a, ArrayList<ArrayList<IBooleanLiteral>> b) {
        ArrayList<ArrayList<IBooleanLiteral>> ret = new ArrayList<ArrayList<IBooleanLiteral>>();
        int m = 0;
        while (m < a.size()) {
            ArrayList<IBooleanLiteral> x = a.get(m);
            int n = 0;
            while (n < b.size()) {
                ArrayList<IBooleanLiteral> y = b.get(n);
                ArrayList<IBooleanLiteral> z = new ArrayList<IBooleanLiteral>();
                z.addAll(x);
                z.addAll(y);
                ret.add(z);
                ++n;
            }
            ++m;
        }
        return ret;
    }

    public void setBarred(boolean barred) {
        this.barred = barred;
    }

    public void setBooleanVariable(IBooleanVariable BV) throws BooleanLiteralException {
        if (BV == null) {
            throw new BooleanLiteralException("Null IBooleanVariable was passed to setBooleanVariable method.");
        }
        this.BV = BV;
    }

    public String toCode() {
        String nm = this.getBooleanVariable().getName();
        if (!this.barred) {
            nm = "(1-" + nm + ")";
        }
        return String.valueOf(nm) + "*" + nm;
    }

    @Override
    public String toString() {
        if (this.isBarred()) {
            return " $" + this.getBooleanVariable().getName() + " ";
        }
        return " " + this.getBooleanVariable().getName() + " ";
    }

    @Override
    public String toString(List<IBooleanLiteral> l) throws BooleanLiteralException {
        if (l == null) {
            throw new BooleanLiteralException("Null List was passed to toString method.");
        }
        BooleanLiteral.interpret(l);
        return this.toString();
    }
}

