# This program runs ACTS for *.acts and ipogbdd for *.bach 
# with different constraint handling options. ACTS and ipogbdd
# are applied to all .acts and .bach files placed under the current 
# directory and its subdirectories. 

import subprocess
import sys
import os
from pathlib import Path
import re

# timeout (sec)
timeout = 3600
strengths = [2, 3]
# times of repetition
numtimes = 12

javasetup = "java -Xms1g -Xmx1g "


# acts
p = Path("./")
actsfiles = list(p.glob("**/*.acts"))
programname = 'acts_3.0.jar'
modes = [(" -Dchandler=no ", ".noconst"), (" -Dchandler=solver ", ".csp"), \
(" ", ".mft")]


for inp in actsfiles:
    input = str(inp)
    for strength in strengths:
        for mode in modes:
            (commandoption, filesuffix) = mode
            output = input + "." + str(strength) + filesuffix
            outputlog = output + ".stat"
            command = javasetup + ' -Ddoi=' + str(strength) + \
                    ' -Drandstar=off -Doutput=csv ' + commandoption \
                    + " -jar " + programname + ' ' + input + ' ' + output
            print(command)
            command_list = re.split(" +", command)
            print(command_list)
            for i in range(0, numtimes):
                print(i)
                with open(outputlog + str(i).zfill(2), "w") as outfile:
                    try:
                        subprocess.run(command_list, stdout=outfile, timeout=timeout)
                    except:
                        print("timeout")
                        break



# bach (ipogbdd)
p = Path("./")
bachfiles = list(p.glob("**/*.bach"))
programname = 'ipogbdd.jar'
modes = [(" -chandler no ", ".noconst"), (" -chandler up ", ".bddup"), \
(" -chandler down ", ".bdddown"), (" -chandler conj ", ".bddconj"), \
(" -chandler sat ", ".sat")]


for inp in bachfiles:
    input = str(inp)
    for strength in strengths:
        for mode in modes:
            (commandoption, filesuffix) = mode
            output = input + "." + str(strength) + filesuffix
            outputlog = output + ".stat"
            command = javasetup + "-jar " + programname + " -c "+ str(strength) \
            + " -randstar on " + commandoption \
            + " -i " + input + " -o " + output
            print(command)
            command_list = re.split(" +", command)
            print(command_list)
            for i in range(0, numtimes):
                print(i)
                with open(outputlog + str(i).zfill(2), "w") as outfile:
                    try:
                        subprocess.run(command_list, stdout=outfile, timeout=timeout)
                    except:
                        print("timeout")
                        break

